/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the Request
 * 
 * @author mikemci 
 */
public interface ISTSRequest extends IMessage
{
	public void setTransportUsername(String strUsername);
	
	public void setTransportPassword(String strPassword);
	
	public String getTransportUsername();
	
	public String getTransportPassword();
	
	/**
	 * Gets the List of IRequestSecurityToken
	 * 
	 * @return the List of IRequestSecurityToken
	 */
	public abstract java.util.List getRequestSecurityTokenCollection();
	
	public abstract java.security.KeyPair getSelfSigningKeyPair();
	
	public abstract void setSelfSigningKeyPair(java.security.KeyPair kpSelf);
}