/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the Message
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IMessage
{
	/**
	 * Gets the Addressing Information
	 * 
	 * @return the Addressing Information
	 */
	public abstract IAddressingInformation getAddressingInformation();
	
	/**
	 * Sets the Addressing Information
	 * 
	 * @param addressingInformation the Addressing Information
	 */
	public abstract void setAddressingInformation(final IAddressingInformation addressingInformation);

	/**
	 * Gets the Security Information
	 * 
	 * @return the Security Information
	 */
	public abstract ISecurityInformation getSecurityInformation();
	
	/**
	 * Sets the Security Information
	 * 
	 * @param securityInformation the Security Information
	 */
	public abstract void setSecurityInformation(final ISecurityInformation securityInformation);
	
	/**
	 * Gets the Raw Message Information
	 * 
	 * @return the Raw Message Information
	 */
	public abstract IElement getMessage();
	
	/**
	 * Sets the Raw Message Information
	 * 
	 * @param messageInformation the Raw Message Information
	 */
	public abstract void setMessage(final IElement messageInformation);

}