/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * @author mikemci
 *
 */
public interface IDigitalIdentity
{
	abstract public void setType(final java.net.URI uriType);

	abstract public java.util.List getClaims();

	abstract public void addClaim(final IClaim claim);
	
	abstract public IClaim getClaim(final java.net.URI uriClaimType);
	
	abstract public java.net.URI getSubjectNameIdentifierURI();
	
	abstract public void setSubjectNameIdentifierURI(java.net.URI uriSubjectNameIdentifier);
	
	abstract public boolean getIncludePPIClaim();
	
	abstract public void setIncludePPIClaim(boolean bIncludePPICliam);
	
    /**
    * Type of DigitalIdentity can be a reflection of how it maybe serialized (e.g. token type), or a runtime representation of a bag of claims 
    * and such. E.g., it can be digital subject containing 'authclaims'
    */
	abstract public java.net.URI getType();
	
    /**
    *   TODO to decide - we can treat it as a blob which can be a binary token, XML token and such. Or we can keep it simple and treat it as a String
    *          and get a toString or something. 
    */
	abstract public Object getSerialized();
}
