/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.client;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.api.ITimestamp;
import org.eclipse.higgins.sts.api.IUsernameToken;
import org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.utilities.DateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType;

public class SecurityTokenServiceClientBinding
implements ISecurityTokenService {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding == null ? (class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding = SecurityTokenServiceClientBinding.class$("org.eclipse.higgins.sts.binding.axis1x.client.SecurityTokenServiceClientBinding")) : class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding).getName());
    private TrustBindingClient tokenServiceClient = null;
    private boolean bInitialized = false;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    protected SecurityTokenServiceClientBinding() throws Exception {
        this.log.trace((Object)"SecurityTokenService::SecurityTokenService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::configure");
        try {
            URI uriTokenService = (URI)mapGlobalSettings.get("TokenServiceTrustURI");
            if (null != uriTokenService) {
                this.tokenServiceClient = new TrustBindingClient(uriTokenService.toURL(), null);
                this.tokenServiceClient.setPortName("Trust");
                this.tokenServiceClient._setProperty("call.CheckMustUnderstand", new Boolean(false));
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            return;
        }
        this.bInitialized = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::invoke");
        if (!this.bInitialized) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", errMsg);
            response.setFault((IFault)fault);
            return;
        }
        RequestSecurityTokenType RST = BindingHelper.Axis1xRSTFromSTSRequest((ISTSRequest)request, (IConstants)constants);
        RequestSecurityTokenResponseType RSTR = null;
        try {
            ISecurityInformation securityInformation = request.getSecurityInformation();
            if (null != securityInformation) {
                IUsernameToken usernameToken;
                SOAPHeaderElement sheSecurityHeader = new SOAPHeaderElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
                ITimestamp timestamp = securityInformation.getTimestamp();
                if (null != timestamp) {
                    MessageElement meTimestamp = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
                    MessageElement meCreated = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
                    meCreated.addTextNode(DateHelper.getIso8601Date((Date)timestamp.getCreated()));
                    meTimestamp.addChild(meCreated);
                    Date expires = timestamp.getExpires();
                    if (null != expires) {
                        MessageElement meExpires = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
                        meExpires.addTextNode(DateHelper.getIso8601Date((Date)expires));
                        meTimestamp.addChild(meExpires);
                    }
                    sheSecurityHeader.addChild(meTimestamp);
                }
                if (null != (usernameToken = securityInformation.getUsernameToken())) {
                    MessageElement meUsernameToken = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
                    MessageElement meUsername = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
                    meUsername.addTextNode(usernameToken.getUsername());
                    meUsernameToken.addChild(meUsername);
                    String strPassword = usernameToken.getPassword();
                    if (null != strPassword) {
                        MessageElement mePassword = new MessageElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
                        mePassword.addTextNode(usernameToken.getPassword());
                        meUsernameToken.addChild(mePassword);
                    }
                    sheSecurityHeader.addChild(meUsernameToken);
                }
                List listSecurityTokens = securityInformation.getSecurityTokenList();
                for (int i = 0; i < listSecurityTokens.size(); ++i) {
                    IElement elemSecurityToken = (IElement)listSecurityTokens.get(i);
                    if (null == elemSecurityToken) {
                        String errMsg = MsgHelper.getString((String)"securitytoken_from_securityinformation_is_null");
                        this.log.error((Object)errMsg);
                        continue;
                    }
                    Element domSecurityToken = (Element)elemSecurityToken.getAs(class$org$w3c$dom$Element == null ? SecurityTokenServiceClientBinding.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                    MessageElement meSecurityToken = new MessageElement(domSecurityToken);
                    sheSecurityHeader.addChild(meSecurityToken);
                }
                this.tokenServiceClient.setHeader(sheSecurityHeader);
            }
            if (null != request.getTransportUsername()) {
                this.tokenServiceClient.setUsername(request.getTransportUsername());
                this.tokenServiceClient.setPassword(request.getTransportPassword());
            }
            RSTR = this.tokenServiceClient.requestSecurityToken(RST);
        }
        catch (AxisFault af) {
            this.log.trace((Object)"Caught AxisFault");
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            response.setFault(BindingHelper.AxisFaultToAxis((AxisFault)af));
            return;
        }
        catch (Exception e) {
            this.log.trace((Object)"Caught Exception");
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            return;
        }
        this.log.trace((Object)"Before STSResponseFromAxis1xRSTR");
        BindingHelper.STSResponseFromAxis1xRSTR((MessageContext)this.tokenServiceClient._getCall().getMessageContext(), (IConstants)constants, (RequestSecurityTokenResponseType)RSTR, (ISTSResponse)response);
        this.log.trace((Object)"After STSResponseFromAxis1xRSTR");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

