/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.client;


import org.apache.axis.client.Call;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Implements the Higgins Security Token Service Client.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
public class SecurityTokenServiceClientBinding
	implements org.eclipse.higgins.sts.api.ISecurityTokenService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenServiceClientBinding.class.getName());
	
	private org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient tokenServiceClient = null;

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected SecurityTokenServiceClientBinding()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}
	
	/**
	 * This method is called to configure (and reconfigure) the Binding.
	 * 
	 */
	public void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings)
	{
		this.log.trace("SecurityTokenServiceClientBinding::configure");
		
		try
		{
			final java.net.URI uriTokenService = (java.net.URI)mapGlobalSettings.get("TokenServiceTrustURI");
			if (null != uriTokenService)
			{
				this.tokenServiceClient = new org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient(uriTokenService.toURL(), null);
				this.tokenServiceClient.setPortName("Trust");
				this.tokenServiceClient._setProperty(Call.CHECK_MUST_UNDERSTAND, new java.lang.Boolean(false));
			}
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			return; // bInitialized = false;
		}
		this.bInitialized = true;
	}
	
	/**
	 *  Called to send an RST.
	 */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
    {
		this.log.trace("SecurityTokenServiceClientBinding::invoke");

		if (!this.bInitialized)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);

			this.log.error(errMsg);
			final IFault fault = new org.eclipse.higgins.sts.common.Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				errMsg);
			response.setFault(fault);			
			return;
		}
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST = BindingHelper.Axis1xRSTFromSTSRequest
			(request,
			constants);
		org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR = null;
		try
		{
			final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
			if (null != securityInformation)
			{
				final org.apache.axis.message.SOAPHeaderElement sheSecurityHeader = new org.apache.axis.message.SOAPHeaderElement
					("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
				final org.eclipse.higgins.sts.api.ITimestamp timestamp = securityInformation.getTimestamp();
				if (null != timestamp)
				{
					final org.apache.axis.message.MessageElement meTimestamp = new org.apache.axis.message.MessageElement
						("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
					final org.apache.axis.message.MessageElement meCreated = new org.apache.axis.message.MessageElement
						("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
					meCreated.addTextNode
						(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date
							(timestamp.getCreated()));
					meTimestamp.addChild(meCreated);
					java.util.Date expires = timestamp.getExpires();
					if (null != expires)
					{
						final org.apache.axis.message.MessageElement meExpires = new org.apache.axis.message.MessageElement
							("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
						meExpires.addTextNode
							(org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date
								(expires));
						meTimestamp.addChild(meExpires);
					}
					sheSecurityHeader.addChild(meTimestamp);
				}
				final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = securityInformation.getUsernameToken();
				if (null != usernameToken)
				{
					final org.apache.axis.message.MessageElement meUsernameToken = new org.apache.axis.message.MessageElement
						("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
					final org.apache.axis.message.MessageElement meUsername = new org.apache.axis.message.MessageElement
						("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
					meUsername.addTextNode(usernameToken.getUsername());
					meUsernameToken.addChild(meUsername);
					final String strPassword = usernameToken.getPassword();
					if (null != strPassword)
					{
						final org.apache.axis.message.MessageElement mePassword = new org.apache.axis.message.MessageElement
							("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
						mePassword.addTextNode(usernameToken.getPassword());
						meUsernameToken.addChild(mePassword);
					}
					sheSecurityHeader.addChild(meUsernameToken);
				}
				final java.util.List listSecurityTokens = securityInformation.getSecurityTokenList();
				for (int i = 0; i < listSecurityTokens.size(); ++i)
				{
					final org.eclipse.higgins.sts.api.IElement elemSecurityToken = (org.eclipse.higgins.sts.api.IElement)listSecurityTokens.get(i);
					if (null == elemSecurityToken)
					{
						String errMsg = MsgHelper.getString(MsgHelper.securitytoken_from_securityinformation_is_null);
						log.error(errMsg);
						continue;
					}
					final org.w3c.dom.Element domSecurityToken = (org.w3c.dom.Element)elemSecurityToken.getAs(org.w3c.dom.Element.class);
					final org.apache.axis.message.MessageElement meSecurityToken = new org.apache.axis.message.MessageElement(domSecurityToken);
					sheSecurityHeader.addChild(meSecurityToken);
				}
				this.tokenServiceClient.setHeader(sheSecurityHeader);
			}
			if (null != request.getTransportUsername())
			{
				this.tokenServiceClient.setUsername(request.getTransportUsername());
				this.tokenServiceClient.setPassword(request.getTransportPassword());
			}
			RSTR = this.tokenServiceClient.requestSecurityToken(RST);
		}
		catch (final org.apache.axis.AxisFault af)
		{
			this.log.trace("Caught AxisFault");
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			response.setFault(BindingHelper.AxisFaultToAxis(af));
			return;
		}
		catch (final Exception e)
		{
			this.log.trace("Caught Exception");
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			return;
		}
		this.log.trace("Before STSResponseFromAxis1xRSTR");
		BindingHelper.STSResponseFromAxis1xRSTR
			(this.tokenServiceClient._getCall().getMessageContext(),
			constants,
			RSTR,
			response);
		this.log.trace("After STSResponseFromAxis1xRSTR");
	}
}