/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.client;

import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IBinarySecurityToken;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityElement;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType;

public class SecurityTokenServiceClientBinding
implements ISecurityTokenService {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding == null ? (class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding = SecurityTokenServiceClientBinding.class$("org.eclipse.higgins.sts.binding.axis1x.client.SecurityTokenServiceClientBinding")) : class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding).getName());
    private TrustBindingClient tokenServiceClient = null;
    private boolean bInitialized = false;
    private IXMLSecurityExtension xmlSecurityExtension = null;
    private IBase64Extension base64Extension = null;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$binding$axis1x$client$SecurityTokenServiceClientBinding;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$api$IBinarySecurityToken;

    protected SecurityTokenServiceClientBinding() throws Exception {
        this.log.trace((Object)"SecurityTokenService::SecurityTokenService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::configure");
        try {
            URI uriTokenService = (URI)mapGlobalSettings.get("TokenServiceTrustURI");
            if (null != uriTokenService) {
                Service service = new Service();
                this.tokenServiceClient = new TrustBindingClient(uriTokenService.toURL(), null);
                this.tokenServiceClient.setPortName("Trust");
                this.tokenServiceClient._setProperty("call.CheckMustUnderstand", new Boolean(false));
            }
            this.xmlSecurityExtension = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
            this.base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            return;
        }
        this.bInitialized = true;
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::invoke");
        if (!this.bInitialized) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", errMsg);
            response.setFault((IFault)fault);
            return;
        }
        RequestSecurityTokenType RST = BindingHelper.Axis1xRSTFromSTSRequest((ISTSRequest)request, (IConstants)constants);
        RequestSecurityTokenResponseType RSTR = null;
        try {
            ISecurityInformation securityInformation = request.getSecurityInformation();
            if (null != securityInformation) {
                SOAPHeaderElement sheSecurityHeader = new SOAPHeaderElement(constants.getWSSecurityNamespace().toString(), "Security");
                List listSecurityElements = securityInformation.getSecurityElementList();
                for (int i = 0; i < listSecurityElements.size(); ++i) {
                    ISecurityElement securityElement = (ISecurityElement)listSecurityElements.get(i);
                    if (null == securityElement) {
                        String errMsg = MsgHelper.getString((String)"securitytoken_from_securityinformation_is_null");
                        this.log.error((Object)errMsg);
                        continue;
                    }
                    IElement elemSecurityElement = securityElement.toElement();
                    Element domSecurityToken = (Element)elemSecurityElement.getAs(class$org$w3c$dom$Element == null ? SecurityTokenServiceClientBinding.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                    MessageElement meSecurityToken = new MessageElement(domSecurityToken);
                    sheSecurityHeader.addChild(meSecurityToken);
                }
                PrivateKey authenticationKey = (PrivateKey)securityInformation.getAuthenticationKey();
                if (null != authenticationKey) {
                    IBinarySecurityToken bst = (IBinarySecurityToken)securityInformation.getFirst(class$org$eclipse$higgins$sts$api$IBinarySecurityToken == null ? (class$org$eclipse$higgins$sts$api$IBinarySecurityToken = SecurityTokenServiceClientBinding.class$("org.eclipse.higgins.sts.api.IBinarySecurityToken")) : class$org$eclipse$higgins$sts$api$IBinarySecurityToken);
                    X509Certificate cert = CertificateHelper.fromString((String)bst.getEncodedValue());
                    this.tokenServiceClient._setProperty("AUTHENTICATIONPRIVATEKEY", authenticationKey);
                    this.tokenServiceClient._setProperty("AUTHENTICATIONPUBLICKEY", cert.getPublicKey());
                    this.tokenServiceClient._setProperty("XMLSECURITYEXTENSION", this.xmlSecurityExtension);
                }
                this.tokenServiceClient.setHeader(sheSecurityHeader);
            }
            if (null != request.getTransportUsername()) {
                this.tokenServiceClient.setUsername(request.getTransportUsername());
                this.tokenServiceClient.setPassword(request.getTransportPassword());
            }
            RSTR = this.tokenServiceClient.requestSecurityToken(RST);
        }
        catch (AxisFault af) {
            this.log.trace((Object)"Caught AxisFault");
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            response.setFault(BindingHelper.AxisFaultToAxis((AxisFault)af));
            return;
        }
        catch (Exception e) {
            this.log.trace((Object)"Caught Exception");
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            return;
        }
        this.log.trace((Object)"Before STSResponseFromAxis1xRSTR");
        BindingHelper.STSResponseFromAxis1xRSTR((MessageContext)this.tokenServiceClient._getCall().getMessageContext(), (IConstants)constants, (IBase64Extension)this.base64Extension, (RequestSecurityTokenResponseType)RSTR, (ISTSResponse)response);
        this.log.trace((Object)"After STSResponseFromAxis1xRSTR");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

