/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.client;

/**
 * Implements the IConfigurableComponentFactory that creates the SecurityTokenService implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class SecurityTokenServiceClientBindingFactory
	implements org.eclipse.higgins.configuration.api.IConfigurableComponentFactory
{
	private static final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenServiceClientBindingFactory.class.getName());
	
	/**
	 * Provides access to the new instance
	 * 
	 * @return the new instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getNewInstance()
	{
		SecurityTokenServiceClientBinding newInstance = null;
		try
		{
		    newInstance = new SecurityTokenServiceClientBinding();
		}
		catch (Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, e);
		    return null;
		}
		return newInstance;
	    }

	/**
	 * The singleton instance
	 */
	private static SecurityTokenServiceClientBinding theInstance = null;

	/**
	 * Provides access to the singleton instance
	 * 
	 * @return the singleton instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getSingletonInstance()
	{
		if (null == SecurityTokenServiceClientBindingFactory.theInstance)
		{
			try
			{
				SecurityTokenServiceClientBindingFactory.theInstance = new SecurityTokenServiceClientBinding();
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(SecurityTokenServiceClientBindingFactory.log,
					e);	
	    		return null;
    		}
		}
		return SecurityTokenServiceClientBindingFactory.theInstance;
	}
	


}

