/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.client;

import java.net.URI;
import java.util.Map;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IMEXResponse;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
import org.eclipse.higgins.sts.binding.axis1x.client.ResourceBindingClient;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.MEXResponse;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.xmlsoap.schemas.ws._2004._09.mex.Metadata;

public class MetadataExchangeServiceClientBinding
implements IMetadataExchangeService {
    private final LogHelper log;
    private ResourceBindingClient metadataServiceClient;
    private boolean bInitialized;
    static /* synthetic */ Class class$0;

    protected MetadataExchangeServiceClientBinding() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.binding.axis1x.client.MetadataExchangeServiceClientBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.metadataServiceClient = null;
        this.bInitialized = false;
        this.log.trace((Object)"SecurityTokenService::SecurityTokenService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::configure");
        try {
            URI uriMetadataService = (URI)mapGlobalSettings.get("MetadataServiceURI");
            if (uriMetadataService != null) {
                this.metadataServiceClient = new ResourceBindingClient(uriMetadataService.toURL(), null);
                this.metadataServiceClient.setPortName("Resource");
                this.metadataServiceClient._setProperty("call.CheckMustUnderstand", new Boolean(false));
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            return;
        }
        this.bInitialized = true;
    }

    public IMEXResponse getMetadata(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, URI uriMetadata) {
        this.log.trace((Object)"SecurityTokenServiceClientBinding::getMetadata");
        MEXResponse response = new MEXResponse();
        if (!this.bInitialized) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", errMsg);
            response.setFault((IFault)fault);
            return response;
        }
        try {
            SOAPHeaderElement sheActionHeader = new SOAPHeaderElement("http://www.w3.org/2005/08/addressing", "Action");
            sheActionHeader.addTextNode("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get");
            this.metadataServiceClient.setHeader(sheActionHeader);
            SOAPHeaderElement sheMessageIDHeader = new SOAPHeaderElement("http://www.w3.org/2005/08/addressing", "MessageID");
            sheMessageIDHeader.addTextNode("urn:RandomStuff");
            this.metadataServiceClient.setHeader(sheMessageIDHeader);
            SOAPHeaderElement sheReplyToHeader = new SOAPHeaderElement("http://www.w3.org/2005/08/addressing", "ReplyTo");
            MessageElement meAddress = new MessageElement("http://www.w3.org/2005/08/addressing", "Address");
            meAddress.addTextNode("http://www.w3.org/2005/08/addressing/anonymous");
            sheReplyToHeader.addChild(meAddress);
            this.metadataServiceClient.setHeader(sheReplyToHeader);
            SOAPHeaderElement sheToHeader = new SOAPHeaderElement("http://www.w3.org/2005/08/addressing", "To");
            sheToHeader.addTextNode(uriMetadata.toString());
            this.metadataServiceClient.setHeader(sheToHeader);
            Metadata metadata = this.metadataServiceClient.get();
            BindingHelper.MEXResponseFromAxis1xMetadata((IConstants)constants, (Metadata)metadata, (IMEXResponse)response);
        }
        catch (Exception e) {
            this.log.trace((Object)"Caught Exception");
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
            response.setFault((IFault)fault);
        }
        return response;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }
}

