/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.client;

import org.apache.axis.client.Call;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.messages.utilities.MsgHelper;


/**
 * Implements the Higgins Security Token Service Client.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
public class MetadataExchangeServiceClientBinding
	implements org.eclipse.higgins.sts.api.IMetadataExchangeService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(MetadataExchangeServiceClientBinding.class.getName());
	
	private org.eclipse.higgins.sts.binding.axis1x.client.ResourceBindingClient metadataServiceClient = null;

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected MetadataExchangeServiceClientBinding()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}
	
	/**
	 * This method is called to configure (and reconfigure) the Binding.
	 * 
	 */
	public void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
	{
		this.log.trace("SecurityTokenServiceClientBinding::configure");
		
		try
		{
			final java.net.URI uriMetadataService = (java.net.URI)mapGlobalSettings.get("MetadataServiceURI");
			if (null != uriMetadataService)
			{
				this.metadataServiceClient = new org.eclipse.higgins.sts.binding.axis1x.client.ResourceBindingClient(uriMetadataService.toURL(), null);
				this.metadataServiceClient.setPortName("Resource");
				this.metadataServiceClient._setProperty(Call.CHECK_MUST_UNDERSTAND, new java.lang.Boolean(false));
			}
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			return; // bInitialized = false;
		}
		this.bInitialized = true;
	}
	
	public org.eclipse.higgins.sts.api.IMEXResponse getMetadata
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final java.net.URI uriMetadata)
	{
		this.log.trace("SecurityTokenServiceClientBinding::getMetadata");
		
		final org.eclipse.higgins.sts.api.IMEXResponse response = new org.eclipse.higgins.sts.common.MEXResponse();
		if (!this.bInitialized)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);
			
			this.log.error(errMsg);
			final IFault fault = new org.eclipse.higgins.sts.common.Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				errMsg);
			response.setFault(fault);	
			return response;
		}
		try
		{
			final org.apache.axis.message.SOAPHeaderElement sheActionHeader = new org.apache.axis.message.SOAPHeaderElement
				("http://www.w3.org/2005/08/addressing", "Action");
			sheActionHeader.addTextNode("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get");
			this.metadataServiceClient.setHeader(sheActionHeader);
			final org.apache.axis.message.SOAPHeaderElement sheMessageIDHeader = new org.apache.axis.message.SOAPHeaderElement
				("http://www.w3.org/2005/08/addressing", "MessageID");
			sheMessageIDHeader.addTextNode("urn:RandomStuff");
			this.metadataServiceClient.setHeader(sheMessageIDHeader);
			final org.apache.axis.message.SOAPHeaderElement sheReplyToHeader = new org.apache.axis.message.SOAPHeaderElement
				("http://www.w3.org/2005/08/addressing", "ReplyTo");
			final org.apache.axis.message.MessageElement meAddress = new org.apache.axis.message.MessageElement
				("http://www.w3.org/2005/08/addressing", "Address");
			meAddress.addTextNode("http://www.w3.org/2005/08/addressing/anonymous");
			sheReplyToHeader.addChild(meAddress);
			this.metadataServiceClient.setHeader(sheReplyToHeader);
			final org.apache.axis.message.SOAPHeaderElement sheToHeader = new org.apache.axis.message.SOAPHeaderElement
				("http://www.w3.org/2005/08/addressing", "To");
			sheToHeader.addTextNode(uriMetadata.toString());
			this.metadataServiceClient.setHeader(sheToHeader);

			final org.xmlsoap.schemas.ws._2004._09.mex.Metadata metadata = this.metadataServiceClient.get();
			org.eclipse.higgins.sts.binding.common.BindingHelper.MEXResponseFromAxis1xMetadata(constants, metadata, response);
		}
		catch (final Exception e)
		{
			this.log.trace("Caught Exception");
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			final IFault fault = new org.eclipse.higgins.sts.common.Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());
			response.setFault(fault);	
		}
		return response;
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}