/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.client;


import org.apache.axis.client.Call;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Implements the Higgins Security Token Service Client.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
public class SecurityTokenServiceClientBinding
	implements org.eclipse.higgins.sts.api.ISecurityTokenService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenServiceClientBinding.class.getName());
	
	private org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient tokenServiceClient = null;

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	private org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurityExtension = null;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected SecurityTokenServiceClientBinding()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}
	
	/**
	 * This method is called to configure (and reconfigure) the Binding.
	 * 
	 */
	public void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
	{
		this.log.trace("SecurityTokenServiceClientBinding::configure");
		
		try
		{
			final java.net.URI uriTokenService = (java.net.URI)mapGlobalSettings.get("TokenServiceTrustURI");
			if (null != uriTokenService)
			{
				org.apache.axis.client.Service service = new org.apache.axis.client.Service();

				this.tokenServiceClient = new org.eclipse.higgins.sts.binding.axis1x.client.TrustBindingClient(uriTokenService.toURL(), null);
				this.tokenServiceClient.setPortName("Trust");
				this.tokenServiceClient._setProperty(Call.CHECK_MUST_UNDERSTAND, new java.lang.Boolean(false));
			}
			xmlSecurityExtension = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			return; // bInitialized = false;
		}
		this.bInitialized = true;
	}
	
	/**
	 *  Called to send an RST.
	 */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
    {
		this.log.trace("SecurityTokenServiceClientBinding::invoke");

		if (!this.bInitialized)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);

			this.log.error(errMsg);
			final IFault fault = new org.eclipse.higgins.sts.common.Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				errMsg);
			response.setFault(fault);			
			return;
		}
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST = BindingHelper.Axis1xRSTFromSTSRequest
			(request,
			constants);
		org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR = null;
		try
		{
			final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
			if (null != securityInformation)
			{
				final org.apache.axis.message.SOAPHeaderElement sheSecurityHeader = new org.apache.axis.message.SOAPHeaderElement
					(constants.getWSSecurityNamespace().toString(),
					"Security");
				final java.util.List listSecurityElements = securityInformation.getSecurityElementList();
				for (int i = 0; i < listSecurityElements.size(); ++i)
				{
					final org.eclipse.higgins.sts.api.ISecurityElement securityElement = (org.eclipse.higgins.sts.api.ISecurityElement)listSecurityElements.get(i);
					if (null == securityElement)
					{
						String errMsg = MsgHelper.getString(MsgHelper.securitytoken_from_securityinformation_is_null);
						log.error(errMsg);
						continue;
					}
					final org.eclipse.higgins.sts.api.IElement elemSecurityElement = securityElement.toElement();
					final org.w3c.dom.Element domSecurityToken = (org.w3c.dom.Element)elemSecurityElement.getAs(org.w3c.dom.Element.class);
					final org.apache.axis.message.MessageElement meSecurityToken = new org.apache.axis.message.MessageElement(domSecurityToken);
					sheSecurityHeader.addChild(meSecurityToken);
				}
				final java.security.PrivateKey authenticationKey = (java.security.PrivateKey)securityInformation.getAuthenticationKey();
				if (null != authenticationKey)
				{
					org.eclipse.higgins.sts.api.IBinarySecurityToken bst = (org.eclipse.higgins.sts.api.IBinarySecurityToken)securityInformation.getFirst
						(org.eclipse.higgins.sts.api.IBinarySecurityToken.class);
					java.security.cert.X509Certificate cert = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString
						(bst.getEncodedValue());
					this.tokenServiceClient._setProperty("AUTHENTICATIONPRIVATEKEY", authenticationKey);
					this.tokenServiceClient._setProperty("AUTHENTICATIONPUBLICKEY", cert.getPublicKey());
					this.tokenServiceClient._setProperty("XMLSECURITYEXTENSION", xmlSecurityExtension);
				}
				this.tokenServiceClient.setHeader(sheSecurityHeader);
			}
			if (null != request.getTransportUsername())
			{
				this.tokenServiceClient.setUsername(request.getTransportUsername());
				this.tokenServiceClient.setPassword(request.getTransportPassword());
			}
			RSTR = this.tokenServiceClient.requestSecurityToken(RST);
		}
		catch (final org.apache.axis.AxisFault af)
		{
			this.log.trace("Caught AxisFault");
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			response.setFault(BindingHelper.AxisFaultToAxis(af));
			return;
		}
		catch (final Exception e)
		{
			this.log.trace("Caught Exception");
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			return;
		}
		this.log.trace("Before STSResponseFromAxis1xRSTR");
		BindingHelper.STSResponseFromAxis1xRSTR
			(this.tokenServiceClient._getCall().getMessageContext(),
			constants,
			RSTR,
			response);
		this.log.trace("After STSResponseFromAxis1xRSTR");
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}