/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.client;

import javax.xml.namespace.QName;

/**
 * @author mikemci
 *
 */
public class SOAPConstants
	implements org.apache.axis.soap.SOAPConstants
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	org.apache.axis.soap.SOAPConstants constants = null;
	
	public SOAPConstants(org.apache.axis.soap.SOAPConstants constants)
	{
		if (null != constants)
			this.constants = constants;
		else
			this.constants = new org.apache.axis.soap.SOAP11Constants();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getArrayType()
	 */
	public QName getArrayType()
	{
		return constants.getArrayType();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getAttrHref()
	 */
	public String getAttrHref()
	{
		return constants.getAttrHref();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getAttrItemType()
	 */
	public String getAttrItemType()
	{
		return constants.getAttrItemType();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getBodyQName()
	 */
	public QName getBodyQName()
	{
		return constants.getBodyQName();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getContentType()
	 */
	public String getContentType()
	{
		String strContentType = constants.getContentType();
		strContentType = strContentType.replaceAll("text/xml", "application/soap+xml");
		System.out.println("getContentType: " + strContentType);
		return strContentType;
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getEncodingURI()
	 */
	public String getEncodingURI()
	{
		return constants.getEncodingURI();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getEnvelopeURI()
	 */
	public String getEnvelopeURI()
	{
		return constants.getEnvelopeURI();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getFaultQName()
	 */
	public QName getFaultQName()
	{
		return constants.getFaultQName();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getHeaderQName()
	 */
	public QName getHeaderQName()
	{
		return constants.getHeaderQName();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getMustunderstandFaultQName()
	 */
	public QName getMustunderstandFaultQName()
	{
		return constants.getMustunderstandFaultQName();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getNextRoleURI()
	 */
	public String getNextRoleURI()
	{
		return constants.getNextRoleURI();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getRoleAttributeQName()
	 */
	public QName getRoleAttributeQName()
	{
		return constants.getRoleAttributeQName();
	}

	/* (non-Javadoc)
	 * @see org.apache.axis.soap.SOAPConstants#getVerMismatchFaultCodeQName()
	 */
	public QName getVerMismatchFaultCodeQName()
	{
		return constants.getVerMismatchFaultCodeQName();
	}

}
