/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.security;

import java.security.PrivateKey;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.Configuration;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.NodeList;

public class WSSRequestConsumerHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$binding$axis1x$security$WSSRequestConsumerHandler == null ? (class$org$eclipse$higgins$sts$binding$axis1x$security$WSSRequestConsumerHandler = WSSRequestConsumerHandler.class$("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler")) : class$org$eclipse$higgins$sts$binding$axis1x$security$WSSRequestConsumerHandler).getName());
    private final IConstants constants = new Constants();
    static /* synthetic */ Class class$org$eclipse$higgins$sts$binding$axis1x$security$WSSRequestConsumerHandler;

    public WSSRequestConsumerHandler() {
        this.log.trace((Object)"WSSRequestConsumerHandler::WSSRequestConsumerHandler");
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        this.log.trace((Object)"WSSRequestConsumerHandler::invoke");
        Configuration configurationHandler = new Configuration();
        try {
            configurationHandler.configure(null);
        }
        catch (Exception e) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            Fault fault = new Fault(this.constants.getWSTrustNamespace(), "wst", this.constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
            throw BindingHelper.FaultToAxisFault((IFault)fault);
        }
        Message mRequest = messageContext.getRequestMessage();
        SOAPEnvelope seRequest = null;
        try {
            seRequest = mRequest.getSOAPEnvelope();
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        SOAPHeaderElement sheSecurity = null;
        try {
            sheSecurity = seRequest.getHeaderByName(this.constants.getWSSecurityNamespace().toString(), "Security");
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        if (null == sheSecurity) {
            this.log.trace((Object)"Security header not found.");
            return;
        }
        try {
            Map mapGlobalSettings = configurationHandler.getSettings();
            IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
            PrivateKey pkIssuer = (PrivateKey)mapGlobalSettings.get("IssuerPrivateKey");
            org.w3c.dom.Element domSecurity = sheSecurity.getAsDOM();
            NodeList nlEncryptedData = domSecurity.getElementsByTagNameNS(this.constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
            if (null == nlEncryptedData) {
                this.log.trace((Object)"No EncryptedData found (getElementsByTagName returned null)");
            } else if (0 == nlEncryptedData.getLength()) {
                this.log.trace((Object)"No EncryptedData found (0 == getLength())");
            } else {
                for (int i = 0; i < nlEncryptedData.getLength(); ++i) {
                    this.log.trace((Object)"Processing EncryptedData element in Security header");
                    org.w3c.dom.Element domEncryptedData = (org.w3c.dom.Element)nlEncryptedData.item(0);
                    Element elemEncryptedData = new Element();
                    elemEncryptedData.set((Object)domEncryptedData);
                    IElement elemDecryptedData = xmlSecurity.DecryptElement((IElement)elemEncryptedData, pkIssuer);
                }
            }
            NodeList nlUsernameTokens = domSecurity.getElementsByTagNameNS(this.constants.getWSSecurityNamespace().toString(), "UsernameToken");
            if (null == nlUsernameTokens) {
                this.log.trace((Object)"No UsernameToken found (getElementsByTagName returned null)");
            } else if (0 == nlUsernameTokens.getLength()) {
                this.log.trace((Object)"No UsernameToken found (0 == getLength())");
            } else if (1 != nlUsernameTokens.getLength()) {
                this.log.trace((Object)"More than one UsernameToken found");
            } else {
                this.log.trace((Object)"Processing UsernameToken element in Security header");
                org.w3c.dom.Element domUsernameToken = (org.w3c.dom.Element)nlUsernameTokens.item(0);
                NodeList nlUsernames = domUsernameToken.getElementsByTagNameNS(this.constants.getWSSecurityNamespace().toString(), "Username");
                if (null == nlUsernames) {
                    this.log.trace((Object)"No Username found");
                } else if (0 == nlUsernames.getLength()) {
                    this.log.trace((Object)"No Username found");
                } else if (1 != nlUsernames.getLength()) {
                    this.log.trace((Object)"More than one Username found");
                } else {
                    org.w3c.dom.Element domUsername = (org.w3c.dom.Element)nlUsernames.item(0);
                    messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Username", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domUsername));
                    this.log.trace((Object)("Found Username: " + XMLHelper.getTextContent((org.w3c.dom.Element)domUsername)));
                }
                NodeList nlPasswords = domUsernameToken.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
                if (null == nlPasswords) {
                    this.log.trace((Object)"No Password found");
                } else if (0 == nlPasswords.getLength()) {
                    this.log.trace((Object)"No Password found");
                } else if (1 != nlPasswords.getLength()) {
                    this.log.trace((Object)"More than one Password found");
                } else {
                    org.w3c.dom.Element domPassword = (org.w3c.dom.Element)nlPasswords.item(0);
                    messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Password", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domPassword));
                    this.log.trace((Object)"Found Password: xxxxx");
                }
            }
            NodeList nlSAMLTokens = domSecurity.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "Assertion");
            if (null == nlSAMLTokens) {
                this.log.trace((Object)"No SAMLToken found (getElementsByTagName returned null)");
            } else if (0 == nlSAMLTokens.getLength()) {
                this.log.trace((Object)"No SAMLToken found (0 == getLength())");
            } else if (1 != nlSAMLTokens.getLength()) {
                this.log.trace((Object)"More than one SAMLToken found");
            } else {
                this.log.trace((Object)"Processing SAML Assertion (Token) element in Security header");
                org.w3c.dom.Element domSAMLToken = (org.w3c.dom.Element)nlSAMLTokens.item(0);
                NodeList nlAttributeStatements = domSAMLToken.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "AttributeStatement");
                if (null == nlAttributeStatements) {
                    this.log.trace((Object)"No AttributeStatement found");
                } else if (0 == nlAttributeStatements.getLength()) {
                    this.log.trace((Object)"No AttributeStatement found");
                } else if (1 != nlAttributeStatements.getLength()) {
                    this.log.trace((Object)"More than one AttributeStatement found");
                } else {
                    this.log.trace((Object)"Processing SAML AttributeStatement element");
                    org.w3c.dom.Element domAttributeStatement = (org.w3c.dom.Element)nlAttributeStatements.item(0);
                    this.log.trace((Object)"Looking for the PPID");
                    NodeList nlAttributes = domAttributeStatement.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "Attribute");
                    if (null == nlAttributes) {
                        this.log.trace((Object)"No Attribute found (getElementsByTagName returned null)");
                    } else if (0 == nlAttributes.getLength()) {
                        this.log.trace((Object)"No Attribute found (0 == getLength())");
                    } else {
                        for (int i = 0; i < nlAttributes.getLength(); ++i) {
                            this.log.trace((Object)"Processing Attribute element");
                            org.w3c.dom.Element elemAttribute = (org.w3c.dom.Element)nlAttributes.item(i);
                            String strAttributeName = elemAttribute.getAttribute("AttributeName");
                            this.log.trace((Object)("Attribute: " + strAttributeName));
                            if (!strAttributeName.matches("privatepersonalidentifier")) continue;
                            NodeList nlAttributeValues = elemAttribute.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "AttributeValue");
                            if (null == nlAttributeValues) {
                                this.log.trace((Object)"No AttributeValue found (getElementsByTagName returned null)");
                                continue;
                            }
                            if (0 == nlAttributeValues.getLength()) {
                                this.log.trace((Object)"No AttributeValue found (0 == getLength())");
                                continue;
                            }
                            if (1 != nlAttributeValues.getLength()) {
                                this.log.trace((Object)"More than 1 AttributeValue found");
                                continue;
                            }
                            org.w3c.dom.Element elemAttributeValue = (org.w3c.dom.Element)nlAttributeValues.item(0);
                            String strPPID = XMLHelper.getTextContent((org.w3c.dom.Element)elemAttributeValue);
                            this.log.trace((Object)("PPID: " + strPPID));
                            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.PPID", (Object)strPPID);
                            break;
                        }
                    }
                    NodeList nlSubjects = domAttributeStatement.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "Subject");
                    if (null == nlSubjects) {
                        this.log.trace((Object)"No Subject found");
                    } else if (0 == nlSubjects.getLength()) {
                        this.log.trace((Object)"No Subject found");
                    } else if (1 != nlSubjects.getLength()) {
                        this.log.trace((Object)"More than one Subject found");
                    } else {
                        this.log.trace((Object)"Processing SAML Subject element");
                        org.w3c.dom.Element domSubject = (org.w3c.dom.Element)nlSubjects.item(0);
                        NodeList nlSubjectConfirmations = domSubject.getElementsByTagNameNS(this.constants.getSAML10Namespace().toString(), "SubjectConfirmation");
                        if (null == nlSubjectConfirmations) {
                            this.log.trace((Object)"No SubjectConfirmation found");
                        } else if (0 == nlSubjectConfirmations.getLength()) {
                            this.log.trace((Object)"No SubjectConfirmation found");
                        } else if (1 != nlSubjectConfirmations.getLength()) {
                            this.log.trace((Object)"More than one SubjectConfirmation found");
                        } else {
                            this.log.trace((Object)"Processing SAML SubjectConfirmation");
                            org.w3c.dom.Element domSubjectConfirmation = (org.w3c.dom.Element)nlSubjectConfirmations.item(0);
                            NodeList nlKeyInfos = domSubjectConfirmation.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "KeyInfo");
                            boolean bFoundKeyInfoInSubjectConfirmation = false;
                            if (null == nlKeyInfos) {
                                this.log.trace((Object)"No KeyInfo found");
                            } else if (0 == nlKeyInfos.getLength()) {
                                this.log.trace((Object)"No KeyInfo found");
                            } else if (1 != nlKeyInfos.getLength()) {
                                this.log.trace((Object)"More than one KeyInfo found");
                            } else {
                                bFoundKeyInfoInSubjectConfirmation = true;
                            }
                            if (!bFoundKeyInfoInSubjectConfirmation) {
                                this.log.trace((Object)"Processing SAML Signature");
                                NodeList nlSignature = domSAMLToken.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "Signature");
                                if (null == nlSignature) {
                                    this.log.trace((Object)"No Signature found");
                                } else if (0 == nlSignature.getLength()) {
                                    this.log.trace((Object)"No Signature found");
                                } else if (1 != nlSignature.getLength()) {
                                    this.log.trace((Object)"More than one Signature found");
                                } else {
                                    org.w3c.dom.Element domSignature = (org.w3c.dom.Element)nlSignature.item(0);
                                    nlKeyInfos = domSignature.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "KeyInfo");
                                    if (null == nlKeyInfos) {
                                        this.log.trace((Object)"No KeyInfo found");
                                    } else if (0 == nlKeyInfos.getLength()) {
                                        this.log.trace((Object)"No KeyInfo found");
                                    } else if (1 != nlKeyInfos.getLength()) {
                                        this.log.trace((Object)"More than one KeyInfo found");
                                    }
                                }
                            }
                            if (1 == nlKeyInfos.getLength()) {
                                this.log.trace((Object)"Processing KeyInfo");
                                org.w3c.dom.Element domKeyInfo = (org.w3c.dom.Element)nlKeyInfos.item(0);
                                NodeList nlKeyValues = domKeyInfo.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "KeyValue");
                                if (null == nlKeyValues) {
                                    this.log.trace((Object)"No KeyValue found");
                                } else if (0 == nlKeyValues.getLength()) {
                                    this.log.trace((Object)"No KeyValue found");
                                } else if (1 != nlKeyValues.getLength()) {
                                    this.log.trace((Object)"More than one KeyValue found");
                                } else {
                                    this.log.trace((Object)"Processing KeyValue");
                                    org.w3c.dom.Element domKeyValue = (org.w3c.dom.Element)nlKeyValues.item(0);
                                    NodeList nlRSAKeyValues = domKeyValue.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "RSAKeyValue");
                                    if (null == nlRSAKeyValues) {
                                        this.log.trace((Object)"No RSAKeyValue found");
                                    } else if (0 == nlRSAKeyValues.getLength()) {
                                        this.log.trace((Object)"No RSAKeyValue found");
                                    } else if (1 != nlRSAKeyValues.getLength()) {
                                        this.log.trace((Object)"More than one RSAKeyValue found");
                                    } else {
                                        this.log.trace((Object)"Processing RSAKeyValue");
                                        org.w3c.dom.Element domRSAKeyValue = (org.w3c.dom.Element)nlRSAKeyValues.item(0);
                                        NodeList nlModuluses = domRSAKeyValue.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "Modulus");
                                        if (null == nlModuluses) {
                                            this.log.trace((Object)"No Modulus found");
                                        } else if (0 == nlModuluses.getLength()) {
                                            this.log.trace((Object)"No Modulus found");
                                        } else if (1 != nlModuluses.getLength()) {
                                            this.log.trace((Object)"More than one Modulus found");
                                        } else {
                                            this.log.trace((Object)"Processing Modulus");
                                            org.w3c.dom.Element domModulus = (org.w3c.dom.Element)nlModuluses.item(0);
                                            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Modulus", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domModulus));
                                            this.log.trace((Object)("Modulus: " + XMLHelper.getTextContent((org.w3c.dom.Element)domModulus)));
                                        }
                                        NodeList nlExponents = domRSAKeyValue.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "Exponent");
                                        if (null == nlExponents) {
                                            this.log.trace((Object)"No Exponent found");
                                        } else if (0 == nlExponents.getLength()) {
                                            this.log.trace((Object)"No Exponent found");
                                        } else if (1 != nlExponents.getLength()) {
                                            this.log.trace((Object)"More than one Exponent found");
                                        } else {
                                            this.log.trace((Object)"Processing Exponent");
                                            org.w3c.dom.Element domExponent = (org.w3c.dom.Element)nlExponents.item(0);
                                            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Exponent", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domExponent));
                                            this.log.trace((Object)("Exponent: " + XMLHelper.getTextContent((org.w3c.dom.Element)domExponent)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            NodeList nlTimestamps = domSecurity.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
            if (null == nlTimestamps) {
                this.log.trace((Object)"No Timestamp found (getElementsByTagName returned null)");
            } else if (0 == nlTimestamps.getLength()) {
                this.log.trace((Object)"No Timestamp found (0 == getLength())");
            } else if (1 != nlTimestamps.getLength()) {
                this.log.trace((Object)"More than one Timestamp found");
            } else {
                this.log.trace((Object)"Processing Timestamp element in Security header");
                org.w3c.dom.Element domTimestamp = (org.w3c.dom.Element)nlTimestamps.item(0);
                NodeList nlCreateds = domTimestamp.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
                if (null == nlCreateds) {
                    this.log.trace((Object)"No Created found");
                } else if (0 == nlCreateds.getLength()) {
                    this.log.trace((Object)"No Created found");
                } else if (1 != nlCreateds.getLength()) {
                    this.log.trace((Object)"More than one Created found");
                } else {
                    org.w3c.dom.Element domCreated = (org.w3c.dom.Element)nlCreateds.item(0);
                    messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Created", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domCreated));
                    this.log.trace((Object)("Found Created: " + XMLHelper.getTextContent((org.w3c.dom.Element)domCreated)));
                }
                NodeList nlExpires = domTimestamp.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
                if (null == nlExpires) {
                    this.log.trace((Object)"No Expires found");
                } else if (0 == nlExpires.getLength()) {
                    this.log.trace((Object)"No Expires found");
                } else if (1 != nlExpires.getLength()) {
                    this.log.trace((Object)"More than one Expires found");
                } else {
                    org.w3c.dom.Element domExpires = (org.w3c.dom.Element)nlExpires.item(0);
                    messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Created", (Object)XMLHelper.getTextContent((org.w3c.dom.Element)domExpires));
                    this.log.trace((Object)("Found Expires: " + XMLHelper.getTextContent((org.w3c.dom.Element)domExpires)));
                }
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw new AxisFault(e.getLocalizedMessage());
        }
        if (null != sheSecurity) {
            sheSecurity.setProcessed(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

