/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.binding.axis1x.security;

import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Used to process WS-Security headers on received request messages
 * 
 * @author mikemci@us.ibm.com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
//TODO: Finish the marshalling on the other side
public class WSSRequestConsumerHandler
	extends org.apache.axis.handlers.BasicHandler
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSSRequestConsumerHandler.class.getName());
	
	private final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
	
	public WSSRequestConsumerHandler()
	{
		this.log.trace("WSSRequestConsumerHandler::WSSRequestConsumerHandler");
	}

	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSSRequestConsumerHandler::invoke");
		
    	final org.eclipse.higgins.sts.utilities.Configuration configurationHandler = new org.eclipse.higgins.sts.utilities.Configuration();
    	
    	try
    	{
    		configurationHandler.configure(null);
    	}
		catch (final Exception e)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);

			this.log.error(errMsg);

			final Fault fault = new Fault
				(this.constants.getWSTrustNamespace(),
				"wst",
				this.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());	
			throw BindingHelper.FaultToAxisFault
				(fault);
		}
    	
		final org.apache.axis.Message mRequest = messageContext.getRequestMessage();
		org.apache.axis.message.SOAPEnvelope seRequest = null;
		try
		{
			seRequest = mRequest.getSOAPEnvelope();    		
		}
		catch (final org.apache.axis.AxisFault af)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			throw af;
		}
    	org.apache.axis.message.SOAPHeaderElement sheSecurity = null;
    	try
    	{
    		sheSecurity = seRequest.getHeaderByName
    			(this.constants.getWSSecurityNamespace().toString(),
    			"Security");
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    			(this.log,
    			af);
			throw af;
    	}
    	if (null == sheSecurity)
    	{
    		this.log.trace("Security header not found.");
    		return;
    	}
    	try
    	{
    		final java.util.Map mapGlobalSettings = configurationHandler.getSettings();
        	final org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
        		("XMLSecurityExtension");
    		final java.security.PrivateKey pkIssuer = (java.security.PrivateKey)mapGlobalSettings.get
    			("IssuerPrivateKey");
    		
    		final org.w3c.dom.Element domSecurity = sheSecurity.getAsDOM();
    		// if anything is encrypted - then we decrypt it first - using our own private key
    		final org.w3c.dom.NodeList nlEncryptedData = domSecurity.getElementsByTagNameNS
				(this.constants.getXMLEncryptionNamespace().toString(),
				"EncryptedData");
			if (null == nlEncryptedData)
			{
				this.log.trace("No EncryptedData found (getElementsByTagName returned null)");
			}
			else if (0 == nlEncryptedData.getLength())
			{
				this.log.trace("No EncryptedData found (0 == getLength())");
			}
			else
			{
				for (int i = 0; i < nlEncryptedData.getLength(); ++i)
				{
					this.log.trace("Processing EncryptedData element in Security header");
					final org.w3c.dom.Element domEncryptedData = (org.w3c.dom.Element)nlEncryptedData.item(0);
					final org.eclipse.higgins.sts.api.IElement elemEncryptedData = new org.eclipse.higgins.sts.common.Element();
					elemEncryptedData.set(domEncryptedData);
					final org.eclipse.higgins.sts.api.IElement elemDecryptedData = xmlSecurity.DecryptElement
						(elemEncryptedData,
						pkIssuer);
				}
			}
    		
    		final org.w3c.dom.NodeList nlUsernameTokens = domSecurity.getElementsByTagNameNS
    			(this.constants.getWSSecurityNamespace().toString(),
    			"UsernameToken");
    		if (null == nlUsernameTokens)
    		{
    			this.log.trace("No UsernameToken found (getElementsByTagName returned null)");
    		}
    		else if (0 == nlUsernameTokens.getLength())
    		{
    			this.log.trace("No UsernameToken found (0 == getLength())");
    		}
    		else if (1 != nlUsernameTokens.getLength())
    		{
    			this.log.trace("More than one UsernameToken found");
    		}
    		else
    		{
				this.log.trace("Processing UsernameToken element in Security header");
    			final org.w3c.dom.Element domUsernameToken = (org.w3c.dom.Element)nlUsernameTokens.item(0);
        		final org.w3c.dom.NodeList nlUsernames = domUsernameToken.getElementsByTagNameNS
    				(this.constants.getWSSecurityNamespace().toString(),
    				"Username");
        		if (null == nlUsernames)
        		{
        			this.log.trace("No Username found");
        		}
        		else if (0 == nlUsernames.getLength())
        		{
        			this.log.trace("No Username found");
        		}
        		else if (1 != nlUsernames.getLength())
        		{
        			this.log.trace("More than one Username found");
        		}
        		else
        		{
        			final org.w3c.dom.Element domUsername = (org.w3c.dom.Element)nlUsernames.item(0);
	          		messageContext.setProperty
	  					(Constants.PROPERTY_REQUEST_CONSUMER_USERNAME,
	  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domUsername));
	        		this.log.trace("Found Username: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domUsername));  
        		}
        		final org.w3c.dom.NodeList nlPasswords = domUsernameToken.getElementsByTagNameNS
    				("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd",
    				"Password");
        		if (null == nlPasswords)
        		{
        			this.log.trace("No Password found");
        		}
        		else if (0 == nlPasswords.getLength())
        		{
        			this.log.trace("No Password found");
        		}
        		else if (1 != nlPasswords.getLength())
        		{
        			this.log.trace("More than one Password found");
        		}
        		else
        		{
        			final org.w3c.dom.Element domPassword = (org.w3c.dom.Element)nlPasswords.item(0);
	          		messageContext.setProperty
	  					(Constants.PROPERTY_REQUEST_CONSUMER_PASSWORD,
	  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domPassword));
	          		/****** Mask password out of trace ******/
	        		//this.log.trace("Found Password: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domPassword));
	          		this.log.trace("Found Password: xxxxx");
	          		/****************************************/
        		}
    		}
    		
    		final org.w3c.dom.NodeList nlSAMLTokens = domSecurity.getElementsByTagNameNS
				(this.constants.getSAML10Namespace().toString(),
				"Assertion");
			if (null == nlSAMLTokens)
			{
				this.log.trace("No SAMLToken found (getElementsByTagName returned null)");
			}
			else if (0 == nlSAMLTokens.getLength())
			{
				this.log.trace("No SAMLToken found (0 == getLength())");
			}
			else if (1 != nlSAMLTokens.getLength())
			{
				this.log.trace("More than one SAMLToken found");
			}
			else
			{
				this.log.trace("Processing SAML Assertion (Token) element in Security header");
				final org.w3c.dom.Element domSAMLToken = (org.w3c.dom.Element)nlSAMLTokens.item(0);
	    		final org.w3c.dom.NodeList nlAttributeStatements = domSAMLToken.getElementsByTagNameNS
					(this.constants.getSAML10Namespace().toString(),
					"AttributeStatement");
	    		if (null == nlAttributeStatements)
	    		{
	    			this.log.trace("No AttributeStatement found");
	    		}
	    		else if (0 == nlAttributeStatements.getLength())
	    		{
	    			this.log.trace("No AttributeStatement found");
	    		}
	    		else if (1 != nlAttributeStatements.getLength())
	    		{
	    			this.log.trace("More than one AttributeStatement found");
	    		}
	    		else
	    		{
	    			this.log.trace("Processing SAML AttributeStatement element");
	    			final org.w3c.dom.Element domAttributeStatement = (org.w3c.dom.Element)nlAttributeStatements.item(0);

	    	    	this.log.trace("Looking for the PPID");
	    	    	
	    	    	final org.w3c.dom.NodeList nlAttributes = domAttributeStatement.getElementsByTagNameNS
	    	    		(this.constants.getSAML10Namespace().toString(), "Attribute");
	    			if (null == nlAttributes)
	    			{
	    				this.log.trace("No Attribute found (getElementsByTagName returned null)");
	    			}
	    			else if (0 == nlAttributes.getLength())
	    			{
	    				this.log.trace("No Attribute found (0 == getLength())");
	    			}
	    			else
	    			{
	    				for (int i = 0; i < nlAttributes.getLength(); ++i)
	    				{
	    					this.log.trace("Processing Attribute element");
	    					final org.w3c.dom.Element elemAttribute = (org.w3c.dom.Element)nlAttributes.item(i);
	    					final String strAttributeName = elemAttribute.getAttribute("AttributeName");
	    					this.log.trace("Attribute: " + strAttributeName);
	    					if (strAttributeName.matches("privatepersonalidentifier"))
	    					{
	    				    	final org.w3c.dom.NodeList nlAttributeValues = elemAttribute.getElementsByTagNameNS
	    				    		(this.constants.getSAML10Namespace().toString(), "AttributeValue");
	    						if (null == nlAttributeValues)
	    						{
	    							this.log.trace("No AttributeValue found (getElementsByTagName returned null)");
	    						}
	    						else if (0 == nlAttributeValues.getLength())
	    						{
	    							this.log.trace("No AttributeValue found (0 == getLength())");
	    						}
	    						else if (1 != nlAttributeValues.getLength())
	    						{
	    							this.log.trace("More than 1 AttributeValue found");
	    						}
	    						else
	    						{
	    							final org.w3c.dom.Element elemAttributeValue = (org.w3c.dom.Element)nlAttributeValues.item(0);
	    			    			final String strPPID = org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(elemAttributeValue);
	    							this.log.trace("PPID: " + strPPID);
						          	messageContext.setProperty
					  					(Constants.PROPERTY_REQUEST_CONSUMER_PPID,
					  					strPPID);
	    							break;
	    						}
	    					}		
	    				}
	    			}

	        		final org.w3c.dom.NodeList nlSubjects = domAttributeStatement.getElementsByTagNameNS
						(this.constants.getSAML10Namespace().toString(),
						"Subject");
		    		if (null == nlSubjects)
		    		{
		    			this.log.trace("No Subject found");
		    		}
		    		else if (0 == nlSubjects.getLength())
		    		{
		    			this.log.trace("No Subject found");
		    		}
		    		else if (1 != nlSubjects.getLength())
		    		{
		    			this.log.trace("More than one Subject found");
		    		}
		    		else
		    		{
		    			this.log.trace("Processing SAML Subject element");
		    			
		    			final org.w3c.dom.Element domSubject = (org.w3c.dom.Element)nlSubjects.item(0);
		        		final org.w3c.dom.NodeList nlSubjectConfirmations = domSubject.getElementsByTagNameNS
							(this.constants.getSAML10Namespace().toString(),
							"SubjectConfirmation");
			    		if (null == nlSubjectConfirmations)
			    		{
			    			this.log.trace("No SubjectConfirmation found");
			    		}
			    		else if (0 == nlSubjectConfirmations.getLength())
			    		{
			    			this.log.trace("No SubjectConfirmation found");
			    		}
			    		else if (1 != nlSubjectConfirmations.getLength())
			    		{
			    			this.log.trace("More than one SubjectConfirmation found");
			    		}
			    		else
			    		{
			    			this.log.trace("Processing SAML SubjectConfirmation");
			    			
			    			final org.w3c.dom.Element domSubjectConfirmation = (org.w3c.dom.Element)nlSubjectConfirmations.item(0);
			        		org.w3c.dom.NodeList nlKeyInfos = domSubjectConfirmation.getElementsByTagNameNS
								(this.constants.getXMLSignatureNamespace().toString(),
								"KeyInfo");
			        		boolean bFoundKeyInfoInSubjectConfirmation = false;
				    		if (null == nlKeyInfos)
				    		{
				    			this.log.trace("No KeyInfo found");
				    		}
				    		else if (0 == nlKeyInfos.getLength())
				    		{
				    			this.log.trace("No KeyInfo found");
				    		}
				    		else if (1 != nlKeyInfos.getLength())
				    		{
				    			this.log.trace("More than one KeyInfo found");
				    		}
				    		else
				    		{
				    			bFoundKeyInfoInSubjectConfirmation = true;
				    		}
				    		if (!bFoundKeyInfoInSubjectConfirmation)
				    		{
				    			this.log.trace("Processing SAML Signature");
				    			final org.w3c.dom.NodeList nlSignature = domSAMLToken.getElementsByTagNameNS
									(this.constants.getXMLSignatureNamespace().toString(),
									"Signature");
					    		if (null == nlSignature)
					    		{
					    			this.log.trace("No Signature found");
					    		}
					    		else if (0 == nlSignature.getLength())
					    		{
					    			this.log.trace("No Signature found");
					    		}
					    		else if (1 != nlSignature.getLength())
					    		{
					    			this.log.trace("More than one Signature found");
					    		}
					    		else
					    		{
					    			final org.w3c.dom.Element domSignature = (org.w3c.dom.Element)nlSignature.item(0);
					        		nlKeyInfos = domSignature.getElementsByTagNameNS
										(this.constants.getXMLSignatureNamespace().toString(),
										"KeyInfo");
						    		if (null == nlKeyInfos)
						    		{
						    			this.log.trace("No KeyInfo found");
						    		}
						    		else if (0 == nlKeyInfos.getLength())
						    		{
						    			this.log.trace("No KeyInfo found");
						    		}
						    		else if (1 != nlKeyInfos.getLength())
						    		{
						    			this.log.trace("More than one KeyInfo found");
						    		}
					    		}
				    		}
					    	if (1 == nlKeyInfos.getLength())
					    	{
				    			this.log.trace("Processing KeyInfo");

				    			final org.w3c.dom.Element domKeyInfo = (org.w3c.dom.Element)nlKeyInfos.item(0);
				        		final org.w3c.dom.NodeList nlKeyValues = domKeyInfo.getElementsByTagNameNS
									(this.constants.getXMLSignatureNamespace().toString(),
									"KeyValue");
					    		if (null == nlKeyValues)
					    		{
					    			this.log.trace("No KeyValue found");
					    		}
					    		else if (0 == nlKeyValues.getLength())
					    		{
					    			this.log.trace("No KeyValue found");
					    		}
					    		else if (1 != nlKeyValues.getLength())
					    		{
					    			this.log.trace("More than one KeyValue found");
					    		}
					    		else
					    		{
					    			this.log.trace("Processing KeyValue");

					    			final org.w3c.dom.Element domKeyValue = (org.w3c.dom.Element)nlKeyValues.item(0);
					        		final org.w3c.dom.NodeList nlRSAKeyValues = domKeyValue.getElementsByTagNameNS
										(this.constants.getXMLSignatureNamespace().toString(),
										"RSAKeyValue");
						    		if (null == nlRSAKeyValues)
						    		{
						    			this.log.trace("No RSAKeyValue found");
						    		}
						    		else if (0 == nlRSAKeyValues.getLength())
						    		{
						    			this.log.trace("No RSAKeyValue found");
						    		}
						    		else if (1 != nlRSAKeyValues.getLength())
						    		{
						    			this.log.trace("More than one RSAKeyValue found");
						    		}
						    		else
						    		{
						    			this.log.trace("Processing RSAKeyValue");

						    			final org.w3c.dom.Element domRSAKeyValue = (org.w3c.dom.Element)nlRSAKeyValues.item(0);
						        		final org.w3c.dom.NodeList nlModuluses = domRSAKeyValue.getElementsByTagNameNS
											(this.constants.getXMLSignatureNamespace().toString(),
											"Modulus");
							    		if (null == nlModuluses)
							    		{
							    			this.log.trace("No Modulus found");
							    		}
							    		else if (0 == nlModuluses.getLength())
							    		{
							    			this.log.trace("No Modulus found");
							    		}
							    		else if (1 != nlModuluses.getLength())
							    		{
							    			this.log.trace("More than one Modulus found");
							    		}
							    		else
							    		{
							    			this.log.trace("Processing Modulus");

							    			final org.w3c.dom.Element domModulus = (org.w3c.dom.Element)nlModuluses.item(0);
								          	messageContext.setProperty
							  					(Constants.PROPERTY_REQUEST_CONSUMER_MODULUS,
							  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domModulus));
							        		this.log.trace("Modulus: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domModulus));  							    			
							    		}
						        		final org.w3c.dom.NodeList nlExponents = domRSAKeyValue.getElementsByTagNameNS
											(this.constants.getXMLSignatureNamespace().toString(),
											"Exponent");
							    		if (null == nlExponents)
							    		{
							    			this.log.trace("No Exponent found");
							    		}
							    		else if (0 == nlExponents.getLength())
							    		{
							    			this.log.trace("No Exponent found");
							    		}
							    		else if (1 != nlExponents.getLength())
							    		{
							    			this.log.trace("More than one Exponent found");
							    		}
							    		else
							    		{
							    			this.log.trace("Processing Exponent");

							    			final org.w3c.dom.Element domExponent = (org.w3c.dom.Element)nlExponents.item(0);
								          	messageContext.setProperty
							  					(Constants.PROPERTY_REQUEST_CONSUMER_EXPONENT,
							  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domExponent));
							        		this.log.trace("Exponent: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domExponent));  							    			
							    		}
						    		}
					    		}
				    		}
			    		}
		    		}
	    		}
			}

    		final org.w3c.dom.NodeList nlTimestamps = domSecurity.getElementsByTagNameNS
				("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
				"Timestamp");
			if (null == nlTimestamps)
			{
				this.log.trace("No Timestamp found (getElementsByTagName returned null)");
			}
			else if (0 == nlTimestamps.getLength())
			{
				this.log.trace("No Timestamp found (0 == getLength())");
			}
			else if (1 != nlTimestamps.getLength())
			{
				this.log.trace("More than one Timestamp found");
			}
			else
			{
				this.log.trace("Processing Timestamp element in Security header");
				final org.w3c.dom.Element domTimestamp = (org.w3c.dom.Element)nlTimestamps.item(0);
	    		final org.w3c.dom.NodeList nlCreateds = domTimestamp.getElementsByTagNameNS
					("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
					"Created");
	    		if (null == nlCreateds)
	    		{
	    			this.log.trace("No Created found");
	    		}
	    		else if (0 == nlCreateds.getLength())
	    		{
	    			this.log.trace("No Created found");
	    		}
	    		else if (1 != nlCreateds.getLength())
	    		{
	    			this.log.trace("More than one Created found");
	    		}
	    		else
	    		{
	    			final org.w3c.dom.Element domCreated = (org.w3c.dom.Element)nlCreateds.item(0);
	          		messageContext.setProperty
	  					(Constants.PROPERTY_REQUEST_CONSUMER_CREATED,
	  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domCreated));
	        		this.log.trace("Found Created: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domCreated));  
	    		}
	    		final org.w3c.dom.NodeList nlExpires = domTimestamp.getElementsByTagNameNS
					("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
					"Expires");
	    		if (null == nlExpires)
	    		{
	    			this.log.trace("No Expires found");
	    		}
	    		else if (0 == nlExpires.getLength())
	    		{
	    			this.log.trace("No Expires found");
	    		}
	    		else if (1 != nlExpires.getLength())
	    		{
	    			this.log.trace("More than one Expires found");
	    		}
	    		else
	    		{
	    			final org.w3c.dom.Element domExpires = (org.w3c.dom.Element)nlExpires.item(0);
	          		messageContext.setProperty
	  					(Constants.PROPERTY_REQUEST_CONSUMER_CREATED,
	  					org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domExpires));
	        		this.log.trace("Found Expires: " + org.eclipse.higgins.sts.utilities.XMLHelper.getTextContent(domExpires));  
	    		}
			}
    	}
    	catch (final Exception e)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
    		throw new org.apache.axis.AxisFault(e.getLocalizedMessage());
    	}
      	if (null != sheSecurity) {
			sheSecurity.setProcessed
      		 	(true);
		}
	}
}
