/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.addressing;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.EndpointReference;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class WSARequestConsumerHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$binding$axis1x$addressing$WSARequestConsumerHandler == null ? (class$org$eclipse$higgins$sts$binding$axis1x$addressing$WSARequestConsumerHandler = WSARequestConsumerHandler.class$("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler")) : class$org$eclipse$higgins$sts$binding$axis1x$addressing$WSARequestConsumerHandler).getName());
    static /* synthetic */ Class class$org$eclipse$higgins$sts$binding$axis1x$addressing$WSARequestConsumerHandler;

    public WSARequestConsumerHandler() {
        this.log.trace((Object)"WSARequestConsumerHandler::WSARequestConsumerHandler");
    }

    private String processURIHeader(MessageContext messageContext, SOAPEnvelope requestEnvelope, String strHeaderName, String strPropertyName) throws AxisFault {
        this.log.trace((Object)("processURIHeader: " + strHeaderName));
        SOAPHeaderElement elemSOAPHeader = null;
        String strNamespace = "http://www.w3.org/2005/08/addressing";
        try {
            elemSOAPHeader = requestEnvelope.getHeaderByName(strNamespace, strHeaderName);
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        if (null == elemSOAPHeader) {
            strNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            try {
                elemSOAPHeader = requestEnvelope.getHeaderByName(strNamespace, strHeaderName);
            }
            catch (AxisFault af) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
                throw af;
            }
        }
        if (null == elemSOAPHeader) {
            strNamespace = null;
        } else {
            this.log.trace((Object)("Name: " + strPropertyName + " Value: " + elemSOAPHeader.getValue()));
            messageContext.setProperty(strPropertyName, (Object)URI.create(elemSOAPHeader.getValue()));
            elemSOAPHeader.setProcessed(true);
        }
        return strNamespace;
    }

    private String processEPRHeader(MessageContext messageContext, SOAPEnvelope requestEnvelope, String strHeaderName, String strPropertyName) throws AxisFault {
        this.log.trace((Object)("processEPRHeader: " + strHeaderName));
        EndpointReference endpointReference = new EndpointReference();
        SOAPHeaderElement elemSOAPHeader = null;
        String strNamespace = "http://www.w3.org/2005/08/addressing";
        try {
            elemSOAPHeader = requestEnvelope.getHeaderByName(strNamespace, strHeaderName);
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        if (null == elemSOAPHeader) {
            strNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            try {
                elemSOAPHeader = requestEnvelope.getHeaderByName(strNamespace, strHeaderName);
            }
            catch (AxisFault af) {
                ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
                throw af;
            }
        }
        if (null == elemSOAPHeader) {
            strNamespace = null;
        } else {
            Iterator iterChildren = elemSOAPHeader.getChildElements();
            List listReferenceParametersElements = endpointReference.getReferenceParametersElements();
            List listMetadataElements = endpointReference.getMetadataElements();
            List listAnyOtherElements = endpointReference.getAnyOtherElements();
            while (iterChildren.hasNext()) {
                SOAPElement seChild = (SOAPElement)iterChildren.next();
                String strLocalName = seChild.getLocalName();
                if (strLocalName.equals("Address")) {
                    String strAddress = seChild.getValue();
                    URI uriAddress = null;
                    try {
                        uriAddress = new URI(strAddress);
                        uriAddress = uriAddress.normalize();
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                    }
                    endpointReference.setAddress(uriAddress);
                    continue;
                }
                Element element = new Element();
                try {
                    element.set((Object)seChild);
                }
                catch (Exception e) {
                    ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                }
                if (strLocalName.equals("ReferenceParameters")) {
                    listReferenceParametersElements.add(element);
                    continue;
                }
                if (strLocalName.equals("Metadata")) {
                    listMetadataElements.add(element);
                    continue;
                }
                listAnyOtherElements.add(element);
            }
            messageContext.setProperty(strPropertyName, (Object)endpointReference);
            elemSOAPHeader.setProcessed(true);
        }
        return strNamespace;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        this.log.trace((Object)"WSARequestConsumerHandler::invoke");
        Message requestMessage = messageContext.getRequestMessage();
        SOAPEnvelope requestEnvelope = null;
        try {
            requestEnvelope = requestMessage.getSOAPEnvelope();
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        org.w3c.dom.Element domEnvelope = null;
        try {
            domEnvelope = requestEnvelope.getAsDOM();
            if (this.log.getLog().isTraceEnabled()) {
                String tmpStr = XMLHelper.toString((org.w3c.dom.Element)domEnvelope);
                String tmpStrLc = tmpStr.toLowerCase();
                if (tmpStrLc.indexOf("password") == -1) {
                    this.log.trace((Object)("Request: " + tmpStr));
                } else {
                    org.w3c.dom.Element domEnvelope2 = null;
                    domEnvelope2 = XMLHelper.toDOM((String)tmpStr);
                    if (domEnvelope2.hasAttribute("Password")) {
                        domEnvelope2.setAttribute("Password", "XXX");
                    } else if (domEnvelope2.hasAttribute("password")) {
                        domEnvelope2.setAttribute("password", "XXX");
                    }
                    this.log.trace((Object)("Request: " + XMLHelper.toString((org.w3c.dom.Element)domEnvelope2)));
                }
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
        }
        boolean bNamespaceSet = false;
        String strAddressingNamespace = null;
        String strNamespace = this.processURIHeader(messageContext, requestEnvelope, "MessageID", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.MessageID");
        if (null != strNamespace) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":MessageID"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:MessageID not found");
        }
        if (null != (strNamespace = this.processURIHeader(messageContext, requestEnvelope, "Action", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.Action"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":Action"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:Action not found");
        }
        if (null != (strNamespace = this.processURIHeader(messageContext, requestEnvelope, "To", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.To"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":To"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:To not found - disabling WSAResponseGeneratorHandler");
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSAResponseGeneratorHandler.Disable", (Object)new Boolean(true));
        }
        if (null != (strNamespace = this.processURIHeader(messageContext, requestEnvelope, "RelatesTo", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.RelatesTo"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":RelatesTo"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:RelatesTo not found");
        }
        if (null != (strNamespace = this.processEPRHeader(messageContext, requestEnvelope, "From", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.From"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":From"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:From not found");
        }
        if (null != (strNamespace = this.processEPRHeader(messageContext, requestEnvelope, "ReplyTo", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.ReplyTo"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":ReplyTo"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:ReplyTo not found");
        }
        if (null != (strNamespace = this.processEPRHeader(messageContext, requestEnvelope, "FaultTo", "org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.FaultTo"))) {
            this.log.trace((Object)("Found WS-Addressing " + strNamespace + ":FaultTo"));
            if (!bNamespaceSet) {
                strAddressingNamespace = strNamespace;
                bNamespaceSet = true;
            }
        } else {
            this.log.trace((Object)"wsa:FaultTo not found");
        }
        if (bNamespaceSet) {
            this.log.trace((Object)("Setting WS-Addressing namespace: " + strAddressingNamespace));
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.Namespace", (Object)URI.create(strAddressingNamespace));
        }
        this.log.trace((Object)"WSARequestConsumerHandler::invoke(done)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

