/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.common;

import java.io.StringWriter;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.higgins.sts.api.IAddressingInformation;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IDisplayClaim;
import org.eclipse.higgins.sts.api.IDisplayToken;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.ILifetime;
import org.eclipse.higgins.sts.api.IMEXResponse;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.common.AddressingInformation;
import org.eclipse.higgins.sts.common.AppliesTo;
import org.eclipse.higgins.sts.common.DisplayClaim;
import org.eclipse.higgins.sts.common.DisplayToken;
import org.eclipse.higgins.sts.common.EndpointReference;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.InformationCardReference;
import org.eclipse.higgins.sts.common.Lifetime;
import org.eclipse.higgins.sts.common.RequestSecurityToken;
import org.eclipse.higgins.sts.common.RequestSecurityTokenResponse;
import org.eclipse.higgins.sts.common.STSRequest;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.DateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.UUIDHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.ws._2004._09.mex.Metadata;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType;
import org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType;

public class BindingHelper {
    private static final LogHelper log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.binding.common.BindingHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new LogHelper(clazz.getName());
    }

    public static MessageElement toElementMessageElement(IElement element) {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new MessageElement((Element)element.getAs((Class)clazz));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static URI toURI(OMElement omURI) {
        return URI.create(omURI.getText());
    }

    public static int toInt(OMElement omInt) {
        try {
            return new Integer(omInt.getText());
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return 0;
        }
    }

    public static boolean toBoolean(OMElement omBoolean) {
        try {
            return new Boolean(omBoolean.getText());
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return false;
        }
    }

    public static ILifetime toLifetime(URI uriWSSUNamespace, OMElement omLifetime) {
        log.trace((Object)"toLifetime");
        Lifetime ltLifetime = new Lifetime();
        QName qnameCreated = new QName(uriWSSUNamespace.toString(), "Created");
        OMElement omCreated = omLifetime.getFirstChildWithName(qnameCreated);
        Date dtCreated = null;
        if (omCreated != null) {
            String strCreated = omCreated.getText();
            log.trace((Object)("Created: " + strCreated));
            dtCreated = DateHelper.getDateFromIso8601((String)strCreated);
            ltLifetime.setCreated(dtCreated);
        }
        QName qnameExpires = new QName(uriWSSUNamespace.toString(), "Expires");
        OMElement omExpires = omLifetime.getFirstChildWithName(qnameExpires);
        Date dtExpires = null;
        if (omExpires != null) {
            String strExpires = omExpires.getText();
            log.trace((Object)("Expires: " + strExpires));
            dtExpires = DateHelper.getDateFromIso8601((String)strExpires);
            ltLifetime.setExpires(dtExpires);
        }
        return ltLifetime;
    }

    public static IAppliesTo toAppliesTo(URI uriWSANamespace, OMElement omAppliesTo, IBase64Extension base64Extension) {
        log.trace((Object)"toAppliesTo");
        AppliesTo appliesTo = new AppliesTo();
        QName qnameEndpointReference = new QName(null, "EndpointReference");
        OMElement omEndpointReference = omAppliesTo.getFirstChildWithName(qnameEndpointReference);
        if (omEndpointReference != null) {
            appliesTo.setEndpointReference(BindingHelper.toEndpointReference(URI.create(omEndpointReference.getNamespace().getNamespaceURI()), omEndpointReference, base64Extension));
        }
        return appliesTo;
    }

    public static IDisplayToken toDisplayToken(OMElement omRequestedDisplayToken) {
        log.trace((Object)"toDisplayToken");
        DisplayToken displayToken = new DisplayToken();
        List listDisplayClaims = displayToken.getDisplayClaimList();
        QName qnameDisplayToken = new QName(null, "DisplayToken");
        QName qnameXMLLang = new QName(null, "lang");
        QName qnameDisplayClaim = new QName(null, "DisplayClaim");
        QName qnameDisplayTag = new QName(null, "DisplayTag");
        QName qnameDisplayValue = new QName(null, "DisplayValue");
        QName qnameUri = new QName(null, "Uri");
        OMElement omDisplayToken = omRequestedDisplayToken.getFirstChildWithName(qnameDisplayToken);
        if (omDisplayToken != null) {
            String strLang = omDisplayToken.getAttributeValue(qnameXMLLang);
            if (strLang == null) {
                strLang = "en";
            }
            if (strLang.length() == 0) {
                strLang = "en";
            }
            displayToken.setLanguage(strLang);
            Iterator iterChildren = omDisplayToken.getChildrenWithName(qnameDisplayClaim);
            while (iterChildren.hasNext()) {
                OMElement omDisplayClaim = (OMElement)iterChildren.next();
                OMElement omDisplayTag = omDisplayClaim.getFirstChildWithName(qnameDisplayTag);
                OMElement omDisplayValue = omDisplayClaim.getFirstChildWithName(qnameDisplayValue);
                DisplayClaim displayClaim = new DisplayClaim();
                String type = omDisplayClaim.getAttributeValue(qnameUri);
                if (type != null) {
                    displayClaim.setType(URI.create(type));
                }
                if (omDisplayTag != null) {
                    displayClaim.setDisplayTag(omDisplayTag.getText());
                }
                if (omDisplayValue != null) {
                    displayClaim.setDisplayValue(omDisplayValue.getText());
                }
                listDisplayClaims.add(displayClaim);
            }
        }
        return displayToken;
    }

    public static IEndpointReference toEndpointReference(URI uriAddressingNamespace, OMElement omEndpointReference, IBase64Extension base64Extension) {
        EndpointReference epr = new EndpointReference();
        List listReferenceParameters = epr.getReferenceParametersElements();
        List listMetadata = epr.getMetadataElements();
        List listAnyOtherElements = epr.getAnyOtherElements();
        Iterator iterChildren = omEndpointReference.getChildElements();
        ArrayList<String> certList = new ArrayList<String>();
        log.trace((Object)"toEndpointReference");
        String strAddress = omEndpointReference.getText();
        while (iterChildren.hasNext()) {
            org.eclipse.higgins.sts.common.Element element;
            OMElement omChild = (OMElement)iterChildren.next();
            String strLocalName = omChild.getLocalName();
            log.trace((Object)("   found [" + strLocalName + "] element"));
            if (strLocalName.equals("Address")) {
                strAddress = omChild.getText();
                continue;
            }
            if (strLocalName.equals("Identity")) {
                Iterator iterIdentityChildren = omChild.getChildElements();
                while (iterIdentityChildren.hasNext()) {
                    OMElement omIdentityChild = (OMElement)iterIdentityChildren.next();
                    String strIdentityChildLocalName = omIdentityChild.getLocalName();
                    log.trace((Object)("   found [Identity." + strIdentityChildLocalName + "] element"));
                    if (!strIdentityChildLocalName.equals("KeyInfo")) continue;
                    Iterator iterKeyInfoChildren = omIdentityChild.getChildElements();
                    while (iterKeyInfoChildren.hasNext()) {
                        OMElement omKeyInfoChild = (OMElement)iterKeyInfoChildren.next();
                        String strKeyInfoChildLocalName = omKeyInfoChild.getLocalName();
                        log.trace((Object)("   found [Identity.KeyInfo." + strKeyInfoChildLocalName + "] element"));
                        if (!strKeyInfoChildLocalName.equals("X509Data")) continue;
                        Iterator iterX509Children = omKeyInfoChild.getChildElements();
                        while (iterX509Children.hasNext()) {
                            OMElement omX509Child = (OMElement)iterX509Children.next();
                            String strX509ChildLocalName = omX509Child.getLocalName();
                            log.trace((Object)("   found [Identity.KeyInfo.X509Data." + strX509ChildLocalName + "] element"));
                            if (!strX509ChildLocalName.equals("X509Certificate")) continue;
                            String strX509Certificate = omX509Child.getText();
                            certList.add(strX509Certificate);
                        }
                    }
                }
                continue;
            }
            if (strLocalName.equals("ReferenceParameters")) {
                Iterator iterReferenceParameters = omChild.getChildElements();
                while (iterReferenceParameters.hasNext()) {
                    OMElement omReferenceParameters = (OMElement)iterReferenceParameters.next();
                    element = new org.eclipse.higgins.sts.common.Element();
                    try {
                        element.set((Object)omReferenceParameters);
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)log, (Exception)e);
                    }
                    listReferenceParameters.add(element);
                }
                continue;
            }
            if (strLocalName.equals("Metadata")) {
                Iterator iterMetadata = omChild.getChildElements();
                while (iterMetadata.hasNext()) {
                    OMElement omMetadata = (OMElement)iterMetadata.next();
                    element = new org.eclipse.higgins.sts.common.Element();
                    try {
                        element.set((Object)omMetadata);
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)log, (Exception)e);
                    }
                    listMetadata.add(element);
                }
                continue;
            }
            org.eclipse.higgins.sts.common.Element element2 = new org.eclipse.higgins.sts.common.Element();
            try {
                element2.set((Object)omChild);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
            }
            listAnyOtherElements.add(element2);
        }
        if (strAddress != null) {
            URI uriAddress = URI.create(strAddress);
            epr.setAddress(uriAddress);
            X509Certificate certLeaf = CertificateHelper.findLeafFromEncodedCertificates(certList);
            if (certLeaf != null) {
                try {
                    epr.setIdentityCertificate(base64Extension.encode(certLeaf.getEncoded()));
                }
                catch (Exception e) {
                    ExceptionHelper.Log((LogHelper)log, (Exception)e);
                }
            }
        }
        return epr;
    }

    public static IInformationCardReference toInformationCardReference(OMElement omInformationCardReference) {
        log.trace((Object)"Begin toInformationCardReference");
        InformationCardReference icr = new InformationCardReference();
        Iterator iterChildren = omInformationCardReference.getChildElements();
        while (iterChildren.hasNext()) {
            OMElement omChild = (OMElement)iterChildren.next();
            String strLocalName = omChild.getLocalName();
            if (strLocalName.equals("CardId")) {
                String strCardId = omChild.getText();
                icr.setCardId(URI.create(strCardId));
                continue;
            }
            if (!strLocalName.equals("CardVersion")) continue;
            String strCardVersion = omChild.getText();
            icr.setCardVersion(strCardVersion);
        }
        log.trace((Object)"End toInformationCardReference");
        return icr;
    }

    public static MessageElement toURIMessageElement(URI uriNamespace, String strPrefix, String strLocalName, URI uriValue) {
        uriNamespace = uriNamespace.normalize();
        uriValue = uriValue.normalize();
        String strElementName = String.valueOf(strPrefix) + ":" + strLocalName;
        try {
            String strElement = "<" + strElementName + " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>" + XMLHelper.escapedString((String)uriValue.toString()) + "</" + strElementName + ">";
            log.trace((Object)("toURIMessageElement: " + strElement));
            return new MessageElement(XMLHelper.toDOM((String)strElement));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static MessageElement toIntMessageElement(URI uriNamespace, String strPrefix, String strLocalName, int nValue) {
        String strElementName = String.valueOf(strPrefix) + ":" + strLocalName;
        try {
            String strElement = "<" + strElementName + " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>" + nValue + "</" + strElementName + ">";
            log.trace((Object)("toIntMessageElement: " + strElement));
            return new MessageElement(XMLHelper.toDOM((String)strElement));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static MessageElement toBooleanMessageElement(URI uriNamespace, String strPrefix, String strLocalName, boolean bValue) {
        String strElementName = String.valueOf(strPrefix) + ":" + strLocalName;
        try {
            String strElement = "<" + strElementName + " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>" + bValue + "</" + strElementName + ">";
            log.trace((Object)("toBooleanMessageElement: " + strElement));
            return new MessageElement(XMLHelper.toDOM((String)strElement));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static MessageElement toLifetimeMessageElement(URI uriTrustNamespace, String strTrustPrefix, URI uriWSSUNamespace, String strWSSUPrefix, ILifetime ltLifetime) {
        Date dtExpires;
        log.trace((Object)"toLifetimeMessageElement");
        String strLifetimeElementName = String.valueOf(strTrustPrefix) + ":Lifetime";
        String strLifetime = "<" + strLifetimeElementName + " xmlns:" + strTrustPrefix + "='" + uriTrustNamespace.toString() + "'" + " xmlns:" + strWSSUPrefix + "='" + uriWSSUNamespace.toString() + "'>";
        Date dtCreated = ltLifetime.getCreated();
        if (dtCreated != null) {
            String strCreatedElementName = String.valueOf(strWSSUPrefix) + ":Created";
            String strCreatedValue = DateHelper.getIso8601Date((Date)dtCreated);
            log.trace((Object)("Created: " + strCreatedValue));
            strLifetime = String.valueOf(strLifetime) + "<" + strCreatedElementName + ">" + strCreatedValue + "</" + strCreatedElementName + ">";
        }
        if ((dtExpires = ltLifetime.getExpires()) != null) {
            String strExpiresElementName = String.valueOf(strWSSUPrefix) + ":Expires";
            String strExpiresValue = DateHelper.getIso8601Date((Date)dtExpires);
            log.trace((Object)("Expires: " + strExpiresValue));
            strLifetime = String.valueOf(strLifetime) + "<" + strExpiresElementName + ">" + strExpiresValue + "</" + strExpiresElementName + ">";
        }
        strLifetime = String.valueOf(strLifetime) + "</" + strLifetimeElementName + ">";
        log.trace((Object)("toLifetimeMessageElement: " + strLifetime));
        try {
            return new MessageElement(XMLHelper.toDOM((String)strLifetime));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static MessageElement toAppliesToMessageElement(URI uriWSPNamespace, String strWSPPrefix, URI uriWSANamespace, String strWSAPrefix, IAppliesTo appliesTo) {
        log.trace((Object)"toAppliesToMessageElement");
        String strAppliesToElementName = String.valueOf(strWSPPrefix) + ":AppliesTo";
        String strAppliesTo = "<" + strAppliesToElementName + " xmlns:" + strWSPPrefix + "='" + uriWSPNamespace.toString() + "'" + " xmlns:" + strWSAPrefix + "='" + uriWSANamespace.toString() + "'>";
        strAppliesTo = String.valueOf(strAppliesTo) + "</" + strAppliesToElementName + ">";
        MessageElement meAppliesTo = null;
        try {
            meAppliesTo = new MessageElement(XMLHelper.toDOM((String)strAppliesTo));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
        IEndpointReference epr = appliesTo.getEndpointReference();
        if (epr != null) {
            try {
                MessageElement meEndpointReference = BindingHelper.toEndpointReferenceMessageElement(uriWSANamespace, strWSAPrefix, "EndpointReference", uriWSANamespace, strWSAPrefix, epr);
                if (meEndpointReference != null) {
                    meAppliesTo.addChild(meEndpointReference);
                }
                return meAppliesTo;
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
            }
        }
        return null;
    }

    public static String toString(IDisplayToken displayToken) {
        log.trace((Object)"toString");
        List listDisplayClaims = displayToken.getDisplayClaimList();
        String strRequestedDisplayToken = "<ic:RequestedDisplayToken xmlns:ic='http://schemas.xmlsoap.org/ws/2005/05/identity'><ic:DisplayToken xml:lang='" + displayToken.getLanguage() + "'>";
        int i = 0;
        while (i < listDisplayClaims.size()) {
            try {
                IDisplayClaim displayClaim = (IDisplayClaim)listDisplayClaims.get(i);
                strRequestedDisplayToken = String.valueOf(strRequestedDisplayToken) + "<ic:DisplayClaim Uri=\"" + StringEscapeUtils.escapeXml((String)displayClaim.getType().toString()) + "\">";
                strRequestedDisplayToken = String.valueOf(strRequestedDisplayToken) + "<ic:DisplayTag>" + StringEscapeUtils.escapeXml((String)displayClaim.getDisplayTag()) + "</ic:DisplayTag>";
                strRequestedDisplayToken = String.valueOf(strRequestedDisplayToken) + "<ic:DisplayValue>" + StringEscapeUtils.escapeXml((String)displayClaim.getDisplayValue()) + "</ic:DisplayValue>";
                strRequestedDisplayToken = String.valueOf(strRequestedDisplayToken) + "</ic:DisplayClaim>";
            }
            catch (Throwable t) {
                ExceptionHelper.Log((LogHelper)log, (Throwable)t);
            }
            ++i;
        }
        strRequestedDisplayToken = String.valueOf(strRequestedDisplayToken) + "</ic:DisplayToken></ic:RequestedDisplayToken>";
        log.trace((Object)("toDisplayTokenMessageElement: " + strRequestedDisplayToken));
        return strRequestedDisplayToken;
    }

    public static MessageElement toDisplayTokenMessageElement(IDisplayToken displayToken) {
        log.trace((Object)"toDisplayTokenMessageElement");
        String strRequestedDisplayToken = BindingHelper.toString(displayToken);
        MessageElement meRequestedDisplayToken = null;
        try {
            meRequestedDisplayToken = new MessageElement(XMLHelper.toDOM((String)strRequestedDisplayToken));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
        return meRequestedDisplayToken;
    }

    public static MessageElement toInformationCardReferenceMessageElement(IInformationCardReference informationCardReference) {
        log.trace((Object)"toInformationCardReferenceMessageElement");
        URI uriCardId = informationCardReference.getCardId();
        String strCardVersion = informationCardReference.getCardVersion();
        String strInformationCardReference = "<ic:InformationCardReference xmlns:ic='http://schemas.xmlsoap.org/ws/2005/05/identity'><ic:CardId>" + XMLHelper.escapedString((String)uriCardId.toString()) + "</ic:CardId>" + "<ic:CardVersion>" + strCardVersion + "</ic:CardVersion>" + "</ic:InformationCardReference>";
        MessageElement meInformationCardReference = null;
        try {
            meInformationCardReference = new MessageElement(XMLHelper.toDOM((String)strInformationCardReference));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
        return meInformationCardReference;
    }

    public static MessageElement toEndpointReferenceMessageElement(URI uriNamespace, String strPrefix, String strLocalName, URI uriAddressingNamespace, String strAddressingPrefix, IEndpointReference ltEndpointReference) {
        List listMetadata;
        List listReferenceParameters;
        String strIdentityCertificate;
        String strEPRElementName = String.valueOf(strPrefix) + ":" + strLocalName;
        String strEPR = "<" + strEPRElementName + " xmlns:" + strPrefix + "='" + uriNamespace.toString();
        if (!strPrefix.equals(strAddressingPrefix)) {
            strEPR = String.valueOf(strEPR) + "' xmlns:" + strAddressingPrefix + "='" + uriAddressingNamespace.toString();
        }
        strEPR = String.valueOf(strEPR) + "'>";
        URI uriAddress = ltEndpointReference.getAddress();
        if (uriAddress != null) {
            String strAddressElementName = String.valueOf(strAddressingPrefix) + ":Address";
            strEPR = String.valueOf(strEPR) + "<" + strAddressElementName + ">" + XMLHelper.escapedString((String)uriAddress.toString()) + "</" + strAddressElementName + ">";
        }
        if ((strIdentityCertificate = ltEndpointReference.getIdentityCertificate()) != null) {
            strEPR = String.valueOf(strEPR) + "<wsid:Identity xmlns:wsid=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>" + strIdentityCertificate + "</ds:X509Certificate>" + "</ds:X509Data>" + "</ds:KeyInfo>" + "</wsid:Identity>";
        }
        if ((listReferenceParameters = ltEndpointReference.getReferenceParametersElements()).size() != 0) {
            String strReferenceParametersName = String.valueOf(strAddressingPrefix) + ":ReferenceParameters";
            strEPR = String.valueOf(strEPR) + "<" + strReferenceParametersName + ">";
            int i = 0;
            while (i < listReferenceParameters.size()) {
                IElement elemReferenceParameters = (IElement)listReferenceParameters.get(i);
                try {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(strEPR));
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    strEPR = stringBuffer.append((String)elemReferenceParameters.getAs((Class)clazz)).toString();
                }
                catch (Exception e) {
                    ExceptionHelper.Log((LogHelper)log, (Exception)e);
                }
                ++i;
            }
            strEPR = String.valueOf(strEPR) + "</" + strReferenceParametersName + ">";
        }
        if ((listMetadata = ltEndpointReference.getMetadataElements()).size() != 0) {
            String strMetadataName = String.valueOf(strAddressingPrefix) + ":Metadata";
            strEPR = String.valueOf(strEPR) + "<" + strMetadataName + ">";
            int i = 0;
            while (i < listMetadata.size()) {
                IElement elemMetadata = (IElement)listMetadata.get(i);
                try {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(strEPR));
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    strEPR = stringBuffer.append((String)elemMetadata.getAs((Class)clazz)).toString();
                }
                catch (Exception e) {
                    ExceptionHelper.Log((LogHelper)log, (Exception)e);
                }
                ++i;
            }
            strEPR = String.valueOf(strEPR) + "</" + strMetadataName + ">";
        }
        List listAnyOther = ltEndpointReference.getAnyOtherElements();
        int i = 0;
        while (i < listAnyOther.size()) {
            IElement elemAnyOther = (IElement)listAnyOther.get(i);
            try {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(strEPR));
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                strEPR = stringBuffer.append((String)elemAnyOther.getAs((Class)clazz)).toString();
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
            }
            ++i;
        }
        strEPR = String.valueOf(strEPR) + "</" + strEPRElementName + ">";
        log.trace((Object)("toEndpointReferenceElement: " + strEPR));
        try {
            return new MessageElement(XMLHelper.toDOM((String)strEPR));
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            return null;
        }
    }

    public static IRequestSecurityToken RSTFromAxis1xRST(IConstants constants, IBase64Extension base64Extension, RequestSecurityTokenType RST) {
        log.trace((Object)"Begin RSTFromAxis1xRST");
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
        String strContext = RST.getContext();
        if (strContext != null) {
            log.trace((Object)("Context: " + strContext));
            requestSecurityToken.setContext(strContext);
        }
        MessageElement[] meRST = RST.get_any();
        int nRequestLength = meRST.length;
        int nRequestIndex = 0;
        while (nRequestIndex < nRequestLength) {
            try {
                OMElement omElement = XMLHelper.toOM((Element)meRST[nRequestIndex].getAsDOM());
                IElement element = XMLHelper.toElement((OMElement)omElement);
                String strLocalName = omElement.getLocalName();
                if (strLocalName.equals("ClientPseudonym")) {
                    requestSecurityToken.setClientPseudonym(element);
                }
                if (strLocalName.equals("InformationCardReference")) {
                    requestSecurityToken.setInformationCardReference(BindingHelper.toInformationCardReference(omElement));
                }
                if (strLocalName.equals("Base")) {
                    requestSecurityToken.setBase(element);
                }
                if (strLocalName.equals("RequestDisplayToken")) {
                    requestSecurityToken.setRequestDisplayToken(element);
                }
                if (strLocalName.equals("ComputedKeyAlgorithm")) {
                    requestSecurityToken.setComputedKeyAlgorithm(BindingHelper.toURI(omElement));
                }
                if (strLocalName.equals("TokenType")) {
                    requestSecurityToken.setTokenType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("RequestType")) {
                    requestSecurityToken.setRequestType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("AppliesTo")) {
                    requestSecurityToken.setAppliesTo(BindingHelper.toAppliesTo(constants.getWSAddressingNamespace(), omElement, base64Extension));
                } else if (strLocalName.equals("CancelTarget")) {
                    requestSecurityToken.setCancelTarget(element);
                } else if (strLocalName.equals("ValidateTarget")) {
                    requestSecurityToken.setValidateTarget(element);
                } else if (strLocalName.equals("Claims")) {
                    requestSecurityToken.setClaims(element);
                } else if (strLocalName.equals("Entropy")) {
                    requestSecurityToken.setEntropy(element);
                } else if (strLocalName.equals("Lifetime")) {
                    requestSecurityToken.setLifetime(BindingHelper.toLifetime(constants.getWSSecurityUtilityNamespace(), omElement));
                } else if (strLocalName.equals("AllowPostdating")) {
                    requestSecurityToken.setAllowPostdating(element);
                } else if (strLocalName.equals("Renewing")) {
                    requestSecurityToken.setRenewing(element);
                } else if (strLocalName.equals("OnBehalfOf")) {
                    requestSecurityToken.setOnBehalfOf(element);
                } else if (strLocalName.equals("Issuer")) {
                    requestSecurityToken.setIssuer(BindingHelper.toEndpointReference(constants.getWSAddressingNamespace(), omElement, base64Extension));
                } else if (strLocalName.equals("AuthenticationType")) {
                    requestSecurityToken.setAuthenticationType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("KeyType")) {
                    requestSecurityToken.setKeyType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("KeySize")) {
                    requestSecurityToken.setKeySize(BindingHelper.toInt(omElement));
                } else if (strLocalName.equals("SignatureAlgorithm")) {
                    requestSecurityToken.setSignatureAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("Encryption")) {
                    requestSecurityToken.setEncryption(element);
                } else if (strLocalName.equals("EncryptionAlgorithm")) {
                    requestSecurityToken.setEncryptionAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("CanonicalizationAlgorithm")) {
                    requestSecurityToken.setCanonicalizationAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("ProofEncryption")) {
                    requestSecurityToken.setProofEncryption(element);
                } else if (strLocalName.equals("UseKey")) {
                    requestSecurityToken.setUseKey(element);
                } else if (strLocalName.equals("SignWith")) {
                    requestSecurityToken.setSignWith(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("EncryptWith")) {
                    requestSecurityToken.setEncryptWith(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("DelegateTo")) {
                    requestSecurityToken.setDelegateTo(element);
                } else if (strLocalName.equals("Forwardable")) {
                    requestSecurityToken.setForwardable(BindingHelper.toBoolean(omElement));
                } else if (strLocalName.equals("Delegatable")) {
                    requestSecurityToken.setDelegatable(BindingHelper.toBoolean(omElement));
                } else if (strLocalName.equals("Policy")) {
                    requestSecurityToken.setPolicy(element);
                } else if (strLocalName.equals("PolicyReference")) {
                    requestSecurityToken.setPolicyReference(element);
                } else {
                    List listAnyOther = requestSecurityToken.getAnyOtherElements();
                    listAnyOther.add(element);
                }
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
                return null;
            }
            ++nRequestIndex;
        }
        log.trace((Object)"End RSTFromAxis1xRST");
        return requestSecurityToken;
    }

    public static AxisFault FaultToAxisFault(IFault fault) {
        QName qname = new QName(fault.getCodeNamespace().toString(), fault.getCodeLocalPart(), fault.getCodePrefix());
        String strDetail = fault.getDetail();
        Element[] domDetails = null;
        if (strDetail != null) {
            strDetail = "<Explanation>" + strDetail + "</Explanation>";
            Element domDetail = null;
            try {
                domDetail = XMLHelper.toDOM((String)strDetail);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
                strDetail = null;
            }
            if (domDetail != null) {
                domDetails = new Element[]{domDetail};
            }
        }
        return new AxisFault(qname, fault.getReason(), null, domDetails);
    }

    public static IFault AxisFaultToAxis(AxisFault fault) {
        Element[] elemFaultDetails = fault.getFaultDetails();
        String strFaultDetails = "";
        int i = 0;
        while (i < elemFaultDetails.length) {
            try {
                strFaultDetails = String.valueOf(strFaultDetails) + XMLHelper.toString((Element)elemFaultDetails[i]);
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
            }
            ++i;
        }
        QName faultCode = fault.getFaultCode();
        Fault result = new Fault(URI.create(faultCode.getNamespaceURI()), faultCode.getPrefix(), faultCode.getLocalPart(), fault.getFaultReason(), strFaultDetails);
        return result;
    }

    public static ISTSRequest STSRequestFromAxis1xRST(MessageContext messageContext, IConstants constants, IBase64Extension base64Extension, RequestSecurityTokenType RST) {
        log.trace((Object)"Begin STSRequestFromAxis1xRST");
        STSRequest request = new STSRequest();
        try {
            Message messageRequest = messageContext.getRequestMessage();
            SOAPEnvelope seRequest = messageRequest.getSOAPEnvelope();
            org.eclipse.higgins.sts.common.Element elemRequestMessage = new org.eclipse.higgins.sts.common.Element();
            elemRequestMessage.set((Object)seRequest.getAsDOM());
            request.setMessage((IElement)elemRequestMessage);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        ISecurityInformation securityInformation = (ISecurityInformation)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Security");
        request.setSecurityInformation(securityInformation);
        AddressingInformation addressingInformation = new AddressingInformation();
        URI uriAddressingNamespace = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.Namespace");
        if (uriAddressingNamespace != null) {
            addressingInformation.setNamespace(uriAddressingNamespace);
        }
        URI uriAction = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.Action");
        try {
            addressingInformation.setAction(uriAction);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        URI uriTo = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.To");
        try {
            addressingInformation.setTo(uriTo);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        IEndpointReference eprFrom = (IEndpointReference)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.From");
        try {
            addressingInformation.setFrom(eprFrom);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        URI uriMessageID = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.MessageID");
        try {
            addressingInformation.setMessageID(uriMessageID);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        URI uriRelatesTo = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.RelatesTo");
        try {
            addressingInformation.setRelatesTo(uriRelatesTo);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        URI uriRelatesToRelationshipType = (URI)messageContext.getProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSARequestConsumerHandler.RelatesToRelationshipType");
        try {
            addressingInformation.setRelatesToRelationshipType(uriRelatesToRelationshipType);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        request.setAddressingInformation((IAddressingInformation)addressingInformation);
        IRequestSecurityToken requestSecurityToken = BindingHelper.RSTFromAxis1xRST(constants, base64Extension, RST);
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(requestSecurityToken);
        log.trace((Object)"End STSRequestFromAxis1xRST");
        return request;
    }

    public static ISTSResponse STSResponseFromSTSRequest(ISTSRequest request, IConstants constants) {
        URI uriRequestMessageID;
        URI uriAction;
        STSResponse response = new STSResponse();
        AddressingInformation responseAddressingInformation = new AddressingInformation();
        IAddressingInformation requestAddressingInformation = request.getAddressingInformation();
        URI uriAddressingNamespace = requestAddressingInformation.getNamespace();
        if (uriAddressingNamespace != null) {
            responseAddressingInformation.setNamespace(uriAddressingNamespace);
        }
        if ((uriAction = requestAddressingInformation.getAction()) != null) {
            if (uriAction.equals(constants.getIssueRequestAction())) {
                responseAddressingInformation.setAction(constants.getIssueResponseAction());
            } else if (uriAction.equals(constants.getValidateRequestAction())) {
                responseAddressingInformation.setAction(constants.getValidateResponseAction());
            } else if (uriAction.equals(constants.getCancelRequestAction())) {
                responseAddressingInformation.setAction(constants.getCancelResponseAction());
            } else if (uriAction.equals(constants.getRenewRequestAction())) {
                responseAddressingInformation.setAction(constants.getRenewResponseAction());
            } else {
                log.trace((Object)"BindingHelper::STSResponseFromSTSRequest Unknown Request Action");
            }
        }
        if ((uriRequestMessageID = requestAddressingInformation.getMessageID()) != null) {
            responseAddressingInformation.setRelatesTo(uriRequestMessageID);
        }
        URI uriResponseMessageID = UUIDHelper.getAsURI();
        responseAddressingInformation.setMessageID(uriResponseMessageID);
        response.setAddressingInformation((IAddressingInformation)responseAddressingInformation);
        List listRST = request.getRequestSecurityTokenCollection();
        RequestSecurityToken RST = (RequestSecurityToken)listRST.get(0);
        RequestSecurityTokenResponse RSTR = new RequestSecurityTokenResponse();
        String strContext = RST.getContext();
        if (strContext != null) {
            RSTR.setContext(strContext);
        }
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        listRSTR.add(RSTR);
        return response;
    }

    public static RequestSecurityTokenResponseType Axis1xRSTRFromSTSResponse(MessageContext messageContext, ISTSResponse response, IConstants constants) {
        URI uriRelatesTo;
        URI uriMessageID;
        URI uriAction;
        log.trace((Object)"Begin Axis1xRSTRFromSTSResponse");
        IAddressingInformation addressingInformation = response.getAddressingInformation();
        URI uriAddressingNamespace = addressingInformation.getNamespace();
        if (uriAddressingNamespace != null) {
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSAResponseGeneratorHandler.Namespace", (Object)uriAddressingNamespace);
        }
        if ((uriAction = addressingInformation.getAction()) != null) {
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSAResponseGeneratorHandler.Action", (Object)uriAction);
        }
        if ((uriMessageID = addressingInformation.getMessageID()) != null) {
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSAResponseGeneratorHandler.MessageID", (Object)uriMessageID);
        }
        if ((uriRelatesTo = addressingInformation.getRelatesTo()) != null) {
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.addressing.WSAResponseGeneratorHandler.RelatesTo", (Object)uriRelatesTo);
        }
        RequestSecurityTokenResponseType RSTR = null;
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        IRequestSecurityTokenResponse requestSecurityTokenResponse = (IRequestSecurityTokenResponse)listRSTR.get(0);
        ArrayList<MessageElement> alME = new ArrayList<MessageElement>();
        try {
            IElement elemPolicyReference;
            IElement elemPolicy;
            Boolean boolDelegatable;
            Boolean boolForwardable;
            IElement elemDelegateTo;
            URI uriEncryptWith;
            URI uriSignWith;
            IElement elemUseKey;
            IElement elemProofEncryption;
            URI uriCanonicalizationAlgorithm;
            URI uriEncryptionAlgorithm;
            IElement elemEncryption;
            URI uriSignatureAlgorithm;
            Integer intKeySize;
            URI uriKeyType;
            IElement elemAuthenticator;
            URI uriAuthenticationType;
            IEndpointReference eprIssuer;
            IElement elemOnBehalfOf;
            IElement elemRenewing;
            IElement elemAllowPostdating;
            IElement elemStatus;
            ILifetime ltLifetime;
            IElement elemEntropy;
            IElement elemRequestedProofToken;
            IElement elemRequestedUnattachedReference;
            IElement elemRequestedAttachedReference;
            IEndpointReference eprAppliesTo;
            IElement elemRequestedSecurityToken;
            URI uriRequestType;
            URI uriTokenType;
            URI uriComputedKey;
            IElement elemRequestedTokenCancelled;
            IDisplayToken dtRequestedDisplayToken = requestSecurityTokenResponse.getRequestedDisplayToken();
            if (dtRequestedDisplayToken != null) {
                alME.add(BindingHelper.toDisplayTokenMessageElement(dtRequestedDisplayToken));
            }
            if ((elemRequestedTokenCancelled = requestSecurityTokenResponse.getRequestedTokenCancelled()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRequestedTokenCancelled.getAs((Class)clazz)));
            }
            if ((uriComputedKey = requestSecurityTokenResponse.getComputedKey()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "ComputedKey", uriComputedKey));
            }
            if ((uriTokenType = requestSecurityTokenResponse.getTokenType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "TokenType", uriTokenType));
            }
            if ((uriRequestType = requestSecurityTokenResponse.getRequestType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "RequestType", uriRequestType));
            }
            if ((elemRequestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRequestedSecurityToken.getAs((Class)clazz)));
            }
            if ((eprAppliesTo = requestSecurityTokenResponse.getAppliesTo()) != null) {
                alME.add(BindingHelper.toEndpointReferenceMessageElement(constants.getWSTrustNamespace(), "wst", "AppliesTo", constants.getWSAddressingNamespace(), "wsa", eprAppliesTo));
            }
            if ((elemRequestedAttachedReference = requestSecurityTokenResponse.getRequestedAttachedReference()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRequestedAttachedReference.getAs((Class)clazz)));
            }
            if ((elemRequestedUnattachedReference = requestSecurityTokenResponse.getRequestedUnattachedReference()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRequestedUnattachedReference.getAs((Class)clazz)));
            }
            if ((elemRequestedProofToken = requestSecurityTokenResponse.getRequestedProofToken()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRequestedProofToken.getAs((Class)clazz)));
            }
            if ((elemEntropy = requestSecurityTokenResponse.getEntropy()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemEntropy.getAs((Class)clazz)));
            }
            if ((ltLifetime = requestSecurityTokenResponse.getLifetime()) != null) {
                alME.add(BindingHelper.toLifetimeMessageElement(constants.getWSTrustNamespace(), "wst", constants.getWSSecurityUtilityNamespace(), "wsu", ltLifetime));
            }
            if ((elemStatus = requestSecurityTokenResponse.getStatus()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemStatus.getAs((Class)clazz)));
            }
            if ((elemAllowPostdating = requestSecurityTokenResponse.getAllowPostdating()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemAllowPostdating.getAs((Class)clazz)));
            }
            if ((elemRenewing = requestSecurityTokenResponse.getRenewing()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemRenewing.getAs((Class)clazz)));
            }
            if ((elemOnBehalfOf = requestSecurityTokenResponse.getOnBehalfOf()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemOnBehalfOf.getAs((Class)clazz)));
            }
            if ((eprIssuer = requestSecurityTokenResponse.getIssuer()) != null) {
                alME.add(BindingHelper.toEndpointReferenceMessageElement(constants.getWSTrustNamespace(), "wst", "Issuer", constants.getWSAddressingNamespace(), "wsa", eprIssuer));
            }
            if ((uriAuthenticationType = requestSecurityTokenResponse.getAuthenticationType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "AuthenticationType", uriAuthenticationType));
            }
            if ((elemAuthenticator = requestSecurityTokenResponse.getAuthenticator()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemAuthenticator.getAs((Class)clazz)));
            }
            if ((uriKeyType = requestSecurityTokenResponse.getKeyType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "KeyType", uriKeyType));
            }
            if ((intKeySize = requestSecurityTokenResponse.getKeySize()) != null) {
                alME.add(BindingHelper.toIntMessageElement(constants.getWSTrustNamespace(), "wst", "KeySize", intKeySize));
            }
            if ((uriSignatureAlgorithm = requestSecurityTokenResponse.getSignatureAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "SignatureAlgorithm", uriSignatureAlgorithm));
            }
            if ((elemEncryption = requestSecurityTokenResponse.getEncryption()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemEncryption.getAs((Class)clazz)));
            }
            if ((uriEncryptionAlgorithm = requestSecurityTokenResponse.getEncryptionAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "EncryptionAlgorithm", uriEncryptionAlgorithm));
            }
            if ((uriCanonicalizationAlgorithm = requestSecurityTokenResponse.getCanonicalizationAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "CanonicalizationAlgorithm", uriCanonicalizationAlgorithm));
            }
            if ((elemProofEncryption = requestSecurityTokenResponse.getProofEncryption()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemProofEncryption.getAs((Class)clazz)));
            }
            if ((elemUseKey = requestSecurityTokenResponse.getUseKey()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemUseKey.getAs((Class)clazz)));
            }
            if ((uriSignWith = requestSecurityTokenResponse.getSignWith()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "SignWith", uriSignWith));
            }
            if ((uriEncryptWith = requestSecurityTokenResponse.getEncryptWith()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "EncryptWith", uriEncryptWith));
            }
            if ((elemDelegateTo = requestSecurityTokenResponse.getDelegateTo()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemDelegateTo.getAs((Class)clazz)));
            }
            if ((boolForwardable = requestSecurityTokenResponse.getForwardable()) != null) {
                alME.add(BindingHelper.toBooleanMessageElement(constants.getWSTrustNamespace(), "wst", "Forwardable", boolForwardable));
            }
            if ((boolDelegatable = requestSecurityTokenResponse.getDelegatable()) != null) {
                alME.add(BindingHelper.toBooleanMessageElement(constants.getWSTrustNamespace(), "wst", "Delegatable", boolDelegatable));
            }
            if ((elemPolicy = requestSecurityTokenResponse.getPolicy()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemPolicy.getAs((Class)clazz)));
            }
            if ((elemPolicyReference = requestSecurityTokenResponse.getPolicyReference()) != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)elemPolicyReference.getAs((Class)clazz)));
            }
            List setAnyOther = requestSecurityTokenResponse.getAnyOtherElements();
            Iterator iterAnyOther = setAnyOther.iterator();
            while (iterAnyOther.hasNext()) {
                IElement element = (IElement)iterAnyOther.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                alME.add(new MessageElement((Element)element.getAs((Class)clazz)));
            }
            MessageElement[] meRSTR = new MessageElement[alME.size()];
            alME.toArray(meRSTR);
            RSTR = new RequestSecurityTokenResponseType();
            RSTR.set_any(meRSTR);
            String strContext = requestSecurityTokenResponse.getContext();
            if (strContext != null) {
                log.trace((Object)("setContext: " + strContext));
                RSTR.setContext(strContext);
            } else {
                log.trace((Object)"getContext is null");
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        log.trace((Object)"End Axis1xRSTRFromSTSResponse");
        return RSTR;
    }

    public static void STSResponseFromAxis1xRSTR(MessageContext messageContext, IConstants constants, IBase64Extension base64Extension, RequestSecurityTokenResponseType RSTR, ISTSResponse response) {
        log.trace((Object)"Begin STSResponseFromAxis1xRSTR");
        try {
            Message messageResponse = messageContext.getResponseMessage();
            SOAPEnvelope seResponse = messageResponse.getSOAPEnvelope();
            org.eclipse.higgins.sts.common.Element elemResponseMessage = new org.eclipse.higgins.sts.common.Element();
            elemResponseMessage.set((Object)seResponse.getAsDOM());
            response.setMessage((IElement)elemResponseMessage);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        RequestSecurityTokenResponse requestSecurityTokenResponse = BindingHelper.RSTRFromAxis1xRSTR(constants, base64Extension, RSTR);
        List listRSTR = response.getRequestSecurityTokenResponseCollection();
        listRSTR.add(requestSecurityTokenResponse);
        log.trace((Object)"End STSResponseFromAxis1xRSTR");
    }

    public static Metadata toAxis1xMetadata(IElement elemMetadata) throws Exception {
        Metadata metadata = new Metadata();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Element domMetadata = (Element)elemMetadata.getAs((Class)clazz);
        NodeList nlMetadataSections = domMetadata.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        MessageElement[] messageElements = new MessageElement[nlMetadataSections.getLength()];
        int i = 0;
        while (i < nlMetadataSections.getLength()) {
            Element domMetadataSection = (Element)nlMetadataSections.item(i);
            messageElements[i] = new MessageElement(domMetadataSection);
            ++i;
        }
        metadata.set_any(messageElements);
        return metadata;
    }

    public static String toString(Metadata metadata) throws Exception {
        QName qname = new QName("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext(writer);
        context.serialize(qname, null, metadata);
        return new String(writer.getBuffer());
    }

    public static void MEXResponseFromAxis1xMetadata(IConstants constants, Metadata metadata, IMEXResponse response) {
        org.eclipse.higgins.sts.common.Element elemMetadata = new org.eclipse.higgins.sts.common.Element();
        try {
            String strMetadata = BindingHelper.toString(metadata);
            elemMetadata.set((Object)strMetadata);
            response.setMetadata((IElement)elemMetadata);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
            response.setFault((IFault)fault);
        }
    }

    public static RequestSecurityTokenResponse RSTRFromAxis1xRSTR(IConstants constants, IBase64Extension base64Extension, RequestSecurityTokenResponseType RSTR) {
        log.trace((Object)"Begin RSTRFromAxis1xRSTR");
        RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse();
        String strContext = RSTR.getContext();
        if (strContext != null) {
            log.trace((Object)("Context: " + strContext));
            requestSecurityTokenResponse.setContext(strContext);
        }
        MessageElement[] meRSTR = RSTR.get_any();
        int nResponseLength = meRSTR.length;
        int nResponseIndex = 0;
        while (nResponseIndex < nResponseLength) {
            try {
                OMElement omElement = XMLHelper.toOM((Element)meRSTR[nResponseIndex].getAsDOM());
                IElement element = XMLHelper.toElement((OMElement)omElement);
                String strLocalName = omElement.getLocalName();
                if (strLocalName.equals("RequestedTokenCancelled")) {
                    requestSecurityTokenResponse.setRequestedTokenCancelled(element);
                }
                if (strLocalName.equals("RequestedDisplayToken")) {
                    requestSecurityTokenResponse.setRequestedDisplayToken(BindingHelper.toDisplayToken(omElement));
                }
                if (strLocalName.equals("TokenType")) {
                    requestSecurityTokenResponse.setTokenType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("ComputedKey")) {
                    requestSecurityTokenResponse.setComputedKey(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("RequestType")) {
                    requestSecurityTokenResponse.setRequestType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("RequestedSecurityToken")) {
                    requestSecurityTokenResponse.setRequestedSecurityToken(element);
                } else if (strLocalName.equals("AppliesTo")) {
                    requestSecurityTokenResponse.setAppliesTo(BindingHelper.toEndpointReference(constants.getWSAddressingNamespace(), omElement, base64Extension));
                } else if (strLocalName.equals("RequestedAttachedReference")) {
                    requestSecurityTokenResponse.setRequestedAttachedReference(element);
                } else if (strLocalName.equals("RequestedUnattachedReference")) {
                    requestSecurityTokenResponse.setRequestedUnattachedReference(element);
                } else if (strLocalName.equals("RequestedProofToken")) {
                    requestSecurityTokenResponse.setRequestedProofToken(element);
                } else if (strLocalName.equals("Entropy")) {
                    requestSecurityTokenResponse.setEntropy(element);
                } else if (strLocalName.equals("Lifetime")) {
                    requestSecurityTokenResponse.setLifetime(BindingHelper.toLifetime(constants.getWSSecurityUtilityNamespace(), omElement));
                } else if (strLocalName.equals("Status")) {
                    requestSecurityTokenResponse.setStatus(element);
                } else if (strLocalName.equals("AllowPostdating")) {
                    requestSecurityTokenResponse.setAllowPostdating(element);
                } else if (strLocalName.equals("Renewing")) {
                    requestSecurityTokenResponse.setRenewing(element);
                } else if (strLocalName.equals("OnBehalfOf")) {
                    requestSecurityTokenResponse.setOnBehalfOf(element);
                } else if (strLocalName.equals("Issuer")) {
                    requestSecurityTokenResponse.setIssuer(BindingHelper.toEndpointReference(constants.getWSAddressingNamespace(), omElement, base64Extension));
                } else if (strLocalName.equals("AuthenticationType")) {
                    requestSecurityTokenResponse.setAuthenticationType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("Authenticator")) {
                    requestSecurityTokenResponse.setAuthenticator(element);
                } else if (strLocalName.equals("KeyType")) {
                    requestSecurityTokenResponse.setKeyType(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("KeySize")) {
                    requestSecurityTokenResponse.setKeySize(BindingHelper.toInt(omElement));
                } else if (strLocalName.equals("SignatureAlgorithm")) {
                    requestSecurityTokenResponse.setSignatureAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("Encryption")) {
                    requestSecurityTokenResponse.setEncryption(element);
                } else if (strLocalName.equals("EncryptionAlgorithm")) {
                    requestSecurityTokenResponse.setEncryptionAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("CanonicalizationAlgorithm")) {
                    requestSecurityTokenResponse.setCanonicalizationAlgorithm(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("ProofEncryption")) {
                    requestSecurityTokenResponse.setProofEncryption(element);
                } else if (strLocalName.equals("UseKey")) {
                    requestSecurityTokenResponse.setUseKey(element);
                } else if (strLocalName.equals("SignWith")) {
                    requestSecurityTokenResponse.setSignWith(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("EncryptWith")) {
                    requestSecurityTokenResponse.setEncryptWith(BindingHelper.toURI(omElement));
                } else if (strLocalName.equals("DelegateTo")) {
                    requestSecurityTokenResponse.setDelegateTo(element);
                } else if (strLocalName.equals("Forwardable")) {
                    requestSecurityTokenResponse.setForwardable(BindingHelper.toBoolean(omElement));
                } else if (strLocalName.equals("Delegatable")) {
                    requestSecurityTokenResponse.setDelegatable(BindingHelper.toBoolean(omElement));
                } else if (strLocalName.equals("Policy")) {
                    requestSecurityTokenResponse.setPolicy(element);
                } else if (strLocalName.equals("PolicyReference")) {
                    requestSecurityTokenResponse.setPolicyReference(element);
                } else {
                    List listAnyOther = requestSecurityTokenResponse.getAnyOtherElements();
                    listAnyOther.add(element);
                }
            }
            catch (Exception e) {
                ExceptionHelper.Log((LogHelper)log, (Exception)e);
                return null;
            }
            ++nResponseIndex;
        }
        log.trace((Object)"End RSTRFromAxis1xRSTR");
        return requestSecurityTokenResponse;
    }

    public static RequestSecurityTokenType Axis1xRSTFromSTSRequest(ISTSRequest request, IConstants constants) {
        log.trace((Object)"Begin Axis1xRSTFromSTSRequest");
        RequestSecurityTokenType RST = new RequestSecurityTokenType();
        List listRST = request.getRequestSecurityTokenCollection();
        IRequestSecurityToken requestSecurityToken = (IRequestSecurityToken)listRST.get(0);
        ArrayList<MessageElement> alME = new ArrayList<MessageElement>();
        try {
            IElement elemClientPseudonym;
            IElement elemPolicyReference;
            IElement elemPolicy;
            Boolean boolDelegatable;
            Boolean boolForwardable;
            IElement elemDelegateTo;
            URI uriEncryptWith;
            URI uriSignWith;
            IElement elemUseKey;
            IElement elemProofEncryption;
            URI uriCanonicalizationAlgorithm;
            URI uriEncryptionAlgorithm;
            IElement elemEncryption;
            URI uriSignatureAlgorithm;
            Integer intKeySize;
            URI uriKeyType;
            URI uriAuthenticationType;
            IEndpointReference eprIssuer;
            IElement elemOnBehalfOf;
            IElement elemRenewing;
            IElement elemAllowPostdating;
            ILifetime ltLifetime;
            IElement elemEntropy;
            IElement elemClaims;
            IElement elemRenewTarget;
            IElement elemValidateTarget;
            IElement elemCancelTarget;
            IAppliesTo appliesTo;
            URI uriRequestType;
            URI uriTokenType;
            URI uriComputedKeyAlgorithm;
            IElement elemBase;
            IElement elemRequestDisplayToken;
            IInformationCardReference informationCardReference;
            String strContext = requestSecurityToken.getContext();
            if (strContext != null) {
                log.trace((Object)("Context: " + strContext));
                RST.setContext(strContext);
            }
            if ((informationCardReference = requestSecurityToken.getInformationCardReference()) != null) {
                alME.add(BindingHelper.toInformationCardReferenceMessageElement(informationCardReference));
            }
            if ((elemRequestDisplayToken = requestSecurityToken.getRequestDisplayToken()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemRequestDisplayToken));
            }
            if ((elemBase = requestSecurityToken.getBase()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemBase));
            }
            if ((uriComputedKeyAlgorithm = requestSecurityToken.getComputedKeyAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "ComputedKeyAlgorithm", uriComputedKeyAlgorithm));
            }
            if ((uriTokenType = requestSecurityToken.getTokenType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "TokenType", uriTokenType));
            }
            if ((uriRequestType = requestSecurityToken.getRequestType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "RequestType", uriRequestType));
            }
            if ((appliesTo = requestSecurityToken.getAppliesTo()) != null) {
                alME.add(BindingHelper.toAppliesToMessageElement(constants.getWSPolicyNamespace(), "wsp", constants.getWSAddressingNamespace(), "wsa", appliesTo));
            }
            if ((elemCancelTarget = requestSecurityToken.getCancelTarget()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemCancelTarget));
            }
            if ((elemValidateTarget = requestSecurityToken.getValidateTarget()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemValidateTarget));
            }
            if ((elemRenewTarget = requestSecurityToken.getRenewTarget()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemRenewTarget));
            }
            if ((elemClaims = requestSecurityToken.getClaims()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemClaims));
            }
            if ((elemEntropy = requestSecurityToken.getEntropy()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemEntropy));
            }
            if ((ltLifetime = requestSecurityToken.getLifetime()) != null) {
                alME.add(BindingHelper.toLifetimeMessageElement(constants.getWSTrustNamespace(), "wst", constants.getWSSecurityUtilityNamespace(), "wsu", ltLifetime));
            }
            if ((elemAllowPostdating = requestSecurityToken.getAllowPostdating()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemAllowPostdating));
            }
            if ((elemRenewing = requestSecurityToken.getRenewing()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemRenewing));
            }
            if ((elemOnBehalfOf = requestSecurityToken.getOnBehalfOf()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemOnBehalfOf));
            }
            if ((eprIssuer = requestSecurityToken.getIssuer()) != null) {
                alME.add(BindingHelper.toEndpointReferenceMessageElement(constants.getWSTrustNamespace(), "wst", "Issuer", constants.getWSAddressingNamespace(), "wsa", eprIssuer));
            }
            if ((uriAuthenticationType = requestSecurityToken.getAuthenticationType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "AuthenticationType", uriAuthenticationType));
            }
            if ((uriKeyType = requestSecurityToken.getKeyType()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "KeyType", uriKeyType));
            }
            if ((intKeySize = requestSecurityToken.getKeySize()) != null) {
                alME.add(BindingHelper.toIntMessageElement(constants.getWSTrustNamespace(), "wst", "KeySize", intKeySize));
            }
            if ((uriSignatureAlgorithm = requestSecurityToken.getSignatureAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "SignatureAlgorithm", uriSignatureAlgorithm));
            }
            if ((elemEncryption = requestSecurityToken.getEncryption()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemEncryption));
            }
            if ((uriEncryptionAlgorithm = requestSecurityToken.getEncryptionAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "EncryptionAlgorithm", uriEncryptionAlgorithm));
            }
            if ((uriCanonicalizationAlgorithm = requestSecurityToken.getCanonicalizationAlgorithm()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "CanonicalizationAlgorithm", uriCanonicalizationAlgorithm));
            }
            if ((elemProofEncryption = requestSecurityToken.getProofEncryption()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemProofEncryption));
            }
            if ((elemUseKey = requestSecurityToken.getUseKey()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemUseKey));
            }
            if ((uriSignWith = requestSecurityToken.getSignWith()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "SignWith", uriSignWith));
            }
            if ((uriEncryptWith = requestSecurityToken.getEncryptWith()) != null) {
                alME.add(BindingHelper.toURIMessageElement(constants.getWSTrustNamespace(), "wst", "EncryptWith", uriEncryptWith));
            }
            if ((elemDelegateTo = requestSecurityToken.getDelegateTo()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemDelegateTo));
            }
            if ((boolForwardable = requestSecurityToken.getForwardable()) != null) {
                alME.add(BindingHelper.toBooleanMessageElement(constants.getWSTrustNamespace(), "wst", "Forwardable", boolForwardable));
            }
            if ((boolDelegatable = requestSecurityToken.getDelegatable()) != null) {
                alME.add(BindingHelper.toBooleanMessageElement(constants.getWSTrustNamespace(), "wst", "Delegatable", boolDelegatable));
            }
            if ((elemPolicy = requestSecurityToken.getPolicy()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemPolicy));
            }
            if ((elemPolicyReference = requestSecurityToken.getPolicyReference()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemPolicyReference));
            }
            if ((elemClientPseudonym = requestSecurityToken.getClientPseudonym()) != null) {
                alME.add(BindingHelper.toElementMessageElement(elemClientPseudonym));
            }
            List setAnyOther = requestSecurityToken.getAnyOtherElements();
            Iterator iterAnyOther = setAnyOther.iterator();
            while (iterAnyOther.hasNext()) {
                IElement element = (IElement)iterAnyOther.next();
                alME.add(BindingHelper.toElementMessageElement(element));
            }
            MessageElement[] meRST = new MessageElement[alME.size()];
            alME.toArray(meRST);
            RST.set_any(meRST);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)log, (Exception)e);
        }
        log.trace((Object)"End Axis1xRSTFromSTSRequest");
        return RST;
    }
}

