/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x.addressing;

import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Used to add WS-Addressing headers to response messages
 * 
 * @author mikemci at us dot ibm dot com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
public class WSAResponseGeneratorHandler extends org.apache.axis.handlers.BasicHandler
{
	private static final long serialVersionUID = 1L;

	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSAResponseGeneratorHandler.class.getName());
	
	public WSAResponseGeneratorHandler()
	{
		this.log.trace("WSAResponseGeneratorHandler::WSAResponseGeneratorHandler");		
	}

	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSAResponseGeneratorHandler::invoke");

		final Boolean bDisable = (Boolean)messageContext.getProperty
			(Constants.PROPERTY_RESPONSE_GENERATOR_DISABLE);
		if (null != bDisable)
		{
			if (bDisable.booleanValue())
			{
				this.log.trace("WSAResponseGeneratorHandler disabled for this message");
				return;
			}
		}
    	final org.apache.axis.Message responseMessage = messageContext.getResponseMessage();
        final org.apache.axis.soap.SOAPConstants soapConstants = messageContext.getSOAPConstants();
        this.log.trace("SOAPConstants: " + soapConstants.getClass().getName());
    	org.apache.axis.message.SOAPEnvelope responseEnvelope = null;
    	try
    	{
    		responseEnvelope = responseMessage.getSOAPEnvelope();
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    			(this.log,
    			af);
			throw af;
    	}
        
		java.net.URI uriNamespace = (java.net.URI)messageContext.getProperty
			(Constants.PROPERTY_RESPONSE_GENERATOR_NAMESPACE_URI);
		if (null == uriNamespace)
		{
			this.log.trace("WS-Addressing Namespace not set - using default");
			uriNamespace = java.net.URI.create("http://www.w3.org/2005/08/addressing");
		}
		else
		{
			uriNamespace = uriNamespace.normalize();
		}
    	
		final java.net.URI uriAction = (java.net.URI)messageContext.getProperty
			(Constants.PROPERTY_RESPONSE_GENERATOR_ACTION_URI);
		if (null == uriAction)
		{
			this.log.trace("WS-Addressing Action not set");			
		}
		else
		{
			uriNamespace = uriNamespace.normalize();
			final org.apache.axis.message.SOAPHeaderElement headerAction = new org.apache.axis.message.SOAPHeaderElement
				(uriNamespace.toString(),
				"Action");
			try
			{
				headerAction.addTextNode(uriAction.toString());
			}
			catch (final javax.xml.soap.SOAPException se)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					se);

	    		String errMsg = MsgHelper.getString(MsgHelper.caught_exception, "WSAResponseGeneratorHandler","invoke", "org.apache.axis.message.SOAPHeaderElement.getAsDOMorg.apache.axis.message.SOAPHeaderElement.getAsDOM");
				throw new org.apache.axis.AxisFault(errMsg, se);

			}
			headerAction.setRole(null);
			headerAction.setMustUnderstand(true);
			responseEnvelope.addHeader(headerAction);
		}
		java.net.URI uriRelatesTo = (java.net.URI)messageContext.getProperty
			(Constants.PROPERTY_RESPONSE_GENERATOR_RELATES_TO_URI);
		if (null == uriRelatesTo)
		{
			this.log.trace("WS-Addressing RelatesTo not set");			
		}
		else
		{
			uriRelatesTo = uriRelatesTo.normalize();
			final org.apache.axis.message.SOAPHeaderElement headerRelatesTo = new org.apache.axis.message.SOAPHeaderElement
				(uriNamespace.toString(),
				"RelatesTo"); 
			try
			{
				headerRelatesTo.addTextNode(uriRelatesTo.toString());
			}
			catch (final javax.xml.soap.SOAPException se)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					se);

	    		String errMsg = MsgHelper.getString(MsgHelper.caught_exception,"WSAResponseGeneratorHandler", "invoke", "org.apache.axis.message.SOAPHeaderElement.getAsDOM");
				throw new org.apache.axis.AxisFault(errMsg, se);
			}
			headerRelatesTo.setRole(null);
			responseEnvelope.addHeader(headerRelatesTo);
		}
		java.net.URI uriMessageID = (java.net.URI)messageContext.getProperty
			(Constants.PROPERTY_RESPONSE_GENERATOR_MESSAGE_ID_URI);
		if (null == uriMessageID)
		{
			this.log.trace("WS-Addressing MessageID not set");
		}
		else
		{
			uriMessageID = uriMessageID.normalize();
			final org.apache.axis.message.SOAPHeaderElement headerMessageID = new org.apache.axis.message.SOAPHeaderElement
				(uriNamespace.toString(),
				"MessageID");
			try
			{
				headerMessageID.addTextNode(uriMessageID.toString());
			}
			catch (final javax.xml.soap.SOAPException se)
			{
				org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					se);

				String errMsg = MsgHelper.getString(MsgHelper.caught_exception,"WSAResponseGeneratorHandler", "invoke", "org.apache.axis.message.SOAPHeaderElement.getAsDOM");
				throw new org.apache.axis.AxisFault(errMsg,se);
			}
			headerMessageID.setRole(null);
			responseEnvelope.addHeader(headerMessageID);
		}
		
		final org.apache.axis.message.SOAPHeaderElement headerTo = new org.apache.axis.message.SOAPHeaderElement
			(uriNamespace.toString(),
			"To");
		try
		{
			headerTo.addTextNode
				(java.net.URI.create(uriNamespace.toString() + "/anonymous").toString());
		}
		catch (final javax.xml.soap.SOAPException se)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				se);
			String errMsg = MsgHelper.getString(MsgHelper.caught_exception,"WSAResponseGeneratorHandler", "invoke", "org.apache.axis.message.SOAPHeaderElement.getAsDOM");
			throw new org.apache.axis.AxisFault(errMsg,se);
		}
		headerTo.setRole(null);
		headerTo.setMustUnderstand(true);
		responseEnvelope.addHeader(headerTo);
		// TODO: Implement To and From
	}
}
