/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd;


/**
 * This type represents a username token per Section 4.1
 */
public class UsernameTokenType  implements java.io.Serializable, org.apache.axis.encoding.AnyContentType {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.AttributedString username;

    private org.apache.axis.message.MessageElement [] _any;

    private org.apache.axis.types.Id id;  // attribute

    public UsernameTokenType() {
    }

    public UsernameTokenType(
           final org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.AttributedString username,
           final org.apache.axis.message.MessageElement [] _any,
           final org.apache.axis.types.Id id) {
           this.username = username;
           this._any = _any;
           this.id = id;
    }


    /**
     * Gets the username value for this UsernameTokenType.
     * 
     * @return username
     */
    public org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.AttributedString getUsername() {
        return this.username;
    }


    /**
     * Sets the username value for this UsernameTokenType.
     * 
     * @param username
     */
    public void setUsername(final org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0_xsd.AttributedString username) {
        this.username = username;
    }


    /**
     * Gets the _any value for this UsernameTokenType.
     * 
     * @return _any
     */
    public org.apache.axis.message.MessageElement [] get_any() {
        return this._any;
    }


    /**
     * Sets the _any value for this UsernameTokenType.
     * 
     * @param _any
     */
    public void set_any(final org.apache.axis.message.MessageElement [] _any) {
        this._any = _any;
    }


    /**
     * Gets the id value for this UsernameTokenType.
     * 
     * @return id
     */
    public org.apache.axis.types.Id getId() {
        return this.id;
    }


    /**
     * Sets the id value for this UsernameTokenType.
     * 
     * @param id
     */
    public void setId(final org.apache.axis.types.Id id) {
        this.id = id;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof UsernameTokenType)) {
			return false;
		}
        final UsernameTokenType other = (UsernameTokenType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.username==null) && (other.getUsername()==null)) || 
             ((this.username!=null) &&
              this.username.equals(other.getUsername()))) &&
            (((this._any==null) && (other.get_any()==null)) || 
             ((this._any!=null) &&
              java.util.Arrays.equals(this._any, other.get_any()))) &&
            (((this.id==null) && (other.getId()==null)) || 
             ((this.id!=null) &&
              this.id.equals(other.getId())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getUsername() != null) {
            _hashCode += this.getUsername().hashCode();
        }
        if (this.get_any() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.get_any());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.get_any(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getId() != null) {
            _hashCode += this.getId().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UsernameTokenType.class, true);

    static {
        UsernameTokenType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameTokenType"));
        final org.apache.axis.description.AttributeDesc attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("id");
        attrField.setXmlName(new javax.xml.namespace.QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "ID"));
        UsernameTokenType.typeDesc.addFieldDesc(attrField);
        final org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("username");
        elemField.setXmlName(new javax.xml.namespace.QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "AttributedString"));
        elemField.setNillable(false);
        UsernameTokenType.typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return UsernameTokenType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, UsernameTokenType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, UsernameTokenType.typeDesc);
    }

}
