/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.ArraySerializer;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.SimpleListSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.IDKey;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.utils.cache.MethodCache;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContext
implements javax.xml.rpc.encoding.SerializationContext {
    protected static Log log;
    private final boolean debugEnabled = log.isDebugEnabled();
    private NSStack nsStack = null;
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private final Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private QName currentXMLType;
    private QName itemQName;
    private QName itemType;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private static final QName multirefQName;
    private static final Class[] SERIALIZER_CLASSES;
    private static final String SERIALIZER_METHOD = "getSerializer";
    private boolean doMultiRefs = false;
    private boolean disablePrettyXML = false;
    private boolean enableNamespacePrefixOptimization = false;
    private boolean pretty = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private Boolean sendNull = Boolean.TRUE;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private boolean noNamespaceMappings = true;
    private QName writeXMLType;
    private XMLEncoder encoder = null;
    protected boolean startOfDocument = true;
    private String encoding = "UTF-8";
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    HashMap preferredPrefixes = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SerializationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        multirefQName = new QName("", "multiRef");
        Class[] classArray = new Class[3];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("javax.xml.namespace.QName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        SERIALIZER_CLASSES = classArray;
    }

    public SerializationContext(Writer writer) {
        this.writer = writer;
        this.initialize();
    }

    private void initialize() {
        this.preferredPrefixes.put(this.soapConstants.getEncodingURI(), "soapenc");
        this.preferredPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.preferredPrefixes.put(this.schemaVersion.getXsdURI(), "xsd");
        this.preferredPrefixes.put(this.schemaVersion.getXsiURI(), "xsi");
        this.preferredPrefixes.put(this.soapConstants.getEnvelopeURI(), "soapenv");
        this.nsStack = new NSStack(this.enableNamespacePrefixOptimization);
    }

    public SerializationContext(Writer writer, MessageContext msgContext) {
        this.writer = writer;
        this.msgContext = msgContext;
        if (msgContext != null) {
            Boolean shouldDisableNamespacePrefixOptimization;
            Boolean shouldDisablePrettyXML;
            Boolean shouldSendMultiRefs;
            this.soapConstants = msgContext.getSOAPConstants();
            this.schemaVersion = msgContext.getSchemaVersion();
            Boolean shouldSendDecl = (Boolean)msgContext.getProperty("sendXMLDeclaration");
            if (shouldSendDecl != null) {
                this.sendXMLDecl = shouldSendDecl;
            }
            if ((shouldSendMultiRefs = (Boolean)msgContext.getProperty("sendMultiRefs")) != null) {
                this.doMultiRefs = shouldSendMultiRefs;
            }
            if ((shouldDisablePrettyXML = (Boolean)msgContext.getProperty("disablePrettyXML")) != null) {
                this.disablePrettyXML = shouldDisablePrettyXML;
            }
            this.enableNamespacePrefixOptimization = (shouldDisableNamespacePrefixOptimization = (Boolean)msgContext.getProperty("enableNamespacePrefixOptimization")) != null ? shouldDisableNamespacePrefixOptimization : JavaUtils.isTrue((String)AxisProperties.getProperty((String)"enableNamespacePrefixOptimization", (String)"true"));
            boolean sendTypesDefault = this.sendXSIType;
            OperationDesc operation = msgContext.getOperation();
            if (operation != null) {
                if (operation.getUse() != Use.ENCODED) {
                    this.doMultiRefs = false;
                    sendTypesDefault = false;
                }
            } else {
                SOAPService service = msgContext.getService();
                if (service != null && service.getUse() != Use.ENCODED) {
                    this.doMultiRefs = false;
                    sendTypesDefault = false;
                }
            }
            if (!msgContext.isPropertyTrue("sendXsiTypes", sendTypesDefault)) {
                this.sendXSIType = false;
            }
        } else {
            this.enableNamespacePrefixOptimization = JavaUtils.isTrue((String)AxisProperties.getProperty((String)"enableNamespacePrefixOptimization", (String)"true"));
        }
        this.initialize();
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        if (!this.disablePrettyXML) {
            this.pretty = pretty;
        }
    }

    public boolean getDoMultiRefs() {
        return this.doMultiRefs;
    }

    public void setDoMultiRefs(boolean shouldDo) {
        this.doMultiRefs = shouldDo;
    }

    public void setSendDecl(boolean sendDecl) {
        this.sendXMLDecl = sendDecl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.getSingletonDelegate();
        }
        String encodingStyle = this.msgContext.getEncodingStyle();
        if (encodingStyle == null) {
            encodingStyle = this.soapConstants.getEncodingURI();
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        return this.getPrefixForURI(uri, defaultPrefix, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix, boolean attribute) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.nsStack.getPrefix(uri, attribute);
        if (prefix == null) {
            prefix = (String)this.preferredPrefixes.get(uri);
            if (prefix == null) {
                if (defaultPrefix == null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                    while (this.nsStack.getNamespaceURI(prefix) != null) {
                        prefix = "ns" + this.lastPrefixIndex++;
                    }
                } else {
                    prefix = defaultPrefix;
                }
            }
            this.registerPrefixForURI(prefix, uri);
        }
        return prefix;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (this.debugEnabled) {
            log.debug((Object)Messages.getMessage((String)"register00", (String)prefix, (String)uri));
        }
        if (uri != null && prefix != null) {
            String activePrefix;
            if (this.noNamespaceMappings) {
                this.nsStack.push();
                this.noNamespaceMappings = false;
            }
            if ((activePrefix = this.nsStack.getPrefix(uri, true)) == null || !activePrefix.equals(prefix)) {
                this.nsStack.add(uri, prefix);
            }
        }
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String getEncodingStyle() {
        return this.msgContext == null ? Use.DEFAULT.getEncoding() : this.msgContext.getEncodingStyle();
    }

    public boolean isEncoded() {
        return Constants.isSOAP_ENC((String)this.getEncodingStyle());
    }

    public String qName2String(QName qName, boolean writeNS) {
        String prefix = null;
        String namespaceURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        if (localPart != null && localPart.length() > 0) {
            int index = localPart.indexOf(58);
            if (index != -1) {
                prefix = localPart.substring(0, index);
                if (prefix.length() > 0 && !prefix.equals("urn")) {
                    this.registerPrefixForURI(prefix, namespaceURI);
                    localPart = localPart.substring(index + 1);
                } else {
                    prefix = null;
                }
            }
            localPart = Utils.getLastLocalPart((String)localPart);
        }
        if (namespaceURI.length() == 0) {
            String defaultNS;
            if (writeNS && (defaultNS = this.nsStack.getNamespaceURI("")) != null && defaultNS.length() > 0) {
                this.registerPrefixForURI("", "");
            }
        } else {
            prefix = this.getPrefixForURI(namespaceURI);
        }
        if (prefix == null || prefix.length() == 0) {
            return localPart;
        }
        return String.valueOf(prefix) + ':' + localPart;
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, false);
    }

    public String attributeQName2String(QName qName) {
        String prefix = null;
        String uri = qName.getNamespaceURI();
        if (uri.length() > 0) {
            prefix = this.getPrefixForURI(uri, null, true);
        }
        if (prefix == null || prefix.length() == 0) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    public QName getQNameForClass(Class cls) {
        return this.getTypeMapping().getTypeQName(cls);
    }

    public boolean isPrimitive(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> javaType = value.getClass();
        if (javaType.isPrimitive()) {
            return true;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (javaType == clazz) {
            return true;
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("org.apache.axis.types.HexBinary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (javaType == clazz6) {
            return true;
        }
        if (javaType.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(javaType);
        return qName != null && Constants.isSchemaXSD((String)qName.getNamespaceURI()) && SchemaUtils.isSimpleSchemaType((QName)qName);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value) throws IOException {
        this.serialize(elemQName, attributes, value, null, null, null, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType) throws IOException {
        this.serialize(elemQName, attributes, value, xmlType, null, null, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, Class javaType) throws IOException {
        this.serialize(elemQName, attributes, value, xmlType, javaType, null, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, boolean sendNull, Boolean sendType) throws IOException {
        this.serialize(elemQName, attributes, value, xmlType, null, sendNull ? Boolean.TRUE : Boolean.FALSE, sendType);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, Boolean sendNull, Boolean sendType) throws IOException {
        this.serialize(elemQName, attributes, value, xmlType, null, sendNull, sendType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, Class javaClass, Boolean sendNull, Boolean sendType) throws IOException {
        boolean sendXSITypeCache = this.sendXSIType;
        if (sendType != null) {
            this.sendXSIType = sendType;
        }
        boolean shouldSendType = this.shouldSendXSIType();
        try {
            block18: {
                block16: {
                    String id;
                    Boolean sendNullCache;
                    block21: {
                        MultiRefItem mri;
                        block19: {
                            block20: {
                                block17: {
                                    Attachments attachments;
                                    block15: {
                                        sendNullCache = this.sendNull;
                                        if (sendNull != null) {
                                            this.sendNull = sendNull;
                                        } else {
                                            sendNull = this.sendNull;
                                        }
                                        if (value != null) break block15;
                                        if (this.sendNull.booleanValue()) {
                                            AttributesImpl attrs = new AttributesImpl();
                                            if (attributes != null && attributes.getLength() > 0) {
                                                attrs.setAttributes(attributes);
                                            }
                                            if (shouldSendType) {
                                                attrs = (AttributesImpl)this.setTypeAttribute(attrs, xmlType);
                                            }
                                            String nil = this.schemaVersion.getNilQName().getLocalPart();
                                            attrs.addAttribute(this.schemaVersion.getXsiURI(), nil, "xsi:" + nil, "CDATA", "true");
                                            this.startElement(elemQName, attrs);
                                            this.endElement();
                                        }
                                        this.sendNull = sendNullCache;
                                        break block16;
                                    }
                                    Message msg = this.getCurrentMessage();
                                    if (msg == null || (attachments = this.getCurrentMessage().getAttachmentsImpl()) == null || !attachments.isAttachment(value)) break block17;
                                    this.serializeActual(elemQName, attributes, value, xmlType, javaClass, sendType);
                                    this.sendNull = sendNullCache;
                                    break block16;
                                }
                                if (!this.doMultiRefs || !this.isEncoded() || value == this.forceSer || this.isPrimitive(value)) break block18;
                                if (this.multiRefIndex == -1) {
                                    this.multiRefValues = new HashMap();
                                }
                                if ((mri = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(value))) != null) break block19;
                                ++this.multiRefIndex;
                                id = "id" + this.multiRefIndex;
                                mri = new MultiRefItem(id, xmlType, sendType, value);
                                this.multiRefValues.put(this.getIdentityKey(value), mri);
                                if (this.soapConstants != SOAPConstants.SOAP12_CONSTANTS) break block20;
                                AttributesImpl attrs = new AttributesImpl();
                                if (attributes != null && attributes.getLength() > 0) {
                                    attrs.setAttributes(attributes);
                                }
                                attrs.addAttribute("", "id", "id", "CDATA", id);
                                this.serializeActual(elemQName, attrs, value, xmlType, javaClass, sendType);
                                this.sendNull = sendNullCache;
                                break block16;
                            }
                            if (this.outputMultiRefsFlag) {
                                if (this.secondLevelObjects == null) {
                                    this.secondLevelObjects = new HashSet();
                                }
                                this.secondLevelObjects.add(this.getIdentityKey(value));
                            }
                            break block21;
                        }
                        id = mri.id;
                    }
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && attributes.getLength() > 0) {
                        attrs.setAttributes(attributes);
                    }
                    attrs.addAttribute("", this.soapConstants.getAttrHref(), this.soapConstants.getAttrHref(), "CDATA", String.valueOf('#') + id);
                    this.startElement(elemQName, attrs);
                    this.endElement();
                    this.sendNull = sendNullCache;
                }
                Object var15_15 = null;
                this.sendXSIType = sendXSITypeCache;
                return;
            }
            if (value == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(elemQName, attributes, value, xmlType, javaClass, sendType);
            Object var15_17 = null;
            this.sendXSIType = sendXSITypeCache;
            return;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.sendXSIType = sendXSITypeCache;
            throw throwable;
        }
    }

    private IDKey getIdentityKey(Object value) {
        return new IDKey(value);
    }

    /*
     * Unable to fully structure code
     */
    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        attrs = new AttributesImpl();
        attrs.addAttribute("", "", "", "", "");
        encodingURI = this.soapConstants.getEncodingURI();
        prefix = this.getPrefixForURI(encodingURI);
        root = String.valueOf(prefix) + ":root";
        attrs.addAttribute(encodingURI, "root", root, "CDATA", "0");
        encodingStyle = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        encStyle = String.valueOf(this.getPrefixForURI(this.soapConstants.getEnvelopeURI())) + ':' + "encodingStyle";
        attrs.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", encStyle, "CDATA", encodingStyle);
        keys = new HashSet<K>();
        keys.addAll(this.multiRefValues.keySet());
        i = keys.iterator();
        ** GOTO lbl29
        {
            attrs2 = new AttributesImpl(attrs);
            val = i.next();
            mri = (MultiRefItem)this.multiRefValues.get(val);
            attrs2.setAttribute(0, "", "id", "id", "CDATA", mri.id);
            this.forceSer = mri.value;
            this.serialize(SerializationContext.multirefQName, attrs2, mri.value, mri.xmlType, null, this.sendNull, Boolean.TRUE);
            do {
                if (i.hasNext()) continue block0;
                if (this.secondLevelObjects == null) continue;
                i = this.secondLevelObjects.iterator();
                this.secondLevelObjects = null;
lbl29:
                // 3 sources

            } while (i.hasNext());
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    public void writeXMLDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(this.encoding);
        this.writer.write("\"?>\n");
        this.startOfDocument = false;
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        ArrayList<String> vecQNames = null;
        if (this.debugEnabled) {
            log.debug((Object)Messages.getMessage((String)"startElem00", (String)("[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart())));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(32);
                ++i;
            }
        }
        String elementQName = this.qName2String(qName, true);
        this.writer.write(60);
        this.writer.write(elementQName);
        if (this.writeXMLType != null) {
            attributes = this.setTypeAttribute(attributes, this.writeXMLType);
            this.writeXMLType = null;
        }
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String qname = attributes.getQName(i);
                this.writer.write(32);
                String prefix = "";
                String uri = attributes.getURI(i);
                if (uri != null && uri.length() > 0) {
                    if (qname.length() == 0) {
                        prefix = this.getPrefixForURI(uri);
                    } else {
                        int idx = qname.indexOf(58);
                        if (idx > -1) {
                            prefix = qname.substring(0, idx);
                            prefix = this.getPrefixForURI(uri, prefix, true);
                        }
                    }
                    qname = prefix.length() > 0 ? String.valueOf(prefix) + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    qname = attributes.getQName(i);
                    if (qname.length() == 0) {
                        qname = attributes.getLocalName(i);
                    }
                }
                if (qname.startsWith("xmlns")) {
                    if (vecQNames == null) {
                        vecQNames = new ArrayList<String>();
                    }
                    vecQNames.add(qname);
                }
                this.writer.write(qname);
                this.writer.write("=\"");
                this.getEncoder().writeEncoded(this.writer, attributes.getValue(i));
                this.writer.write(34);
                ++i;
            }
        }
        if (this.noNamespaceMappings) {
            this.nsStack.push();
        } else {
            Mapping map = this.nsStack.topOfFrame();
            while (map != null) {
                if (!(map.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && map.getPrefix().equals("xmlns") || map.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") && map.getPrefix().equals("xml"))) {
                    StringBuffer sb = new StringBuffer("xmlns");
                    if (map.getPrefix().length() > 0) {
                        sb.append(':');
                        sb.append(map.getPrefix());
                    }
                    if (vecQNames == null || vecQNames.indexOf(sb.toString()) == -1) {
                        this.writer.write(32);
                        sb.append("=\"");
                        sb.append(map.getNamespaceURI());
                        sb.append('\"');
                        this.writer.write(sb.toString());
                    }
                }
                map = this.nsStack.next();
            }
            this.noNamespaceMappings = true;
        }
        this.writingStartTag = true;
        this.elementStack.push(elementQName);
        this.onlyXML = true;
    }

    public void endElement() throws IOException {
        String elementQName = (String)this.elementStack.pop();
        if (this.debugEnabled) {
            log.debug((Object)Messages.getMessage((String)"endElem00", (String)elementQName));
        }
        this.nsStack.pop();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                int i = 0;
                while (i < this.indent) {
                    this.writer.write(32);
                    ++i;
                }
            }
        }
        this.writer.write("</");
        this.writer.write(elementQName);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.onlyXML = true;
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(p1, p2, p3));
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.onlyXML = false;
    }

    public void writeSafeString(String string) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.getEncoder().writeEncoded(this.writer, string);
        this.onlyXML = false;
    }

    public void writeDOMElement(Element el) throws IOException {
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writeXMLDeclaration();
        }
        if (el instanceof org.apache.axis.message.Text) {
            this.writeSafeString(((Text)((Object)el)).getData());
            return;
        }
        AttributesImpl attributes = null;
        NamedNodeMap attrMap = el.getAttributes();
        if (attrMap.getLength() > 0) {
            attributes = new AttributesImpl();
            int i = 0;
            while (i < attrMap.getLength()) {
                Attr attr = (Attr)attrMap.item(i);
                String tmp = attr.getNamespaceURI();
                if (tmp != null && tmp.equals("http://www.w3.org/2000/xmlns/")) {
                    String prefix = attr.getLocalName();
                    if (prefix != null) {
                        if (prefix.equals("xmlns")) {
                            prefix = "";
                        }
                        String nsURI = attr.getValue();
                        this.registerPrefixForURI(prefix, nsURI);
                    }
                } else {
                    attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
                }
                ++i;
            }
        }
        String namespaceURI = el.getNamespaceURI();
        String localPart = el.getLocalName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            localPart = el.getNodeName();
        }
        QName qName = new QName(namespaceURI, localPart);
        this.startElement(qName, attributes);
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.writeDOMElement((Element)child);
            } else if (child instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)child).getData());
                this.writeString("]]>");
            } else if (child instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)child).getData());
                this.writeString("-->");
            } else if (child instanceof Text) {
                this.writeSafeString(((Text)child).getData());
            }
            ++i;
        }
        this.endElement();
    }

    public final Serializer getSerializerForJavaType(Class javaType) {
        SerializerFactory serF = null;
        Serializer ser = null;
        try {
            serF = (SerializerFactory)this.getTypeMapping().getSerializer(javaType);
            if (serF != null) {
                ser = (Serializer)serF.getSerializerAs("Axis SAX Mechanism");
            }
        }
        catch (JAXRPCException jAXRPCException) {}
        return ser;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        SchemaVersion schema = SchemaVersion.SCHEMA_2001;
        if (this.msgContext != null) {
            schema = this.msgContext.getSchemaVersion();
        }
        if (type == null || type.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex(schema.getXsiURI(), "type") != -1) {
            return attributes;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null && attributes.getLength() > 0) {
            attrs.setAttributes(attributes);
        }
        String prefix = this.getPrefixForURI(schema.getXsiURI(), "xsi");
        attrs.addAttribute(schema.getXsiURI(), "type", String.valueOf(prefix) + ":type", "CDATA", this.attributeQName2String(type));
        return attrs;
    }

    private void serializeActual(QName elemQName, Attributes attributes, Object value, QName xmlType, Class javaClass, Boolean sendType) throws IOException {
        boolean shouldSendType;
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value != null) {
            TypeMapping tm = this.getTypeMapping();
            if (tm == null) {
                throw new IOException(Messages.getMessage((String)"noSerializer00", (String)value.getClass().getName(), (String)("" + this)));
            }
            this.currentXMLType = xmlType;
            if (Constants.equals((QName)Constants.XSD_ANYTYPE, (QName)xmlType)) {
                xmlType = null;
                shouldSendType = true;
            }
            QNameHolder actualXMLType = new QNameHolder();
            Class javaType = this.getActualJavaClass(xmlType, javaClass, value);
            Serializer ser = this.getSerializer(javaType, xmlType, actualXMLType);
            if (ser != null) {
                if (shouldSendType || xmlType != null && !xmlType.equals(actualXMLType.value)) {
                    if (!this.isEncoded()) {
                        if (!(Constants.isSOAP_ENC((String)actualXMLType.value.getNamespaceURI()) || javaType.isPrimitive() && javaClass != null && JavaUtils.getWrapperClass((Class)javaType) == javaClass || javaType.isArray() && xmlType != null && Constants.isSchemaXSD((String)xmlType.getNamespaceURI()))) {
                            this.writeXMLType = actualXMLType.value;
                        }
                    } else {
                        this.writeXMLType = actualXMLType.value;
                    }
                }
                ser.serialize(elemQName, attributes, value, this);
                return;
            }
            throw new IOException(Messages.getMessage((String)"noSerializer00", (String)value.getClass().getName(), (String)("" + tm)));
        }
    }

    private Class getActualJavaClass(QName xmlType, Class javaType, Object obj) {
        Class<?> cls;
        block9: {
            block8: {
                cls = obj.getClass();
                if (xmlType != null && Constants.isSchemaXSD((String)xmlType.getNamespaceURI()) && "anyType".equals(xmlType.getLocalPart())) break block8;
                if (javaType == null) break block9;
                if (javaType.isArray()) break block8;
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (javaType != clazz) break block9;
            }
            return cls;
        }
        if (javaType != null && cls != javaType && !cls.isArray()) {
            return javaType;
        }
        return cls;
    }

    private Serializer getSerializerFromClass(Class javaType, QName qname) {
        Serializer serializer = null;
        try {
            Method method = MethodCache.getInstance().getMethod(javaType, SERIALIZER_METHOD, SERIALIZER_CLASSES);
            if (method != null) {
                serializer = (Serializer)method.invoke(null, this.getEncodingStyle(), javaType, qname);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return serializer;
    }

    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class javaType, QName xmlType, TypeMapping tm) {
        SerializerFactory serFactory = null;
        Class<?>[] interfaces = javaType.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                Class<?> iface = interfaces[i];
                serFactory = (SerializerFactory)tm.getSerializer(iface, xmlType);
                if (serFactory == null) {
                    serFactory = this.getSerializerFactoryFromInterface(iface, xmlType, tm);
                }
                if (serFactory != null) break;
                ++i;
            }
        }
        return serFactory;
    }

    private Serializer getSerializer(Class javaType, QName xmlType, QNameHolder actualXMLType) {
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        if (actualXMLType != null) {
            actualXMLType.value = null;
        }
        while (javaType != null) {
            serFactory = (SerializerFactory)tm.getSerializer(javaType, xmlType);
            if (serFactory != null) break;
            Serializer serializer = this.getSerializerFromClass(javaType, xmlType);
            if (serializer != null) {
                TypeDesc typedesc;
                if (actualXMLType != null && (typedesc = TypeDesc.getTypeDescForClass((Class)javaType)) != null) {
                    actualXMLType.value = typedesc.getXmlType();
                }
                return serializer;
            }
            serFactory = this.getSerializerFactoryFromInterface(javaType, xmlType, tm);
            if (serFactory != null) break;
            javaType = javaType.getSuperclass();
        }
        Serializer ser = null;
        if (serFactory != null) {
            ser = (Serializer)serFactory.getSerializerAs("Axis SAX Mechanism");
            if (actualXMLType != null) {
                if (serFactory instanceof BaseSerializerFactory) {
                    actualXMLType.value = ((BaseSerializerFactory)serFactory).getXMLType();
                }
                boolean encoded = this.isEncoded();
                if (actualXMLType.value == null || !encoded && (actualXMLType.value.equals(Constants.SOAP_ARRAY) || actualXMLType.value.equals(Constants.SOAP_ARRAY12))) {
                    actualXMLType.value = tm.getXMLType(javaType, xmlType, encoded);
                }
            }
        }
        return ser;
    }

    public String getValueAsString(Object value, QName xmlType, Class javaClass) throws IOException {
        Class cls = value.getClass();
        cls = this.getActualJavaClass(xmlType, javaClass, value);
        Serializer ser = this.getSerializer(cls, xmlType, null);
        if (ser instanceof ArraySerializer) {
            SimpleListSerializerFactory factory = new SimpleListSerializerFactory(cls, xmlType);
            ser = (Serializer)factory.getSerializerAs(this.getEncodingStyle());
        }
        if (!(ser instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage((String)"needSimpleValueSer", (String)ser.getClass().getName()));
        }
        SimpleValueSerializer simpleSer = (SimpleValueSerializer)ser;
        return simpleSer.getValueAsString(value, this);
    }

    public void setWriteXMLType(QName type) {
        this.writeXMLType = type;
    }

    public XMLEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = XMLUtils.getXMLEncoder((String)this.encoding);
        }
        return this.encoder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public QName getItemQName() {
        return this.itemQName;
    }

    public void setItemQName(QName itemQName) {
        this.itemQName = itemQName;
    }

    public QName getItemType() {
        return this.itemType;
    }

    public void setItemType(QName itemType) {
        this.itemType = itemType;
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;

        MultiRefItem(String id, QName xmlType, Boolean sendType, Object value) {
            this.id = id;
            this.xmlType = xmlType;
            this.sendType = sendType;
            this.value = value;
        }
    }
}

