/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.security;

import java.security.PrivateKey;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISecurityElement;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.BinarySecurityToken;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.CustomSecurityToken;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.common.SAML11Token;
import org.eclipse.higgins.sts.common.SecurityInformation;
import org.eclipse.higgins.sts.common.Timestamp;
import org.eclipse.higgins.sts.common.UsernameToken;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.Configuration;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSRequestConsumerHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private final LogHelper log;
    private final IConstants constants;
    static /* synthetic */ Class class$0;

    public WSSRequestConsumerHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.constants = new Constants();
        this.log.trace((Object)"WSSRequestConsumerHandler::WSSRequestConsumerHandler");
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        this.log.trace((Object)"WSSRequestConsumerHandler::invoke");
        Configuration configurationHandler = new Configuration();
        try {
            configurationHandler.configure(null);
        }
        catch (Exception e) {
            String errMsg = MsgHelper.getString((String)"not_initialized");
            this.log.error((Object)errMsg);
            Fault fault = new Fault(this.constants.getWSTrustNamespace(), "wst", this.constants.getRequestFailedFaultCode(), "The specified request failed", e.getLocalizedMessage());
            throw BindingHelper.FaultToAxisFault((IFault)fault);
        }
        Message mRequest = messageContext.getRequestMessage();
        SOAPEnvelope seRequest = null;
        try {
            seRequest = mRequest.getSOAPEnvelope();
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        SOAPHeaderElement sheSecurity = null;
        try {
            sheSecurity = seRequest.getHeaderByName(this.constants.getWSSecurityNamespace().toString(), "Security");
        }
        catch (AxisFault af) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)((Object)af));
            throw af;
        }
        if (sheSecurity == null) {
            this.log.trace((Object)"Security header not found.");
            return;
        }
        try {
            SecurityInformation securityInformation = new SecurityInformation();
            Map mapGlobalSettings = configurationHandler.getSettings();
            IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
            PrivateKey pkIssuer = (PrivateKey)mapGlobalSettings.get("IssuerPrivateKey");
            org.w3c.dom.Element domSecurity = sheSecurity.getAsDOM();
            NodeList nlEncryptedData = domSecurity.getElementsByTagNameNS(this.constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
            if (nlEncryptedData == null) {
                this.log.trace((Object)"No EncryptedData found (getElementsByTagName returned null)");
            } else if (nlEncryptedData.getLength() == 0) {
                this.log.trace((Object)"No EncryptedData found (0 == getLength())");
            } else {
                int i = 0;
                while (i < nlEncryptedData.getLength()) {
                    this.log.trace((Object)"Processing EncryptedData element in Security header");
                    org.w3c.dom.Element domEncryptedData = (org.w3c.dom.Element)nlEncryptedData.item(0);
                    Element elemEncryptedData = new Element();
                    elemEncryptedData.set((Object)domEncryptedData);
                    xmlSecurity.DecryptElement((IElement)elemEncryptedData, pkIssuer);
                    ++i;
                }
            }
            NodeList nlSignatures = domSecurity.getElementsByTagNameNS(this.constants.getXMLSignatureNamespace().toString(), "Signature");
            if (nlSignatures == null) {
                this.log.trace((Object)"No Signature found (getElementsByTagName returned null)");
            } else if (nlSignatures.getLength() == 0) {
                this.log.trace((Object)"No Signature found (0 == getLength())");
            } else {
                int i = 0;
                while (i < nlSignatures.getLength()) {
                    this.log.trace((Object)"Processing Signature element in Security header");
                    org.w3c.dom.Element domSignature = (org.w3c.dom.Element)nlSignatures.item(0);
                    Element elemSignature = new Element();
                    elemSignature.set((Object)domSignature);
                    ++i;
                }
            }
            NodeList nlSecurityNodes = domSecurity.getChildNodes();
            int i = 0;
            while (i < nlSecurityNodes.getLength()) {
                Node nodeSecurityNode = nlSecurityNodes.item(i);
                if (1 == nodeSecurityNode.getNodeType()) {
                    org.w3c.dom.Element domSecurityElement = (org.w3c.dom.Element)nodeSecurityNode;
                    String strLocalName = domSecurityElement.getLocalName();
                    this.log.trace((Object)("Processing " + strLocalName + " element in Security header"));
                    Element elemSecurityElement = new Element();
                    elemSecurityElement.set((Object)domSecurityElement);
                    Object securityElement = null;
                    if (!strLocalName.equals("Signature")) {
                        securityElement = strLocalName.equals("UsernameToken") ? new UsernameToken() : (strLocalName.equals("Assertion") ? new SAML11Token() : (strLocalName.equals("Timestamp") ? new Timestamp() : (strLocalName.equals("BinarySecurityToken") ? new BinarySecurityToken() : new CustomSecurityToken())));
                        securityElement.fromElement((IElement)elemSecurityElement);
                        securityInformation.addSecurityElement((ISecurityElement)securityElement);
                    }
                }
                ++i;
            }
            sheSecurity.setProcessed(true);
            messageContext.setProperty("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestConsumerHandler.Security", (Object)securityInformation);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            throw new AxisFault(e.getLocalizedMessage());
        }
    }
}

