/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.w3.www._2000._09.xmldsig;

public class SignatureMethodType  implements java.io.Serializable, org.apache.axis.encoding.AnyContentType, org.apache.axis.encoding.MixedContentType {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private java.math.BigInteger HMACOutputLength;

    private org.apache.axis.message.MessageElement [] _any;

    private org.apache.axis.types.URI algorithm;  // attribute

    public SignatureMethodType() {
    }

    public SignatureMethodType(
           final java.math.BigInteger HMACOutputLength,
           final org.apache.axis.message.MessageElement [] _any,
           final org.apache.axis.types.URI algorithm) {
           this.HMACOutputLength = HMACOutputLength;
           this._any = _any;
           this.algorithm = algorithm;
    }


    /**
     * Gets the HMACOutputLength value for this SignatureMethodType.
     * 
     * @return HMACOutputLength
     */
    public java.math.BigInteger getHMACOutputLength() {
        return this.HMACOutputLength;
    }


    /**
     * Sets the HMACOutputLength value for this SignatureMethodType.
     * 
     * @param HMACOutputLength
     */
    public void setHMACOutputLength(final java.math.BigInteger HMACOutputLength) {
        this.HMACOutputLength = HMACOutputLength;
    }


    /**
     * Gets the _any value for this SignatureMethodType.
     * 
     * @return _any
     */
    public org.apache.axis.message.MessageElement [] get_any() {
        return this._any;
    }


    /**
     * Sets the _any value for this SignatureMethodType.
     * 
     * @param _any
     */
    public void set_any(final org.apache.axis.message.MessageElement [] _any) {
        this._any = _any;
    }


    /**
     * Gets the algorithm value for this SignatureMethodType.
     * 
     * @return algorithm
     */
    public org.apache.axis.types.URI getAlgorithm() {
        return this.algorithm;
    }


    /**
     * Sets the algorithm value for this SignatureMethodType.
     * 
     * @param algorithm
     */
    public void setAlgorithm(final org.apache.axis.types.URI algorithm) {
        this.algorithm = algorithm;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof SignatureMethodType)) {
			return false;
		}
        final SignatureMethodType other = (SignatureMethodType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.HMACOutputLength==null) && (other.getHMACOutputLength()==null)) || 
             ((this.HMACOutputLength!=null) &&
              this.HMACOutputLength.equals(other.getHMACOutputLength()))) &&
            (((this._any==null) && (other.get_any()==null)) || 
             ((this._any!=null) &&
              java.util.Arrays.equals(this._any, other.get_any()))) &&
            (((this.algorithm==null) && (other.getAlgorithm()==null)) || 
             ((this.algorithm!=null) &&
              this.algorithm.equals(other.getAlgorithm())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getHMACOutputLength() != null) {
            _hashCode += this.getHMACOutputLength().hashCode();
        }
        if (this.get_any() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.get_any());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.get_any(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getAlgorithm() != null) {
            _hashCode += this.getAlgorithm().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(SignatureMethodType.class, true);

    static {
        SignatureMethodType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "SignatureMethodType"));
        final org.apache.axis.description.AttributeDesc attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("algorithm");
        attrField.setXmlName(new javax.xml.namespace.QName("", "Algorithm"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        SignatureMethodType.typeDesc.addFieldDesc(attrField);
        final org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("HMACOutputLength");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        SignatureMethodType.typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return SignatureMethodType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, SignatureMethodType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, SignatureMethodType.typeDesc);
    }

}
