/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.w3.www._2000._09.xmldsig;

public class X509IssuerSerialType  implements java.io.Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private java.lang.String x509IssuerName;

    private java.math.BigInteger x509SerialNumber;

    public X509IssuerSerialType() {
    }

    public X509IssuerSerialType(
           final java.lang.String x509IssuerName,
           final java.math.BigInteger x509SerialNumber) {
           this.x509IssuerName = x509IssuerName;
           this.x509SerialNumber = x509SerialNumber;
    }


    /**
     * Gets the x509IssuerName value for this X509IssuerSerialType.
     * 
     * @return x509IssuerName
     */
    public java.lang.String getX509IssuerName() {
        return this.x509IssuerName;
    }


    /**
     * Sets the x509IssuerName value for this X509IssuerSerialType.
     * 
     * @param x509IssuerName
     */
    public void setX509IssuerName(final java.lang.String x509IssuerName) {
        this.x509IssuerName = x509IssuerName;
    }


    /**
     * Gets the x509SerialNumber value for this X509IssuerSerialType.
     * 
     * @return x509SerialNumber
     */
    public java.math.BigInteger getX509SerialNumber() {
        return this.x509SerialNumber;
    }


    /**
     * Sets the x509SerialNumber value for this X509IssuerSerialType.
     * 
     * @param x509SerialNumber
     */
    public void setX509SerialNumber(final java.math.BigInteger x509SerialNumber) {
        this.x509SerialNumber = x509SerialNumber;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof X509IssuerSerialType)) {
			return false;
		}
        final X509IssuerSerialType other = (X509IssuerSerialType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.x509IssuerName==null) && (other.getX509IssuerName()==null)) || 
             ((this.x509IssuerName!=null) &&
              this.x509IssuerName.equals(other.getX509IssuerName()))) &&
            (((this.x509SerialNumber==null) && (other.getX509SerialNumber()==null)) || 
             ((this.x509SerialNumber!=null) &&
              this.x509SerialNumber.equals(other.getX509SerialNumber())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getX509IssuerName() != null) {
            _hashCode += this.getX509IssuerName().hashCode();
        }
        if (this.getX509SerialNumber() != null) {
            _hashCode += this.getX509SerialNumber().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(X509IssuerSerialType.class, true);

    static {
        X509IssuerSerialType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerialType"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("x509IssuerName");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        X509IssuerSerialType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("x509SerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(false);
        X509IssuerSerialType.typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return X509IssuerSerialType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, X509IssuerSerialType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, X509IssuerSerialType.typeDesc);
    }

}
