/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.binding.axis1x.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSRequestGeneratorHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private final LogHelper log;
    private final IConstants constants;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WSSRequestGeneratorHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.binding.axis1x.security.WSSRequestGeneratorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.constants = new Constants();
        this.log.trace((Object)"WSSRequestGeneratorHandler::WSSRequestGeneratorHandler");
    }

    public void invoke(MessageContext mc) throws AxisFault {
        this.log.trace((Object)"WSSRequestGeneratorHandler::invoke");
        try {
            NodeList nlTS;
            org.w3c.dom.Element domTS;
            String strTSId;
            PrivateKey authenticationPrivateKey = (PrivateKey)mc.getProperty("AUTHENTICATIONPRIVATEKEY");
            PublicKey authenticationPublicKey = (PublicKey)mc.getProperty("AUTHENTICATIONPUBLICKEY");
            IXMLSecurityExtension xmlSecurityExtension = (IXMLSecurityExtension)mc.getProperty("XMLSECURITYEXTENSION");
            Message msg = mc.getRequestMessage();
            SOAPEnvelope envelope = msg.getSOAPEnvelope();
            org.w3c.dom.Element domEnvelope = envelope.getAsDOM();
            String strEnvelope = XMLHelper.toString((org.w3c.dom.Element)domEnvelope);
            this.log.trace((Object)("WSSRequestGeneratorHandler: " + strEnvelope));
            if (authenticationPrivateKey == null) {
                return;
            }
            domEnvelope = XMLHelper.toDOM((String)strEnvelope);
            NodeList nlEnvelopeChildren = domEnvelope.getChildNodes();
            org.w3c.dom.Element domHeader = null;
            org.w3c.dom.Element domBody = null;
            int i = 0;
            while (i < nlEnvelopeChildren.getLength()) {
                Node nodeChild = nlEnvelopeChildren.item(i);
                if (1 == nodeChild.getNodeType()) {
                    org.w3c.dom.Element domChild = (org.w3c.dom.Element)nodeChild;
                    String strLocalName = domChild.getLocalName();
                    String strTagName = domChild.getTagName();
                    this.log.trace((Object)("LocalName: " + strLocalName + " TagName: " + strTagName));
                    if (strLocalName.equals("Body")) {
                        domBody = domChild;
                    }
                    if (strLocalName.equals("Header")) {
                        domHeader = domChild;
                    }
                }
                ++i;
            }
            NodeList nlBodyElements = domBody.getElementsByTagName("*");
            org.w3c.dom.Element domBodyElement = (org.w3c.dom.Element)nlBodyElements.item(0);
            String strBodyId = domBodyElement.getAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "Id");
            if (strBodyId == null || strBodyId.equals("")) {
                strBodyId = "theBody";
                domBodyElement.setAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "wsu:Id", strBodyId);
            }
            NodeList nlSecurityElements = domHeader.getElementsByTagNameNS(this.constants.getWSSecurityNamespace().toString(), "Security");
            org.w3c.dom.Element cfr_ignored_0 = (org.w3c.dom.Element)nlSecurityElements.item(0);
            org.w3c.dom.Element domSecurity = (org.w3c.dom.Element)nlSecurityElements.item(0);
            Element elemSecurity = new Element();
            elemSecurity.set((Object)domSecurity);
            NodeList nlBST = domSecurity.getElementsByTagNameNS(this.constants.getWSSecurityNamespace().toString(), "BinarySecurityToken");
            org.w3c.dom.Element domBST = (org.w3c.dom.Element)nlBST.item(0);
            String strBSTId = domBST.getAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "Id");
            if (strBSTId == null || strBSTId.equals("")) {
                strBSTId = "theToken";
                domBST.setAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "wsu:Id", strBSTId);
            }
            if ((strTSId = (domTS = (org.w3c.dom.Element)(nlTS = domSecurity.getElementsByTagNameNS(this.constants.getWSSecurityUtilityNamespace().toString(), "Timestamp")).item(0)).getAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "Id")) == null || strTSId.equals("")) {
                strTSId = "theTimestamp";
                domTS.setAttributeNS(this.constants.getWSSecurityUtilityNamespace().toString(), "wsu:Id", strTSId);
            }
            IElement elemSignature = xmlSecurityExtension.SignDetached(new String[]{strTSId, strBodyId}, (IElement)elemSecurity, authenticationPrivateKey, authenticationPublicKey, strBSTId, this.constants);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.w3c.dom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            org.w3c.dom.Element domSignature = (org.w3c.dom.Element)elemSignature.getAs((Class)clazz);
            domSecurity.appendChild(domSignature);
            strEnvelope = XMLHelper.toString((org.w3c.dom.Element)domEnvelope);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(strEnvelope.getBytes("UTF-8"));
            envelope = new SOAPEnvelope((InputStream)inputStream);
            msg = new Message((Object)envelope, false);
            mc.setCurrentMessage(msg);
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
        }
    }
}

