/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.binding.axis1x.security;

import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Used to process WS-Security headers on received request messages
 * 
 * @author mikemci@us.ibm.com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
//TODO: Finish the marshalling on the other side
public class WSSRequestConsumerHandler
	extends org.apache.axis.handlers.BasicHandler
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(WSSRequestConsumerHandler.class.getName());
	
	private final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
	
	public WSSRequestConsumerHandler()
	{
		this.log.trace("WSSRequestConsumerHandler::WSSRequestConsumerHandler");
	}

	public void invoke
		(final org.apache.axis.MessageContext messageContext)
		throws org.apache.axis.AxisFault
	{
		this.log.trace("WSSRequestConsumerHandler::invoke");
		
    	final org.eclipse.higgins.sts.utilities.Configuration configurationHandler = new org.eclipse.higgins.sts.utilities.Configuration();
    	
    	try
    	{
    		configurationHandler.configure(null);
    	}
		catch (final Exception e)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);

			this.log.error(errMsg);

			final Fault fault = new Fault
				(this.constants.getWSTrustNamespace(),
				"wst",
				this.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());	
			throw BindingHelper.FaultToAxisFault
				(fault);
		}
    	
		final org.apache.axis.Message mRequest = messageContext.getRequestMessage();
		org.apache.axis.message.SOAPEnvelope seRequest = null;
		try
		{
			seRequest = mRequest.getSOAPEnvelope();    		
		}
		catch (final org.apache.axis.AxisFault af)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				af);
			throw af;
		}
    	org.apache.axis.message.SOAPHeaderElement sheSecurity = null;
    	try
    	{
    		sheSecurity = seRequest.getHeaderByName
    			(this.constants.getWSSecurityNamespace().toString(),
    			"Security");
    	}
    	catch (final org.apache.axis.AxisFault af)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
    			(this.log,
    			af);
			throw af;
    	}
    	if (null == sheSecurity)
    	{
    		this.log.trace("Security header not found.");
    		return;
    	}
    	try
    	{
    		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
    		final java.util.Map mapGlobalSettings = configurationHandler.getSettings();
        	final org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
        		("XMLSecurityExtension");
    		final java.security.PrivateKey pkIssuer = (java.security.PrivateKey)mapGlobalSettings.get
    			("IssuerPrivateKey");
    		
    		final org.w3c.dom.Element domSecurity = sheSecurity.getAsDOM();
    		// if anything is encrypted - then we decrypt it first - using our own private key
    		final org.w3c.dom.NodeList nlEncryptedData = domSecurity.getElementsByTagNameNS
				(this.constants.getXMLEncryptionNamespace().toString(),
				"EncryptedData");
			if (null == nlEncryptedData)
			{
				this.log.trace("No EncryptedData found (getElementsByTagName returned null)");
			}
			else if (0 == nlEncryptedData.getLength())
			{
				this.log.trace("No EncryptedData found (0 == getLength())");
			}
			else
			{
				for (int i = 0; i < nlEncryptedData.getLength(); ++i)
				{
					this.log.trace("Processing EncryptedData element in Security header");
					final org.w3c.dom.Element domEncryptedData = (org.w3c.dom.Element)nlEncryptedData.item(0);
					final org.eclipse.higgins.sts.api.IElement elemEncryptedData = new org.eclipse.higgins.sts.common.Element();
					elemEncryptedData.set(domEncryptedData);
					final org.eclipse.higgins.sts.api.IElement elemDecryptedData = xmlSecurity.DecryptElement
						(elemEncryptedData,
						pkIssuer);
				}
			}
			
			// then we verify any signatures that we find
    		final org.w3c.dom.NodeList nlSignatures = domSecurity.getElementsByTagNameNS
			(this.constants.getXMLSignatureNamespace().toString(),
			"Signature");
    		if (null == nlSignatures)
    		{
    			this.log.trace("No Signature found (getElementsByTagName returned null)");
    		}
    		else if (0 == nlSignatures.getLength())
    		{
    			this.log.trace("No Signature found (0 == getLength())");
    		}
    		else
    		{
				for (int i = 0; i < nlSignatures.getLength(); ++i)
				{
					this.log.trace("Processing Signature element in Security header");
					final org.w3c.dom.Element domSignature = (org.w3c.dom.Element)nlSignatures.item(0);
					final org.eclipse.higgins.sts.api.IElement elemSignature = new org.eclipse.higgins.sts.common.Element();
					elemSignature.set(domSignature);
//XXX Enable signature verification				
// Verification is turned off until such time as STS can handle BST with b64 cert and KeyInfo
//	containing STR with Reference to BST				
//				final boolean verifies = xmlSecurity.VerifyEnveloped(elemSignature, null);
//				if (verifies)
//					this.log.trace("Signature element in Security header verified successfully");
//				else
//				{
//					this.log.trace("Signature validation failed");
//					throw new RuntimeException("Signature validation failed");
//				}
				}
			}

			final org.w3c.dom.NodeList nlSecurityNodes = domSecurity.getChildNodes();
			for (int i = 0; i < nlSecurityNodes.getLength(); ++i)
			{
				final org.w3c.dom.Node nodeSecurityNode = nlSecurityNodes.item(i);
				if (org.w3c.dom.Node.ELEMENT_NODE != nodeSecurityNode.getNodeType())
					continue;
				final org.w3c.dom.Element domSecurityElement = (org.w3c.dom.Element)nodeSecurityNode;
				final String strLocalName = domSecurityElement.getLocalName();
				this.log.trace("Processing " + strLocalName + " element in Security header");
				final org.eclipse.higgins.sts.api.IElement elemSecurityElement = new org.eclipse.higgins.sts.common.Element();
				elemSecurityElement.set(domSecurityElement);
				org.eclipse.higgins.sts.api.ISecurityElement securityElement = null;
				// TODO - Make the following configuration driven...
				if (strLocalName.equals("Signature"))
					continue; // already processed signatures
				if (strLocalName.equals("UsernameToken"))
				{
					securityElement = new org.eclipse.higgins.sts.common.UsernameToken();
				}
				else if (strLocalName.equals("Assertion"))
				{
					securityElement = new org.eclipse.higgins.sts.common.SAML11Token();
				}
				else if (strLocalName.equals("Timestamp"))
				{
					securityElement = new org.eclipse.higgins.sts.common.Timestamp();
				}
				else if (strLocalName.equals("BinarySecurityToken"))
				{
					securityElement = new org.eclipse.higgins.sts.common.BinarySecurityToken();
				}
				else
				{
					securityElement = new org.eclipse.higgins.sts.common.CustomSecurityToken();
				}
				securityElement.fromElement(elemSecurityElement);
				securityInformation.addSecurityElement(securityElement);
			}
			sheSecurity.setProcessed(true);
			messageContext.setProperty(org.eclipse.higgins.sts.binding.axis1x.security.Constants.PROPERTY_REQUEST_CONSUMER_SECURITY, securityInformation);
    	}
    	catch (final Exception e)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
    		throw new org.apache.axis.AxisFault(e.getLocalizedMessage());
    	}
	}
}
