/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

// Eliminate requirement for excess Jar in various projects (e.g. Axis, LDAP CP, IdAS, Servlet, etc.)

package org.eclipse.higgins.sts.binding.common;

import javax.xml.namespace.QName;

import org.eclipse.higgins.sts.api.IAddressingInformation;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ILifetime;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.common.AddressingInformation;
import org.eclipse.higgins.sts.common.Lifetime;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Element;

/**
 * @author mikemci at us dot ibm dot com
 */
public class BindingHelper
{
	private static final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(BindingHelper.class.getName());
	
	public static org.apache.axis.message.MessageElement toElementMessageElement(final org.eclipse.higgins.sts.api.IElement element)
	{
		try
		{
			return new org.apache.axis.message.MessageElement
				((org.w3c.dom.Element)element.getAs
					(org.w3c.dom.Element.class));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);	
		}
		return null;
	}

	public static java.net.URI toURI(final org.apache.axiom.om.OMElement omURI)
	{
		return java.net.URI.create(omURI.getText());
	}
	
	public static int toInt(final org.apache.axiom.om.OMElement omInt)
	{
		try
		{
			return new java.lang.Integer(omInt.getText()).intValue();
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return 0;
	}
	
	public static boolean toBoolean(final org.apache.axiom.om.OMElement omBoolean)
	{
		try
		{
			return new java.lang.Boolean(omBoolean.getText()).booleanValue();
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return false;
	}
	
	public static org.eclipse.higgins.sts.api.ILifetime toLifetime
		(final java.net.URI uriWSSUNamespace,
		final org.apache.axiom.om.OMElement omLifetime)
	{
		BindingHelper.log.trace("toLifetime");
		final ILifetime ltLifetime = new Lifetime();
		final javax.xml.namespace.QName qnameCreated = new javax.xml.namespace.QName
			(uriWSSUNamespace.toString(),
			"Created");
		final org.apache.axiom.om.OMElement omCreated = omLifetime.getFirstChildWithName
			(qnameCreated);
		java.util.Date dtCreated = null;
		if (null != omCreated)
		{
			final String strCreated = omCreated.getText();
			BindingHelper.log.trace("Created: " + strCreated);
			dtCreated = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strCreated);
			ltLifetime.setCreated(dtCreated);
		}
		final javax.xml.namespace.QName qnameExpires = new javax.xml.namespace.QName
			(uriWSSUNamespace.toString(),
			"Expires");
		final org.apache.axiom.om.OMElement omExpires = omLifetime.getFirstChildWithName
			(qnameExpires);
		java.util.Date dtExpires = null;
		if (null != omExpires)
		{
			final String strExpires = omExpires.getText();
			BindingHelper.log.trace("Expires: " + strExpires);
			dtExpires = org.eclipse.higgins.sts.utilities.DateHelper.getDateFromIso8601(strExpires);
			ltLifetime.setExpires(dtExpires);
		}
		return ltLifetime;
	}
	
	public static org.eclipse.higgins.sts.api.IAppliesTo toAppliesTo
		(final java.net.URI uriWSANamespace,
		final org.apache.axiom.om.OMElement omAppliesTo)
	{
		BindingHelper.log.trace("toAppliesTo");
		final org.eclipse.higgins.sts.api.IAppliesTo appliesTo = new org.eclipse.higgins.sts.common.AppliesTo();
		final javax.xml.namespace.QName qnameEndpointReference = new javax.xml.namespace.QName
			(null,
			"EndpointReference");
		final org.apache.axiom.om.OMElement omEndpointReference = omAppliesTo.getFirstChildWithName
			(qnameEndpointReference);
		if (null != omEndpointReference)
		{
			appliesTo.setEndpointReference
				(BindingHelper.toEndpointReference
					(java.net.URI.create(omEndpointReference.getNamespace().getNamespaceURI()),
					omEndpointReference));
		}
		return appliesTo;
	}
	
	public static org.eclipse.higgins.sts.api.IDisplayToken toDisplayToken
		(final org.apache.axiom.om.OMElement omRequestedDisplayToken)
	{
		// TODO Support full display token text and lang ... 
		BindingHelper.log.trace("toDisplayToken");
		final org.eclipse.higgins.sts.api.IDisplayToken displayToken = new org.eclipse.higgins.sts.common.DisplayToken();
		java.util.List listDisplayClaims = displayToken.getDisplayClaimList();
		final javax.xml.namespace.QName qnameDisplayToken = new javax.xml.namespace.QName
			(null,
			"DisplayToken");
		final javax.xml.namespace.QName qnameXMLLang = new javax.xml.namespace.QName
			(null,
			"lang");
		final javax.xml.namespace.QName qnameDisplayClaim = new javax.xml.namespace.QName
			(null,
			"DisplayClaim");
		final javax.xml.namespace.QName qnameDisplayTag = new javax.xml.namespace.QName
			(null,
			"DisplayTag");
		final javax.xml.namespace.QName qnameDisplayValue = new javax.xml.namespace.QName
			(null,
			"DisplayValue");
		final javax.xml.namespace.QName qnameUri = new javax.xml.namespace.QName
			(null,
			"Uri");
		final org.apache.axiom.om.OMElement omDisplayToken = omRequestedDisplayToken.getFirstChildWithName
			(qnameDisplayToken);
		if (null != omDisplayToken)
		{
			String strLang = omDisplayToken.getAttributeValue(qnameXMLLang);
			if (null == strLang)
			{
				strLang = "en";
			}
			if (0 == strLang.length())
			{
				strLang = "en";				
			}
			displayToken.setLanguage(strLang);
			final java.util.Iterator iterChildren = omDisplayToken.getChildrenWithName(qnameDisplayClaim);
			while (iterChildren.hasNext())
			{
				final org.apache.axiom.om.OMElement omDisplayClaim = (org.apache.axiom.om.OMElement)iterChildren.next();
				final org.apache.axiom.om.OMElement omDisplayTag = omDisplayClaim.getFirstChildWithName
					(qnameDisplayTag);
				final org.apache.axiom.om.OMElement omDisplayValue = omDisplayClaim.getFirstChildWithName
					(qnameDisplayValue);
				final org.eclipse.higgins.sts.api.IDisplayClaim displayClaim = new org.eclipse.higgins.sts.common.DisplayClaim();
				String type = omDisplayClaim.getAttributeValue(qnameUri);
				if (null != type)
					displayClaim.setType(java.net.URI.create(type));
				if (omDisplayTag != null) {
					displayClaim.setDisplayTag(omDisplayTag.getText());
				}
				if (omDisplayValue != null) {
					displayClaim.setDisplayValue(omDisplayValue.getText());
				}
				listDisplayClaims.add(displayClaim);
			}
		}
		return displayToken;
	}
	
	public static org.eclipse.higgins.sts.api.IEndpointReference toEndpointReference
		(final java.net.URI uriAddressingNamespace,
		final org.apache.axiom.om.OMElement omEndpointReference)
	{
		final org.eclipse.higgins.sts.api.IEndpointReference epr = new org.eclipse.higgins.sts.common.EndpointReference();
		final java.util.List listReferenceParameters = epr.getReferenceParametersElements();
		final java.util.List listMetadata = epr.getMetadataElements();
		final java.util.List listAnyOtherElements = epr.getAnyOtherElements();
		final java.util.Iterator iterChildren = omEndpointReference.getChildElements();
		
		java.util.ArrayList	certList = new java.util.ArrayList();
		
		BindingHelper.log.trace("toEndpointReference");
		String strAddress = omEndpointReference.getText();
		
		while (iterChildren.hasNext())
		{
			final org.apache.axiom.om.OMElement omChild = (org.apache.axiom.om.OMElement)iterChildren.next();
			final String strLocalName = omChild.getLocalName();
			BindingHelper.log.trace("   found [" + strLocalName + "] element");
			if (strLocalName.equals("Address"))
			{
				strAddress = omChild.getText();
			}
			else if (strLocalName.equals("Identity"))
			{
				final java.util.Iterator iterIdentityChildren = omChild.getChildElements();
				while (iterIdentityChildren.hasNext())
				{
					final org.apache.axiom.om.OMElement omIdentityChild = (org.apache.axiom.om.OMElement)iterIdentityChildren.next();
					final String strIdentityChildLocalName = omIdentityChild.getLocalName();
					BindingHelper.log.trace("   found [Identity." + strIdentityChildLocalName + "] element");
					if (strIdentityChildLocalName.equals("KeyInfo"))
					{
						final java.util.Iterator iterKeyInfoChildren = omIdentityChild.getChildElements();
						while (iterKeyInfoChildren.hasNext())
						{
							final org.apache.axiom.om.OMElement omKeyInfoChild = (org.apache.axiom.om.OMElement)iterKeyInfoChildren.next();
							final String strKeyInfoChildLocalName = omKeyInfoChild.getLocalName();
							BindingHelper.log.trace("   found [Identity.KeyInfo." + strKeyInfoChildLocalName + "] element");
							if (strKeyInfoChildLocalName.equals("X509Data"))
								// <wsid:Identity> <ds:KeyInfo> <ds:X509Data> <ds:X509Certificate>...</ds:X509Certificate> </ds:X509Data> </ds:KeyInfo> </wsid:Identity>
							{
								final java.util.Iterator iterX509Children = omKeyInfoChild.getChildElements();
								while (iterX509Children.hasNext())
								{
									final org.apache.axiom.om.OMElement omX509Child = (org.apache.axiom.om.OMElement)iterX509Children.next();
									final String strX509ChildLocalName = omX509Child.getLocalName();
									BindingHelper.log.trace("   found [Identity.KeyInfo.X509Data." + strX509ChildLocalName + "] element");
									if (strX509ChildLocalName.equals("X509Certificate"))
										// <wsid:Identity> <ds:KeyInfo> <ds:X509Data> <ds:X509Certificate>...</ds:X509Certificate> </ds:X509Data> </ds:KeyInfo> </wsid:Identity>
									{
										
										final String strX509Certificate = omX509Child.getText();
										
										certList.add( strX509Certificate);
										
									}
								}
							}
						}
					}
				}
			}
			else if (strLocalName.equals("ReferenceParameters"))
			{
				final java.util.Iterator iterReferenceParameters = omChild.getChildElements();
				while (iterReferenceParameters.hasNext())
				{
					final org.apache.axiom.om.OMElement omReferenceParameters = (org.apache.axiom.om.OMElement)iterReferenceParameters.next();
					final org.eclipse.higgins.sts.api.IElement element = new org.eclipse.higgins.sts.common.Element();
					try
					{
						element.set(omReferenceParameters);
					}
					catch (final Exception e)
					{
						org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
							(BindingHelper.log,
							e);					
					}
					listReferenceParameters.add(element);
				}
			}
			else if (strLocalName.equals("Metadata"))
			{
				final java.util.Iterator iterMetadata = omChild.getChildElements();
				while (iterMetadata.hasNext())
				{
					final org.apache.axiom.om.OMElement omMetadata = (org.apache.axiom.om.OMElement)iterMetadata.next();
					final org.eclipse.higgins.sts.api.IElement element = new org.eclipse.higgins.sts.common.Element();
					try
					{
						element.set(omMetadata);
					}
					catch (final Exception e)
					{
						org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
							(BindingHelper.log,
							e);					
					}
					listMetadata.add(element);
				}				
			}
			else
			{
				final org.eclipse.higgins.sts.api.IElement element = new org.eclipse.higgins.sts.common.Element();
				try
				{
					element.set(omChild);
				}
				catch (final Exception e)
				{
					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
						(BindingHelper.log,
						e);					
				}
				listAnyOtherElements.add(element);
			}
			
		}
		if (null != strAddress)
		{
			final java.net.URI uriAddress = java.net.URI.create(strAddress);
			epr.setAddress(uriAddress);				
			// Find the leaf certificate (the one that no other certificate points to as its issuer
			java.security.cert.X509Certificate certLeaf = org.eclipse.higgins.sts.utilities.CertificateHelper.findLeafFromEncodedCertificates
				(certList);
			if (null != certLeaf)
			{
				try
				{
					epr.setIdentityCertificate
						(new String
							(org.apache.commons.codec.binary.Base64.encodeBase64
								(certLeaf.getEncoded())));
				}
				catch (Exception e)
				{
					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, e);
				}
			}
		}
		return epr;
	}

	public static org.eclipse.higgins.sts.api.IInformationCardReference toInformationCardReference
		(final org.apache.axiom.om.OMElement omInformationCardReference)
	{
		BindingHelper.log.trace("Begin toInformationCardReference");
		
		final org.eclipse.higgins.sts.api.IInformationCardReference icr = new org.eclipse.higgins.sts.common.InformationCardReference();
		final java.util.Iterator iterChildren = omInformationCardReference.getChildElements();
		while (iterChildren.hasNext())
		{
			final org.apache.axiom.om.OMElement omChild = (org.apache.axiom.om.OMElement)iterChildren.next();
			final String strLocalName = omChild.getLocalName();
			if (strLocalName.equals("CardId"))
			{
				final String strCardId = omChild.getText();
				icr.setCardId(java.net.URI.create(strCardId));				
			}
			else if (strLocalName.equals("CardVersion"))
			{
				final String strCardVersion = omChild.getText();
				icr.setCardVersion(strCardVersion);				
			}
		}
		BindingHelper.log.trace("End toInformationCardReference");
		return icr;
	}
	
	public static org.apache.axis.message.MessageElement toURIMessageElement
		(java.net.URI uriNamespace,
		final String strPrefix,
		final String strLocalName,
		java.net.URI uriValue)
	{
		uriNamespace = uriNamespace.normalize();
		uriValue = uriValue.normalize();
		final String strElementName = strPrefix + ":" + strLocalName;
		try
		{
			final String strElement = 
				"<" + strElementName
					+ " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>"
					+ org.eclipse.higgins.sts.utilities.XMLHelper.escapedString(uriValue.toString())
					+ "</" + strElementName + ">";
			BindingHelper.log.trace("toURIMessageElement: " + strElement);
			return new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strElement));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return null;
	}
	
	public static org.apache.axis.message.MessageElement toIntMessageElement
		(final java.net.URI uriNamespace,
		final String strPrefix,
		final String strLocalName,
		final int nValue)
	{
		final String strElementName = strPrefix + ":" + strLocalName;
		try
		{
			final String strElement =
				"<" + strElementName
					+ " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>"
					+ nValue
					+ "</" + strElementName + ">";
			BindingHelper.log.trace("toIntMessageElement: " + strElement);
			return new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strElement));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return null;
	}

	public static org.apache.axis.message.MessageElement toBooleanMessageElement
		(final java.net.URI uriNamespace,
		final String strPrefix,
		final String strLocalName,
		final boolean bValue)
	{
		final String strElementName = strPrefix + ":" + strLocalName;
		try
		{
			final String strElement =
				"<" + strElementName
					+ " xmlns:" + strPrefix + "='" + uriNamespace.toString() + "'>"
					+ bValue
					+ "</" + strElementName + ">";
			BindingHelper.log.trace("toBooleanMessageElement: " + strElement);
			return new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strElement));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return null;
	}

	// TODO: Split out AttributedDateTime
	public static org.apache.axis.message.MessageElement toLifetimeMessageElement
		(final java.net.URI uriTrustNamespace,
		final String strTrustPrefix,
		final java.net.URI uriWSSUNamespace,
		final String strWSSUPrefix,
		final org.eclipse.higgins.sts.api.ILifetime ltLifetime)
	{
		BindingHelper.log.trace("toLifetimeMessageElement");
		final String strLifetimeElementName = strTrustPrefix + ":Lifetime";
		String strLifetime = 
			"<" + strLifetimeElementName
				+ " xmlns:" + strTrustPrefix + "='" + uriTrustNamespace.toString() + "'"
				+ " xmlns:" + strWSSUPrefix + "='" + uriWSSUNamespace.toString() + "'>";
		final java.util.Date dtCreated = ltLifetime.getCreated();
		if (null != dtCreated)
		{
			final String strCreatedElementName = strWSSUPrefix + ":Created";
			final String strCreatedValue = org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date
				(dtCreated);
			BindingHelper.log.trace("Created: " + strCreatedValue);
			strLifetime +=
				"<" + strCreatedElementName + ">"
					+ strCreatedValue
					+ "</" + strCreatedElementName + ">";
		}
		final java.util.Date dtExpires = ltLifetime.getExpires();
		if (null != dtExpires)
		{
			final String strExpiresElementName = strWSSUPrefix + ":Expires";
			final String strExpiresValue = org.eclipse.higgins.sts.utilities.DateHelper.getIso8601Date
				(dtExpires);
			BindingHelper.log.trace("Expires: " + strExpiresValue);
			strLifetime +=
				"<" + strExpiresElementName + ">"
					+ strExpiresValue
					+ "</" + strExpiresElementName + ">";
		}
		strLifetime += "</" + strLifetimeElementName + ">";
		BindingHelper.log.trace("toLifetimeMessageElement: " + strLifetime);		
		try
		{
			return new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strLifetime));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return null;
	}
	
	public static org.apache.axis.message.MessageElement toAppliesToMessageElement
		(final java.net.URI uriWSPNamespace,
		final String strWSPPrefix,
		final java.net.URI uriWSANamespace,
		final String strWSAPrefix,
		final org.eclipse.higgins.sts.api.IAppliesTo appliesTo)
	{
		BindingHelper.log.trace("toAppliesToMessageElement");
		final String strAppliesToElementName = strWSPPrefix + ":AppliesTo";
		String strAppliesTo = 
			"<" + strAppliesToElementName
				+ " xmlns:" + strWSPPrefix + "='" + uriWSPNamespace.toString() + "'"
				+ " xmlns:" + strWSAPrefix + "='" + uriWSANamespace.toString() + "'>";
		strAppliesTo += "</" + strAppliesToElementName + ">";
		org.apache.axis.message.MessageElement meAppliesTo = null;
		try
		{
			meAppliesTo = new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strAppliesTo));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
			return null;
		}
		final IEndpointReference epr = appliesTo.getEndpointReference();
		if (null != epr)
		{
			try
			{
				final org.apache.axis.message.MessageElement meEndpointReference = BindingHelper.toEndpointReferenceMessageElement
					(uriWSANamespace,
					strWSAPrefix,
					"EndpointReference",
					uriWSANamespace,
					strWSAPrefix,
					epr);
				if (null != meEndpointReference)
				{
					meAppliesTo.addChild(meEndpointReference);
				}
				return meAppliesTo;
			}
			catch (final Exception e)
			{
				org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);
			}
		}
		return null;
	}
	
	public static String toString 
		(final org.eclipse.higgins.sts.api.IDisplayToken displayToken)
	{
		BindingHelper.log.trace("toString");

		java.util.List listDisplayClaims = displayToken.getDisplayClaimList();
		String strRequestedDisplayToken = 
			"<ic:RequestedDisplayToken xmlns:ic='http://schemas.xmlsoap.org/ws/2005/05/identity'>"
			+ "<ic:DisplayToken xml:lang='" + displayToken.getLanguage() + "'>";
		for (int i = 0; i < listDisplayClaims.size(); ++i)
		{
			try
			{
			org.eclipse.higgins.sts.api.IDisplayClaim displayClaim = (org.eclipse.higgins.sts.api.IDisplayClaim)listDisplayClaims.get(i);
			strRequestedDisplayToken += "<ic:DisplayClaim Uri=\"" + org.apache.commons.lang.StringEscapeUtils.escapeXml( displayClaim.getType().toString()) + "\">";
			strRequestedDisplayToken += "<ic:DisplayTag>" + org.apache.commons.lang.StringEscapeUtils.escapeXml( displayClaim.getDisplayTag()) + "</ic:DisplayTag>";
			strRequestedDisplayToken += "<ic:DisplayValue>" + org.apache.commons.lang.StringEscapeUtils.escapeXml( displayClaim.getDisplayValue()) + "</ic:DisplayValue>";
			strRequestedDisplayToken += "</ic:DisplayClaim>";
			}
			catch (Throwable t)
			{
				org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, t);
			}
		}
		strRequestedDisplayToken += 
			"</ic:DisplayToken>"
			+ "</ic:RequestedDisplayToken>";
		BindingHelper.log.trace("toDisplayTokenMessageElement: " + strRequestedDisplayToken);
		return strRequestedDisplayToken;
	}
	
	public static org.apache.axis.message.MessageElement toDisplayTokenMessageElement
		(final org.eclipse.higgins.sts.api.IDisplayToken displayToken)
	{
		BindingHelper.log.trace("toDisplayTokenMessageElement");

		String strRequestedDisplayToken = toString(displayToken);
		org.apache.axis.message.MessageElement meRequestedDisplayToken = null;
		try
		{
			meRequestedDisplayToken = new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strRequestedDisplayToken));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
			return null;
		}
		return meRequestedDisplayToken;
	}

	public static org.apache.axis.message.MessageElement toInformationCardReferenceMessageElement
		(final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference)
	{
		BindingHelper.log.trace("toInformationCardReferenceMessageElement");
		
		final java.net.URI uriCardId = informationCardReference.getCardId();
		final String strCardVersion = informationCardReference.getCardVersion();

		String strInformationCardReference = 
			"<ic:InformationCardReference xmlns:ic='http://schemas.xmlsoap.org/ws/2005/05/identity'>"
			+ "<ic:CardId>" + XMLHelper.escapedString(uriCardId.toString()) + "</ic:CardId>"
			+ "<ic:CardVersion>" + strCardVersion + "</ic:CardVersion>"
			+ "</ic:InformationCardReference>";
		org.apache.axis.message.MessageElement meInformationCardReference = null;
		try
		{
			meInformationCardReference = new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strInformationCardReference));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
			return null;
		}
		return meInformationCardReference;
	}


	public static org.apache.axis.message.MessageElement toEndpointReferenceMessageElement
		(final java.net.URI uriNamespace,
		final String strPrefix,
		final String strLocalName,
		final java.net.URI uriAddressingNamespace,
		final String strAddressingPrefix,
		final org.eclipse.higgins.sts.api.IEndpointReference ltEndpointReference)
	{
		final String strEPRElementName = strPrefix + ":" + strLocalName;
		String strEPR =
			"<" + strEPRElementName
				+ " xmlns:" + strPrefix + "='" + uriNamespace.toString();
		if (!strPrefix.equals(strAddressingPrefix))
		{
			strEPR += "' xmlns:" + strAddressingPrefix + "='" + uriAddressingNamespace.toString();
		}
		strEPR += "'>";
		
		final java.net.URI uriAddress = ltEndpointReference.getAddress();
		if (null != uriAddress)
		{
			final String strAddressElementName = strAddressingPrefix + ":Address";
			strEPR +=
				"<" + strAddressElementName + ">"
					+ org.eclipse.higgins.sts.utilities.XMLHelper.escapedString(uriAddress.toString())
					+ "</" + strAddressElementName + ">";
		}
		// <wsid:Identity> <ds:KeyInfo> <ds:X509Data> <ds:X509Certificate>...</ds:X509Certificate> </ds:X509Data> </ds:KeyInfo> </wsid:Identity>
		final String strIdentityCertificate = ltEndpointReference.getIdentityCertificate();
		if (null != strIdentityCertificate)
		{
			strEPR += "<wsid:Identity xmlns:wsid=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\">"
				+ "<ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">"
				+   "<ds:X509Data>"
				+     "<ds:X509Certificate>" + strIdentityCertificate + "</ds:X509Certificate>"
			    +   "</ds:X509Data>"
			    + "</ds:KeyInfo>"
			    + "</wsid:Identity>";
		}
		final java.util.List listReferenceParameters = ltEndpointReference.getReferenceParametersElements();
		if (0 != listReferenceParameters.size())
		{
			final String strReferenceParametersName = strAddressingPrefix + ":ReferenceParameters";
			strEPR += "<" + strReferenceParametersName + ">";			
			for (int i = 0; i < listReferenceParameters.size(); ++i)
			{
				final org.eclipse.higgins.sts.api.IElement elemReferenceParameters = (org.eclipse.higgins.sts.api.IElement)listReferenceParameters.get(i);
				try
				{
					strEPR += (String)elemReferenceParameters.getAs(String.class);
				}
				catch (final Exception e)
				{
					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
						(BindingHelper.log,
						e);
				}
			}
			strEPR += "</" + strReferenceParametersName + ">";						
		}
		final java.util.List listMetadata = ltEndpointReference.getMetadataElements();
		if (0 != listMetadata.size())
		{
			final String strMetadataName = strAddressingPrefix + ":Metadata";
			strEPR += "<" + strMetadataName + ">";			
			for (int i = 0; i < listMetadata.size(); ++i)
			{
				final org.eclipse.higgins.sts.api.IElement elemMetadata = (org.eclipse.higgins.sts.api.IElement)listMetadata.get(i);
				try
				{
					strEPR += (String)elemMetadata.getAs(String.class);
				}
				catch (final Exception e)
				{
					org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
						(BindingHelper.log,
						e);
				}
			}
			strEPR += "</" + strMetadataName + ">";						
		}
		final java.util.List listAnyOther = ltEndpointReference.getAnyOtherElements();
		for (int i = 0; i < listAnyOther.size(); ++i)
		{
			final org.eclipse.higgins.sts.api.IElement elemAnyOther = (org.eclipse.higgins.sts.api.IElement)listAnyOther.get(i);
			try
			{
				strEPR += (String)elemAnyOther.getAs(String.class);
			}
			catch (final Exception e)
			{
				org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);
			}
		}
		strEPR +=
			"</" + strEPRElementName + ">";
		BindingHelper.log.trace("toEndpointReferenceElement: " + strEPR);		
		try
		{
			return new org.apache.axis.message.MessageElement
				(org.eclipse.higgins.sts.utilities.XMLHelper.toDOM
					(strEPR));
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		return null;
	}
	
	

	/**
	 * Converts the values in an Axis 1.x RequestSecurityToken to this framework independent form
     *
	 * @param RST the Axis 1.x framework generated RequestSecurityToken to be converted
	 * @return the converted framework independent RequestSecurityToken
	 */
	public static org.eclipse.higgins.sts.api.IRequestSecurityToken RSTFromAxis1xRST
		(final IConstants constants,
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST)
	{
		BindingHelper.log.trace("Begin RSTFromAxis1xRST");
		
		final org.eclipse.higgins.sts.api.IRequestSecurityToken requestSecurityToken = new org.eclipse.higgins.sts.common.RequestSecurityToken();
	    final String strContext = RST.getContext();
	    if (null != strContext)
	    {
	    	BindingHelper.log.trace("Context: " + strContext);
	    	requestSecurityToken.setContext
	    		(strContext);		
	    }
	   	final org.apache.axis.message.MessageElement [] meRST = RST.get_any();
	   	final int nRequestLength = meRST.length;
	   	for (int nRequestIndex = 0; nRequestIndex < nRequestLength; ++nRequestIndex)
	   	{
	   		try
	   		{
	   			final org.apache.axiom.om.OMElement omElement = org.eclipse.higgins.sts.utilities.XMLHelper.toOM
	   				(meRST[nRequestIndex].getAsDOM());
	   			final IElement element = org.eclipse.higgins.sts.utilities.XMLHelper.toElement
	   				(omElement);
	   			final String strLocalName = omElement.getLocalName();
	   			if (strLocalName.equals
		   			("ClientPseudonym")) {
					requestSecurityToken.setClientPseudonym
   						(element);
				}
	   			if (strLocalName.equals
	   				("InformationCardReference")) {
					requestSecurityToken.setInformationCardReference
	   					(BindingHelper.toInformationCardReference
	   						(omElement));
				}
	   			if (strLocalName.equals
	   				("Base")) {
					requestSecurityToken.setBase
	   					(element);
				}
	   			if (strLocalName.equals
		   			("RequestDisplayToken")) {
					requestSecurityToken.setRequestDisplayToken
		   				(element);
				}
	   			if (strLocalName.equals
	   				("ComputedKeyAlgorithm")) {
					requestSecurityToken.setComputedKeyAlgorithm
	   					(BindingHelper.toURI(omElement));
				}
	   			if (strLocalName.equals
	   				("TokenType")) {
					requestSecurityToken.setTokenType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("RequestType")) {
					requestSecurityToken.setRequestType
   						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("AppliesTo")) {
					requestSecurityToken.setAppliesTo
	   					(BindingHelper.toAppliesTo
	   						(constants.getWSAddressingNamespace(),
	   						omElement));
				} else if (strLocalName.equals
	   				("CancelTarget")) {
					requestSecurityToken.setCancelTarget
	   					(element);
				} else if (strLocalName.equals
	   				("ValidateTarget")) {
					requestSecurityToken.setValidateTarget
	   					(element);
				} else if (strLocalName.equals
	   				("Claims")) {
					requestSecurityToken.setClaims
	   					(element);
				} else if (strLocalName.equals
	   				("Entropy")) {
					requestSecurityToken.setEntropy
	   					(element);
				} else if (strLocalName.equals
	   				("Lifetime")) {
					requestSecurityToken.setLifetime
	   					(BindingHelper.toLifetime
	   						(constants.getWSSecurityUtilityNamespace(),
	   						omElement));
				} else if (strLocalName.equals
	   				("AllowPostdating")) {
					requestSecurityToken.setAllowPostdating
	   					(element);
				} else if (strLocalName.equals
	   				("Renewing")) {
					requestSecurityToken.setRenewing
	   					(element);
				} else if (strLocalName.equals
	   				("OnBehalfOf")) {
					requestSecurityToken.setOnBehalfOf
	   					(element);
				} else if (strLocalName.equals
	   				("Issuer")) {
					requestSecurityToken.setIssuer
	   					(BindingHelper.toEndpointReference
		   					(constants.getWSAddressingNamespace(),
		   		   			omElement));
				} else if (strLocalName.equals
	   				("AuthenticationType")) {
					requestSecurityToken.setAuthenticationType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("KeyType")) {
					requestSecurityToken.setKeyType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("KeySize")) {
					requestSecurityToken.setKeySize
   						(BindingHelper.toInt(omElement));
				} else if (strLocalName.equals
	   				("SignatureAlgorithm")) {
					requestSecurityToken.setSignatureAlgorithm
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("Encryption")) {
					requestSecurityToken.setEncryption
	   					(element);
				} else if (strLocalName.equals
	   				("EncryptionAlgorithm")) {
					requestSecurityToken.setEncryptionAlgorithm
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("CanonicalizationAlgorithm")) {
					requestSecurityToken.setCanonicalizationAlgorithm
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("ProofEncryption")) {
					requestSecurityToken.setProofEncryption
	   					(element);
				} else if (strLocalName.equals
	   				("UseKey")) {
					requestSecurityToken.setUseKey
	   					(element);
				} else if (strLocalName.equals
	   				("SignWith")) {
					requestSecurityToken.setSignWith
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("EncryptWith")) {
					requestSecurityToken.setEncryptWith
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("DelegateTo")) {
					requestSecurityToken.setDelegateTo
	   					(element);
				} else if (strLocalName.equals
	   				("Forwardable")) {
					requestSecurityToken.setForwardable
	   					(BindingHelper.toBoolean(omElement));
				} else if (strLocalName.equals
	   				("Delegatable")) {
					requestSecurityToken.setDelegatable
   						(BindingHelper.toBoolean(omElement));
				} else if (strLocalName.equals
	   				("Policy")) {
					requestSecurityToken.setPolicy
	   					(element);
				} else if (strLocalName.equals
	   				("PolicyReference")) {
					requestSecurityToken.setPolicyReference
	   					(element);
				} else 
	   			{
	   				final java.util.List listAnyOther = requestSecurityToken.getAnyOtherElements();
	   				listAnyOther.add(element);
	   			}
	   		}
	   		catch (final Exception e)
	   		{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);	
	    		return null;
	   		}
	   	}
		BindingHelper.log.trace("End RSTFromAxis1xRST");
		return requestSecurityToken;
	}
	
	public static org.apache.axis.AxisFault FaultToAxisFault
		(final org.eclipse.higgins.sts.api.IFault fault)
	{
    	final javax.xml.namespace.QName qname = new QName
    		(fault.getCodeNamespace().toString(),
    		fault.getCodeLocalPart(),
    		fault.getCodePrefix());
    	String strDetail = fault.getDetail();
    	Element [] domDetails = null;
    	if (null != strDetail)
    	{
    		strDetail = "<Explanation>" + strDetail + "</Explanation>";
    		org.w3c.dom.Element domDetail = null;
    		try
    		{
    			domDetail = XMLHelper.toDOM(strDetail);
    		}
    		catch (final Exception e)
    		{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);	
	    		strDetail = null;
    		}
    		
    		if (null != domDetail)
    		{
    			domDetails = new Element[1];
    			domDetails[0] = domDetail;
    		}
    	}
    	return new org.apache.axis.AxisFault
    		(qname,
    		fault.getReason(),
    		null,
    		domDetails);
	}
	
	public static org.eclipse.higgins.sts.api.IFault AxisFaultToAxis
		(final org.apache.axis.AxisFault fault)
	{
		final Element [] elemFaultDetails = fault.getFaultDetails();
		String strFaultDetails = "";
		for (int i = 0; i < elemFaultDetails.length; ++i)
		{
			try
			{
				strFaultDetails += XMLHelper.toString
					(elemFaultDetails[i]);
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);
			}
		}
		final QName faultCode = fault.getFaultCode();
		final org.eclipse.higgins.sts.api.IFault result = new org.eclipse.higgins.sts.common.Fault
			(java.net.URI.create(faultCode.getNamespaceURI()),
			faultCode.getPrefix(),
			faultCode.getLocalPart(),
			fault.getFaultReason(),
			strFaultDetails);
		return result;
	}
    
	/**
	 * Converts the values in an Axis 1.x framework dependent RequestSecurityToken to the framework independent STSRequest
     *
	 * @param RST the Axis 1.x framework dependent RequestSecurityToken to be converted
	 * @return the converted framework independent STSRequest
	 */
	public static ISTSRequest STSRequestFromAxis1xRST
		(final org.apache.axis.MessageContext messageContext,
		final org.eclipse.higgins.sts.api.IConstants constants,
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST)
	{
		BindingHelper.log.trace("Begin STSRequestFromAxis1xRST");
		
		final ISTSRequest request = new org.eclipse.higgins.sts.common.STSRequest();
		try
		{
			final org.apache.axis.Message messageRequest = messageContext.getRequestMessage();
			final org.apache.axis.message.SOAPEnvelope seRequest = messageRequest.getSOAPEnvelope();
			final org.eclipse.higgins.sts.api.IElement elemRequestMessage = new org.eclipse.higgins.sts.common.Element();
			elemRequestMessage.set(seRequest.getAsDOM());
			request.setMessage(elemRequestMessage);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final ISecurityInformation securityInformation = (ISecurityInformation)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.security.Constants.PROPERTY_REQUEST_CONSUMER_SECURITY);
		request.setSecurityInformation(securityInformation);
		final IAddressingInformation addressingInformation = new AddressingInformation();
		final java.net.URI uriAddressingNamespace = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_NAMESPACE_URI);
		if (null != uriAddressingNamespace)
		{
			addressingInformation.setNamespace
				(uriAddressingNamespace);
		}
		final java.net.URI uriAction = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_ACTION_URI);
		try
		{
			addressingInformation.setAction
				(uriAction);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final java.net.URI uriTo = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_TO_URI);
		try
		{
			addressingInformation.setTo
				(uriTo);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final org.eclipse.higgins.sts.api.IEndpointReference eprFrom = (org.eclipse.higgins.sts.api.IEndpointReference)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_FROM_EPR);
		try
		{
			addressingInformation.setFrom
				(eprFrom);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final java.net.URI uriMessageID = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_MESSAGE_ID_URI);
		try
		{
			addressingInformation.setMessageID
				(uriMessageID);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final java.net.URI uriRelatesTo = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_RELATES_TO_URI);
		try
		{
			addressingInformation.setRelatesTo
				(uriRelatesTo);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final java.net.URI uriRelatesToRelationshipType = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_RELATES_TO_RELATIONSHIP_TYPE_URI);
		try
		{
			addressingInformation.setRelatesToRelationshipType
				(uriRelatesToRelationshipType);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		request.setAddressingInformation(addressingInformation);
		final org.eclipse.higgins.sts.api.IRequestSecurityToken requestSecurityToken = BindingHelper.RSTFromAxis1xRST
			(constants,
			RST);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add
			(requestSecurityToken);
		BindingHelper.log.trace("End STSRequestFromAxis1xRST");
	   	return request;
	}
	
	public static ISTSResponse STSResponseFromSTSRequest
		(final ISTSRequest request,
		final IConstants constants)
	{
		final ISTSResponse response = new STSResponse();
		final AddressingInformation responseAddressingInformation = new AddressingInformation();
		final org.eclipse.higgins.sts.api.IAddressingInformation requestAddressingInformation = request.getAddressingInformation();
		final java.net.URI uriAddressingNamespace = requestAddressingInformation.getNamespace();
		if (null != uriAddressingNamespace) {
			responseAddressingInformation.setNamespace(uriAddressingNamespace);
		}
		final java.net.URI uriAction = requestAddressingInformation.getAction();
		if (null != uriAction)
		{
			if (uriAction.equals(constants.getIssueRequestAction()))
			{
				responseAddressingInformation.setAction(constants.getIssueResponseAction());
			}
			else if (uriAction.equals(constants.getValidateRequestAction()))
			{
				responseAddressingInformation.setAction(constants.getValidateResponseAction());
			}
			else if (uriAction.equals(constants.getCancelRequestAction()))
			{
				responseAddressingInformation.setAction(constants.getCancelResponseAction());
			}
			else if (uriAction.equals(constants.getRenewRequestAction()))
			{
				responseAddressingInformation.setAction(constants.getRenewResponseAction());
			}
			else
			{
				BindingHelper.log.trace("BindingHelper::STSResponseFromSTSRequest Unknown Request Action");
				// TODO: Register Mapping form Request to Response Actions
			}
		}
		final java.net.URI uriRequestMessageID = requestAddressingInformation.getMessageID();
		if (null != uriRequestMessageID)
		{
			responseAddressingInformation.setRelatesTo(uriRequestMessageID);
		}
		final java.net.URI uriResponseMessageID = org.eclipse.higgins.sts.utilities.UUIDHelper.getAsURI();
		responseAddressingInformation.setMessageID(uriResponseMessageID);
		response.setAddressingInformation(responseAddressingInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final org.eclipse.higgins.sts.common.RequestSecurityToken RST = (org.eclipse.higgins.sts.common.RequestSecurityToken)listRST.get(0);
		final org.eclipse.higgins.sts.common.RequestSecurityTokenResponse RSTR = new org.eclipse.higgins.sts.common.RequestSecurityTokenResponse();
		final String strContext = RST.getContext();
		if (null != strContext)
		{
			RSTR.setContext(strContext);
		}
		final java.util.List listRSTR = response.getRequestSecurityTokenResponseCollection();
		listRSTR.add(RSTR);
		return response;
	}
	
	/**
	 * Converts the values in an framework independent RequestSecurityTokenResponse to an array of framework dependent MessageElements
     *
     * @param messageContext the MessageContext
	 * @param response the STSResponse
	 * @return the Axis 1.x framework dependent RequestSecurityTokenResponse
	 */
	public static org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType Axis1xRSTRFromSTSResponse
		(final org.apache.axis.MessageContext messageContext,
		final ISTSResponse response,
		final IConstants constants)
	{
		BindingHelper.log.trace("Begin Axis1xRSTRFromSTSResponse");
		
		final IAddressingInformation addressingInformation = response.getAddressingInformation();
		final java.net.URI uriAddressingNamespace = addressingInformation.getNamespace();
		if (null != uriAddressingNamespace)
		{
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_NAMESPACE_URI,
				uriAddressingNamespace);
		}
		final java.net.URI uriAction = addressingInformation.getAction();
		if (null != uriAction)
		{
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_ACTION_URI,
				uriAction);
		}
		final java.net.URI uriMessageID = addressingInformation.getMessageID();
		if (null != uriMessageID)
		{
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_MESSAGE_ID_URI,
				uriMessageID);
		}
		final java.net.URI uriRelatesTo = addressingInformation.getRelatesTo();
		if (null != uriRelatesTo)
		{
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_RELATES_TO_URI,
				uriRelatesTo);
		}
  	   	org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR = null;
    	final java.util.List listRSTR = response.getRequestSecurityTokenResponseCollection();
    	// TODO: Deal with multiple returned RSTRs here
    	final IRequestSecurityTokenResponse requestSecurityTokenResponse = (IRequestSecurityTokenResponse)listRSTR.get(0);
		final java.util.ArrayList alME = new java.util.ArrayList();
		try
		{
			final org.eclipse.higgins.sts.api.IDisplayToken dtRequestedDisplayToken = requestSecurityTokenResponse.getRequestedDisplayToken();
			if (null != dtRequestedDisplayToken) {
				alME.add
					(BindingHelper.toDisplayTokenMessageElement
						(dtRequestedDisplayToken));
			}
			final IElement elemRequestedTokenCancelled = requestSecurityTokenResponse.getRequestedTokenCancelled();
			if (null != elemRequestedTokenCancelled) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRequestedTokenCancelled.getAs
							(org.w3c.dom.Element.class)));
			}
			final java.net.URI uriComputedKey = requestSecurityTokenResponse.getComputedKey();
			if (null != uriComputedKey) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"ComputedKey",
						uriComputedKey));
			}
			final java.net.URI uriTokenType = requestSecurityTokenResponse.getTokenType();
			if (null != uriTokenType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"TokenType",
						uriTokenType));
			}
			final java.net.URI uriRequestType = requestSecurityTokenResponse.getRequestType();		
			if (null != uriRequestType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"RequestType",
						uriRequestType));
			}
			final IElement elemRequestedSecurityToken = requestSecurityTokenResponse.getRequestedSecurityToken();		
			if (null != elemRequestedSecurityToken) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRequestedSecurityToken.getAs
							(org.w3c.dom.Element.class)));
			}
			final org.eclipse.higgins.sts.api.IEndpointReference eprAppliesTo = requestSecurityTokenResponse.getAppliesTo();		
			if (null != eprAppliesTo) {
				alME.add
					(BindingHelper.toEndpointReferenceMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"AppliesTo",
						constants.getWSAddressingNamespace(),
						"wsa",
						eprAppliesTo));
			}
			final IElement elemRequestedAttachedReference = requestSecurityTokenResponse.getRequestedAttachedReference();		
			if (null != elemRequestedAttachedReference) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRequestedAttachedReference.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemRequestedUnattachedReference = requestSecurityTokenResponse.getRequestedUnattachedReference();		
			if (null != elemRequestedUnattachedReference) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRequestedUnattachedReference.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemRequestedProofToken = requestSecurityTokenResponse.getRequestedProofToken();		
			if (null != elemRequestedProofToken) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRequestedProofToken.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemEntropy = requestSecurityTokenResponse.getEntropy();		
			if (null != elemEntropy) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemEntropy.getAs
							(org.w3c.dom.Element.class)));
			}
			final org.eclipse.higgins.sts.api.ILifetime ltLifetime = requestSecurityTokenResponse.getLifetime();		
			if (null != ltLifetime) {
				alME.add
					(BindingHelper.toLifetimeMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						constants.getWSSecurityUtilityNamespace(),
						"wsu",
						ltLifetime));
			}
			final IElement elemStatus = requestSecurityTokenResponse.getStatus();		
			if (null != elemStatus) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemStatus.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemAllowPostdating = requestSecurityTokenResponse.getAllowPostdating();		
			if (null != elemAllowPostdating) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemAllowPostdating.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemRenewing = requestSecurityTokenResponse.getRenewing();		
			if (null != elemRenewing) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemRenewing.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemOnBehalfOf = requestSecurityTokenResponse.getOnBehalfOf();		
			if (null != elemOnBehalfOf) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemOnBehalfOf.getAs
							(org.w3c.dom.Element.class)));
			}
			final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = requestSecurityTokenResponse.getIssuer();
			if (null != eprIssuer) {
				alME.add
					(BindingHelper.toEndpointReferenceMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Issuer",
						constants.getWSAddressingNamespace(),
						"wsa",
						eprIssuer));
			}
			final java.net.URI uriAuthenticationType = requestSecurityTokenResponse.getAuthenticationType();		
			if (null != uriAuthenticationType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"AuthenticationType",
						uriAuthenticationType));
			}
			final IElement elemAuthenticator = requestSecurityTokenResponse.getAuthenticator();		
			if (null != elemAuthenticator) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemAuthenticator.getAs
							(org.w3c.dom.Element.class)));
			}
			final java.net.URI uriKeyType = requestSecurityTokenResponse.getKeyType();		
			if (null != uriKeyType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"KeyType",
						uriKeyType));
			}
			final java.lang.Integer intKeySize = requestSecurityTokenResponse.getKeySize();		
			if (null != intKeySize) {
				alME.add
					(BindingHelper.toIntMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"KeySize",
						intKeySize.intValue()));
			}
			final java.net.URI uriSignatureAlgorithm = requestSecurityTokenResponse.getSignatureAlgorithm();		
			if (null != uriSignatureAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"SignatureAlgorithm",
						uriSignatureAlgorithm));
			}
			final IElement elemEncryption = requestSecurityTokenResponse.getEncryption();		
			if (null != elemEncryption) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemEncryption.getAs
							(org.w3c.dom.Element.class)));
			}
			final java.net.URI uriEncryptionAlgorithm = requestSecurityTokenResponse.getEncryptionAlgorithm();		
			if (null != uriEncryptionAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"EncryptionAlgorithm",
						uriEncryptionAlgorithm));
			}
			final java.net.URI uriCanonicalizationAlgorithm = requestSecurityTokenResponse.getCanonicalizationAlgorithm();		
			if (null != uriCanonicalizationAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"CanonicalizationAlgorithm",
						uriCanonicalizationAlgorithm));
			}
			final IElement elemProofEncryption = requestSecurityTokenResponse.getProofEncryption();		
			if (null != elemProofEncryption) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemProofEncryption.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemUseKey = requestSecurityTokenResponse.getUseKey();		
			if (null != elemUseKey) {
				alME.add
					(new org.apache.axis.message.MessageElement
							((org.w3c.dom.Element)elemUseKey.getAs
									(org.w3c.dom.Element.class)));
			}
			final java.net.URI uriSignWith = requestSecurityTokenResponse.getSignWith();		
			if (null != uriSignWith) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"SignWith",
						uriSignWith));
			}
			final java.net.URI uriEncryptWith = requestSecurityTokenResponse.getEncryptWith();		
			if (null != uriEncryptWith) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"EncryptWith",
						uriEncryptWith));
			}	
			final IElement elemDelegateTo = requestSecurityTokenResponse.getDelegateTo();		
			if (null != elemDelegateTo) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemDelegateTo.getAs
							(org.w3c.dom.Element.class)));
			}
			final Boolean boolForwardable = requestSecurityTokenResponse.getForwardable();		
			if (null != boolForwardable) {
				alME.add
					(BindingHelper.toBooleanMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Forwardable",
						boolForwardable.booleanValue()));
			}
			final Boolean boolDelegatable = requestSecurityTokenResponse.getDelegatable();		
			if (null != boolDelegatable) {
				alME.add
					(BindingHelper.toBooleanMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Delegatable",
						boolDelegatable.booleanValue()));
			}
			final IElement elemPolicy = requestSecurityTokenResponse.getPolicy();		
			if (null != elemPolicy) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemPolicy.getAs
							(org.w3c.dom.Element.class)));
			}
			final IElement elemPolicyReference = requestSecurityTokenResponse.getPolicyReference();
			if (null != elemPolicyReference) {
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)elemPolicyReference.getAs
							(org.w3c.dom.Element.class)));
			}
			final java.util.List setAnyOther = requestSecurityTokenResponse.getAnyOtherElements();		
			final java.util.Iterator iterAnyOther = setAnyOther.iterator();
			for (;;)
			{
				if (!iterAnyOther.hasNext()) {
					break;
				}
				final IElement element = (IElement)iterAnyOther.next();
				alME.add
					(new org.apache.axis.message.MessageElement
						((org.w3c.dom.Element)element.getAs
							(org.w3c.dom.Element.class)));
			}
	    	final org.apache.axis.message.MessageElement [] meRSTR = new org.apache.axis.message.MessageElement[alME.size()];
			alME.toArray(meRSTR);
	  	   	RSTR = new org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType();
	  	   	RSTR.set_any
	  	   		(meRSTR);
			final String strContext = requestSecurityTokenResponse.getContext();
			if (null != strContext)
			{
				BindingHelper.log.trace("setContext: " + strContext);
				RSTR.setContext(strContext);
			}
			else
			{
				BindingHelper.log.trace("getContext is null");
			}
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		
		BindingHelper.log.trace("End Axis1xRSTRFromSTSResponse");

		return RSTR;
	}
	
	public static void STSResponseFromAxis1xRSTR
		(final org.apache.axis.MessageContext messageContext,
		final IConstants constants,
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR,
		final org.eclipse.higgins.sts.api.ISTSResponse response)
	{
		BindingHelper.log.trace("Begin STSResponseFromAxis1xRSTR");

		try
		{
			final org.apache.axis.Message messageResponse = messageContext.getResponseMessage();
			final org.apache.axis.message.SOAPEnvelope seResponse = messageResponse.getSOAPEnvelope();
			final org.eclipse.higgins.sts.api.IElement elemResponseMessage = new org.eclipse.higgins.sts.common.Element();
			elemResponseMessage.set(seResponse.getAsDOM());
			response.setMessage(elemResponseMessage);
		}
		catch (final Exception e)
		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);				
		}
		final org.eclipse.higgins.sts.common.RequestSecurityTokenResponse requestSecurityTokenResponse = BindingHelper.RSTRFromAxis1xRSTR
			(constants,
			RSTR);
		final java.util.List listRSTR = response.getRequestSecurityTokenResponseCollection();
		listRSTR.add
			(requestSecurityTokenResponse);
		
		BindingHelper.log.trace("End STSResponseFromAxis1xRSTR");
	}
	
	
	public static org.xmlsoap.schemas.ws._2004._09.mex.Metadata toAxis1xMetadata
		(final IElement elemMetadata)
		throws Exception
	{
		final org.xmlsoap.schemas.ws._2004._09.mex.Metadata metadata = new org.xmlsoap.schemas.ws._2004._09.mex.Metadata();
		final org.w3c.dom.Element domMetadata = (org.w3c.dom.Element)elemMetadata.getAs(org.w3c.dom.Element.class);
		final org.w3c.dom.NodeList nlMetadataSections = domMetadata.getElementsByTagNameNS
			("http://schemas.xmlsoap.org/ws/2004/09/mex",
			"MetadataSection");
		final org.apache.axis.message.MessageElement [] messageElements = new org.apache.axis.message.MessageElement [nlMetadataSections.getLength()];
		for (int i = 0; i < nlMetadataSections.getLength(); ++i)
		{
			final org.w3c.dom.Element domMetadataSection = (org.w3c.dom.Element)nlMetadataSections.item(i);
			messageElements[i] = new org.apache.axis.message.MessageElement(domMetadataSection);
		}
		metadata.set_any(messageElements);
		
		return metadata;
	}
	
	public static String toString
		(final org.xmlsoap.schemas.ws._2004._09.mex.Metadata metadata)
		throws Exception
	{
		final javax.xml.namespace.QName qname = new javax.xml.namespace.QName
			("http://schemas.xmlsoap.org/ws/2004/09/mex",
			"Metadata");
		final java.io.StringWriter writer = new java.io.StringWriter();
		final org.apache.axis.encoding.SerializationContext context = new org.apache.axis.encoding.SerializationContext(writer);
	    context.serialize(qname, null, metadata);
		return new String(writer.getBuffer());
	}
	
	public static void MEXResponseFromAxis1xMetadata
		(final IConstants constants,
		final org.xmlsoap.schemas.ws._2004._09.mex.Metadata metadata,
		final org.eclipse.higgins.sts.api.IMEXResponse response)
	{
        final org.eclipse.higgins.sts.api.IElement elemMetadata = new org.eclipse.higgins.sts.common.Element();
        try
        {
            final String strMetadata = BindingHelper.toString(metadata);
        	elemMetadata.set(strMetadata);
    		response.setMetadata(elemMetadata);
        }
   		catch (final Exception e)
   		{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);	
			final IFault fault = new org.eclipse.higgins.sts.common.Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());
			response.setFault(fault);	
   		}
	}

	public static org.eclipse.higgins.sts.common.RequestSecurityTokenResponse RSTRFromAxis1xRSTR
		(final IConstants constants,
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR)
	{
		BindingHelper.log.trace("Begin RSTRFromAxis1xRSTR");

		final org.eclipse.higgins.sts.common.RequestSecurityTokenResponse requestSecurityTokenResponse = new org.eclipse.higgins.sts.common.RequestSecurityTokenResponse();
		final String strContext = RSTR.getContext();
		if (null != strContext)
	    {
	    	BindingHelper.log.trace("Context: " + strContext);
	    	requestSecurityTokenResponse.setContext
	    		(strContext);
	    }
	   	final org.apache.axis.message.MessageElement [] meRSTR = RSTR.get_any();
	   	final int nResponseLength = meRSTR.length;
	   	for (int nResponseIndex = 0; nResponseIndex < nResponseLength; ++nResponseIndex)
	   	{
	   		try
	   		{
	   			final org.apache.axiom.om.OMElement omElement = org.eclipse.higgins.sts.utilities.XMLHelper.toOM
	   				(meRSTR[nResponseIndex].getAsDOM());
	   			final IElement element = org.eclipse.higgins.sts.utilities.XMLHelper.toElement
	   				(omElement);
	   			final String strLocalName = omElement.getLocalName();
	   			if (strLocalName.equals
	   				("RequestedTokenCancelled")) {
					requestSecurityTokenResponse.setRequestedTokenCancelled
	   					(element);
				}
	   			if (strLocalName.equals
		   			("RequestedDisplayToken")) {
					requestSecurityTokenResponse.setRequestedDisplayToken
		   				(BindingHelper.toDisplayToken
		   					(omElement));
				}
	   			if (strLocalName.equals
	   				("TokenType")) {
					requestSecurityTokenResponse.setTokenType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("ComputedKey")) {
					requestSecurityTokenResponse.setComputedKey
		   				(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("RequestType")) {
					requestSecurityTokenResponse.setRequestType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
		   			("RequestedSecurityToken")) {
					requestSecurityTokenResponse.setRequestedSecurityToken
		   				(element);
				} else if (strLocalName.equals
		   			("AppliesTo")) {
					requestSecurityTokenResponse.setAppliesTo
		   				(BindingHelper.toEndpointReference
			   				(constants.getWSAddressingNamespace(),
					   		omElement));
				} else if (strLocalName.equals
		   			("RequestedAttachedReference")) {
					requestSecurityTokenResponse.setRequestedAttachedReference
		   				(element);
				} else if (strLocalName.equals
		   			("RequestedUnattachedReference")) {
					requestSecurityTokenResponse.setRequestedUnattachedReference
		   				(element);
				} else if (strLocalName.equals
		   			("RequestedProofToken")) {
					requestSecurityTokenResponse.setRequestedProofToken
		   				(element);
				} else if (strLocalName.equals
	   				("Entropy")) {
					requestSecurityTokenResponse.setEntropy
	   					(element);
				} else if (strLocalName.equals
	   				("Lifetime")) {
					requestSecurityTokenResponse.setLifetime
   						(BindingHelper.toLifetime
	   						(constants.getWSSecurityUtilityNamespace(),
	   						omElement));
				} else if (strLocalName.equals
	   				("Status")) {
					requestSecurityTokenResponse.setStatus
	   					(element);
				} else if (strLocalName.equals
	   				("AllowPostdating")) {
					requestSecurityTokenResponse.setAllowPostdating
	   					(element);
				} else if (strLocalName.equals
	   				("Renewing")) {
					requestSecurityTokenResponse.setRenewing
	   					(element);
				} else if (strLocalName.equals
	   				("OnBehalfOf")) {
					requestSecurityTokenResponse.setOnBehalfOf
	   					(element);
				} else if (strLocalName.equals
	   				("Issuer")) {
					requestSecurityTokenResponse.setIssuer
	   					(BindingHelper.toEndpointReference
			   				(constants.getWSAddressingNamespace(),
					   		omElement));
				} else if (strLocalName.equals
	   				("AuthenticationType")) {
					requestSecurityTokenResponse.setAuthenticationType
	   					(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("Authenticator")) {
					requestSecurityTokenResponse.setAuthenticator
	   					(element);
				} else if (strLocalName.equals
	   				("KeyType")) {
					requestSecurityTokenResponse.setKeyType
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("KeySize")) {
					requestSecurityTokenResponse.setKeySize
	   					(BindingHelper.toInt(omElement));
				} else if (strLocalName.equals
	   				("SignatureAlgorithm")) {
					requestSecurityTokenResponse.setSignatureAlgorithm
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("Encryption")) {
					requestSecurityTokenResponse.setEncryption
	   					(element);
				} else if (strLocalName.equals
	   				("EncryptionAlgorithm")) {
					requestSecurityTokenResponse.setEncryptionAlgorithm
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("CanonicalizationAlgorithm")) {
					requestSecurityTokenResponse.setCanonicalizationAlgorithm
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("ProofEncryption")) {
					requestSecurityTokenResponse.setProofEncryption
	   					(element);
				} else if (strLocalName.equals
	   				("UseKey")) {
					requestSecurityTokenResponse.setUseKey
	   					(element);
				} else if (strLocalName.equals
	   				("SignWith")) {
					requestSecurityTokenResponse.setSignWith
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("EncryptWith")) {
					requestSecurityTokenResponse.setEncryptWith
						(BindingHelper.toURI(omElement));
				} else if (strLocalName.equals
	   				("DelegateTo")) {
					requestSecurityTokenResponse.setDelegateTo
	   					(element);
				} else if (strLocalName.equals
	   				("Forwardable")) {
					requestSecurityTokenResponse.setForwardable
						(BindingHelper.toBoolean(omElement));
				} else if (strLocalName.equals
	   				("Delegatable")) {
					requestSecurityTokenResponse.setDelegatable
						(BindingHelper.toBoolean(omElement));
				} else if (strLocalName.equals
	   				("Policy")) {
					requestSecurityTokenResponse.setPolicy
	   					(element);
				} else if (strLocalName.equals
	   				("PolicyReference")) {
					requestSecurityTokenResponse.setPolicyReference
	   					(element);
				} else 
	   			{
	   				final java.util.List listAnyOther = requestSecurityTokenResponse.getAnyOtherElements();
	   				listAnyOther.add(element);
	   			}
	   		}
	   		catch (final Exception e)
	   		{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(BindingHelper.log,
					e);	
	    		return null;
	   		}
	   	}
		BindingHelper.log.trace("End RSTRFromAxis1xRSTR");

		return requestSecurityTokenResponse;
	}
		
	public static org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType Axis1xRSTFromSTSRequest
		(final ISTSRequest request,
		final IConstants constants)
	{
		BindingHelper.log.trace("Begin Axis1xRSTFromSTSRequest");
		
		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST = new org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType();
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		// TODO: Deal with multiple returned RSTRs here
		final IRequestSecurityToken requestSecurityToken = (IRequestSecurityToken)listRST.get(0);
		final java.util.ArrayList alME = new java.util.ArrayList();
		try
		{
			final String strContext = requestSecurityToken.getContext();
			if (null != strContext)
			{
				BindingHelper.log.trace("Context: " + strContext);
				RST.setContext(strContext);
			}
			org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = requestSecurityToken.getInformationCardReference();
			if (null != informationCardReference)
				alME.add
					(BindingHelper.toInformationCardReferenceMessageElement
						(informationCardReference));
			final IElement elemRequestDisplayToken = requestSecurityToken.getRequestDisplayToken();
			if (null != elemRequestDisplayToken) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemRequestDisplayToken));
			}
			final IElement elemBase = requestSecurityToken.getBase();
			if (null != elemBase) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemBase));
			}
			final java.net.URI uriComputedKeyAlgorithm = requestSecurityToken.getComputedKeyAlgorithm();
			if (null != uriComputedKeyAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"ComputedKeyAlgorithm",
						uriComputedKeyAlgorithm));
			}
			final java.net.URI uriTokenType = requestSecurityToken.getTokenType();
			if (null != uriTokenType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"TokenType",
						uriTokenType));
			}
			final java.net.URI uriRequestType = requestSecurityToken.getRequestType();		
			if (null != uriRequestType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"RequestType",
						uriRequestType));
			}
			final org.eclipse.higgins.sts.api.IAppliesTo appliesTo = requestSecurityToken.getAppliesTo();		
			if (null != appliesTo) {
				alME.add
					(BindingHelper.toAppliesToMessageElement
						(constants.getWSPolicyNamespace(),
						"wsp",
						constants.getWSAddressingNamespace(),
						"wsa",
						appliesTo));
			}
			final IElement elemCancelTarget = requestSecurityToken.getCancelTarget();		
			if (null != elemCancelTarget) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemCancelTarget));
			}
			final IElement elemValidateTarget = requestSecurityToken.getValidateTarget();		
			if (null != elemValidateTarget) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemValidateTarget));
			}
			final IElement elemRenewTarget = requestSecurityToken.getRenewTarget();		
			if (null != elemRenewTarget) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemRenewTarget));
			}
			final IElement elemClaims = requestSecurityToken.getClaims();		
			if (null != elemClaims) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemClaims));
			}
			final IElement elemEntropy = requestSecurityToken.getEntropy();		
			if (null != elemEntropy) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemEntropy));
			}
			final ILifetime ltLifetime = requestSecurityToken.getLifetime();		
			if (null != ltLifetime) {
				alME.add
					(BindingHelper.toLifetimeMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						constants.getWSSecurityUtilityNamespace(),
						"wsu",
						ltLifetime));
			}
			final IElement elemAllowPostdating = requestSecurityToken.getAllowPostdating();		
			if (null != elemAllowPostdating) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemAllowPostdating));
			}
			final IElement elemRenewing = requestSecurityToken.getRenewing();		
			if (null != elemRenewing) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemRenewing));
			}
			final IElement elemOnBehalfOf = requestSecurityToken.getOnBehalfOf();		
			if (null != elemOnBehalfOf) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemOnBehalfOf));
			}
			final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = requestSecurityToken.getIssuer();
			if (null != eprIssuer) {
				alME.add
					(BindingHelper.toEndpointReferenceMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Issuer",
						constants.getWSAddressingNamespace(),
						"wsa",
						eprIssuer));
			}
			final java.net.URI uriAuthenticationType = requestSecurityToken.getAuthenticationType();		
			if (null != uriAuthenticationType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"AuthenticationType",
						uriAuthenticationType));
			}
			final java.net.URI uriKeyType = requestSecurityToken.getKeyType();		
			if (null != uriKeyType) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"KeyType",
						uriKeyType));
			}
			final java.lang.Integer intKeySize = requestSecurityToken.getKeySize();		
			if (null != intKeySize) {
				alME.add
					(BindingHelper.toIntMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"KeySize",
						intKeySize.intValue()));
			}
			
			final java.net.URI uriSignatureAlgorithm = requestSecurityToken.getSignatureAlgorithm();		
			if (null != uriSignatureAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"SignatureAlgorithm",
						uriSignatureAlgorithm));
			}		
			final IElement elemEncryption = requestSecurityToken.getEncryption();		
			if (null != elemEncryption) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemEncryption));
			}
			final java.net.URI uriEncryptionAlgorithm = requestSecurityToken.getEncryptionAlgorithm();		
			if (null != uriEncryptionAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"EncryptionAlgorithm",
						uriEncryptionAlgorithm));
			}		
			final java.net.URI uriCanonicalizationAlgorithm = requestSecurityToken.getCanonicalizationAlgorithm();		
			if (null != uriCanonicalizationAlgorithm) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"CanonicalizationAlgorithm",
						uriCanonicalizationAlgorithm));
			}		
			final IElement elemProofEncryption = requestSecurityToken.getProofEncryption();		
			if (null != elemProofEncryption) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemProofEncryption));
			}
			final IElement elemUseKey = requestSecurityToken.getUseKey();		
			if (null != elemUseKey) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemUseKey));
			}
			final java.net.URI uriSignWith = requestSecurityToken.getSignWith();		
			if (null != uriSignWith) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"SignWith",
						uriSignWith));
			}		
			final java.net.URI uriEncryptWith = requestSecurityToken.getEncryptWith();		
			if (null != uriEncryptWith) {
				alME.add
					(BindingHelper.toURIMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"EncryptWith",
						uriEncryptWith));
			}		
			final IElement elemDelegateTo = requestSecurityToken.getDelegateTo();		
			if (null != elemDelegateTo) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemDelegateTo));
			}
			final java.lang.Boolean boolForwardable = requestSecurityToken.getForwardable();		
			if (null != boolForwardable) {
				alME.add
					(BindingHelper.toBooleanMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Forwardable",
						boolForwardable.booleanValue()));
			}
			final java.lang.Boolean boolDelegatable = requestSecurityToken.getDelegatable();		
			if (null != boolDelegatable) {
				alME.add
					(BindingHelper.toBooleanMessageElement
						(constants.getWSTrustNamespace(),
						"wst",
						"Delegatable",
						boolDelegatable.booleanValue()));
			}
			final IElement elemPolicy = requestSecurityToken.getPolicy();		
			if (null != elemPolicy) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemPolicy));
			}
			final IElement elemPolicyReference = requestSecurityToken.getPolicyReference();
			if (null != elemPolicyReference) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemPolicyReference));
			}
			final IElement elemClientPseudonym = requestSecurityToken.getClientPseudonym();
			if (null != elemClientPseudonym) {
				alME.add
					(BindingHelper.toElementMessageElement
						(elemClientPseudonym));
			}
			final java.util.List setAnyOther = requestSecurityToken.getAnyOtherElements();		
			final java.util.Iterator iterAnyOther = setAnyOther.iterator();
			for (;;)
			{
				if (!iterAnyOther.hasNext()) {
					break;
				}
				final IElement element = (IElement)iterAnyOther.next();
				alME.add
					(BindingHelper.toElementMessageElement
						(element));
			}
	    	final org.apache.axis.message.MessageElement [] meRST = new org.apache.axis.message.MessageElement[alME.size()];
			alME.toArray(meRST);
	  	   	RST.set_any
	  	   		(meRST);
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(BindingHelper.log,
				e);
		}
		
		BindingHelper.log.trace("End Axis1xRSTFromSTSRequest");
		
		return RST;
	}
}
