/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.w3.www._2000._09.xmldsig;

public class DSAKeyValueType  implements java.io.Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private byte[] p;

    private byte[] q;

    private byte[] g;

    private byte[] y;

    private byte[] j;

    private byte[] seed;

    private byte[] pgenCounter;

    public DSAKeyValueType() {
    }

    public DSAKeyValueType(
           final byte[] p,
           final byte[] q,
           final byte[] g,
           final byte[] y,
           final byte[] j,
           final byte[] seed,
           final byte[] pgenCounter) {
           this.p = p;
           this.q = q;
           this.g = g;
           this.y = y;
           this.j = j;
           this.seed = seed;
           this.pgenCounter = pgenCounter;
    }


    /**
     * Gets the p value for this DSAKeyValueType.
     * 
     * @return p
     */
    public byte[] getP() {
        return this.p;
    }


    /**
     * Sets the p value for this DSAKeyValueType.
     * 
     * @param p
     */
    public void setP(final byte[] p) {
        this.p = p;
    }


    /**
     * Gets the q value for this DSAKeyValueType.
     * 
     * @return q
     */
    public byte[] getQ() {
        return this.q;
    }


    /**
     * Sets the q value for this DSAKeyValueType.
     * 
     * @param q
     */
    public void setQ(final byte[] q) {
        this.q = q;
    }


    /**
     * Gets the g value for this DSAKeyValueType.
     * 
     * @return g
     */
    public byte[] getG() {
        return this.g;
    }


    /**
     * Sets the g value for this DSAKeyValueType.
     * 
     * @param g
     */
    public void setG(final byte[] g) {
        this.g = g;
    }


    /**
     * Gets the y value for this DSAKeyValueType.
     * 
     * @return y
     */
    public byte[] getY() {
        return this.y;
    }


    /**
     * Sets the y value for this DSAKeyValueType.
     * 
     * @param y
     */
    public void setY(final byte[] y) {
        this.y = y;
    }


    /**
     * Gets the j value for this DSAKeyValueType.
     * 
     * @return j
     */
    public byte[] getJ() {
        return this.j;
    }


    /**
     * Sets the j value for this DSAKeyValueType.
     * 
     * @param j
     */
    public void setJ(final byte[] j) {
        this.j = j;
    }


    /**
     * Gets the seed value for this DSAKeyValueType.
     * 
     * @return seed
     */
    public byte[] getSeed() {
        return this.seed;
    }


    /**
     * Sets the seed value for this DSAKeyValueType.
     * 
     * @param seed
     */
    public void setSeed(final byte[] seed) {
        this.seed = seed;
    }


    /**
     * Gets the pgenCounter value for this DSAKeyValueType.
     * 
     * @return pgenCounter
     */
    public byte[] getPgenCounter() {
        return this.pgenCounter;
    }


    /**
     * Sets the pgenCounter value for this DSAKeyValueType.
     * 
     * @param pgenCounter
     */
    public void setPgenCounter(final byte[] pgenCounter) {
        this.pgenCounter = pgenCounter;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof DSAKeyValueType)) {
			return false;
		}
        final DSAKeyValueType other = (DSAKeyValueType) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.p==null) && (other.getP()==null)) || 
             ((this.p!=null) &&
              java.util.Arrays.equals(this.p, other.getP()))) &&
            (((this.q==null) && (other.getQ()==null)) || 
             ((this.q!=null) &&
              java.util.Arrays.equals(this.q, other.getQ()))) &&
            (((this.g==null) && (other.getG()==null)) || 
             ((this.g!=null) &&
              java.util.Arrays.equals(this.g, other.getG()))) &&
            (((this.y==null) && (other.getY()==null)) || 
             ((this.y!=null) &&
              java.util.Arrays.equals(this.y, other.getY()))) &&
            (((this.j==null) && (other.getJ()==null)) || 
             ((this.j!=null) &&
              java.util.Arrays.equals(this.j, other.getJ()))) &&
            (((this.seed==null) && (other.getSeed()==null)) || 
             ((this.seed!=null) &&
              java.util.Arrays.equals(this.seed, other.getSeed()))) &&
            (((this.pgenCounter==null) && (other.getPgenCounter()==null)) || 
             ((this.pgenCounter!=null) &&
              java.util.Arrays.equals(this.pgenCounter, other.getPgenCounter())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getP() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getP());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getP(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getQ() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getQ());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getQ(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getG() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getG());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getG(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getY() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getY());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getY(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getJ() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getJ());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getJ(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getSeed() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getSeed());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getSeed(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getPgenCounter() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getPgenCounter());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getPgenCounter(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(DSAKeyValueType.class, true);

    static {
        DSAKeyValueType.typeDesc.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValueType"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("p");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "P"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("q");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "Q"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("g");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "G"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("y");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "Y"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("j");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "J"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("seed");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "Seed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pgenCounter");
        elemField.setXmlName(new javax.xml.namespace.QName("http://www.w3.org/2000/09/xmldsig#", "PgenCounter"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(false);
        DSAKeyValueType.typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return DSAKeyValueType.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, DSAKeyValueType.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, DSAKeyValueType.typeDesc);
    }

}
