/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.xmlsoap.schemas.ws._2004._09.policy;

public class PolicyReference  implements java.io.Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private org.apache.axis.types.URI URI;  // attribute

    private byte[] digest;  // attribute

    private org.apache.axis.types.URI digestAlgorithm;  // attribute

    public PolicyReference() {
    }

    public PolicyReference(
           final org.apache.axis.types.URI URI,
           final byte[] digest,
           final org.apache.axis.types.URI digestAlgorithm) {
           this.URI = URI;
           this.digest = digest;
           this.digestAlgorithm = digestAlgorithm;
    }


    /**
     * Gets the URI value for this PolicyReference.
     * 
     * @return URI
     */
    public org.apache.axis.types.URI getURI() {
        return this.URI;
    }


    /**
     * Sets the URI value for this PolicyReference.
     * 
     * @param URI
     */
    public void setURI(final org.apache.axis.types.URI URI) {
        this.URI = URI;
    }


    /**
     * Gets the digest value for this PolicyReference.
     * 
     * @return digest
     */
    public byte[] getDigest() {
        return this.digest;
    }


    /**
     * Sets the digest value for this PolicyReference.
     * 
     * @param digest
     */
    public void setDigest(final byte[] digest) {
        this.digest = digest;
    }


    /**
     * Gets the digestAlgorithm value for this PolicyReference.
     * 
     * @return digestAlgorithm
     */
    public org.apache.axis.types.URI getDigestAlgorithm() {
        return this.digestAlgorithm;
    }


    /**
     * Sets the digestAlgorithm value for this PolicyReference.
     * 
     * @param digestAlgorithm
     */
    public void setDigestAlgorithm(final org.apache.axis.types.URI digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(final java.lang.Object obj) {
        if (!(obj instanceof PolicyReference)) {
			return false;
		}
        final PolicyReference other = (PolicyReference) obj;
        if (obj == null) {
			return false;
		}
        if (this == obj) {
			return true;
		}
        if (this.__equalsCalc != null) {
            return (this.__equalsCalc == obj);
        }
        this.__equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            (((this.URI==null) && (other.getURI()==null)) || 
             ((this.URI!=null) &&
              this.URI.equals(other.getURI()))) &&
            (((this.digest==null) && (other.getDigest()==null)) || 
             ((this.digest!=null) &&
              java.util.Arrays.equals(this.digest, other.getDigest()))) &&
            (((this.digestAlgorithm==null) && (other.getDigestAlgorithm()==null)) || 
             ((this.digestAlgorithm!=null) &&
              this.digestAlgorithm.equals(other.getDigestAlgorithm())));
        this.__equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getURI() != null) {
            _hashCode += this.getURI().hashCode();
        }
        if (this.getDigest() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(this.getDigest());
                 i++) {
                final java.lang.Object obj = java.lang.reflect.Array.get(this.getDigest(), i);
                if ((obj != null) &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (this.getDigestAlgorithm() != null) {
            _hashCode += this.getDigestAlgorithm().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static final org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PolicyReference.class, true);

    static {
        PolicyReference.typeDesc.setXmlType(new javax.xml.namespace.QName("http://schemas.xmlsoap.org/ws/2004/09/policy", ">PolicyReference"));
        org.apache.axis.description.AttributeDesc attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("URI");
        attrField.setXmlName(new javax.xml.namespace.QName("", "URI"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        PolicyReference.typeDesc.addFieldDesc(attrField);
        attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("digest");
        attrField.setXmlName(new javax.xml.namespace.QName("", "Digest"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        PolicyReference.typeDesc.addFieldDesc(attrField);
        attrField = new org.apache.axis.description.AttributeDesc();
        attrField.setFieldName("digestAlgorithm");
        attrField.setXmlName(new javax.xml.namespace.QName("", "DigestAlgorithm"));
        attrField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "anyURI"));
        PolicyReference.typeDesc.addFieldDesc(attrField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return PolicyReference.typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, PolicyReference.typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           final java.lang.String mechType, 
           final java.lang.Class _javaType,  
           final javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, PolicyReference.typeDesc);
    }

}
