/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.xmlsoap.schemas.ws._2005._02.trust.wsdl;

public class SecurityTokenServiceProxy implements org.xmlsoap.schemas.ws._2005._02.trust.wsdl.SecurityTokenService {
  private String _endpoint = null;
  private org.xmlsoap.schemas.ws._2005._02.trust.wsdl.SecurityTokenService securityTokenService = null;
  
  public SecurityTokenServiceProxy() {
    this._initSecurityTokenServiceProxy();
  }
  
  private void _initSecurityTokenServiceProxy() {
    try {
      this.securityTokenService = (new org.xmlsoap.schemas.ws._2005._02.trust.impl.TrustServiceLocator()).getSecurityTokenService();
      if (this.securityTokenService != null) {
        if (this._endpoint != null) {
			((javax.xml.rpc.Stub)this.securityTokenService)._setProperty("javax.xml.rpc.service.endpoint.address", this._endpoint);
		} else {
			this._endpoint = (String)((javax.xml.rpc.Stub)this.securityTokenService)._getProperty("javax.xml.rpc.service.endpoint.address");
		}
      }
      
    }
    catch (final javax.xml.rpc.ServiceException serviceException) {}
  }
  
  public String getEndpoint() {
    return this._endpoint;
  }
  
  public void setEndpoint(final String endpoint) {
    this._endpoint = endpoint;
    if (this.securityTokenService != null) {
		((javax.xml.rpc.Stub)this.securityTokenService)._setProperty("javax.xml.rpc.service.endpoint.address", this._endpoint);
	}
    
  }
  
  public org.xmlsoap.schemas.ws._2005._02.trust.wsdl.SecurityTokenService getSecurityTokenService() {
    if (this.securityTokenService == null) {
		this._initSecurityTokenServiceProxy();
	}
    return this.securityTokenService;
  }
  
  public org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType requestSecurityToken(final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType request) throws java.rmi.RemoteException{
    if (this.securityTokenService == null) {
		this._initSecurityTokenServiceProxy();
	}
    return this.securityTokenService.requestSecurityToken(request);
  }
  
  public org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType[] requestSecurityToken2(final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType request) throws java.rmi.RemoteException{
    if (this.securityTokenService == null) {
		this._initSecurityTokenServiceProxy();
	}
    return this.securityTokenService.requestSecurityToken2(request);
  }
  
  
}