/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x;

import org.apache.axis.transport.http.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.management.ServiceAdmin;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.utils.ByteArray;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.w3c.dom.Element;

public class Servlet
	extends AxisServletBase
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected static Log log =
            LogFactory.getLog(Servlet.class.getName());
    
    protected static final org.eclipse.higgins.sts.utilities.LogHelper logHelper = new org.eclipse.higgins.sts.utilities.LogHelper
    	(Servlet.log);

    public static final String INIT_PROPERTY_TRANSPORT_NAME =
            "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY =
            "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST =
            "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR =
            "axis.jws.servletClassDir";
    public static final String INIT_PROPERTY_DISABLE_SERVICES_LIST =
            "axis.disableServiceList";
    public static final String INIT_PROPERTY_SERVICES_PATH =
            "axis.servicesPath";

    private String transportName = null;

    private Handler transport = null;

    private ServletSecurityProvider securityProvider = null;

    private String servicesPath = null;
    
	private final org.eclipse.higgins.sts.binding.axis1x.SecurityTokenServiceServerBinding sts = org.eclipse.higgins.sts.binding.axis1x.SecurityTokenServiceServerBinding.getInstance();

	private final org.eclipse.higgins.sts.binding.axis1x.MetadataExchangeServiceServerBinding mex = org.eclipse.higgins.sts.binding.axis1x.MetadataExchangeServiceServerBinding.getInstance();

	private final org.eclipse.higgins.sts.binding.axis1x.ProfileServiceServerBinding profile = org.eclipse.higgins.sts.binding.axis1x.ProfileServiceServerBinding.getInstance();
	
	/**
     * Cached path to JWS output directory
     */
    private String jwsClassDir = null;
    protected String getJWSClassDir() {return this.jwsClassDir;}

    /**
     * create a new servlet instance
     */
    public Servlet() {}

    /**
     * Initialization method.
     */
    public void init()
    	throws javax.servlet.ServletException
    {
        super.init();

        Servlet.log.debug("Servlet::init");
        
		  final ServletConfig servletConfig = this.getServletConfig();
        final ServletContext context = servletConfig.getServletContext();

        this.transportName = this.getOption
        	(context,
            Servlet.INIT_PROPERTY_TRANSPORT_NAME,
            HTTPTransport.DEFAULT_TRANSPORT_NAME);

        if (JavaUtils.isTrueExplicitly
        	(this.getOption
        		(context,
                Servlet.INIT_PROPERTY_USE_SECURITY,
                null)))
        {
            this.securityProvider = new ServletSecurityProvider();
        }

        this.jwsClassDir = this.getOption
        	(context,
        	Servlet.INIT_PROPERTY_JWS_CLASS_DIR,
        	null);

        this.servicesPath = this.getOption
        	(context,
        	Servlet.INIT_PROPERTY_SERVICES_PATH,
            "/services/");

        if (this.jwsClassDir != null)
        {
            if (this.getHomeDir() != null)
            {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } 
        else
        {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }

        this.initQueryStringHandlers();

        try
        {
            ServiceAdmin.setEngine
            	(this.getEngine(),
            	context.getServerInfo());
        } 
        catch (final AxisFault af)
        {
            Servlet.log.info("Exception setting AxisEngine on ServiceAdmin " + af);
        }
        
        try
        {
        	Servlet.log.trace("Servlet::init - call configure");
			
			String strConfigDir = servletConfig.getInitParameter( "org.eclipse.higgins.sts.conf");
			String strConfigFile = servletConfig.getInitParameter( "org.eclipse.higgins.sts.conf.file");
			
			// If the configuration directory and configuration file were not specified in
			// web.xml, see if they are specified as system properties.
			
			if (null == strConfigDir)
			{
				strConfigDir = System.getProperty( "org.eclipse.higgins.sts.conf");
			}
			if (null == strConfigFile)
			{
				strConfigFile = System.getProperty( "org.eclipse.higgins.sts.conf.file");
			}
			
			this.sts.setConfigurationInfo( strConfigDir, strConfigFile);
        	this.sts.configure(null, null, null);
			this.mex.setConfigurationInfo( strConfigDir, strConfigFile);
        	this.mex.configure(null, null, null);
			this.profile.setConfigurationInfo( strConfigDir, strConfigFile);
        	this.profile.configure(null, null, null);
        	Servlet.log.trace("Servlet::init - return configure");
        }
        catch (final Exception e)
        {
        	Servlet.log.trace("Servlet::init - STS.configure Exception");
        	org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
        		(Servlet.logHelper, e);
    		throw new javax.servlet.ServletException
    			(e.getLocalizedMessage());
        }
    }

    /**
     * Process GET requests. This includes handoff of pseudo-SOAP requests
     *
     * @param request request in
     * @param response request out
     * @throws ServletException
     * @throws IOException
     */
    public void doGet
    	(final HttpServletRequest request,
    	final HttpServletResponse response)
    	throws
            ServletException,
            IOException
    {
		 String	strRequestURI = request.getRequestURI();
		 int		servicesStart;
		 
		 for (servicesStart = 0; servicesStart < strRequestURI.length(); servicesStart++)
		 {
			 if (strRequestURI.startsWith( "/services/", servicesStart))
			 {
				 strRequestURI = strRequestURI.substring( servicesStart);
				 break;
			 }
		 }
		 
        Servlet.log.debug("doGet");
        
    	Servlet.log.trace("BEGIN REQUEST");
    	Servlet.log.trace(request.getMethod() + " " + request.getRequestURI());
    	Servlet.log.trace("HTTP Headers:");
    	final java.util.Enumeration enumHeaderNames = request.getHeaderNames();
    	while (enumHeaderNames.hasMoreElements())
    	{
    		final String strHeaderName = (String)enumHeaderNames.nextElement();
    		final String strHeader = (String)request.getHeader(strHeaderName);
    		Servlet.log.trace(strHeaderName + ": " + strHeader);
    	}
    	Servlet.log.trace("Parameters:");
    	final java.util.Enumeration enumParameterNames = request.getParameterNames();
    	while (enumParameterNames.hasMoreElements())
    	{
    		final String strParameterName = (String)enumParameterNames.nextElement();
    		final String strParameter = (String)request.getParameter(strParameterName);
    		Servlet.log.trace(strParameterName + ": " + strParameter);
    	}
    	Servlet.log.trace("END REQUEST");
    	
        if (strRequestURI.equals
        	("/services/DecryptToken"))
        {
        	response.setContentType("text/xml; charset=utf-8");
        	final PrintWriter out = response.getWriter();
        	String strResult = null;
        	try
        	{
        		final String strToken = request.getParameter("xmlToken");
        		strResult = this.profile.decryptToken
    				(strToken);
        		Servlet.log.trace("Response: " + strResult);
        	}
        	catch (final Exception e)
        	{
        		strResult = "Exception: " + e;
        	}
        	out.print
        		(strResult);
        	return;
        }
    	
        if (strRequestURI.equals
        	("/services/GetCard.crd"))
        {
        	response.setContentType("application/soap+xml; charset=utf-8");
        	final PrintWriter out = response.getWriter();
        	String strResult = null;
        	try
        	{
        		String strCardName = request.getParameter("CardName");
        		final String strUsername = request.getParameter("Username");
        		final String strPassword = request.getParameter("Password");
        		final String strCredential = request.getParameter("Credential");
        		final String strRequireAppliesTo = request.getParameter("RequireAppliesTo");
        		final String strToken = request.getParameter("xmlToken");
        		if (null == strCardName) {
					strCardName = strUsername + " Higgins Card";
				}
        		strResult = this.profile.getManagedCard
    				(strCardName,
    				strUsername,
    				strPassword,
    				strCredential,
    				strRequireAppliesTo,
    				strToken);
        		Servlet.log.trace("Response: " + strResult);
        	}
        	catch (final Exception e)
        	{
        		strResult = "Exception: " + e;
        	}
        	out.print
        		(strResult);
        }
        else if (strRequestURI.startsWith
        	("/services/Metadata"))
        {
        	final String strMetadata = this.mex.getMetadataString
        		(java.net.URI.create
        			(request.getRequestURI()));
        	response.setContentType("application/xml; charset=utf-8");
        	final PrintWriter out = response.getWriter();
 	        Servlet.log.trace("Response: " + strMetadata);
        	out.println
    			(strMetadata);
        }
        else
        {
        	super.doGet(request, response);
        }
    }

    /**
     * routine called whenever an axis fault is caught; where they
     * are logged and any other business. The method may modify the fault
     * in the process
     * @param fault what went wrong.
     */
    protected void processAxisFault
    	(final AxisFault fault)
    {
        final Element runtimeException = fault.lookupFaultDetail
        	(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null)
        {
            Servlet.log.info
            	(Messages.getMessage
            		("axisFault00"),
            	fault);
            //strip runtime details
            fault.removeFaultDetail
            	(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        }
        else if (Servlet.log.isDebugEnabled())
        {
            Servlet.log.debug
            	(Messages.getMessage
            		("axisFault00"),
            	fault);
        }
        if (!this.isDevelopment())
        {
            fault.removeFaultDetail
            	(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    /**
     * log any exception to our output log, at our chosen level
     * @param e what went wrong
     */
    protected void logException(final Throwable e)
    {
        Servlet.log.info
        	(Messages.getMessage
        		("exception00"),
        	e);
    }

    /**
     * print a snippet of service info.
     * @param service service
     * @param writer output channel
     * @param serviceName where to put stuff
     */
    protected void reportServiceInfo
    	(final HttpServletResponse response,
        final PrintWriter writer,
        final SOAPService service,
        final String serviceName)
    {
        response.setContentType
        	("text/html; charset=utf-8");
        writer.println
        	("<h1>"
        		+ service.getName()
        		+ "</h1>");
        writer.println
        	("<p>"
        		+ Messages.getMessage
        			("axisService00")
        		+ "</p>");
        writer.println
        	("<i>"
        		+ Messages.getMessage
        			("perhaps00")
        		+ "</i>");
    }

    /**
     * This method lists the available services; it is called when there is
     * nothing to execute on a GET
     * @param response
     * @param writer
     * @param request
     * @throws ConfigurationException
     * @throws AxisFault
     */
    protected void reportAvailableServices(final HttpServletResponse response,
                                           final PrintWriter writer,
                                           final HttpServletRequest request) throws
            ConfigurationException, AxisFault {
        final AxisEngine engine = this.getEngine();

        response.setContentType("text/html; charset=utf-8");
        writer.println("<h2>And now... Some Services</h2>");

        Iterator i;
        try {
            i = engine.getConfig().getDeployedServices();
        } catch (final ConfigurationException configException) {
            //turn any internal configuration exceptions back into axis faults
            //if that is what they are
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault) configException.getContainedException();
            } else {
                throw configException;
            }
        }
        // baseURL may change if <endpointURL> tag is used for
        // custom deployment at a different location
        final String defaultBaseURL = this.getWebappBase(request) + this.servicesPath;
        writer.println("<ul>");
        while (i.hasNext()) {
            final ServiceDesc sd = (ServiceDesc) i.next();
            final StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            final String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            final String endpointURL = sd.getEndpointURL();
            final String baseURL = (endpointURL == null) ? defaultBaseURL :
                             endpointURL;
            sb.append(baseURL);
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            writer.println(sb.toString());
            final ArrayList operations = sd.getOperations();
            if (!operations.isEmpty()) {
                writer.println("<ul>");
                for (final Iterator it = operations.iterator(); it.hasNext(); ) {
                    final OperationDesc desc = (OperationDesc) it.next();
                    writer.println("<li>" + desc.getName());
                }
                writer.println("</ul>");
            }
        }
        writer.println("</ul>");
    }

    /**
     * generate the error response to indicate that there is apparently no endpoint there
     * @param request the request that didnt have an edpoint
     * @param response response we are generating
     * @param writer open writer for the request
     */
    protected void reportCantGetAxisService(final HttpServletRequest request,
                                            final HttpServletResponse response,
                                            final PrintWriter writer) {
        // no such service....
        response.setStatus(HttpURLConnection.HTTP_NOT_FOUND);
        response.setContentType("text/html; charset=utf-8");
        writer.println("<h2>" +
                       Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" +
                       Messages.getMessage("noService06") +
                       "</p>");
    }

    /**
     * probe for a JWS page and report 'no service' if one is not found there
     * @param request the request that didnt have an edpoint
     * @param response response we are generating
     * @param writer open writer for the request
     */
    protected void reportCantGetJWSService(final HttpServletRequest request,
                                           final HttpServletResponse response,
                                           final PrintWriter writer) {
        // first look to see if there is a service
        // requestPath is a work around to support serving .jws web services
        // from services URL - see AXIS-843 for more information
        final String requestPath = request.getServletPath() + ((request.getPathInfo() != null) ?
                request.getPathInfo() : "");
        final String realpath = this.getServletConfig().getServletContext()
                          .getRealPath(requestPath);
        Servlet.log.debug("JWS real path: " + realpath);
        final boolean foundJWSFile = (new File(realpath).exists()) &&
                               (realpath.endsWith(Constants.
                                                  JWS_DEFAULT_FILE_EXTENSION));
        response.setContentType("text/html; charset=utf-8");
        if (foundJWSFile) {
            response.setStatus(HttpURLConnection.HTTP_OK);
            writer.println(Messages.getMessage("foundJWS00") + "<p>");
            final String url = request.getRequestURI();
            final String urltext = Messages.getMessage("foundJWS01");
            writer.println("<a href='" + url + "?wsdl'>" + urltext + "</a>");
        } else {
            response.setStatus(HttpURLConnection.HTTP_NOT_FOUND);
            writer.println(Messages.getMessage("noService06"));
        }
    }


    /**
     * Process a POST to the servlet by handing it off to the Axis Engine.
     * Here is where SOAP messages are received
     * @param req posted request
     * @param res respose
     * @throws ServletException trouble
     * @throws IOException different trouble
     */
    public void doPost(final HttpServletRequest req, final HttpServletResponse res) throws
            ServletException, IOException
    {
		 String	strRequestURI = req.getRequestURI();
		 int		servicesStart;
		 
		 for (servicesStart = 0; servicesStart < strRequestURI.length(); servicesStart++)
		 {
			 if (strRequestURI.startsWith( "/services/", servicesStart))
			 {
				 strRequestURI = strRequestURI.substring( servicesStart);
				 break;
			 }
		 }
		 
        Servlet.log.debug("doPost");
    	
        /* Get request message
         */
    	Servlet.log.trace("BEGIN REQUEST");
    	Servlet.log.trace(req.getMethod() + " " + req.getRequestURI());
    	final java.util.Enumeration enumHeaderNames = req.getHeaderNames();
    	while (enumHeaderNames.hasMoreElements())
    	{
    		final String strHeaderName = (String)enumHeaderNames.nextElement();
    		final String strHeader = (String)req.getHeader(strHeaderName);
    		Servlet.log.trace(strHeaderName + ": " + strHeader);
    	}
    	Servlet.log.trace("END REQUEST");
    	
        if (strRequestURI.equals
        	("/services/DecryptToken"))
        {
        	res.setContentType("text/xml; charset=utf-8");
        	final PrintWriter out = res.getWriter();
        	String strResult = null;
        	try
        	{
        		final String strToken = req.getParameter("xmlToken");
        		strResult = this.profile.decryptToken
    				(strToken);
        		Servlet.log.trace("Response: " + strResult);
        	}
        	catch (final Exception e)
        	{
        		strResult = "Exception: " + e;
        	}
        	out.print
        		(strResult);
        	return;
        }

        if (strRequestURI.equals
        	("/services/GetCard.crd"))
        {
        	res.setContentType("application/soap+xml; charset=utf-8");
        	final PrintWriter out = res.getWriter();
        	String strResult = null;
        	try
        	{
        		String strCardName = req.getParameter("CardName");
        		final String strUsername = req.getParameter("Username");
        		final String strPassword = req.getParameter("Password");
        		final String strRequireAppliesTo = req.getParameter("RequireAppliesTo");
        		final String strToken = req.getParameter("xmlToken");
        		final String strCredential = req.getParameter("Credential");
        		if (null == strCardName) {
					strCardName = strUsername + " Higgins Card";
				}
        		strResult = this.profile.getManagedCard
    				(strCardName,
    				strUsername,
    				strPassword,
    				strCredential,
    				strRequireAppliesTo,
    				strToken);
        		Servlet.log.trace("Response: " + strResult);
        	}
        	catch (final Exception e)
        	{
        		strResult = "Exception: " + e;
        	}
        	out.print
        		(strResult);
        	return;
        }
        final org.apache.axis.Message requestMsg =
            new org.apache.axis.Message(req.getInputStream(),
                        false,
                        req.getHeader(HTTPConstants.HEADER_CONTENT_TYPE),
                        req.getHeader(HTTPConstants.HEADER_CONTENT_LOCATION));

        /****** Mask password out of trace ******/
        // Servlet.log.debug("Request Message:" + requestMsg.getSOAPPartAsString());

        try {
        	if (Servlet.logHelper.getLog().isTraceEnabled()) {
        		String tmpStr = requestMsg.getSOAPPartAsString();
        		String tmpStrLc = tmpStr.toLowerCase();
        		if (tmpStrLc.indexOf("password") == -1 ) {
        			Servlet.log.trace("Request: " + tmpStr);                	
        		} else {
        			// This request contains the string "password", so Mask out password
        			org.w3c.dom.Element domEnvelope2 = null;
        			domEnvelope2 = org.eclipse.higgins.sts.utilities.XMLHelper.toDOM(tmpStr);
        			org.eclipse.higgins.sts.utilities.XMLHelper.maskPasswordForChildren(domEnvelope2);
        			Servlet.log.trace("Request: " + org.eclipse.higgins.sts.utilities.XMLHelper.toString(domEnvelope2));
        		}
        	}
        } catch (Exception e) {
        	org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
        	(Servlet.logHelper, e);
        }
        /***************************************/          String soapAction = null;
        MessageContext msgContext = null;

        org.apache.axis.Message responseMsg = null;
        String contentType = null;

        try {
            final AxisEngine engine = this.getEngine();

            if (engine == null) {
                // !!! should return a SOAP fault...
                final ServletException se =
                        new ServletException(Messages.getMessage("noEngine00"));
                Servlet.log.debug("No Engine!", se);
                throw se;
            }

            res.setBufferSize(1024 * 8); // provide performance boost.

            /** get message context w/ various properties set
             */
            msgContext = this.createMessageContext(engine, req, res);
            msgContext.setProperty("HTTP_REQUEST_URI", req.getRequestURI());

            // ? OK to move this to 'getMessageContext',
            // ? where it would also be picked up for 'doGet()' ?
            if (this.securityProvider != null)
            {
                Servlet.log.debug("securityProvider:" + this.securityProvider);
                msgContext.setProperty
                	(MessageContext.SECURITY_PROVIDER,
                    this.securityProvider);
            }

            // Transfer HTTP headers to MIME headers for request message.
            final MimeHeaders requestMimeHeaders = requestMsg.getMimeHeaders();
            for (final Enumeration e = req.getHeaderNames(); e.hasMoreElements(); )
            {
                final String headerName = (String) e.nextElement();
                for (final Enumeration f = req.getHeaders(headerName); f.hasMoreElements(); )
                {
                    final String headerValue = (String) f.nextElement();
                    requestMimeHeaders.addHeader(headerName, headerValue);
                }
            }
            msgContext.setRequestMessage(requestMsg);
            final String url = req.getRequestURL().toString();
            msgContext.setProperty
            	(MessageContext.TRANS_URL,
            	url);
            String requestEncoding;
            try
            {
                requestEncoding = (String) requestMsg.getProperty
                	(SOAPMessage.CHARACTER_SET_ENCODING);
                if (requestEncoding != null)
                {
                    msgContext.setProperty
                    	(SOAPMessage.CHARACTER_SET_ENCODING,
                        requestEncoding);
                }
            } 
            catch (final SOAPException e1)
            {
            }

            try
            {
                soapAction = this.getSoapAction(req);
                if (soapAction != null)
                {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }

                msgContext.setSession(new AxisHttpSession(req));

                Servlet.log.debug("Invoking Axis Engine.");

                engine.invoke(msgContext);
                
                Servlet.log.debug("Return from Axis Engine.");

                responseMsg = msgContext.getResponseMessage();

                // We used to throw exceptions on null response messages.
                // They are actually OK in certain situations (asynchronous
                // services), so fall through here and return an ACCEPTED
                // status code below.  Might want to install a configurable
                // error check for this later.
            }
            catch (final AxisFault fault)
            {
            	Servlet.log.trace("Caught AxisFault");
            	ExceptionHelper.Log(Servlet.logHelper, fault);
                //log and sanitize
                this.processAxisFault(fault);
                this.configureResponseFromAxisFault(res, fault);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null)
                {
                    responseMsg = new org.apache.axis.Message(fault);
                    ((org.apache.axis.SOAPPart) responseMsg.getSOAPPart()).
                            getMessage().setMessageContext(msgContext);
                }
            } catch (final Exception e)
            {
            	ExceptionHelper.Log(Servlet.logHelper, e);
                //other exceptions are internal trouble
                responseMsg = msgContext.getResponseMessage();
                res.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
                ((org.apache.axis.SOAPPart) responseMsg.getSOAPPart()).
                        getMessage().setMessageContext(msgContext);
            } 
            catch (final Throwable t)
            {
            	ExceptionHelper.Log(Servlet.logHelper, t);
                this.logException(t);
                //other exceptions are internal trouble
                responseMsg = msgContext.getResponseMessage();
                res.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                responseMsg = new org.apache.axis.Message(new AxisFault(t.toString(),t));
                ((org.apache.axis.SOAPPart) responseMsg.getSOAPPart()).
                        getMessage().setMessageContext(msgContext);
            }
        } 
        catch (final AxisFault fault)
        {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(res, fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new org.apache.axis.Message(fault);
                ((org.apache.axis.SOAPPart) responseMsg.getSOAPPart()).
                        getMessage().setMessageContext(msgContext);
            }
        }

        /* Send response back along the wire...  */
        /***********************************/
        if (responseMsg != null)
        {
            final MimeHeaders responseMimeHeaders = responseMsg.getMimeHeaders();
            for (final Iterator i = responseMimeHeaders.getAllHeaders(); i.hasNext(); )
            {
                final MimeHeader responseMimeHeader = (MimeHeader) i.next();
                res.addHeader(responseMimeHeader.getName(),
                              responseMimeHeader.getValue());
            }
            // synchronize the character encoding of request and response
            final String responseEncoding = (String) msgContext.getProperty
            	(SOAPMessage.CHARACTER_SET_ENCODING);
            if (responseEncoding != null)
            {
                try
                {
                    responseMsg.setProperty
                    	(SOAPMessage.CHARACTER_SET_ENCODING,
                        responseEncoding);
                } 
                catch (final SOAPException e)
                {
                }
            }
            contentType = responseMsg.getContentType
            	(msgContext.getSOAPConstants());
            this.sendResponse
            	(contentType,
            	res,
            	responseMsg);
        }
        else
        {

            res.setStatus(202);
        }
    }

    /**
     * Configure the servlet response status code and maybe other headers
     * from the fault info.
     * @param response response to configure
     * @param fault what went wrong
     */
    private void configureResponseFromAxisFault
    	(final HttpServletResponse response,
        final AxisFault fault)
    {
        final int status = this.getHttpServletResponseStatus(fault);
        if (status == HttpServletResponse.SC_UNAUTHORIZED)
        {
            response.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        response.setStatus(status);
    }

    /**
     * turn any Exception into an AxisFault, log it, set the response
     * status code according to what the specifications say and
     * return a response message for posting. This will be the response
     * message passed in if non-null; one generated from the fault otherwise.
     *
     * @param exception what went wrong
     * @param responseMsg what response we have (if any)
     * @return a response message to send to the user
     */
    private org.apache.axis.Message convertExceptionToAxisFault
    	(final Exception exception,
        org.apache.axis.Message responseMsg)
    {
        this.logException(exception);
        if (responseMsg == null)
        {
            final AxisFault fault = AxisFault.makeFault(exception);
            this.processAxisFault(fault);
            responseMsg = new org.apache.axis.Message(fault);
        }
        return responseMsg;
    }

    /**
     * Extract information from AxisFault and map it to a HTTP Status code.
     *
     * @param af Axis Fault
     * @return HTTP Status code.
     */
    protected int getHttpServletResponseStatus
    	(final AxisFault af)
    {
        return af.getFaultCode().getLocalPart().startsWith
        	("Server.Unauth")
                ? HttpServletResponse.SC_UNAUTHORIZED
                : HttpServletResponse.SC_INTERNAL_SERVER_ERROR;
    }

    /**
     * write a message to the response, set appropriate headers for content
     * type..etc.
     * @param res   response
     * @param responseMsg message to write
     * @throws AxisFault
     * @throws IOException if the response stream can not be written to
     */
    private void sendResponse
    	(final String contentType,
        final HttpServletResponse res,
        final org.apache.axis.Message responseMsg)
    	throws 
    		AxisFault,
            IOException
    {
    	if (responseMsg == null)
    	{
            res.setStatus(HttpServletResponse.SC_NO_CONTENT);
            Servlet.log.debug("NO AXIS MESSAGE TO RETURN!");
        } 
    	else
    	{
        	try
        	{	
        		Servlet.log.debug("Setting WRITE_XML_DECLARATION to false");
        		responseMsg.setProperty
	    			(javax.xml.soap.SOAPMessage.WRITE_XML_DECLARATION,
	    			"false");
        	}
        	catch (final Exception e)
        	{
        		this.logException(e);
        	}
            Servlet.log.debug("Returned Content-Type: " + contentType);
            Servlet.log.debug("Returned Content-Length: " + responseMsg.getContentLength());
            try
            {
                res.setContentType(contentType);
                final String strResponse = responseMsg.getSOAPPartAsString();
                Servlet.log.trace("Response: " + strResponse);
                final java.io.OutputStream outputStream = res.getOutputStream();
                final MessageContext messageContext = responseMsg.getMessageContext();
                final String strCharEncoding = XMLUtils.getEncoding
	        		(responseMsg,
	        		messageContext);
                final org.apache.axis.SOAPPart responseSOAPPart = (org.apache.axis.SOAPPart)responseMsg.getSOAPPart();
                final int nCurrentForm = responseSOAPPart.getCurrentForm();
                final Object objectCurrentMessage = responseSOAPPart.getCurrentMessage();
                if (org.apache.axis.SOAPPart.FORM_BYTES == nCurrentForm)
                {
                	outputStream.write((byte[])objectCurrentMessage);
                }
                else if (org.apache.axis.SOAPPart.FORM_OPTIMIZED == nCurrentForm)
                {
                	((ByteArray)objectCurrentMessage).writeTo(outputStream);
                }
                else
                {
                    Writer writer = new OutputStreamWriter
                    	(outputStream,
                    	strCharEncoding);
                    writer = new BufferedWriter
                    	(new PrintWriter
                    		(writer));
                    boolean inclXmlDecl = false;
                    final String xmlDecl = (String)responseMsg.getProperty
                    	(SOAPMessage.WRITE_XML_DECLARATION);
                    inclXmlDecl = ((xmlDecl != null) && xmlDecl.equals("true"));
                    if (org.apache.axis.SOAPPart.FORM_FAULT == nCurrentForm)
                    {
                    	final AxisFault env = (AxisFault)objectCurrentMessage;
                        try
                        {
                        	final SerializationContext serContext = new SerializationContext
                        		(writer,
                        		messageContext); 
                            serContext.setSendDecl(inclXmlDecl);
                            serContext.setEncoding(strCharEncoding);
                            env.output(serContext);
                        }
                        catch (final Exception e)
                        {
                            Servlet.log.error(Messages.getMessage("exception00"), e);
                            throw env;
                        }
                    }
                    else if (org.apache.axis.SOAPPart.FORM_SOAPENVELOPE == nCurrentForm)
                    {
                    	final SOAPEnvelope env = (SOAPEnvelope)objectCurrentMessage;
                        try
                        {
                        	final SerializationContext serContext = new SerializationContext
                        		(writer,
                        		messageContext); 
                            serContext.setSendDecl(inclXmlDecl);
                            serContext.setEncoding(strCharEncoding);
                            env.output(serContext);
                        }
                        catch (final Exception e)
                        {
                            throw AxisFault.makeFault(e);
                        }
                    }
                    else
                    {
                     	final String xml = responseSOAPPart.getAsString();
                        if (inclXmlDecl)
                        {
                            if (!xml.startsWith("<?xml"))
                            {
                                writer.write("<?xml version=\"1.0\" encoding=\"");
                                writer.write(strCharEncoding);
                                writer.write("\"?>\n");
                            }
                        }
                        writer.write(xml);
                    }
                    writer.flush();
                }    
            } 
            catch (final SOAPException e)
            {
                this.logException(e);
            }
        }
        if (!res.isCommitted())
        {
            res.flushBuffer(); // Force it right now.
        }
    }

    /**
     * Place the Request message in the MessagContext object - notice
     * that we just leave it as a 'ServletRequest' object and let the
     * Message processing routine convert it - we don't do it since we
     * don't know how it's going to be used - perhaps it might not
     * even need to be parsed.
     * @return a message context
     */
    private MessageContext createMessageContext
    	(final AxisEngine engine,
        final HttpServletRequest req,
        final HttpServletResponse res)
    {
        final MessageContext msgContext = new MessageContext
        	(engine);
        final String requestPath = Servlet.getRequestPath
        	(req);
        Servlet.log.debug
        	("MessageContext:"
        		+ msgContext);
        Servlet.log.debug
        	("HEADER_CONTENT_TYPE:"
        		+ req.getHeader
        			(HTTPConstants.HEADER_CONTENT_TYPE));
        Servlet.log.debug
        	("HEADER_CONTENT_LOCATION:"
        		+ req.getHeader
        			(HTTPConstants.HEADER_CONTENT_LOCATION));
        Servlet.log.debug
        	("Constants.MC_HOME_DIR:"
        		+ String.valueOf
        			(this.getHomeDir()));
        Servlet.log.debug
        	("Constants.MC_RELATIVE_PATH:"
        		+ requestPath);
        Servlet.log.debug
        	("HTTPConstants.MC_HTTP_SERVLETLOCATION:"
        		+ String.valueOf(this.getWebInfPath()));
        Servlet.log.debug
        	("HTTPConstants.MC_HTTP_SERVLETPATHINFO:"
        		+ req.getPathInfo());
        Servlet.log.debug
        	("HTTPConstants.HEADER_AUTHORIZATION:"
        		+ req.getHeader
        			(HTTPConstants.HEADER_AUTHORIZATION));
        Servlet.log.debug
        	("Constants.MC_REMOTE_ADDR:"
        		+ req.getRemoteAddr());
        Servlet.log.debug
        	("configPath:"
        		+ String.valueOf
        			(this.getWebInfPath()));

        msgContext.setTransportName
        	(this.transportName);
        msgContext.setProperty
        	(Constants.MC_JWS_CLASSDIR,
        	this.jwsClassDir);
        msgContext.setProperty
        	(Constants.MC_HOME_DIR,
        	this.getHomeDir());
        msgContext.setProperty
        	(Constants.MC_RELATIVE_PATH,
        	requestPath);
        msgContext.setProperty
        	(HTTPConstants.MC_HTTP_SERVLET,
        	this);
        msgContext.setProperty
        	(HTTPConstants.MC_HTTP_SERVLETREQUEST,
        	req);
        msgContext.setProperty
        	(HTTPConstants.MC_HTTP_SERVLETRESPONSE,
        	res);
        msgContext.setProperty
        	(HTTPConstants.MC_HTTP_SERVLETLOCATION,
            this.getWebInfPath());
        msgContext.setProperty
        	(HTTPConstants.MC_HTTP_SERVLETPATHINFO,
            req.getPathInfo());
        msgContext.setProperty
        	(HTTPConstants.HEADER_AUTHORIZATION,
            req.getHeader
            	(HTTPConstants.HEADER_AUTHORIZATION));
        msgContext.setProperty
        	(Constants.MC_REMOTE_ADDR,
        	req.getRemoteAddr());
        final ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty
        	(Constants.MC_SERVLET_ENDPOINT_CONTEXT,
        	sec);
        final String realpath = this.getServletConfig().getServletContext().getRealPath
        	(requestPath);

        if (realpath != null)
        {
            msgContext.setProperty
            	(Constants.MC_REALPATH,
            	realpath);
        }

        msgContext.setProperty
        	(Constants.MC_CONFIGPATH,
        	this.getWebInfPath());
        return msgContext;
    }

    /**
     * Extract the SOAPAction header.
     * if SOAPAction is null then we'll we be forced to scan the body for it.
     * if SOAPAction is "" then use the URL
     * @param req incoming request
     * @return the action
     * @throws AxisFault
     */
    private String getSoapAction
    	(final HttpServletRequest req)
    	throws AxisFault
    {
        String soapAction = req.getHeader
        	(HTTPConstants.HEADER_SOAP_ACTION);
        if (soapAction == null)
        {
            final String contentType = req.getHeader
            	(HTTPConstants.HEADER_CONTENT_TYPE);
            if (contentType != null)
            {
                final int index = contentType.indexOf
                	("action");
                if (index != -1)
                {
                    soapAction = contentType.substring
                    	(index + 7);
                }
            }
        }
        Servlet.log.debug("HEADER_SOAP_ACTION:" + soapAction);
        if (soapAction == null)
        {
        	soapAction = "";
        }
        Servlet.log.debug("HEADER_SOAP_ACTION:" + soapAction);
        // the SOAP 1.1 spec & WS-I 1.0 says:
        // soapaction    = "SOAPAction" ":" [ <"> URI-reference <"> ]
        // some implementations leave off the quotes
        // we strip them if they are present
        if (soapAction.startsWith("\"")
        	&& soapAction.endsWith("\"")
            && (soapAction.length() >= 2))
        {
            final int end = soapAction.length() - 1;
            soapAction = soapAction.substring(1, end);
        }
        if (soapAction.length() == 0)
        {
            soapAction = req.getContextPath(); // Is this right?
        }
        return soapAction;
    }

    /**
     * Provided to allow overload of default JWSClassDir
     * by derived class.
     * @return directory for JWS files
     */
    protected String getDefaultJWSClassDir()
    {
        return (this.getWebInfPath() == null)
        	? null // ??? what is a good FINAL default for WebLogic?
            : this.getWebInfPath()
            	+ File.separator
            	+ "jwsClasses";
    }

    /**
     * Initialize a Handler for the transport defined in the Axis server config.
     * This includes optionally filling in query string handlers.
     */
    public void initQueryStringHandlers()
    {
        try
        {
            this.transport = this.getEngine().getTransport
            	(this.transportName);
            if (this.transport == null)
            {
                this.transport = new SimpleTargetedChain();
                this.transport.setOption
                	("qs.list",
                    "org.apache.axis.transport.http.QSListHandler");
                this.transport.setOption
                	("qs.method",
                    "org.apache.axis.transport.http.QSMethodHandler");
                this.transport.setOption
                	("qs.wsdl",
                    "org.apache.axis.transport.http.QSWSDLHandler");
            }
            else
            {
                boolean defaultQueryStrings = true;
                final String useDefaults = (String)this.transport.getOption
                	("useDefaultQueryStrings");

                if ((useDefaults != null) &&
                    useDefaults.toLowerCase().equals
                    	("false"))
                {
                    defaultQueryStrings = false;
                }
                if (defaultQueryStrings == true)
                {
                    this.transport.setOption
                    	("qs.list",
                        "org.apache.axis.transport.http.QSListHandler");
                    this.transport.setOption
                    	("qs.method",
                        "org.apache.axis.transport.http.QSMethodHandler");
                    this.transport.setOption
                    	("qs.wsdl",
                        "org.apache.axis.transport.http.QSWSDLHandler");
                }
            }
        }
        catch (final AxisFault e)
        {
            this.transport = new SimpleTargetedChain();
            this.transport.setOption
            	("qs.list",
                "org.apache.axis.transport.http.QSListHandler");
            this.transport.setOption
            	("qs.method",
                "org.apache.axis.transport.http.QSMethodHandler");
            this.transport.setOption
            	("qs.wsdl",
                "org.apache.axis.transport.http.QSWSDLHandler");
        }
    }

    /**
     * getRequestPath a returns request path for web service padded with
     * request.getPathInfo for web services served from /services directory.
     * This is a required to support serving .jws web services from /services
     * URL. See AXIS-843 for more information.
     *
     * @param request HttpServletRequest
     * @return String
     */
    private static String getRequestPath
    	(final HttpServletRequest request)
    {
        return request.getServletPath()
        	+ ((request.getPathInfo() != null)
        		? request.getPathInfo()
        		: "");
    }
}