/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x;

import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Binds the Axis 1.x framework generated skeleton code to the Higgins STS implementation.
 * Class was originally auto-generated from WSDL by the Apache Axis 1.3 Oct 05, 2005 (05:23:37 EDT) WSDL2Java emitter.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when SecurityTokenServiceServerBinding instances are instantiated (singleton? instance per request? other?)
abstract public class ServerServiceBinding implements org.eclipse.higgins.configuration.api.IConfigurableComponent
{
	static protected final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
	
	static private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ServerServiceBinding.class.getName());
	
	static private final org.eclipse.higgins.sts.utilities.Configuration configurationHandler = new org.eclipse.higgins.sts.utilities.Configuration();

	static private java.util.Map mapGlobalSettings = null;
	
	private java.util.Map mapComponentSettings = null;
	
	private String strConfigurationDir = null;
	private String strConfigurationFile = null;
	
	abstract protected String getServiceName();
	
	public void setConfigurationInfo(
		String	strConfigDir,
		String	strConfigFile)
	{
		strConfigurationDir = strConfigDir;
		strConfigurationFile = strConfigFile;
	}
	
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getService() throws Exception
	{
		java.util.Map mapGlobalSettings = this.getGlobalSettings();
		String strServiceName = this.getServiceName();
		Object objectService = mapGlobalSettings.get(strServiceName);
		log.trace("Service: " + strServiceName + " From: " + objectService.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
		log.trace("IConfigurableComponent From: " + org.eclipse.higgins.configuration.api.IConfigurableComponent.class.getProtectionDomain().getCodeSource().getLocation().getFile());
		
		return (org.eclipse.higgins.configuration.api.IConfigurableComponent)(mapGlobalSettings.get(this.getServiceName()));
	}
	
	public java.util.Map getServiceSettings() throws Exception
	{
		if (null == mapComponentSettings)
			mapComponentSettings = (java.util.Map)this.getGlobalSettings().get("ComponentSettings");
		return (java.util.Map)mapComponentSettings.get(this.getServiceName());
	}

	static protected boolean bInitialized = false;

	public synchronized java.util.Map getGlobalSettings() throws Exception
	{
    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
		return ServerServiceBinding.mapGlobalSettings;
	}
	
	/**
	 * Constructor that initializes the class
	 */
	public ServerServiceBinding()
	{
		ServerServiceBinding.log.trace("ServerServiceBinding::ServerServiceBinding");
	}
		
	public synchronized void configure
		(final java.util.Map mapConfigureGlobalSettings,
		final String strConfigureComponentName,
		final java.util.Map mapConfigureComponentSettings)
		throws Exception
	{
		ServerServiceBinding.log.trace("ServerServiceBinding::configure");

		configurationHandler.setConfigurationBase(strConfigurationDir);
    	if (null != strConfigurationFile)
    		configurationHandler.setFileName(strConfigurationFile);
		ServerServiceBinding.bInitialized = configurationHandler.configure(null);
		if (!ServerServiceBinding.bInitialized)
		{
			ServerServiceBinding.log.error
				("Not Initialized!");
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Not Initialized!");
			throw BindingHelper.FaultToAxisFault
				(fault);
		}
		ServerServiceBinding.mapGlobalSettings = configurationHandler.getSettings();

		ServerServiceBinding.log.trace("ServerServiceBinding::configure DONE");
	}
	
	public void ConfigureOrThrowException() throws java.rmi.RemoteException
	{
       	if (!ServerServiceBinding.bInitialized)
       	{
       		try
       		{
       			this.configure(null, null, null);
       		}
        	catch (final Exception e)
        	{
    			final Fault fault = new Fault
    				(ServerServiceBinding.constants.getWSTrustNamespace(),
    				"wst",
    				ServerServiceBinding.constants.getRequestFailedFaultCode(),
    				"The specified request failed",
    				e.getLocalizedMessage());	
    			throw BindingHelper.FaultToAxisFault
    				(fault);
        	}
    	}

	}
 }