/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x;

import org.eclipse.higgins.sts.api.IProfile;

/**
 * Binds the Axis 1.x framework generated skeleton code to the Higgins STS implementation.
 * Class was originally auto-generated from WSDL by the Apache Axis 1.3 Oct 05, 2005 (05:23:37 EDT) WSDL2Java emitter.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when SecurityTokenServiceServerBinding instances are instantiated (singleton? instance per request? other?)
public class ProfileServiceServerBinding extends ServerServiceBinding
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ProfileServiceServerBinding.class.getName());
	
	static private ProfileServiceServerBinding theInstance = null;
	
	public String getServiceName()
	{
		return "ProfileService";
	}
	
	org.eclipse.higgins.sts.api.IProfileService profileService = null;

	public static synchronized ProfileServiceServerBinding getInstance()
	{
		if (null == ProfileServiceServerBinding.theInstance)
		{
			ProfileServiceServerBinding.theInstance = new ProfileServiceServerBinding();
		}
		return ProfileServiceServerBinding.theInstance;
	}
	
	/**
	 * Constructor that initializes the class
	 */
	private ProfileServiceServerBinding()
	{
		this.log.trace("ProfileServiceServerBinding::ProfileServiceServerBinding");
	}
		
	public synchronized void configure
		(final java.util.Map mapConfigureGlobalSettings,
		final String strConfigureComponentName,
		final java.util.Map mapConfigureComponentSettings)
		throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::configure");
		
		super.configure
			(mapConfigureGlobalSettings,
			strConfigureComponentName,
			mapConfigureComponentSettings);
		
		this.profileService = (org.eclipse.higgins.sts.api.IProfileService)this.getService();
		
		this.log.trace("ProfileServiceServerBinding::configure DONE");
	}

	public String getManagedCard
		(final String strCardName,
		final String strUsername,
		final String strPassword,
		final String strCredentialType,
		final String strRequireAppliesTo,
		final String strToken)
		throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::getManagedCard");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.getManagedCard
    		(ServerServiceBinding.constants,
    		strCardName,
    		strUsername,
    		strPassword,
    		strCredentialType,
    		strRequireAppliesTo,
    		strToken);
	}
	
	public String createProfile
		(final String strUserIdentifier,
		final String strUserPassword)
		throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::createProfile");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.createProfile
    		(ServerServiceBinding.constants,
    	    strUserIdentifier,
    		strUserPassword);
	}

	
	public String getProfile
		(final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile) throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::getProfile");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.getProfile
    		(ServerServiceBinding.constants,
    	    strUserIdentifier,
    		strUserPassword,
    		profile);
	}

	public String deleteProfile
		(final String strUserIdentifier,
		final String strUserPassword) throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::deleteProfile");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.deleteProfile
    		(ServerServiceBinding.constants,
    	    strUserIdentifier,
    		strUserPassword);
	}
	
	public String modifyProfileSetCardKeyHash
		(final String strUserIdentifier,
		final String strUserPassword,
		final String strPPID,
		final String strModulus,
		final String strExponent)
		throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::modifyProfileSetCardKeyHash");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.modifyProfileSetCardKeyHash
    		(ServerServiceBinding.constants,
    	    strUserIdentifier,
    		strUserPassword,
    		strPPID,
    		strModulus,
    		strExponent);
	}
	
	public String modifyProfile
		(final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile) // (mobile in inetOrgPerson)
	 	throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::modifyProfile");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.modifyProfile
    		(ServerServiceBinding.constants,
    	    strUserIdentifier,
    		strUserPassword,
    		profile);
	}

	public String decryptToken(String strToken) throws Exception
	{
		this.log.trace("ProfileServiceServerBinding::decryptToken");

    	if (!ServerServiceBinding.bInitialized)
    	{
    		this.configure(null, null, null);
    	}
    	
    	return this.profileService.decryptToken
    		(ServerServiceBinding.constants,
    		strToken);
    }
}