/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.binding.axis1x.service;

import org.eclipse.higgins.sts.api.IProfile;

/**
 * @author mikemci
 *
 */
public class ProfileBindingImpl 
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(ProfileBindingImpl.class.getName());

	/**
	 * Class that implements the SecurityTokenService
	 */
	private static final org.eclipse.higgins.sts.binding.axis1x.ProfileServiceServerBinding ProfileService
		= org.eclipse.higgins.sts.binding.axis1x.ProfileServiceServerBinding.getInstance();

	public String createProfile
		(final String strUserIdentifier,
		final String strUserPassword)
		throws Exception
	{
		String strResult = null;
		try
		{
			strResult = ProfileBindingImpl.ProfileService.createProfile
				(strUserIdentifier,
				strUserPassword);
		}
		catch (final Exception e)
		{
			this.log.error("createProfile: " + e.getLocalizedMessage());
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(this.log, e);
			throw e;
		}
		return strResult;

	}
	
	public String modifyProfile
		(final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile) // (mobile in inetOrgPerson)
		throws Exception
	{
		String strResult = null;
		try
		{
			strResult = ProfileBindingImpl.ProfileService.modifyProfile
				(strUserIdentifier,
				strUserPassword,
				profile);
		}
		catch (final Exception e)
		{
			this.log.error("modifyProfile: " + e.getLocalizedMessage());
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(this.log, e);
			throw e;
		}
		return strResult;
	}
	
	public String deleteProfile
		(final String strUserIdentifier,
		final String strUserPassword)
		throws Exception
	{
		String strResult = null;
		try
		{
			strResult = ProfileBindingImpl.ProfileService.deleteProfile
				(strUserIdentifier,
				strUserPassword);	
		}
		catch (final Exception e)
		{
			this.log.error("modifyProfile: " + e.getLocalizedMessage());
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(this.log, e);
			throw e;
		}
		return strResult;
	}
	
	public String getProfile
		(final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile) // (mobile in inetOrgPerson)
		throws Exception
	{
		String strResult = null;
		try
		{
			strResult = ProfileBindingImpl.ProfileService.getProfile
				(strUserIdentifier,
				strUserPassword,
				profile);
		}
		catch (final Exception e)
		{
			this.log.error("modifyProfile: " + e.getLocalizedMessage());
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(this.log, e);
			throw e;
		}
		return strResult;
	}
}