/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Binds the Axis 1.x framework generated skeleton code to the Higgins STS implementation.
 * Class was originally auto-generated from WSDL by the Apache Axis 1.3 Oct 05, 2005 (05:23:37 EDT) WSDL2Java emitter.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when SecurityTokenServiceServerBinding instances are instantiated (singleton? instance per request? other?)
public class MetadataExchangeServiceServerBinding
	extends ServerServiceBinding
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(MetadataExchangeServiceServerBinding.class.getName());

	static private MetadataExchangeServiceServerBinding theInstance = null;

	public String getServiceName()
	{
		return "MetadataExchangeService";
	}
	
	public static synchronized MetadataExchangeServiceServerBinding getInstance()
	{
		if (null == MetadataExchangeServiceServerBinding.theInstance)
		{
			MetadataExchangeServiceServerBinding.theInstance = new MetadataExchangeServiceServerBinding();
		}
		return MetadataExchangeServiceServerBinding.theInstance;
	}
	
	/**
	 * Constructor that initializes the class
	 */
	private MetadataExchangeServiceServerBinding()
	{
		this.log.trace("MetadataExchangeServiceServerBinding::MetadataExchangeServiceServerBinding");
	}
		
	public synchronized void configure
		(final java.util.Map mapConfigureGlobalSettings,
		final String strConfigureComponentName,
		final java.util.Map mapConfigureComponentSettings,
		ISettingDescriptor componentDescriptor,
		ISettingDescriptor globalDescriptor)
		throws Exception
	{
		this.log.trace("MetadataExchangeServiceServerBinding::configure");
		
		super.configure
			(mapConfigureGlobalSettings,
			strConfigureComponentName,
			mapConfigureComponentSettings, null, null);
		
		this.log.trace("MetadataExchangeServiceServerBinding::configure DONE");
	}
    
    public org.xmlsoap.schemas.ws._2004._09.mex.Metadata getMetadata()
		throws java.rmi.RemoteException
	{
    	this.log.trace("MetadataExchangeServiceServerBinding::getMetadata()");
    	
    	ConfigureOrThrowException();
		
    	final org.apache.axis.MessageContext messageContext = org.apache.axis.MessageContext.getCurrentContext();
    	if (messageContext == null)
    	{
    		this.log.error
				("org.apache.axis.MessageContext.getCurrentContext returned null");
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Could not access message context.");	
			throw BindingHelper.FaultToAxisFault
				(fault);
    	}
    	
        final String strRequestURI = (String)messageContext.getProperty("HTTP_REQUEST_URI");
        final java.net.URI uriRequest = java.net.URI.create(strRequestURI);
        final org.xmlsoap.schemas.ws._2004._09.mex.Metadata metadata = this.getMetadata(uriRequest);
        
		final java.net.URI uriRequestAddressingNamespace = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_NAMESPACE_URI);
		final java.net.URI uriTo = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_TO_URI);
		final org.eclipse.higgins.sts.api.IEndpointReference eprFrom = (org.eclipse.higgins.sts.api.IEndpointReference)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_FROM_EPR);
		final java.net.URI uriMessageID = (java.net.URI)messageContext.getProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_REQUEST_CONSUMER_MESSAGE_ID_URI);
		if (null != uriRequestAddressingNamespace)
		{
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_NAMESPACE_URI,
				uriRequestAddressingNamespace);
			if (null != uriMessageID)
			{
				messageContext.setProperty
					(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_RELATES_TO_URI,
					uriMessageID);
			}
			final java.net.URI uriResponseMessageID = org.eclipse.higgins.sts.utilities.UUIDHelper.getAsURI();
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_MESSAGE_ID_URI,
				uriResponseMessageID);
			java.net.URI uriResponseTo = null;
			if (null != eprFrom)
			{
				uriResponseTo = eprFrom.getAddress();
			}
			else
			{
				uriResponseTo = java.net.URI.create
					("http://www.w3.org/2005/08/addressing/role/anonymous");
			}
			messageContext.setProperty
				(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_TO_URI,
				uriResponseTo);
			if (null != uriTo)
			{
				final org.eclipse.higgins.sts.api.IEndpointReference eprResponseFrom = new org.eclipse.higgins.sts.common.EndpointReference();
				final java.net.URI uriResponseFrom = uriTo;
				eprResponseFrom.setAddress
					(uriResponseFrom);
				messageContext.setProperty
					(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_FROM_EPR,
					eprResponseFrom);
			}
		}
		final java.net.URI uriResponseAction = java.net.URI.create("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse");
		messageContext.setProperty
			(org.eclipse.higgins.sts.binding.axis1x.addressing.Constants.PROPERTY_RESPONSE_GENERATOR_ACTION_URI,
			uriResponseAction);

        return metadata;
	}
    
    public org.xmlsoap.schemas.ws._2004._09.mex.Metadata getMetadata
    	(final java.net.URI uriRequest)
		throws java.rmi.RemoteException
	{
    	this.log.trace("MetadataExchangeServiceServerBinding::getMetadata(URI)");
    	
    	ConfigureOrThrowException();

    	try
    	{
	    	final org.eclipse.higgins.sts.api.IMetadataExchangeService mex = (org.eclipse.higgins.sts.api.IMetadataExchangeService)this.getService();
	    	final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = mex.getMetadata
	    		(this.getGlobalSettings(),
	    		this.getServiceName(),
	    		this.getServiceSettings(),
	    		null,
	    		ServerServiceBinding.constants,
	    		uriRequest);
	    	final org.eclipse.higgins.sts.api.IElement elemMetadata = mexResponse.getMetadata();
			return org.eclipse.higgins.sts.binding.common.BindingHelper.toAxis1xMetadata(elemMetadata);
    	}
    	catch (final Exception e)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(this.log, e);
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());	
			throw BindingHelper.FaultToAxisFault
				(fault);
    	}
	}

    public String getMetadataString
		(final java.net.URI uriRequest)
    	throws java.rmi.RemoteException
    {
    	this.log.trace("MetadataExchangeServiceServerBinding::getMetadataString(URI)");

    	ConfigureOrThrowException();
    	
    	try
    	{
	    	final org.eclipse.higgins.sts.api.IMetadataExchangeService mex = (org.eclipse.higgins.sts.api.IMetadataExchangeService)this.getService();
	    	final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = mex.getMetadata
	    		(this.getGlobalSettings(),
	    		this.getServiceName(),
	    		this.getServiceSettings(),
	    		null,
	    		ServerServiceBinding.constants,
	    		uriRequest);
	    	final org.eclipse.higgins.sts.api.IElement elemMetadata = mexResponse.getMetadata();
	    	return (String)elemMetadata.getAs(String.class);
    	}
		catch (final Exception e)
		{
			this.log.error
				("Failed to create URI.");
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Failed to create URI.");	
			throw BindingHelper.FaultToAxisFault
				(fault);
		}
    }
    
    public ISettingDescriptor getComponentDescriptor() {
    	return null;
    }
}