/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.sts.binding.axis1x;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.binding.common.BindingHelper;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Binds the Axis 1.x framework generated skeleton code to the Higgins STS implementation.
 * Class was originally auto-generated from WSDL by the Apache Axis 1.3 Oct 05, 2005 (05:23:37 EDT) WSDL2Java emitter.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when SecurityTokenServiceServerBinding instances are instantiated (singleton? instance per request? other?)
public class SecurityTokenServiceServerBinding extends ServerServiceBinding
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenServiceServerBinding.class.getName());
	
	public String getServiceName()
	{
		return "SecurityTokenService";
	}
	
	static private SecurityTokenServiceServerBinding theInstance = null;
	
	public static synchronized SecurityTokenServiceServerBinding getInstance()
	{
		if (null == SecurityTokenServiceServerBinding.theInstance)
		{
			SecurityTokenServiceServerBinding.theInstance = new SecurityTokenServiceServerBinding();
		}
		return SecurityTokenServiceServerBinding.theInstance;
	}
	
	/**
	 * Constructor that initializes the class
	 */
	private SecurityTokenServiceServerBinding()
	{
		this.log.trace("SecurityTokenServiceServerBinding::SecurityTokenServiceServerBinding");
	}
		
	public synchronized void configure
		(final java.util.Map mapConfigureGlobalSettings,
		final String strConfigureComponentName,
		final java.util.Map mapConfigureComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
		throws Exception
	{
		this.log.trace("SecurityTokenServiceServerBinding::configure");
		
		super.configure
			(mapConfigureGlobalSettings,
			strConfigureComponentName,
			mapConfigureComponentSettings, null, null);
		
		this.log.trace("SecurityTokenServiceServerBinding::configure DONE");
	}

	/**
	 * This method is called each time the framework receives a RequestSecurityToken message
	 * requesting a single RequestSecurityTokenResponse.
	 * 
	 * @param RST the received RequestSecurityToken element
	 * @return RequestSecurityTokenResponse element
	 */
    public org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType requestSecurityToken
    	(final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST)
    	throws java.rmi.RemoteException
    {
    	this.log.trace("SecurityTokenServiceServerBinding::requestSecurityToken");

    	ConfigureOrThrowException();
       	
    	final org.apache.axis.MessageContext messageContext = org.apache.axis.MessageContext.getCurrentContext();
    	if (messageContext == null)
    	{
    		this.log.error
				("org.apache.axis.MessageContext.getCurrentContext returned null");
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Could not access message context.");	
			throw BindingHelper.FaultToAxisFault
				(fault);
    	}
		    	
    	final ISTSRequest request = BindingHelper.STSRequestFromAxis1xRST
    		(messageContext,
    		ServerServiceBinding.constants,
    		RST);
    	final ISTSResponse response = BindingHelper.STSResponseFromSTSRequest
    		(request,
    		ServerServiceBinding.constants);
    	org.eclipse.higgins.sts.api.ISecurityTokenService STS = null;
    	try
    	{
    		STS = (org.eclipse.higgins.sts.api.ISecurityTokenService)this.getService();
        	final java.util.Map mapInvocationSettings = new java.util.Hashtable();
    		STS.invoke
    	   		(this.getGlobalSettings(),
    	   		this.getServiceName(),
    	   		this.getServiceSettings(),
    	   		mapInvocationSettings,
    	   		ServerServiceBinding.constants,
    	   		request,
    	   		response);
    	}
    	catch (final Exception e)
    	{
    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, e);
			final Fault fault = new Fault
				(ServerServiceBinding.constants.getWSTrustNamespace(),
				"wst",
				ServerServiceBinding.constants.getRequestFailedFaultCode(),
				"The specified request failed",
				e.getLocalizedMessage());	
			throw BindingHelper.FaultToAxisFault
				(fault);
    	}

    	final org.eclipse.higgins.sts.api.IFault fault = response.getFault();
    	if (null != fault)
    	{
    		throw BindingHelper.FaultToAxisFault
    			(fault);
    	}
    	else
    	{
    		final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType RSTR = BindingHelper.Axis1xRSTRFromSTSResponse
        		(messageContext,
        		response,
        		ServerServiceBinding.constants);
    		return RSTR;
    	}
    }

	/**
	 * This method is called each time the framework receives a RequestSecurityToken message
	 * requesting a RequestSecurityTokenResponseCollection.
	 * 
	 * @param RST the received RequestSecurityToken element
	 * @return RequestSecurityTokenResponse element(s)
	 */
	// TODO: Implement the requestSecurityToken2 function
    public org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenResponseType [] requestSecurityToken2
    	(final org.xmlsoap.schemas.ws._2005._02.trust.RequestSecurityTokenType RST)
    	throws java.rmi.RemoteException
    {
    	this.log.trace("SecurityTokenServiceServerBinding::requestSecurityToken2");

    	ConfigureOrThrowException();
    	
    	return null;
    }
    
    public ISettingDescriptor getComponentDescriptor() {
    	return null;
    }
}