/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client.samples;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.client.samples.ManagedCard;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory;

public class TestManaged {
    private Map mapGlobalSettings = null;
    private final LogHelper log;
    private static final String strTestRPCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    private static final String strTestRootCertificate = "MIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy";
    private URI uriTestRP;
    private final URI uriTestSTS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TestManaged() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.client.samples.TestManaged");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.uriTestRP = null;
        this.uriTestSTS = URI.create("https://localhost/TokenService/services/Trust");
    }

    public static void main(String[] args) {
        TestManaged t = new TestManaged();
        t.Run();
    }

    public String Run() {
        block20: {
            STSResponse stsResponse;
            Constants constants;
            block19: {
                ConfigurationHandler configurationHandler;
                block18: {
                    System.out.println("TestManaged");
                    try {
                        this.uriTestRP = URI.create(XMLHelper.escapedString((String)"https://pamelaproject.com/jostest/index.php?option=com_pwjos&task=process#test#test"));
                        configurationHandler = new ConfigurationHandler();
                        String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
                        if (strConfigurationBase == null) {
                            throw new Exception("org.eclipse.higgins.sts.conf System property not found");
                        }
                        configurationHandler.setConfigurationBase(strConfigurationBase);
                        configurationHandler.setFileName("ManagedClientConfiguration.xml");
                        boolean bInitialized = configurationHandler.configure(null);
                        if (bInitialized) break block18;
                        this.log.error((Object)"Not Initialized!");
                        System.err.println("Not Initialized!");
                        return "Error";
                    }
                    catch (Exception e) {
                        ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
                        e.printStackTrace(System.err);
                        return "Error";
                    }
                }
                this.mapGlobalSettings = configurationHandler.getSettings();
                ISecurityTokenService sts = (ISecurityTokenService)this.mapGlobalSettings.get("SecurityTokenService");
                ISecurityTokenService stsBinding = (ISecurityTokenService)this.mapGlobalSettings.get("SecurityTokenServiceBinding");
                ManagedCard informationCard = new ManagedCard();
                informationCard.setID(URI.create("urn:Higgins-LDAP-Server"));
                informationCard.setVersion("1");
                informationCard.setIssuer(this.uriTestSTS.toString());
                informationCard.setIssuerName(this.uriTestSTS.toString());
                constants = new Constants();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String string = "-----BEGIN CERTIFICATE-----\nMIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamCertificate = new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM\n-----END CERTIFICATE-----\n".getBytes());
                X509Certificate certRP = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
                String string2 = "-----BEGIN CERTIFICATE-----\nMIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamRootCertificate = new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy\n-----END CERTIFICATE-----\n".getBytes());
                X509Certificate certRoot = (X509Certificate)certificateFactory.generateCertificate(streamRootCertificate);
                X509Certificate[] certChain = new X509Certificate[]{certRP, certRoot};
                IBase64Extension base64Extension = (IBase64Extension)this.mapGlobalSettings.get("Base64Extension");
                URI uriTokenService = URI.create(informationCard.getIssuer());
                this.mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
                stsBinding.configure(this.mapGlobalSettings, "SecurityTokenService", null);
                TokenRequestFactory factoryRequest = new TokenRequestFactory();
                Element elemClaims = new Element();
                elemClaims.set((Object)"<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"/></wst:Claims>");
                stsResponse = new STSResponse();
                ISTSRequest stsRequest = factoryRequest.createManagedRequest(this.uriTestRP, certChain, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)informationCard, (IElement)elemClaims, "mikemci@us.ibm.com", "secret", base64Extension);
                sts.invoke(this.mapGlobalSettings, null, null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
                if (stsResponse.getFault() == null) break block19;
                System.err.println("Returning STS Fault");
                this.log.trace((Object)"Returning STS Fault");
                return "STS Fault";
            }
            List listRSTR = stsResponse.getRequestSecurityTokenResponseCollection();
            if (1 != listRSTR.size()) break block20;
            IRequestSecurityTokenResponse RSTR = (IRequestSecurityTokenResponse)listRSTR.get(0);
            IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs((Class)clazz);
            System.err.println("Token: " + strRequestedSecurityToken);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.apache.axiom.om.OMElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            OMElement omRequestedSecurityToken = (OMElement)elemRequestedSecurityToken.getAs((Class)clazz2);
            QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
            QName qnameSAMLAssertion = new QName(constants.getSAML10Namespace().toString(), "Assertion");
            OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
            OMElement omEncryptedSecurityToken = null;
            if (omReturnedSAMLAssertion != null) {
                IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)this.mapGlobalSettings.get("XMLSecurityExtension");
                if (xmlSecurity == null) {
                    XMLSecurityApacheExtensionFactory xmlSecurityFactory = new XMLSecurityApacheExtensionFactory();
                    xmlSecurity = (IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
                    xmlSecurity.configure(this.mapGlobalSettings, null, null);
                }
                IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemRequestedSecurityToken, strTestRPCertificate);
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.apache.axiom.om.OMElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                OMElement omEncryptedRequestedSecurityToken = (OMElement)elemEncryptedRequestedSecurityToken.getAs((Class)clazz3);
                omEncryptedSecurityToken = omEncryptedRequestedSecurityToken.getFirstElement();
                String strEncryptedStringToken = XMLHelper.toString((OMElement)omEncryptedSecurityToken);
                System.err.println("Encrypted Token: " + strEncryptedStringToken);
                break block20;
            }
            OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
            if (omReturnedEncryptedData != null) {
                omEncryptedSecurityToken = omReturnedEncryptedData;
            } else {
                System.err.println("Unexpected RequestedSecurityToken");
            }
        }
        System.out.println("Success");
        return "Success";
    }
}

