/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client.samples;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.xml.security.Init;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IMEXResponse;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.client.samples.ManagedCard;
import org.eclipse.higgins.sts.client.samples.PersonalCard;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory;

public class TestPersonalAndManaged {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$client$samples$TestPersonalAndManaged == null ? (class$org$eclipse$higgins$sts$client$samples$TestPersonalAndManaged = TestPersonalAndManaged.class$("org.eclipse.higgins.sts.client.samples.TestPersonalAndManaged")) : class$org$eclipse$higgins$sts$client$samples$TestPersonalAndManaged).getName());
    private static final String strTestRPCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    private static final String strTestRootCertificate = "MIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy";
    private final URI uriTestRP = URI.create("https://pamelaproject.com/jostest/index.php?option=com_pwjos&task=process");
    private final URI uriTestSTS = URI.create("https://localhost/TokenService/services/Trust");
    private final URI uriTestMex = URI.create("https://localhost/TokenService/services/MetadataUsernameToken");
    static /* synthetic */ Class class$org$eclipse$higgins$sts$client$samples$TestPersonalAndManaged;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;

    public static void main(String[] args) {
        TestPersonalAndManaged t = new TestPersonalAndManaged();
        t.Run();
    }

    public String Run() {
        System.out.println("TestPersonalAndManaged");
        Init.init();
        Map mapGlobalSettings = null;
        try {
            ConfigurationHandler configurationHandler = new ConfigurationHandler();
            String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
            if (null == strConfigurationBase) {
                throw new Exception("org.eclipse.higgins.sts.conf System property not found");
            }
            configurationHandler.setConfigurationBase(strConfigurationBase);
            configurationHandler.setFileName("ClientConfiguration.xml");
            boolean bInitialized = configurationHandler.configure(null);
            if (!bInitialized) {
                this.log.error((Object)"Not Initialized!");
                System.err.println("Not Initialized!");
                return "Error";
            }
            mapGlobalSettings = configurationHandler.getSettings();
            ISecurityTokenService stsPersonal = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
            ISecurityTokenService stsManaged = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceClient");
            ISecurityTokenService stsBinding = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceBinding");
            IMetadataExchangeService mex = (IMetadataExchangeService)mapGlobalSettings.get("MetadataExchangeServiceClient");
            IMetadataExchangeService mexBinding = (IMetadataExchangeService)mapGlobalSettings.get("MetadataExchangeServiceBinding");
            IBase64Extension base64Extension = (IBase64Extension)mapGlobalSettings.get("Base64Extension");
            ManagedCard iCardManaged = new ManagedCard();
            iCardManaged.setID(URI.create("file:///C:/higgins.config.xml?id=Higgins-LDAP-Server"));
            iCardManaged.setVersion("1");
            iCardManaged.setIssuer(this.uriTestSTS.toString());
            iCardManaged.setIssuerName(this.uriTestSTS.toString());
            PersonalCard iCardPersonal = new PersonalCard();
            iCardPersonal.setID(URI.create("file:///C:/higgins.config.xml?id=Higgins-LDAP-Server"));
            iCardPersonal.setVersion("1");
            iCardPersonal.setIssuer(this.uriTestSTS.toString());
            iCardPersonal.setIssuerName(this.uriTestSTS.toString());
            Constants constants = new Constants();
            TokenRequestFactory factoryRequest = new TokenRequestFactory();
            Element elemClaimsPersonal = new Element();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\nMIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM\n-----END CERTIFICATE-----\n";
            ByteArrayInputStream streamCertificate = new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM\n-----END CERTIFICATE-----\n".getBytes());
            X509Certificate certRP = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
            String strRootCertificate = "-----BEGIN CERTIFICATE-----\nMIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy\n-----END CERTIFICATE-----\n";
            ByteArrayInputStream streamRootCertificate = new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy\n-----END CERTIFICATE-----\n".getBytes());
            X509Certificate certRoot = (X509Certificate)certificateFactory.generateCertificate(streamRootCertificate);
            X509Certificate[] certChain = new X509Certificate[]{certRP, certRoot};
            elemClaimsPersonal.set((Object)"<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\">Mike</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\">McIntosh</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"></ic:ClaimType></wst:Claims>");
            STSResponse stsResponsePersonal = new STSResponse();
            ISTSRequest stsRequestPersonal = factoryRequest.createPersonalRequest(this.uriTestRP, certChain, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)iCardPersonal, (IElement)elemClaimsPersonal, base64Extension);
            stsPersonal.invoke(mapGlobalSettings, "SecurityTokenService", null, null, (IConstants)constants, stsRequestPersonal, (ISTSResponse)stsResponsePersonal);
            if (null != stsResponsePersonal.getFault()) {
                System.err.println("Returning STS Fault");
                System.err.println(stsResponsePersonal.getFault().getDetail());
                this.log.trace((Object)"Returning STS Fault");
                return "STS Fault";
            }
            List listRSTRPersonal = stsResponsePersonal.getRequestSecurityTokenResponseCollection();
            if (1 == listRSTRPersonal.size()) {
                IRequestSecurityTokenResponse RSTR = (IRequestSecurityTokenResponse)listRSTRPersonal.get(0);
                IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
                String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(class$java$lang$String == null ? (class$java$lang$String = TestPersonalAndManaged.class$("java.lang.String")) : class$java$lang$String);
                System.err.println("Returned Token: " + strRequestedSecurityToken);
                OMElement omEncryptedToken = null;
                OMElement omRequestedSecurityToken = (OMElement)elemRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestPersonalAndManaged.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
                QName qnameSAMLAssertion = new QName(constants.getSAML10Namespace().toString(), "Assertion");
                OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
                if (null != omReturnedSAMLAssertion) {
                    IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
                    if (null == xmlSecurity) {
                        XMLSecurityApacheExtensionFactory xmlSecurityFactory = new XMLSecurityApacheExtensionFactory();
                        xmlSecurity = (IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
                        xmlSecurity.configure(null, null, null);
                    }
                    IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemRequestedSecurityToken, strTestRPCertificate);
                    OMElement omEncryptedRequestedSecurityToken = (OMElement)elemEncryptedRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestPersonalAndManaged.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                    omEncryptedToken = omEncryptedRequestedSecurityToken.getFirstElement();
                    String strEncryptedToken = XMLHelper.toString((OMElement)omEncryptedToken);
                    System.err.println("Encrypted Token: " + strEncryptedToken);
                } else {
                    OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
                    if (null != omReturnedEncryptedData) {
                        omEncryptedToken = omReturnedEncryptedData;
                    } else {
                        System.err.println("Unexpected RequestedSecurityToken");
                    }
                }
            }
            URI uriMetadataService = URI.create(this.uriTestMex.toString());
            mapGlobalSettings.put("MetadataServiceURI", uriMetadataService);
            mexBinding.configure(mapGlobalSettings, "MetadataExchangeService", null);
            IMEXResponse mexResponse = mex.getMetadata(mapGlobalSettings, null, null, null, (IConstants)constants, uriMetadataService);
            if (null != mexResponse.getFault()) {
                System.err.println("Returning MEX Fault");
                this.log.trace((Object)"Returning MEX Fault");
                IFault fault = mexResponse.getFault();
                System.err.println("Returning MEX Fault: " + fault.getDetail());
                return "MEX Fault";
            }
            URI uriTokenService = URI.create(iCardManaged.getIssuer());
            mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
            stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null);
            Element elemClaimsManaged = new Element();
            elemClaimsManaged.set((Object)"<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"/></wst:Claims>");
            STSResponse stsResponse = new STSResponse();
            ISTSRequest stsRequest = factoryRequest.createManagedRequest(this.uriTestRP, certChain, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)iCardManaged, (IElement)elemClaimsManaged, "mikemci@us.ibm.com", "secret", base64Extension);
            stsManaged.invoke(mapGlobalSettings, null, null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
            if (null != stsResponse.getFault()) {
                System.err.println("Returning STS Fault");
                this.log.trace((Object)"Returning STS Fault");
                return "STS Fault";
            }
            List listRSTR = stsResponse.getRequestSecurityTokenResponseCollection();
            if (1 == listRSTR.size()) {
                IRequestSecurityTokenResponse RSTR = (IRequestSecurityTokenResponse)listRSTR.get(0);
                IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
                String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(class$java$lang$String == null ? (class$java$lang$String = TestPersonalAndManaged.class$("java.lang.String")) : class$java$lang$String);
                System.err.println("Token: " + strRequestedSecurityToken);
                OMElement omRequestedSecurityToken = (OMElement)elemRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestPersonalAndManaged.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
                QName qnameSAMLAssertion = new QName(constants.getSAML10Namespace().toString(), "Assertion");
                OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
                OMElement omEncryptedSecurityToken = null;
                if (null != omReturnedSAMLAssertion) {
                    IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
                    if (null == xmlSecurity) {
                        XMLSecurityApacheExtensionFactory xmlSecurityFactory = new XMLSecurityApacheExtensionFactory();
                        xmlSecurity = (IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
                        xmlSecurity.configure(mapGlobalSettings, null, null);
                    }
                    IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemRequestedSecurityToken, strTestRPCertificate);
                    OMElement omEncryptedRequestedSecurityToken = (OMElement)elemEncryptedRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestPersonalAndManaged.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                    omEncryptedSecurityToken = omEncryptedRequestedSecurityToken.getFirstElement();
                    String strEncryptedStringToken = XMLHelper.toString((OMElement)omEncryptedSecurityToken);
                    System.err.println("Encrypted Token: " + strEncryptedStringToken);
                } else {
                    OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
                    if (null != omReturnedEncryptedData) {
                        omEncryptedSecurityToken = omReturnedEncryptedData;
                    } else {
                        System.err.println("Unexpected RequestedSecurityToken");
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            e.printStackTrace(System.err);
            return "Error";
        }
        System.out.println("Success");
        return "Success";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

