/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client.samples;

import java.util.Date;
import java.util.List;

import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;

/**
 * @author mikemci
 *
 */
public class PersonalCard extends
		org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard {
	
	private byte [] masterKey_ = {
	        80, -86, 121, 26, -76, -26, 41, 126, 84, -118, 
	        21, -27, 121, 64, -48, -103, -33, -1, 0, 122, 
	        -49, 53, 75, 91, 47, 113, -119, 25, -12, -118, 
	        -44, 55 };
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.IInformationCard#getMasterKey()
	 */
	public byte[] getMasterKey() throws CardException {
		return masterKey_;
	}
	
	public void setID(java.net.URI uriID)
	{
		id_ = uriID;
	}
	
	public void setIssuer(String strIssuer)
	{
		issuer_ = strIssuer;
	}
	
	public void setVersion(String strVersion)
	{
		version_ = strVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#applyUpdates()
	 */
	public void applyUpdates() throws InvalidStateException, CardException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#beginUpdates()
	 */
	public void beginUpdates() throws InvalidStateException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#cancelUpdates()
	 */
	public void cancelUpdates() throws InvalidStateException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#isEditMode()
	 */
	public boolean isEditMode() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#isEditable()
	 */
	public boolean isEditable() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#setImage(byte[], java.lang.String)
	 */
	public void setImage(byte[] newImage, String newImageType)
			throws CardException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#setIssuerName(java.lang.String)
	 */
	public void setIssuerName(String name) throws CardException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#setName(java.lang.String)
	 */
	public void setName(String newName) throws CardException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ICard#setTimeExpires(java.util.Date)
	 */
	public void setTimeExpires(Date date) throws CardException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.IClaimContainer#createClaim(java.lang.String)
	 */
	public IClaim createClaim(String type) throws InvalidTypeException,
			ReadOnlyObjectException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.IClaimContainer#setClaim(org.eclipse.higgins.icard.IClaim)
	 */
	public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException,
			InvalidTypeException, ReadOnlyObjectException {
		// TODO Auto-generated method stub
		return null;
	}

	public void setClaimList(List claims) throws CardException {
		// TODO Auto-generated method stub
		
	}

	public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
		// TODO Auto-generated method stub
		
	}

	protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
		// TODO Auto-generated method stub
		
	}
}
