/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client.samples;

import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
//import org.eclipse.higgins.icard.provider.cardspace.impl.InformationCard;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class TestPersonalAndManaged
{
//	private java.util.Map mapGlobalSettings = null;

	private final LogHelper log = new LogHelper
		(TestPersonalAndManaged.class.getName());
	
	private static final String strTestRPCertificate = 
		"MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";

	private static final String strTestRootCertificate = 
		"MIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy";

	private final java.net.URI uriTestRP = java.net.URI.create("https://pamelaproject.com/jostest/index.php?option=com_pwjos&task=process");
	
	private final java.net.URI uriTestSTS = java.net.URI.create("https://localhost/TokenService/services/Trust");
	
	private final java.net.URI uriTestMex = java.net.URI.create("https://localhost/TokenService/services/MetadataUsernameToken");

	public static void main(final String [] args)
	{
		org.apache.log4j.PropertyConfigurator.configure("/ws/higgins/hbxie/configuration/log4j.properties");

		final TestPersonalAndManaged t = new TestPersonalAndManaged();
		t.Run();
	}
	
	public String Run()
	{
		System.out.println("TestPersonalAndManaged");
		
		org.apache.xml.security.Init.init();
		
		// Setup STS (No Binding)
		java.util.Map mapGlobalSettings = null;
		try
		{
			final ConfigurationHandler configurationHandler = new ConfigurationHandler();
			
			String strConfigurationBase = System.getProperty
				("org.eclipse.higgins.sts.conf");
			if (null == strConfigurationBase)
			{
				throw new Exception("org.eclipse.higgins.sts.conf System property not found");
			}
			configurationHandler.setConfigurationBase(strConfigurationBase);
			configurationHandler.setFileName("ClientConfiguration.xml");
				
			boolean bInitialized = configurationHandler.configure(null);
			if (!bInitialized)
			{
				this.log.error
					("Not Initialized!");
				System.err.println
					("Not Initialized!");				
				return "Error";
			}
			mapGlobalSettings = configurationHandler.getSettings();
		
			final ISecurityTokenService stsPersonal = (ISecurityTokenService)mapGlobalSettings.get
				("SecurityTokenService");
	
			final ISecurityTokenService stsManaged = (ISecurityTokenService)mapGlobalSettings.get
				("SecurityTokenServiceClient");
			
			final ISecurityTokenService stsBinding = (ISecurityTokenService)mapGlobalSettings.get
				("SecurityTokenServiceBinding");
			
			final IMetadataExchangeService mex = (IMetadataExchangeService)mapGlobalSettings.get
				("MetadataExchangeServiceClient");
			
			final IMetadataExchangeService mexBinding = (IMetadataExchangeService)mapGlobalSettings.get
				("MetadataExchangeServiceBinding");
			
			final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension = (org.eclipse.higgins.sts.spi.IBase64Extension)mapGlobalSettings.get
				("Base64Extension");

			final java.security.KeyStore ksTrusted = (java.security.KeyStore)mapGlobalSettings.get
				("TrustedKeyStore");
	
			java.util.Collection collCertificates = new java.util.ArrayList();
			java.util.Enumeration enumCertificates = ksTrusted.aliases();
			while (enumCertificates.hasMoreElements())
			{
				String strAlias = (String)enumCertificates.nextElement();
				java.security.cert.Certificate cert = ksTrusted.getCertificate(strAlias);
				collCertificates.add(cert);
			}
			
			java.security.cert.CollectionCertStoreParameters collCSP = new java.security.cert.CollectionCertStoreParameters
				(collCertificates);

			java.security.cert.CertStore certStoreTrust = java.security.cert.CertStore.getInstance
				("Collection",
				collCSP);
			
			// Create a Card
			final ManagedCard iCardManaged = new ManagedCard();
			iCardManaged.setID(java.net.URI.create("file:///C:/higgins.config.xml?id=Higgins-LDAP-Server"));
			iCardManaged.setVersion("1");
			iCardManaged.setIssuer(uriTestSTS.toString());
			iCardManaged.setIssuerName(uriTestSTS.toString());
			
			final PersonalCard iCardPersonal = new PersonalCard();
			iCardPersonal.setID(java.net.URI.create("file:///C:/higgins.config.xml?id=Higgins-LDAP-Server"));
			iCardPersonal.setVersion("1");
			iCardPersonal.setIssuer(uriTestSTS.toString());
			iCardPersonal.setIssuerName(uriTestSTS.toString());
			
			// Create Request
			final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
			final TokenRequestFactory factoryRequest = new TokenRequestFactory();
			final org.eclipse.higgins.sts.api.IElement elemClaimsPersonal = new org.eclipse.higgins.sts.common.Element();

			final java.security.cert.X509Certificate certRP = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString(strTestRPCertificate);
			
			final java.security.cert.X509Certificate certRoot = org.eclipse.higgins.sts.utilities.CertificateHelper.fromString(strTestRootCertificate);
			
			java.security.cert.X509Certificate [] certChain = new java.security.cert.X509Certificate[2];
			certChain[0] = certRP;
			certChain[1] = certRoot;
		
			elemClaimsPersonal.set
				("<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\">Mike</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\">McIntosh</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"></ic:ClaimType></wst:Claims>");

			final ISTSResponse stsResponsePersonal = new STSResponse();
			final org.eclipse.higgins.sts.api.ISTSRequest stsRequestPersonal = factoryRequest.createPersonalRequest
				(this.uriTestRP,
				certChain,
				certStoreTrust,
				java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"),
				iCardPersonal,
				elemClaimsPersonal,
				base64Extension);
			
			// Invoke the STS
			stsPersonal.invoke
				(mapGlobalSettings,
				"SecurityTokenService",
				null,
				null,
				constants,
				stsRequestPersonal,
				stsResponsePersonal);
			if (null != stsResponsePersonal.getFault())
			{
				System.err.println("Returning STS Fault");
				System.err.println(stsResponsePersonal.getFault().getDetail());
				this.log.trace("Returning STS Fault");
				return "STS Fault";
			}
			
			// Print the Token
			final java.util.List listRSTRPersonal = stsResponsePersonal.getRequestSecurityTokenResponseCollection();
			if (1 == listRSTRPersonal.size())
			{
				final org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTRPersonal.get(0);
				final org.eclipse.higgins.sts.api.IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
				final String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(String.class);
				System.err.println("Returned Token: " + strRequestedSecurityToken);
				
				/// This must be done before the Token is handed off to a Browser to be POSTed to the RP.
				org.apache.axiom.om.OMElement omEncryptedToken = null;
				final org.apache.axiom.om.OMElement omRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemRequestedSecurityToken.getAs
					(org.apache.axiom.om.OMElement.class);
				final javax.xml.namespace.QName qnameEncryptedData = new javax.xml.namespace.QName
					(constants.getXMLEncryptionNamespace().toString(),
					"EncryptedData"); 	
				final javax.xml.namespace.QName qnameSAMLAssertion = new javax.xml.namespace.QName
					(constants.getSAML10Namespace().toString(),
					"Assertion"); 
				final org.apache.axiom.om.OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName
					(qnameSAMLAssertion);
				if (null != omReturnedSAMLAssertion)
				{
					org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
						("XMLSecurityExtension");
					if (null == xmlSecurity)
					{
						final org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory xmlSecurityFactory = new org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory();
						xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
						xmlSecurity.configure(null, null, null);
					}
					final org.eclipse.higgins.sts.api.IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement
						("saml:Assertion",
						elemRequestedSecurityToken,
						strTestRPCertificate);
					final org.apache.axiom.om.OMElement omEncryptedRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemEncryptedRequestedSecurityToken.getAs(org.apache.axiom.om.OMElement.class);
				    omEncryptedToken = omEncryptedRequestedSecurityToken.getFirstElement();
					final String strEncryptedToken = org.eclipse.higgins.sts.utilities.XMLHelper.toString(omEncryptedToken);
					System.err.println("Encrypted Token: " + strEncryptedToken);
				}
				else
				{
					final org.apache.axiom.om.OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName
						(qnameEncryptedData);
					if (null != omReturnedEncryptedData)
					{
						omEncryptedToken = omReturnedEncryptedData;
					}
					else
					{
						System.err.println("Unexpected RequestedSecurityToken");
					}
				}
				// At this point the omEncryptedToken should be POSTed to the RP.
			}

			// Need to do this for each request
			final java.net.URI uriMetadataService = java.net.URI.create(uriTestMex.toString()); // This should come form card
			mapGlobalSettings.put("MetadataServiceURI", uriMetadataService);
			mexBinding.configure(mapGlobalSettings, "MetadataExchangeService", null);
	
			final org.eclipse.higgins.sts.api.IMEXResponse mexResponse = mex.getMetadata
				(mapGlobalSettings,
				null,
				null,
				null,
				constants,
				uriMetadataService);
			if (null != mexResponse.getFault())
			{
				System.err.println("Returning MEX Fault");
				this.log.trace("Returning MEX Fault");
				final org.eclipse.higgins.sts.api.IFault fault = mexResponse.getFault();
				System.err.println("Returning MEX Fault: " + fault.getDetail());
				return "MEX Fault";
			}
				
			// Create a Request			
			java.net.URI uriTokenService = java.net.URI.create(iCardManaged.getIssuer());
			mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService); 
			stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null);
	
			final org.eclipse.higgins.sts.api.IElement elemClaimsManaged = new org.eclipse.higgins.sts.common.Element();
			elemClaimsManaged.set("<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\"/><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"/></wst:Claims>");
	
			final ISTSResponse stsResponse = new STSResponse();
			final org.eclipse.higgins.sts.api.ISTSRequest stsRequest = factoryRequest.createManagedRequest
				(this.uriTestRP,
				certChain,
				certStoreTrust,
				uriTokenService,
				java.net.URI.create("urn:oasis:names:tc:SAML:1.0:assertion"),
				iCardManaged,
				elemClaimsManaged,
				"mikemci@us.ibm.com",
				"secret",
				base64Extension);
		
			// Invoke the STS
			stsManaged.invoke
				(mapGlobalSettings,
				null,
				null,
				null,
				constants,
				stsRequest,
				stsResponse);
			if (null != stsResponse.getFault())
			{
				System.err.println("Returning STS Fault");
				this.log.trace("Returning STS Fault");
				return "STS Fault";
			}
			
			// Print the Token
			final java.util.List listRSTR = stsResponse.getRequestSecurityTokenResponseCollection();
			if (1 == listRSTR.size())
			{
				final org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse RSTR = (org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse)listRSTR.get(0);
				final org.eclipse.higgins.sts.api.IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
				final String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(String.class);
				System.err.println("Token: " + strRequestedSecurityToken);
				
				/// This must be done before the Token is handed off to a Browser to be POSTed to the RP.
				final org.apache.axiom.om.OMElement omRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemRequestedSecurityToken.getAs
					(org.apache.axiom.om.OMElement.class);
				final javax.xml.namespace.QName qnameEncryptedData = new javax.xml.namespace.QName
					(constants.getXMLEncryptionNamespace().toString(),
					"EncryptedData"); 	
				final javax.xml.namespace.QName qnameSAMLAssertion = new javax.xml.namespace.QName
					(constants.getSAML10Namespace().toString(),
					"Assertion"); 
				final org.apache.axiom.om.OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName
					(qnameSAMLAssertion);
				org.apache.axiom.om.OMElement omEncryptedSecurityToken = null;
				if (null != omReturnedSAMLAssertion)
				{
					org.eclipse.higgins.sts.spi.IXMLSecurityExtension xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)mapGlobalSettings.get
						("XMLSecurityExtension");
					if (null == xmlSecurity)
					{
						final org.eclipse.higgins.configuration.api.IConfigurableComponentFactory xmlSecurityFactory = new org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtensionFactory();
						xmlSecurity = (org.eclipse.higgins.sts.spi.IXMLSecurityExtension)xmlSecurityFactory.getSingletonInstance();
						xmlSecurity.configure(mapGlobalSettings, null, null);
					}
				    final org.eclipse.higgins.sts.api.IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement
						("saml:Assertion",
						elemRequestedSecurityToken,
						strTestRPCertificate);
				    final org.apache.axiom.om.OMElement omEncryptedRequestedSecurityToken = (org.apache.axiom.om.OMElement)elemEncryptedRequestedSecurityToken.getAs(org.apache.axiom.om.OMElement.class);
				    omEncryptedSecurityToken = omEncryptedRequestedSecurityToken.getFirstElement();
					final String strEncryptedStringToken = org.eclipse.higgins.sts.utilities.XMLHelper.toString(omEncryptedSecurityToken);
					System.err.println("Encrypted Token: " + strEncryptedStringToken);
				}
				else
				{
					final org.apache.axiom.om.OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName
						(qnameEncryptedData);
					if (null != omReturnedEncryptedData)
					{
						omEncryptedSecurityToken = omReturnedEncryptedData;
					}
					else
					{
						System.err.println("Unexpected RequestedSecurityToken");
					}
				}
				// At this point the omEncryptedToken should be POSTed to the RP.
			}
		}
		catch (final Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
				(this.log,
				e);
			e.printStackTrace(System.err);
			return "Error";			
		}
				
		System.out.println("Success");
		return "Success";
	}
}
