/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial design and implementation
 *******************************************************************************/ 
package org.eclipse.higgins.sts.client.samples;

/**
 * @author mikemci
 *
 */
public class TestNewClient {

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		java.net.URI uriAddress = java.net.URI.create
			("https://localhost/TokenService/services/MetadataX509Token");
		String strHost = uriAddress.getHost();
		String strPath = uriAddress.getPath();
		String strRequestBody = "<s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\">"
				+ "<s:Header>"
					+ "<a:Action s:mustUnderstand=\"1\">"
						+ "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get"
					+ "</a:Action>"
					+ "<a:MessageID>"
						+ "urn:uuid:4238d1c1-bf85-46b5-87ae-972d9e5894d9"
					+ "</a:MessageID>"
					+ "<a:ReplyTo>"
						+ "<a:Address>"
							+ "http://www.w3.org/2005/08/addressing/anonymous"
						+ "</a:Address>"
					+ "</a:ReplyTo>"
					+ "<a:To s:mustUnderstand=\"1\">"
						+ uriAddress.toString()
					+ "</a:To>"
				+ "</s:Header>"
				+ "<s:Body/>"
			+ "</s:Envelope>";
		try
		{
			org.apache.commons.httpclient.HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
			org.apache.commons.httpclient.methods.PostMethod httpPostMethod = new org.apache.commons.httpclient.methods.PostMethod
				(uriAddress.toString());
			httpPostMethod.setRequestBody
				(strRequestBody);
			httpPostMethod.setRequestHeader
				("content-type",
				"application/soap+xml; charset=utf-8");
			httpPostMethod.setRequestHeader
				("user-agent",
				"Higgins Token Service Client/1.0");
			httpClient.executeMethod
				(httpPostMethod);
			java.io.InputStream isBody = httpPostMethod.getResponseBodyAsStream();
			org.w3c.dom.Element domBody = org.eclipse.higgins.sts.utilities.XMLHelper.domFromStream
				(isBody);
			httpPostMethod.releaseConnection();
			String strBody = org.eclipse.higgins.sts.utilities.XMLHelper.toString
				(domBody);
			System.out.println
				(strBody);
		}
		catch (Exception ex)
		{
			System.err.println("Exception: " + ex.getLocalizedMessage());
		}
	}
}
