/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client.samples;

import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IRequestSecurityTokenResponse;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.STSResponse;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;

public class TestSAMLResponse {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$client$samples$TestSAMLResponse == null ? (class$org$eclipse$higgins$sts$client$samples$TestSAMLResponse = TestSAMLResponse.class$("org.eclipse.higgins.sts.client.samples.TestSAMLResponse")) : class$org$eclipse$higgins$sts$client$samples$TestSAMLResponse).getName());
    private static final String strTestRPCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    private static final String strTestRootCertificate = "MIICbDCCAdWgAwIBAgIERWUHpTANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAIcFIvEB2pWBf/B3Xh156Pia3OkgT88FyTZs4WyhN18Zf05nXr7ebSkUNy71emoHpYY5AF3mpgf5ltTaVE09XF4aFJm+MkVkkI7Wx75yPkbGvBV9lHrVKlH+y6Gj7RNcms6DNwpjUqjnNyqG3HSQIXU5xcSS9Qfkqj7i72QdDodpAgMBAAGjUzBRMB0GA1UdDgQWBBQWbV9hrYalWfkZz6REmhtZfBsqfjAfBgNVHSMEGDAWgBQWbV9hrYalWfkZz6REmhtZfBsqfjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAFEjuPi00CV+He2xPWbhGPL8F89tKNmjOCZQL2ZpyFbhAq6mnev9MrwuSs60ig+LFiTbTc6qg3LcTRph6pf9soqinBea3uv4ZksjTDPoIEquzP5aIAe620dr6ghcruG6A5wpIoScSHFyZAxfi6cZAXoPNt6c18Ba1d1kADBhPOPy";
    private final URI uriTestSTS = URI.create("https://localhost/TokenService/services/Trust");
    private final URI uriTestRP = URI.create("https://pamelaproject.com/jostest/index.php?option=com_pwjos&task=process");
    static /* synthetic */ Class class$org$eclipse$higgins$sts$client$samples$TestSAMLResponse;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$axiom$om$OMElement;

    public static void main(String[] args) {
        System.out.println("Enter main");
        TestSAMLResponse t = new TestSAMLResponse();
        t.Run();
        System.out.println("Exit main");
    }

    public String Run() {
        System.out.println("TestSAMLResponse");
        Map mapGlobalSettings = null;
        CertStore certStoreTrust = null;
        try {
            ConfigurationHandler configurationHandler = new ConfigurationHandler();
            String strConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
            if (null == strConfigurationBase) {
                throw new Exception("org.eclipse.higgins.sts.conf System property not found");
            }
            configurationHandler.setConfigurationBase(strConfigurationBase);
            configurationHandler.setFileName("ManagedClientConfiguration.xml");
            boolean bInitialized = configurationHandler.configure(null);
            if (!bInitialized) {
                this.log.error((Object)"Not Initialized!");
                System.err.println("Not Initialized!");
                return "Error";
            }
            mapGlobalSettings = configurationHandler.getSettings();
            KeyStore ksTrusted = (KeyStore)mapGlobalSettings.get("TrustedKeyStore");
            ArrayList<Certificate> collCertificates = new ArrayList<Certificate>();
            Enumeration<String> enumCertificates = ksTrusted.aliases();
            while (enumCertificates.hasMoreElements()) {
                String strAlias = enumCertificates.nextElement();
                Certificate cert = ksTrusted.getCertificate(strAlias);
                collCertificates.add(cert);
            }
            CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(collCertificates);
            certStoreTrust = CertStore.getInstance("Collection", collCSP);
            ISecurityTokenService sts = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
            ISecurityTokenService stsBinding = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenServiceBinding");
            IXMLSecurityExtension xmlSecurity = (IXMLSecurityExtension)mapGlobalSettings.get("XMLSecurityExtension");
            mapGlobalSettings.put("TokenServiceTrustURI", this.uriTestSTS);
            stsBinding.configure(mapGlobalSettings, "SecurityTokenService", null, null, null);
            Constants constants = new Constants();
            TokenRequestFactory factoryRequest = new TokenRequestFactory();
            Element elemClaims = new Element();
            X509Certificate[] certChain = null;
            X509Certificate certRP = CertificateHelper.fromString((String)strTestRPCertificate);
            X509Certificate certRoot = CertificateHelper.fromString((String)strTestRootCertificate);
            certChain = new X509Certificate[]{certRP, certRoot};
            elemClaims.set((Object)"<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname\">Mike</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname\">McIntosh</ic:ClaimType><ic:ClaimType Uri=\"http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier\"></ic:ClaimType></wst:Claims>");
            STSResponse stsResponse = new STSResponse();
            ISTSRequest stsRequest = factoryRequest.createRequest(this.uriTestRP, this.uriTestSTS, URI.create("urn:oasis:names:tc:SAML:2.0:protocol"), (IElement)elemClaims, "mikemci@us.ibm.com", "secret");
            sts.invoke(mapGlobalSettings, "SecurityTokenService", null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
            if (null != stsResponse.getFault()) {
                System.err.println("Returning STS Fault");
                System.err.println(stsResponse.getFault().getDetail());
                this.log.trace((Object)"Returning STS Fault");
                return "STS Fault";
            }
            List listRSTR = stsResponse.getRequestSecurityTokenResponseCollection();
            if (1 == listRSTR.size()) {
                IRequestSecurityTokenResponse RSTR = (IRequestSecurityTokenResponse)listRSTR.get(0);
                IElement elemRequestedSecurityToken = RSTR.getRequestedSecurityToken();
                String strRequestedSecurityToken = (String)elemRequestedSecurityToken.getAs(class$java$lang$String == null ? (class$java$lang$String = TestSAMLResponse.class$("java.lang.String")) : class$java$lang$String);
                System.err.println("Returned Token: " + strRequestedSecurityToken);
                OMElement omEncryptedToken = null;
                OMElement omRequestedSecurityToken = (OMElement)elemRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestSAMLResponse.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                QName qnameEncryptedData = new QName(constants.getXMLEncryptionNamespace().toString(), "EncryptedData");
                QName qnameSAMLAssertion = new QName(constants.getSAML10AssertionNamespace().toString(), "Assertion");
                OMElement omReturnedSAMLAssertion = omRequestedSecurityToken.getFirstChildWithName(qnameSAMLAssertion);
                if (null != omReturnedSAMLAssertion) {
                    IElement elemEncryptedRequestedSecurityToken = xmlSecurity.EncryptElement("saml:Assertion", elemRequestedSecurityToken, strTestRPCertificate);
                    OMElement omEncryptedRequestedSecurityToken = (OMElement)elemEncryptedRequestedSecurityToken.getAs(class$org$apache$axiom$om$OMElement == null ? (class$org$apache$axiom$om$OMElement = TestSAMLResponse.class$("org.apache.axiom.om.OMElement")) : class$org$apache$axiom$om$OMElement);
                    omEncryptedToken = omEncryptedRequestedSecurityToken.getFirstElement();
                    String strEncryptedToken = XMLHelper.toString((OMElement)omEncryptedToken);
                    System.err.println("Encrypted Token: " + strEncryptedToken);
                } else {
                    OMElement omReturnedEncryptedData = omRequestedSecurityToken.getFirstChildWithName(qnameEncryptedData);
                    if (null != omReturnedEncryptedData) {
                        omEncryptedToken = omReturnedEncryptedData;
                    } else {
                        System.err.println("Unexpected RequestedSecurityToken");
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHelper.Log((LogHelper)this.log, (Exception)e);
            e.printStackTrace(System.err);
            return "Error";
        }
        System.out.println("Success");
        return "Success";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

