/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.ITimestamp;
import org.eclipse.higgins.sts.api.IUsernameToken;
import org.eclipse.higgins.sts.api.client.IRequestFactory;
import org.eclipse.higgins.sts.common.AppliesTo;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.EndpointReference;
import org.eclipse.higgins.sts.common.InformationCardReference;
import org.eclipse.higgins.sts.common.RequestSecurityToken;
import org.eclipse.higgins.sts.common.STSRequest;
import org.eclipse.higgins.sts.common.SecurityInformation;
import org.eclipse.higgins.sts.common.Timestamp;
import org.eclipse.higgins.sts.common.UsernameToken;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.KeyGenHelper;

public class TokenRequestFactory
implements IRequestFactory {
    public ISTSRequest createRequestByTokenType(String strTokenType, String strUsername, String strPassword) {
        Constants constants = new Constants();
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setRequestType(constants.getIssueRequestType());
        rst.setTokenType(URI.create(strTokenType));
        STSRequest request = new STSRequest();
        SecurityInformation securityInformation = new SecurityInformation();
        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setUsername(strUsername);
        usernameToken.setPassword(strPassword);
        securityInformation.setUsernameToken((IUsernameToken)usernameToken);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createRequestByRequestType(URI requestType, String strUsername, String strPassword) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setRequestType(requestType);
        STSRequest request = new STSRequest();
        SecurityInformation securityInformation = new SecurityInformation();
        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setUsername(strUsername);
        usernameToken.setPassword(strPassword);
        securityInformation.setUsernameToken((IUsernameToken)usernameToken);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createRequestByRequestType(URI requestType, URI tokenType, String strUsername, String strPassword) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setRequestType(requestType);
        rst.setTokenType(tokenType);
        STSRequest request = new STSRequest();
        SecurityInformation securityInformation = new SecurityInformation();
        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setUsername(strUsername);
        usernameToken.setPassword(strPassword);
        securityInformation.setUsernameToken((IUsernameToken)usernameToken);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createManagedRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, String strUsername, String strPassword, IBase64Extension base64Extension) {
        STSRequest request = new STSRequest();
        RequestSecurityToken rst = new RequestSecurityToken();
        Constants constants = new Constants();
        rst.setRequestType(constants.getIssueRequestType());
        rst.setTokenType(uriTokenType);
        EndpointReference eprIssuer = new EndpointReference();
        eprIssuer.setAddress(uriTokenService);
        rst.setIssuer((IEndpointReference)eprIssuer);
        SecurityInformation securityInformation = new SecurityInformation();
        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setUsername(strUsername);
        usernameToken.setPassword(strPassword);
        securityInformation.setUsernameToken((IUsernameToken)usernameToken);
        Timestamp timestamp = new Timestamp();
        Date dateNow = new Date();
        Date dateLater = new Date(dateNow.getTime() + 604800000L);
        timestamp.setCreated(dateNow);
        timestamp.setExpires(dateLater);
        securityInformation.setTimestamp((ITimestamp)timestamp);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(informationCard.getID()));
        informationCardReference.setCardVersion("1");
        rst.setInformationCardReference((IInformationCardReference)informationCardReference);
        try {
            byte[] byteRPIdentifier = KeyGenHelper.generateRPIdentifier((X509Certificate[])certRelyingPartyChain);
            String strPPID = base64Extension.encode(KeyGenHelper.generatePPID((URI)informationCardReference.getCardId(), (byte[])byteRPIdentifier));
            String strCertificate = base64Extension.encode(certRelyingPartyChain[0].getEncoded());
            String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:PPID>" + strPPID + "</ic:PPID>" + "</ic:ClientPseudonym>";
            Element elemClientPseudonym = new Element();
            elemClientPseudonym.set((Object)strClientPseudonym);
            rst.setClientPseudonym((IElement)elemClientPseudonym);
            boolean bSendAppliesTo = false;
            Boolean boolRequireAppliesTo = null;
            if (informationCard instanceof IManagedInformationCard) {
                boolRequireAppliesTo = ((IManagedInformationCard)informationCard).getRequireAppliesTo();
            }
            if (boolRequireAppliesTo != null) {
                boolean bl = bSendAppliesTo = boolRequireAppliesTo == false;
            }
            if (uriRelyingParty != null && bSendAppliesTo) {
                AppliesTo appliesTo = new AppliesTo();
                EndpointReference epr = new EndpointReference();
                appliesTo.setEndpointReference((IEndpointReference)epr);
                epr.setAddress(uriRelyingParty);
                if (strCertificate != null) {
                    String strIdentity = "<wsid:Identity xmlns:wsid=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>" + strCertificate + "</ds:X509Certificate>" + "</ds:X509Data>" + "</ds:KeyInfo>" + "</wsid:Identity>";
                    Element elemIdentity = new Element();
                    elemIdentity.set((Object)strIdentity);
                    List listAnyOther = epr.getAnyOtherElements();
                    listAnyOther.add(elemIdentity);
                }
                rst.setAppliesTo((IAppliesTo)appliesTo);
            }
            rst.setKeyType(constants.getNoProofKeyKeyType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (claims != null) {
            rst.setClaims(claims);
        }
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createManagedRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, IElement authenticationToken, IBase64Extension base64Extension) {
        STSRequest request = new STSRequest();
        RequestSecurityToken rst = new RequestSecurityToken();
        Constants constants = new Constants();
        rst.setRequestType(constants.getIssueRequestType());
        rst.setTokenType(uriTokenType);
        EndpointReference eprIssuer = new EndpointReference();
        eprIssuer.setAddress(uriTokenService);
        rst.setIssuer((IEndpointReference)eprIssuer);
        SecurityInformation securityInformation = new SecurityInformation();
        securityInformation.addSecurityToken(authenticationToken);
        Timestamp timestamp = new Timestamp();
        Date dateNow = new Date();
        Date dateLater = new Date(dateNow.getTime() + 604800000L);
        timestamp.setCreated(dateNow);
        timestamp.setExpires(dateLater);
        securityInformation.setTimestamp((ITimestamp)timestamp);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(informationCard.getID()));
        informationCardReference.setCardVersion("1");
        rst.setInformationCardReference((IInformationCardReference)informationCardReference);
        try {
            byte[] byteRPIdentifier = KeyGenHelper.generateRPIdentifier((X509Certificate[])certRelyingPartyChain);
            String strPPID = base64Extension.encode(KeyGenHelper.generatePPID((URI)informationCardReference.getCardId(), (byte[])byteRPIdentifier));
            String strCertificate = base64Extension.encode(certRelyingPartyChain[0].getEncoded());
            String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:PPID>" + strPPID + "</ic:PPID>" + "</ic:ClientPseudonym>";
            Element elemClientPseudonym = new Element();
            elemClientPseudonym.set((Object)strClientPseudonym);
            rst.setClientPseudonym((IElement)elemClientPseudonym);
            elemClientPseudonym.set((Object)strClientPseudonym);
            rst.setClientPseudonym((IElement)elemClientPseudonym);
            boolean bSendAppliesTo = false;
            Boolean boolRequireAppliesTo = null;
            if (informationCard instanceof IManagedInformationCard) {
                boolRequireAppliesTo = ((IManagedInformationCard)informationCard).getRequireAppliesTo();
            }
            if (boolRequireAppliesTo != null) {
                boolean bl = bSendAppliesTo = boolRequireAppliesTo == false;
            }
            if (uriRelyingParty != null && bSendAppliesTo) {
                AppliesTo appliesTo = new AppliesTo();
                EndpointReference epr = new EndpointReference();
                appliesTo.setEndpointReference((IEndpointReference)epr);
                epr.setAddress(uriRelyingParty);
                if (strCertificate != null) {
                    String strIdentity = "<wsid:Identity xmlns:wsid=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>" + strCertificate + "</ds:X509Certificate>" + "</ds:X509Data>" + "</ds:KeyInfo>" + "</wsid:Identity>";
                    Element elemIdentity = new Element();
                    elemIdentity.set((Object)strIdentity);
                    List listAnyOther = epr.getAnyOtherElements();
                    listAnyOther.add(elemIdentity);
                }
                rst.setAppliesTo((IAppliesTo)appliesTo);
            }
            rst.setKeyType(constants.getNoProofKeyKeyType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (claims != null) {
            rst.setClaims(claims);
        }
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createPersonalRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, URI uriTokenType, IInformationCard informationCard, IElement claims, IBase64Extension base64Extension) {
        STSRequest request = new STSRequest();
        RequestSecurityToken rst = new RequestSecurityToken();
        Constants constants = new Constants();
        rst.setRequestType(constants.getIssueRequestType());
        rst.setTokenType(uriTokenType);
        EndpointReference eprIssuer = new EndpointReference();
        URI uriTokenService = URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self");
        eprIssuer.setAddress(uriTokenService);
        rst.setIssuer((IEndpointReference)eprIssuer);
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(informationCard.getID()));
        informationCardReference.setCardVersion("1");
        rst.setInformationCardReference((IInformationCardReference)informationCardReference);
        try {
            byte[] byteRPIdentifier = KeyGenHelper.generateRPIdentifier((X509Certificate[])certRelyingPartyChain);
            String strPPID = base64Extension.encode(KeyGenHelper.generatePPID((URI)informationCardReference.getCardId(), (byte[])byteRPIdentifier));
            String strCertificate = base64Extension.encode(certRelyingPartyChain[0].getEncoded());
            String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:PPID>" + strPPID + "</ic:PPID>" + "</ic:ClientPseudonym>";
            Element elemClientPseudonym = new Element();
            elemClientPseudonym.set((Object)strClientPseudonym);
            rst.setClientPseudonym((IElement)elemClientPseudonym);
            boolean bSendAppliesTo = true;
            if (uriRelyingParty != null && bSendAppliesTo) {
                AppliesTo appliesTo = new AppliesTo();
                EndpointReference epr = new EndpointReference();
                appliesTo.setEndpointReference((IEndpointReference)epr);
                epr.setAddress(uriRelyingParty);
                if (strCertificate != null) {
                    String strIdentity = "<wsid:Identity xmlns:wsid=\"http://schemas.xmlsoap.org/ws/2006/02/addressingidentity\"><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:X509Data><ds:X509Certificate>" + strCertificate + "</ds:X509Certificate>" + "</ds:X509Data>" + "</ds:KeyInfo>" + "</wsid:Identity>";
                    Element elemIdentity = new Element();
                    elemIdentity.set((Object)strIdentity);
                    List listAnyOther = epr.getAnyOtherElements();
                    listAnyOther.add(elemIdentity);
                }
                rst.setAppliesTo((IAppliesTo)appliesTo);
            }
            rst.setKeyType(constants.getNoProofKeyKeyType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (claims != null) {
            rst.setClaims(claims);
        }
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }
}

