/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api.client;

import java.net.URI;

import org.eclipse.higgins.sts.api.IElement;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public interface IRequestFactory
{
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByTokenType
		(String strTokenType,
		String strUsername,
		String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(java.net.URI requestType,
		String strUsername,
		String strPassword);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(java.net.URI requestType,
		java.net.URI tokenType,
		String strUsername,
		String strPassword);

	public abstract org.eclipse.higgins.sts.api.ISTSRequest createPersonalRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.net.URI uriTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final String strUsername,
		final String strPassword,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension);
	
	public abstract org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final URI uriTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final IElement authenticationToken,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension);
}
