/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.sts.client.RelyingPartyIdentifierHelper;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.KeyGenHelper;

public class PPIDHelper {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$sts$client$PPIDHelper == null ? (class$org$eclipse$higgins$sts$client$PPIDHelper = PPIDHelper.class$("org.eclipse.higgins.sts.client.PPIDHelper")) : class$org$eclipse$higgins$sts$client$PPIDHelper));
    static char[] userFriendlyPPIDValuetabe = new char[]{'Q', 'L', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static /* synthetic */ Class class$org$eclipse$higgins$sts$client$PPIDHelper;

    public static byte[] computeClaimValuePPID(IInformationCard informationCard, X509Certificate[] rp, CertStore certStore, IBase64Extension base64Extension) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        log.trace((Object)("used cardid: " + informationCard.getID()));
        byte[] canonicalCardId = md.digest(informationCard.getID().getBytes("UTF-16LE"));
        log.trace((Object)("cardid in bytes: " + canonicalCardId));
        md.reset();
        byte[] relyingPartyId = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(rp, certStore);
        md.update(relyingPartyId);
        md.update(canonicalCardId);
        log.info((Object)("CardID: " + KeyGenHelper.byteArrayToHexString((byte[])canonicalCardId)));
        byte[] res = md.digest();
        log.info((Object)("PPID: " + KeyGenHelper.byteArrayToHexString((byte[])res)));
        return res;
    }

    public static String getUserFriendlyPPID(byte[] ppid) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] ppidh = md.digest(ppid);
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            int value = ppidh[i];
            if ((value %= 32) < 0) {
                value += 32;
            }
            char A_i = userFriendlyPPIDValuetabe[value];
            res.append(A_i);
            if (i != 2 && i != 6) continue;
            res.append('-');
        }
        return res.toString();
    }

    public static String getUserFriendlyPPID(String ppid, IBase64Extension base64Extension) throws Exception {
        byte[] bppid = base64Extension.decode(ppid);
        return PPIDHelper.getUserFriendlyPPID(bppid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

