/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.sts.api.IAppliesTo;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IEndpointReference;
import org.eclipse.higgins.sts.api.IInformationCardReference;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISecurityElement;
import org.eclipse.higgins.sts.api.ISecurityInformation;
import org.eclipse.higgins.sts.api.ISecurityToken;
import org.eclipse.higgins.sts.api.client.IRequestFactory;
import org.eclipse.higgins.sts.client.PPIDHelper;
import org.eclipse.higgins.sts.client.RelyingPartyIdentifierHelper;
import org.eclipse.higgins.sts.common.AppliesTo;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.EndpointReference;
import org.eclipse.higgins.sts.common.InformationCardReference;
import org.eclipse.higgins.sts.common.RequestSecurityToken;
import org.eclipse.higgins.sts.common.STSRequest;
import org.eclipse.higgins.sts.common.SecurityInformation;
import org.eclipse.higgins.sts.common.Timestamp;
import org.eclipse.higgins.sts.common.UsernameToken;
import org.eclipse.higgins.sts.spi.IBase64Extension;
import org.eclipse.higgins.sts.utilities.KeyGenHelper;

public class TokenRequestFactory
implements IRequestFactory {
    private ISTSRequest createRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, CertStore certStore, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, IBase64Extension base64Extension) {
        STSRequest request = new STSRequest();
        RequestSecurityToken rst = new RequestSecurityToken();
        Constants constants = new Constants();
        rst.setRequestType(constants.getIssueRequestType());
        rst.setTokenType(uriTokenType);
        EndpointReference eprIssuer = new EndpointReference();
        eprIssuer.setAddress(uriTokenService);
        rst.setIssuer((IEndpointReference)eprIssuer);
        SecurityInformation securityInformation = new SecurityInformation();
        Timestamp timestamp = new Timestamp();
        Date dateNow = new Date();
        Date dateLater = new Date(dateNow.getTime() + 604800000L);
        timestamp.setCreated(dateNow);
        timestamp.setExpires(dateLater);
        securityInformation.addSecurityElement((ISecurityElement)timestamp);
        request.setSecurityInformation((ISecurityInformation)securityInformation);
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(informationCard.getID()));
        informationCardReference.setCardVersion(informationCard.getVersion());
        rst.setInformationCardReference((IInformationCardReference)informationCardReference);
        try {
            String strPPID = base64Extension.encode(PPIDHelper.computeClaimValuePPID(informationCard, certRelyingPartyChain, certStore, base64Extension));
            String strCertificate = base64Extension.encode(certRelyingPartyChain[0].getEncoded());
            String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\"><ic:PPID>" + strPPID + "</ic:PPID>" + "</ic:ClientPseudonym>";
            Element elemClientPseudonym = new Element();
            elemClientPseudonym.set((Object)strClientPseudonym);
            rst.setClientPseudonym((IElement)elemClientPseudonym);
            boolean bSendAppliesTo = false;
            Boolean boolRequireAppliesTo = null;
            if (informationCard instanceof IManagedInformationCard) {
                boolRequireAppliesTo = ((IManagedInformationCard)informationCard).getRequireAppliesTo();
                if (null != boolRequireAppliesTo) {
                    bSendAppliesTo = boolRequireAppliesTo == false;
                }
            } else {
                bSendAppliesTo = true;
            }
            if (null != uriRelyingParty && bSendAppliesTo) {
                AppliesTo appliesTo = new AppliesTo();
                EndpointReference epr = new EndpointReference();
                appliesTo.setEndpointReference((IEndpointReference)epr);
                epr.setAddress(uriRelyingParty);
                if (null != strCertificate && informationCard instanceof IManagedInformationCard) {
                    epr.setIdentityCertificate(strCertificate);
                }
                rst.setAppliesTo((IAppliesTo)appliesTo);
            }
            rst.setKeyType(constants.getNoProofKeyKeyType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != claims) {
            rst.setClaims(claims);
        }
        List listRST = request.getRequestSecurityTokenCollection();
        listRST.add(rst);
        return request;
    }

    public ISTSRequest createManagedRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, CertStore certStore, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, String strUsername, String strPassword, IBase64Extension base64Extension) {
        ISTSRequest request = this.createRequest(uriRelyingParty, certRelyingPartyChain, certStore, uriTokenService, uriTokenType, informationCard, claims, base64Extension);
        ISecurityInformation securityInformation = request.getSecurityInformation();
        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setUsername(strUsername);
        usernameToken.setPassword(strPassword);
        securityInformation.addSecurityElement((ISecurityElement)usernameToken);
        return request;
    }

    public ISTSRequest createManagedRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, CertStore certStore, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, ISecurityToken authenticationToken, IBase64Extension base64Extension) {
        ISTSRequest request = this.createRequest(uriRelyingParty, certRelyingPartyChain, certStore, uriTokenService, uriTokenType, informationCard, claims, base64Extension);
        ISecurityInformation securityInformation = request.getSecurityInformation();
        securityInformation.addSecurityElement((ISecurityElement)authenticationToken);
        return request;
    }

    public ISTSRequest createManagedRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, CertStore certStore, URI uriTokenService, URI uriTokenType, IInformationCard informationCard, IElement claims, PrivateKey authenticationKey, ISecurityToken authenticationToken, IBase64Extension base64Extension) {
        ISTSRequest request = this.createRequest(uriRelyingParty, certRelyingPartyChain, certStore, uriTokenService, uriTokenType, informationCard, claims, base64Extension);
        ISecurityInformation securityInformation = request.getSecurityInformation();
        securityInformation.addSecurityElement((ISecurityElement)authenticationToken);
        securityInformation.setAuthenticationKey((Key)authenticationKey);
        return request;
    }

    public ISTSRequest createPersonalRequest(URI uriRelyingParty, X509Certificate[] certRelyingPartyChain, CertStore certStore, URI uriTokenType, IInformationCard informationCard, IElement claims, IBase64Extension base64Extension) {
        ISTSRequest request = this.createRequest(uriRelyingParty, certRelyingPartyChain, certStore, URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self"), uriTokenType, informationCard, claims, base64Extension);
        try {
            byte[] byteRPIdentifier = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(certRelyingPartyChain, certStore);
            KeyPair kpSelf = KeyGenHelper.generateRSAKeyPair((IBase64Extension)base64Extension, (byte[])informationCard.getMasterKey(), (byte[])byteRPIdentifier, (int)2048);
            request.setSelfSigningKeyPair(kpSelf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return request;
    }
}

