/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client;

import java.net.URI;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.client.IRequestFactory;
import org.eclipse.higgins.sts.common.STSRequest;

/**
 * @author mikemci at us dot ibm dot com
 *
 */
public class TokenRequestFactory implements IRequestFactory
{
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.client.IRequestFactory#createRSTByTokenType(java.lang.String)
	 */
	/*
	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByTokenType
		(final String strTokenType,
		final String strUsername,
		final String strPassword)
	{
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		final org.eclipse.higgins.sts.common.RequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(constants.getIssueRequestType());
		rst.setTokenType(java.net.URI.create(strTokenType));
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}

	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(final java.net.URI requestType,
		final String strUsername,
		final String strPassword)
	{	
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(requestType);		
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	
	public org.eclipse.higgins.sts.api.ISTSRequest createRequestByRequestType
		(final java.net.URI requestType,
        final java.net.URI tokenType,
		final String strUsername,
		final String strPassword)
	{	
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		rst.setRequestType(requestType);
		rst.setTokenType(tokenType);
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		request.setSecurityInformation(securityInformation);
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	*/
	
	private org.eclipse.higgins.sts.api.ISTSRequest createRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final java.net.URI uriTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension)
	{
		final ISTSRequest request = new STSRequest();
		final org.eclipse.higgins.sts.api.IRequestSecurityToken rst = new org.eclipse.higgins.sts.common.RequestSecurityToken();
		final org.eclipse.higgins.sts.api.IConstants constants = new org.eclipse.higgins.sts.common.Constants();
		rst.setRequestType(constants.getIssueRequestType());
		rst.setTokenType(uriTokenType);	
		final org.eclipse.higgins.sts.api.IEndpointReference eprIssuer = new org.eclipse.higgins.sts.common.EndpointReference();
		eprIssuer.setAddress(uriTokenService);
		rst.setIssuer(eprIssuer);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = new org.eclipse.higgins.sts.common.SecurityInformation();
		final org.eclipse.higgins.sts.api.ITimestamp timestamp = new org.eclipse.higgins.sts.common.Timestamp();
		final java.util.Date dateNow = new java.util.Date();
		final java.util.Date dateLater = new java.util.Date(dateNow.getTime() + (1000*60*60*24*7));
		timestamp.setCreated(dateNow);
		timestamp.setExpires(dateLater);
		securityInformation.addSecurityElement(timestamp);
		request.setSecurityInformation(securityInformation);
		final org.eclipse.higgins.sts.api.IInformationCardReference informationCardReference = new org.eclipse.higgins.sts.common.InformationCardReference();
		informationCardReference.setCardId(java.net.URI.create(informationCard.getID()));
		informationCardReference.setCardVersion(informationCard.getVersion());
		rst.setInformationCardReference(informationCardReference);
		try
		{
			final String strPPID = base64Extension.encode
				(PPIDHelper.computeClaimValuePPID( informationCard, certRelyingPartyChain, certStore, base64Extension));
			final String strCertificate = base64Extension.encode(certRelyingPartyChain[0].getEncoded());
			final String strClientPseudonym = "<ic:ClientPseudonym xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">"
				+ "<ic:PPID>"
				+ strPPID
				+ "</ic:PPID>"
				+ "</ic:ClientPseudonym>";
			final org.eclipse.higgins.sts.api.IElement elemClientPseudonym = new org.eclipse.higgins.sts.common.Element();
			elemClientPseudonym.set(strClientPseudonym);
			rst.setClientPseudonym(elemClientPseudonym);
			boolean bSendAppliesTo = false;
			java.lang.Boolean boolRequireAppliesTo = null;
			if (informationCard instanceof IManagedInformationCard)
			{
				boolRequireAppliesTo = ((IManagedInformationCard) informationCard).getRequireAppliesTo();
				if (null != boolRequireAppliesTo)
					bSendAppliesTo = !(boolRequireAppliesTo.booleanValue());
			}
			else
			{
				bSendAppliesTo = true;
			}

			if ((null != uriRelyingParty) && (bSendAppliesTo))
			{
				final org.eclipse.higgins.sts.api.IAppliesTo appliesTo = new org.eclipse.higgins.sts.common.AppliesTo();
				final org.eclipse.higgins.sts.api.IEndpointReference epr = new org.eclipse.higgins.sts.common.EndpointReference();
				appliesTo.setEndpointReference(epr);
				epr.setAddress(uriRelyingParty);
				if ((null != strCertificate) && (informationCard instanceof IManagedInformationCard))
				{
					epr.setIdentityCertificate(strCertificate);
				}
				rst.setAppliesTo(appliesTo);
			}
			rst.setKeyType(constants.getNoProofKeyKeyType());
		}
		catch (final Exception e)
		{
			e.printStackTrace();
		}

		if (null != claims) {
			rst.setClaims(claims);
		}
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		listRST.add(rst);
		return request;
	}
	
	public org.eclipse.higgins.sts.api.ISTSRequest createManagedRequest
		(final java.net.URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final java.net.URI uriTokenService,
		final java.net.URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final org.eclipse.higgins.sts.api.IElement claims,
		final String strUsername,
		final String strPassword,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			uriTokenType,
			informationCard,
			claims,
			base64Extension);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		final org.eclipse.higgins.sts.api.IUsernameToken usernameToken = new org.eclipse.higgins.sts.common.UsernameToken();
		usernameToken.setUsername(strUsername);
		usernameToken.setPassword(strPassword);
		securityInformation.addSecurityElement(usernameToken);
		return request;
	}

	public ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			uriTokenType,
			informationCard,
			claims,
			base64Extension);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		securityInformation.addSecurityElement(authenticationToken);
		return request;
	}

	public ISTSRequest createManagedRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenService,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final java.security.PrivateKey authenticationKey,
		final org.eclipse.higgins.sts.api.ISecurityToken authenticationToken,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			uriTokenService,
			uriTokenType,
			informationCard,
			claims,
			base64Extension);
		final org.eclipse.higgins.sts.api.ISecurityInformation securityInformation = request.getSecurityInformation();
		securityInformation.addSecurityElement(authenticationToken);
		securityInformation.setAuthenticationKey(authenticationKey);
		return request;
	}

	public ISTSRequest createPersonalRequest
		(final URI uriRelyingParty,
		final java.security.cert.X509Certificate [] certRelyingPartyChain,
		final java.security.cert.CertStore certStore,
		final URI uriTokenType,
		final org.eclipse.higgins.icard.IInformationCard informationCard,
		final IElement claims,
		final org.eclipse.higgins.sts.spi.IBase64Extension base64Extension)
	{
		final ISTSRequest request = createRequest
			(uriRelyingParty,
			certRelyingPartyChain,
			certStore,
			java.net.URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self"),
			uriTokenType,
			informationCard,
			claims,
			base64Extension);
		try
		{
			byte [] byteRPIdentifier = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier
				(certRelyingPartyChain, certStore);
			java.security.KeyPair kpSelf = org.eclipse.higgins.sts.utilities.KeyGenHelper.generateRSAKeyPair
				(base64Extension,
				informationCard.getMasterKey(),
				byteRPIdentifier,
				2048);
			request.setSelfSigningKeyPair(kpSelf);
		}
		catch (final Exception e)
		{
			e.printStackTrace();
		}
		return request;
	}
}
