/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client;

import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Implements the Higgins Security Token Service Client.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
public class SecurityTokenService
	implements org.eclipse.higgins.sts.api.ISecurityTokenService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenService.class.getName());
	
	org.eclipse.higgins.sts.api.ISecurityTokenService bindingSecurityTokenServiceClient = null;
	
	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected SecurityTokenService()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.client.ISecurityTokenService#configure()
	 */
	public void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings)
	{
		this.log.trace("SecurityTokenService::initialize");
		
		this.bindingSecurityTokenServiceClient = (org.eclipse.higgins.sts.api.ISecurityTokenService)mapGlobalSettings.get
			("SecurityTokenServiceBinding");
		
		this.bInitialized = true;
	}

	/**
	 *  Called to send an RST.
	 */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
    {
		this.log.trace("SecurityTokenService::invoke");

		if (!this.bInitialized)
		{
			String errMsg = MsgHelper.getString(MsgHelper.not_initialized);

			this.log.error(errMsg);
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				errMsg);
			response.setFault(fault);			
			return;
		}
		this.bindingSecurityTokenServiceClient.invoke
			(mapGlobalSettings,
			strComponentName,
			mapComponentSettings,
			mapInvocationSettings,
			constants,
			request,
			response);
    }
}
