/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.client;

/**
 * Implements the IObjectFactory that creates the SecurityTokenService implementation.
 * 
 * @author mikemci at us dot ibm dot com
 */
public class SecurityTokenServiceFactory
	implements org.eclipse.higgins.configuration.api.IConfigurableComponentFactory
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenServiceFactory.class.getName());

	/**
	 * The singleton instance
	 */
	private static SecurityTokenService theInstance = null;

	/**
	 * Provides access to the singleton instance
	 * 
	 * @return the singleton instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getSingletonInstance()
	{
		if (null == SecurityTokenServiceFactory.theInstance)
		{
			try
			{
				SecurityTokenServiceFactory.theInstance = new SecurityTokenService();
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);	
	    		return null;
    		}
		}
		return SecurityTokenServiceFactory.theInstance;
	}
	
	/**
	 * Provides access to the new instance
	 * 
	 * @return the new instance
	 */
	public org.eclipse.higgins.configuration.api.IConfigurableComponent getNewInstance()
	{
		SecurityTokenService newInstance = null;
		try
		{
		    newInstance = new SecurityTokenService();
		}
		catch (Exception e)
		{
			org.eclipse.higgins.sts.utilities.ExceptionHelper.Log(log, e);
		    return null;
		}
		return newInstance;
	}

}

