/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.client;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PPIDHelper {
	protected static final Log log = LogFactory.getLog(PPIDHelper.class);

	// ppid as claim value ( page 43 of Cardspace tech ref)
	static public byte[] computeClaimValuePPID
		(final org.eclipse.higgins.icard.IInformationCard informationCard,
		final X509Certificate [] rp,
		java.security.cert.CertStore certStore)
		throws Exception {
		// get card id
		java.security.MessageDigest md = java.security.MessageDigest
				.getInstance("SHA-256");
		log.trace("used cardid: " + informationCard.getID());
		//informationCard.getID();
		byte[] canonicalCardId = md.digest(informationCard.getID().getBytes(
				"UTF-16LE"));
		log.trace("cardid in bytes: " + canonicalCardId);
		md.reset();

		// get relying party identifier
		byte[] relyingPartyId = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(rp, certStore);

		md.update(relyingPartyId);
		md.update(canonicalCardId);
		
		log.info("CardID: " + org.eclipse.higgins.sts.utilities.KeyGenHelper.byteArrayToHexString(canonicalCardId));

		byte[] res = md.digest();
		
		log.info("PPID: " + org.eclipse.higgins.sts.utilities.KeyGenHelper.byteArrayToHexString(res));

		return res;
	}

	static char[] userFriendlyPPIDValuetabe = { 'Q', 'L', '2', '3', '4', '5',
			'6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J',
			'K', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z' };

	public static String getUserFriendlyPPID(byte[] ppid)
			throws NoSuchAlgorithmException {
		java.security.MessageDigest md = java.security.MessageDigest
				.getInstance("SHA-1");
		byte[] ppidh = md.digest(ppid);

		StringBuffer res = new StringBuffer();
		for (int i = 0; i < 10; i++) {
			int value = ppidh[i];
			value = value % 32;
			if (value < 0) {
				value = value + 32;
			}
			char A_i = userFriendlyPPIDValuetabe[value];
			res.append(A_i);
			if (i == 2 || i == 6) {
				res.append('-');
			}
		}

		return res.toString();
	}

	public static String getUserFriendlyPPID(String ppid) throws Exception {
		// decode base 64
		byte[] bppid = org.apache.commons.codec.binary.Base64.decodeBase64(ppid.getBytes());
		// compute user friendly ppid
		return getUserFriendlyPPID(bppid);
	}
}
