/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.sts.utilities.CertificateHelper;
import org.eclipse.higgins.sts.utilities.KeyGenHelper;

public class RelyingPartyIdentifierHelper {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierHelper == null ? (class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierHelper = RelyingPartyIdentifierHelper.class$("org.eclipse.higgins.sts.client.RelyingPartyIdentifierHelper")) : class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierHelper));
    public static String[] ev_policies_oids = new String[]{"1.3.6.1.4.1.6449.1.2.1.5.1", "1.3.6.1.4.1.6334.1.100.1", "2.16.840.1.114412.2.1", "2.16.840.1.114028.10.1.2", "1.3.6.1.4.1.14370.1.6", "2.16.840.1.114413.1.7.23.3", "1.3.6.1.4.1.8024.0.2.100.1.2", "2.16.840.1.114414.1.7.23.3", "2.16.840.1.113733.1.7.48.1", "2.16.840.1.113733.1.7.23.6"};
    static /* synthetic */ Class class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierHelper;

    public static String getOrgIdString(X509Certificate rp) {
        String dnName = rp.getSubjectDN().getName();
        log.trace((Object)("Subject DN of certificate: " + dnName));
        String O_string = "O=\"\"";
        String L_string = "L=\"\"";
        String S_string = "S=\"\"";
        String C_string = "C=\"\"";
        List strArr = RelyingPartyIdentifierHelper.splitAttributesOfSubjectName(dnName);
        for (int i = 0; i < strArr.size(); ++i) {
            String temp = (String)strArr.get(i);
            if (temp.startsWith("O=")) {
                if (temp.charAt(2) == '\"') {
                    O_string = temp;
                    continue;
                }
                O_string = "O=\"" + temp.substring(2) + "\"";
                continue;
            }
            if (temp.startsWith("L=")) {
                if (temp.charAt(2) == '\"') {
                    L_string = temp;
                    continue;
                }
                L_string = "L=\"" + temp.substring(2) + "\"";
                continue;
            }
            if (temp.startsWith("S=")) {
                if (temp.charAt(2) == '\"') {
                    S_string = temp;
                    continue;
                }
                S_string = "S=\"" + temp.substring(2) + "\"";
                continue;
            }
            if (temp.startsWith("ST=")) {
                if (temp.charAt(3) == '\"') {
                    S_string = temp;
                    continue;
                }
                S_string = "S=\"" + temp.substring(3) + "\"";
                continue;
            }
            if (!temp.startsWith("C=")) continue;
            C_string = temp.charAt(2) == '\"' ? temp : "C=\"" + temp.substring(2) + "\"";
        }
        String res = "|" + O_string + "|" + L_string + "|" + S_string + "|" + C_string + "|";
        log.trace((Object)("org id string is: " + res));
        return res;
    }

    public static List findSplitCommaPositions(String n) {
        char[] chars = n.toCharArray();
        ArrayList<Integer> res = new ArrayList<Integer>();
        boolean withinQuotes = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                withinQuotes = !withinQuotes;
                continue;
            }
            if (c != ',' || withinQuotes) continue;
            res.add(new Integer(i));
        }
        return res;
    }

    public static List splitAttributesOfSubjectName(String name) {
        ArrayList<String> res = new ArrayList<String>();
        List commaPos = RelyingPartyIdentifierHelper.findSplitCommaPositions(name);
        log.trace((Object)("Comma pos: " + commaPos));
        if (commaPos.size() == 0) {
            res.add(name);
            return res;
        }
        int beginIndex = 0;
        int endIndex = -1;
        Iterator iter = commaPos.iterator();
        while (iter.hasNext()) {
            Integer element = (Integer)iter.next();
            endIndex = element;
            String attr = name.substring(beginIndex, endIndex);
            res.add(attr);
            log.trace((Object)("Found attribute: " + attr));
            beginIndex = endIndex + 2;
        }
        String attr = name.substring(beginIndex);
        res.add(attr);
        log.trace((Object)("Found attribute: " + attr));
        return res;
    }

    public static String getCertPathString(X509Certificate cert) {
        String name_RFC1779 = cert.getSubjectX500Principal().getName("RFC1779");
        String name_toString = cert.getSubjectX500Principal().toString();
        log.trace((Object)("name_RFC1779:  " + name_RFC1779));
        log.trace((Object)("name_toString: " + name_toString));
        log.trace((Object)("subject dn:    " + cert.getSubjectDN()));
        int pathLength = cert.getBasicConstraints();
        log.trace((Object)("Path length: " + pathLength));
        List attributes = RelyingPartyIdentifierHelper.splitAttributesOfSubjectName(name_RFC1779);
        ArrayList<String> attributesTransformed = new ArrayList<String>();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            int pos_equalSign = element.indexOf("=");
            String attrID = element.substring(0, pos_equalSign);
            String attrValue = element.substring(pos_equalSign + 1);
            X500_Oid_HashTable x500Table = new X500_Oid_HashTable();
            String attrIDTrans = X500_Oid_HashTable.transform(attrID);
            String attrValueTrans = attrValue;
            String transformed = attrIDTrans + "=" + attrValueTrans;
            log.trace((Object)("transformed is: " + transformed));
            attributesTransformed.add(transformed);
        }
        String res = (String)attributesTransformed.get(0);
        for (int i = 1; i < attributesTransformed.size(); ++i) {
            res = res + ", " + (String)attributesTransformed.get(i);
        }
        return "|ChainElement=\"" + res + "\"";
    }

    public static boolean isExtendendValidationCertificate(X509Certificate rp) {
        String s_rp = rp.toString();
        for (int i = 0; i < ev_policies_oids.length; ++i) {
            if (s_rp.indexOf(ev_policies_oids[i]) == -1) continue;
            log.trace((Object)("certificate is ev and contains oid: " + ev_policies_oids[i]));
            return true;
        }
        log.trace((Object)"Certificate is not ev");
        return false;
    }

    public static boolean hasNoOrganizationalIdentifierAttributes(X509Certificate rp) {
        String orgIdString = RelyingPartyIdentifierHelper.getOrgIdString(rp);
        return orgIdString.equals("|O=\"\"|L=\"\"|S=\"\"|C=\"\"|");
    }

    public static boolean isRootCertificate(X509Certificate cert) {
        String issuer_dn = null;
        issuer_dn = ((Object)cert.getIssuerDN()).toString();
        String subject_dn = ((Object)cert.getSubjectDN()).toString();
        return issuer_dn.equals(subject_dn);
    }

    public static String getQualifiedOrgIdString(List certPath) throws Exception {
        if (certPath.size() == 0) {
            throw new Exception("certificate path is empty");
        }
        X509Certificate rp = (X509Certificate)certPath.get(0);
        String orgIdString = RelyingPartyIdentifierHelper.getOrgIdString(rp);
        String res = "";
        for (int i = 1; i < certPath.size(); ++i) {
            X509Certificate cert = (X509Certificate)certPath.get(i);
            String certPathString = RelyingPartyIdentifierHelper.getCertPathString(cert);
            log.trace((Object)("next chain element for qualified org id string: " + certPathString));
            res = certPathString + res;
        }
        res = res + orgIdString;
        log.trace((Object)("Qualified org id string is: " + res));
        return res;
    }

    public static List extendPath(List path) {
        try {
            log.trace((Object)"Extending path ...");
            String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            FileInputStream is = new FileInputStream(filename);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            String password = "changeit";
            keystore.load(is, password.toCharArray());
            PKIXParameters params = new PKIXParameters(keystore);
            params.setRevocationEnabled(false);
            ArrayList ll = new ArrayList();
            ll.add(path.get(path.size() - 1));
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            CertPath certPath = certFact.generateCertPath(ll);
            CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            CertPathValidatorResult result = certPathValidator.validate(certPath, params);
            PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)result;
            TrustAnchor ta = pkixResult.getTrustAnchor();
            X509Certificate cert = ta.getTrustedCert();
            log.trace((Object)("Extending path by: " + cert + "\n"));
            path.add(cert);
            if (!RelyingPartyIdentifierHelper.isRootCertificate(cert)) {
                return RelyingPartyIdentifierHelper.extendPath(path);
            }
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return path;
        }
    }

    public static String hostnameByCertficate(X509Certificate cert) throws Exception {
        String dnName = cert.getSubjectDN().getName();
        log.trace((Object)("Subject DN of certificate: " + dnName));
        String hostname = null;
        List strArr = RelyingPartyIdentifierHelper.splitAttributesOfSubjectName(dnName);
        for (int i = 0; i < strArr.size(); ++i) {
            String temp = (String)strArr.get(i);
            if (!temp.startsWith("CN=")) continue;
            hostname = temp.substring(3);
            break;
        }
        if (hostname == null) {
            throw new Exception("host not found in x509 certificate");
        }
        return hostname;
    }

    public static byte[] getRelyingPartyIdentifier(X509Certificate[] rpCertPath, CertStore certStore) throws Exception {
        byte[] idBytes;
        log.info((Object)"getRelyingPartyIdentifier");
        X509Certificate[] certPath = RelyingPartyIdentifierHelper.normalizeCertificateChain(rpCertPath, certStore);
        X509Certificate leaf = certPath[0];
        String strIssuerDN = leaf.getIssuerDN().getName();
        String strSubjectDN = leaf.getSubjectDN().getName();
        if (RelyingPartyIdentifierHelper.isExtendendValidationCertificate(leaf)) {
            log.info((Object)"isExtendendValidationCertificate");
            String orgIdString = RelyingPartyIdentifierHelper.getOrgIdString(leaf);
            log.info((Object)("orgIdString: " + orgIdString));
            idBytes = orgIdString.getBytes("UTF-16LE");
        } else if (RelyingPartyIdentifierHelper.hasNoOrganizationalIdentifierAttributes(leaf)) {
            log.info((Object)"hasNoOrganizationalIdentifierAttributes");
            idBytes = leaf.getPublicKey().getEncoded();
        } else {
            log.info((Object)"hasOrganizationalIdentifierAttributes");
            List<X509Certificate> path_asList = new ArrayList<X509Certificate>();
            log.info((Object)"*****BEGIN CERT PATH*****");
            for (int i = 0; i < certPath.length; ++i) {
                path_asList.add(certPath[i]);
                log.info((Object)("Certificate " + i + " :" + certPath[i]));
            }
            log.info((Object)"*****END CERT PATH*****");
            if (!strIssuerDN.equals(strSubjectDN)) {
                path_asList = RelyingPartyIdentifierHelper.extendPath(path_asList);
            }
            String qualifiedOrgIdString = RelyingPartyIdentifierHelper.getQualifiedOrgIdString(path_asList);
            log.info((Object)("qualifiedOrgIdString: " + qualifiedOrgIdString));
            idBytes = qualifiedOrgIdString.getBytes("UTF-16LE");
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(idBytes);
        byte[] res = md.digest();
        log.info((Object)("RPID: " + KeyGenHelper.byteArrayToHexString((byte[])res)));
        return res;
    }

    public static byte[] getRelyingPartyIdentifier(String hostname, CertStore certStore) throws Exception {
        X509Certificate[] certPath = RelyingPartyIdentifierHelper.getCertificateChain(hostname);
        return RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(certPath, certStore);
    }

    public static byte[] getRelyingPartyIdentifier(X509Certificate rp, CertStore certStore) throws Exception {
        String hostname = RelyingPartyIdentifierHelper.hostnameByCertficate(rp);
        byte[] rpid = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(hostname, certStore);
        return rpid;
    }

    public static X509Certificate[] normalizeCertificateChain(X509Certificate[] certs, CertStore certStore) throws Exception {
        X509CertSelector x509CertSelector = new X509CertSelector();
        ArrayList<X509Certificate> listCerts = new ArrayList<X509Certificate>();
        Hashtable<String, X509Certificate> mapSubjectToCert = new Hashtable<String, X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            listCerts.add(certs[i]);
            mapSubjectToCert.put(certs[i].getSubjectDN().getName(), certs[i]);
        }
        X509Certificate leaf = CertificateHelper.findLeafFromCertificates(listCerts);
        ArrayList<X509Certificate> listCertPath = new ArrayList<X509Certificate>();
        listCertPath.add(leaf);
        log.info((Object)"Building Cert Chain In Order ...");
        String strIssuerDN = leaf.getIssuerDN().getName();
        String strSubjectDN = leaf.getSubjectDN().getName();
        log.info((Object)("Subject: " + strSubjectDN + " Issuer: " + strIssuerDN));
        X509Certificate x509Previous = leaf;
        while (!strIssuerDN.equals(strSubjectDN)) {
            x509CertSelector.setSubject(strIssuerDN);
            Collection<? extends Certificate> collCertificates = certStore.getCertificates(x509CertSelector);
            X509Certificate cert = null;
            if (0 == collCertificates.size()) {
                cert = (X509Certificate)mapSubjectToCert.get(strIssuerDN);
            } else if (1 == collCertificates.size()) {
                cert = (X509Certificate)collCertificates.iterator().next();
            } else {
                log.error((Object)("CertStore contains multiple certificates for Subject: " + strIssuerDN + " using first certificate - path not unique."));
                cert = (X509Certificate)collCertificates.iterator().next();
            }
            if (null == cert || x509Previous == cert) break;
            x509Previous = cert;
            listCertPath.add(cert);
            strIssuerDN = cert.getIssuerDN().getName();
            strSubjectDN = cert.getSubjectDN().getName();
            log.info((Object)("Subject: " + strSubjectDN + " Issuer: " + strIssuerDN));
        }
        X509Certificate[] certPath = new X509Certificate[listCertPath.size()];
        for (int i = 0; i < listCertPath.size(); ++i) {
            certPath[i] = (X509Certificate)listCertPath.get(i);
        }
        return certPath;
    }

    public static X509Certificate[] getCertificateChain(String hostname) throws Exception {
        X509Certificate cert;
        log.info((Object)"getCertificateChain");
        int port = 443;
        SSLSocketFactory factory = HttpsURLConnection.getDefaultSSLSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(hostname, port);
        socket.startHandshake();
        X509Certificate[] rpCertPath = (X509Certificate[])socket.getSession().getPeerCertificates();
        if (rpCertPath.length == 0) {
            throw new Exception("no certificates in path of host: " + hostname);
        }
        socket.close();
        ArrayList<X509Certificate> listCerts = new ArrayList<X509Certificate>();
        Hashtable<String, X509Certificate> mapSubjectToCert = new Hashtable<String, X509Certificate>();
        for (int i = 0; i < rpCertPath.length; ++i) {
            listCerts.add(rpCertPath[i]);
            mapSubjectToCert.put(rpCertPath[i].getSubjectDN().getName(), rpCertPath[i]);
        }
        X509Certificate rp0 = CertificateHelper.findLeafFromCertificates(listCerts);
        ArrayList listCertPath = new ArrayList();
        X509Certificate[] certPath = new X509Certificate[rpCertPath.length];
        certPath[0] = rp0;
        int iCerts = 1;
        log.info((Object)"Building Cert Chain In Order ...");
        String strIssuerDN = rp0.getIssuerDN().getName();
        String strSubjectDN = rp0.getSubjectDN().getName();
        log.info((Object)("Subject: " + strSubjectDN + " Issuer: " + strIssuerDN));
        while (!strIssuerDN.matches(strSubjectDN) && null != (cert = (X509Certificate)mapSubjectToCert.get(strIssuerDN))) {
            certPath[iCerts++] = cert;
            strIssuerDN = cert.getIssuerDN().getName();
            strSubjectDN = cert.getSubjectDN().getName();
            log.info((Object)("Subject: " + strSubjectDN + " Issuer: " + strIssuerDN));
        }
        return certPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class X500_Oid_HashTable {
        static Map map = new HashMap();

        public X500_Oid_HashTable() {
            map.put("2.5.4.3", "CN");
            map.put("2.5.4.4", "SN");
            map.put("2.5.4.6", "C");
            map.put("2.5.4.7", "L");
            map.put("2.5.4.8", "S");
            map.put("2.5.4.9", "street");
            map.put("2.5.4.10", "O");
            map.put("2.5.4.11", "OU");
            map.put("2.5.4.12", "T");
            map.put("0.9.2342.19200300.100.1.25", "DC");
            map.put("0.9.2342.19200300.100.1.1", "UID");
            map.put("1.2.840.113549.1.9.1", "E");
        }

        public static String transform(String attrID) {
            if (attrID.startsWith("OID.")) {
                String oid = attrID.substring(4);
                String keyName = (String)map.get(oid);
                if (keyName == null) {
                    return attrID;
                }
                return keyName;
            }
            if (attrID.equals("ST")) {
                return "S";
            }
            return attrID;
        }
    }
}

