/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.util.LinkedHashMap;

public class DNParser {
    private static final char SEP = '=';
    private static final char QUOTE = '\"';
    private static final char DELIM = ',';
    private static final char ESCAPE = '\\';

    public static LinkedHashMap parse(String dn) throws Exception {
        LinkedHashMap<String, String> dnMap = new LinkedHashMap<String, String>();
        boolean isKeyProcessed = true;
        boolean startedQuote = false;
        String key = "";
        StringBuffer currentToken = new StringBuffer();
        char current = '\u0000';
        char previous = '\u0000';
        int size = dn.length();
        for (int i = 0; i < size; ++i) {
            previous = current;
            current = dn.charAt(i);
            if (current == '=') {
                if (isKeyProcessed) {
                    key = currentToken.toString();
                    currentToken = new StringBuffer();
                    isKeyProcessed = false;
                    continue;
                }
                if (startedQuote) {
                    currentToken.append(current);
                    continue;
                }
                throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
            }
            if (current == '\\') {
                if (previous != '\\') continue;
                currentToken.append(current);
                continue;
            }
            if (current == '\"') {
                if (previous == '\\') {
                    currentToken.append(current);
                    continue;
                }
                if (!isKeyProcessed) {
                    startedQuote = !startedQuote;
                    currentToken.append(current);
                    continue;
                }
                throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
            }
            if (current == ',') {
                if (previous == '\\') {
                    currentToken.append(current);
                    continue;
                }
                if (!isKeyProcessed) {
                    if (startedQuote) {
                        currentToken.append(current);
                        continue;
                    }
                    String value = currentToken.toString();
                    dnMap.put(key.trim(), value.trim());
                    isKeyProcessed = true;
                    startedQuote = false;
                    key = "";
                    currentToken = new StringBuffer();
                    continue;
                }
                throw new Exception("Unexpected symbol at possition " + i + ", " + dn);
            }
            currentToken.append(current);
        }
        if (!isKeyProcessed) {
            String value = currentToken.toString();
            String previousVal = dnMap.put(key.trim(), value.trim());
            if (previousVal != null) {
                throw new Exception(dn + " DN contains duplicated key " + key);
            }
        }
        return dnMap;
    }
}

