/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.client;

import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.registry.KeyStoreRegistry;
import org.eclipse.higgins.sts.client.DNParser;

public class RelyingPartyIdentifierV15Helper {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierV15Helper == null ? (class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierV15Helper = RelyingPartyIdentifierV15Helper.class$("org.eclipse.higgins.sts.client.RelyingPartyIdentifierV15Helper")) : class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierV15Helper));
    static /* synthetic */ Class class$org$eclipse$higgins$sts$client$RelyingPartyIdentifierV15Helper;

    public static byte[] getRelyingPartyIdentifier(String rpURL, X509Certificate[] certificateChain) throws Exception {
        return RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifier(rpURL, certificateChain, true);
    }

    public static byte[] getRelyingPartyIdentifierForProofKey(String rpURL, X509Certificate[] certificateChain) throws Exception {
        return RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifier(rpURL, certificateChain, false);
    }

    private static byte[] getRelyingPartyIdentifier(String rpURL, X509Certificate[] certificateChain, boolean forPPID) throws Exception {
        if (certificateChain != null && certificateChain.length > 0) {
            return RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifier(certificateChain, forPPID);
        }
        if (rpURL != null) {
            return RelyingPartyIdentifierV15Helper.getRelyingPartyIdentifier(rpURL);
        }
        throw new Exception("Either certificate or URL required to generate relying party identifier.");
    }

    private static byte[] getRelyingPartyIdentifier(X509Certificate[] certificateChain, boolean forPPID) throws Exception {
        IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
        X509Certificate leaf = securityService.findLeafFromCertificates(certificateChain);
        String subjDN = leaf.getSubjectX500Principal().getName();
        LinkedHashMap subjHash = DNParser.parse(subjDN);
        log.debug((Object)("Certificate chain size : " + certificateChain.length));
        if (log.isDebugEnabled()) {
            int k = certificateChain.length;
            for (int i = 0; i < k; ++i) {
                log.debug((Object)("Certificate " + i + " : /n" + Base64.encode((byte[])certificateChain[i].getEncoded()) + " \n" + certificateChain[i].getSubjectDN().getName()));
            }
        }
        boolean isCertificateValid = securityService.validateCertificateChain(null, certificateChain, null);
        boolean isEVCertificate = securityService.extendendValidationCertificateChain(null, certificateChain, null);
        String organization = (String)subjHash.get("O");
        String commonName = (String)subjHash.get("CN");
        log.debug((Object)("isCertificateValid=" + isCertificateValid + ", isEVCertificate=" + isEVCertificate + ", O=" + organization + ", CN=" + commonName));
        if (isEVCertificate && isCertificateValid) {
            log.debug((Object)"Case 1: RP's certificate is EV for organizational identifier attributes and chains to a trusted root certificate authority");
            String orgId = RelyingPartyIdentifierV15Helper.getOrgIdString(subjHash);
            log.debug((Object)("orgId : " + orgId));
            byte[] orgIdB = orgId.getBytes("UTF-16LE");
            return RelyingPartyIdentifierV15Helper.getSHA256Digest(orgIdB);
        }
        if (isCertificateValid && !RelyingPartyIdentifierV15Helper.isEmpty(organization)) {
            log.debug((Object)"Case 2: RP's certificate is not EV for organizational identifier attributes, has a non-empty Organization (O) value, and chains to a trusted root certificate authority");
            String orgId = null;
            orgId = forPPID ? RelyingPartyIdentifierV15Helper.getOrgIdString(subjHash) : "|Non-EV" + RelyingPartyIdentifierV15Helper.getOrgIdString(subjHash);
            log.debug((Object)("orgId : " + orgId));
            byte[] orgIdB = orgId.getBytes("UTF-16LE");
            return RelyingPartyIdentifierV15Helper.getSHA256Digest(orgIdB);
        }
        if (!isCertificateValid || RelyingPartyIdentifierV15Helper.isEmpty(organization) && RelyingPartyIdentifierV15Helper.isEmpty(commonName)) {
            log.debug((Object)"Case 3: RP's certificate has an empty or no Organization (O) value and has an empty or no Common Name (CN) or does not chain to a trusted root certificate authority");
            byte[] pKey = leaf.getPublicKey().getEncoded();
            if (log.isDebugEnabled()) {
                String keyStr = Base64.encode((byte[])pKey);
                log.debug((Object)("Key : " + keyStr));
            }
            return RelyingPartyIdentifierV15Helper.getSHA256Digest(pKey);
        }
        if (isCertificateValid && RelyingPartyIdentifierV15Helper.isEmpty(organization) && !RelyingPartyIdentifierV15Helper.isEmpty(commonName)) {
            log.debug((Object)"Case 4: RP's certificate has an empty or no Organization (O) value but has a non-empty Common Name (CN) value and chains to a trusted root certificate authority");
            String cnId = RelyingPartyIdentifierV15Helper.getCnIdString(subjHash);
            log.debug((Object)("cnId : " + cnId));
            byte[] cnIdB = cnId.getBytes("UTF-16LE");
            return RelyingPartyIdentifierV15Helper.getSHA256Digest(cnIdB);
        }
        log.debug((Object)"Impossible case. RPId generation logic is failed.");
        return null;
    }

    private static byte[] getRelyingPartyIdentifier(String url) throws Exception {
        URL uri = new URL(url);
        String hostName = uri.getHost();
        byte[] cnIdB = hostName.getBytes("UTF-16LE");
        return RelyingPartyIdentifierV15Helper.getSHA256Digest(cnIdB);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String getOrgIdString(LinkedHashMap subjHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("|");
        RelyingPartyIdentifierV15Helper.appendSubjAttribute(buffer, "O", RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "O"));
        RelyingPartyIdentifierV15Helper.appendSubjAttribute(buffer, "L", RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "L"));
        String state = RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "S");
        if ("".equals(state)) {
            state = RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "ST");
        }
        RelyingPartyIdentifierV15Helper.appendSubjAttribute(buffer, "S", state);
        RelyingPartyIdentifierV15Helper.appendSubjAttribute(buffer, "C", RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "C"));
        String orgId = buffer.toString();
        return orgId;
    }

    private static String getCnIdString(LinkedHashMap subjHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("|");
        RelyingPartyIdentifierV15Helper.appendSubjAttribute(buffer, "CN", RelyingPartyIdentifierV15Helper.getSubjAttribute(subjHash, "CN"));
        return buffer.toString();
    }

    private static String getSubjAttribute(LinkedHashMap subjHash, String attrName) throws Exception {
        return subjHash.containsKey(attrName) ? (String)subjHash.get(attrName) : "";
    }

    private static void appendSubjAttribute(StringBuffer buffer, String attrName, String attrValue) throws Exception {
        buffer.append(attrName);
        buffer.append("=");
        if (!attrValue.startsWith("\"")) {
            buffer.append("\"");
        }
        buffer.append(attrValue);
        if (!attrValue.endsWith("\"")) {
            buffer.append("\"");
        }
        buffer.append("|");
    }

    private static byte[] getSHA256Digest(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest hash = MessageDigest.getInstance("SHA-256");
        return hash.digest(bytes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

